<?php

class ControllerSetupCompany extends HController {

    protected function getAlias() {
        return 'setup/company';
    }

    protected function getPrimaryKey() {
        return 'company_id';
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $lang = $this->load->language($this->getAlias());
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'company_name','status','created_at');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $lang['delete'],
                'href' => 'javascript:void(0);',
                'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                'btn_class' => 'btn btn-danger btn-xs',
                'class' => 'fa fa-times'
            );


            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $this->data['time_zones'] = getTimeZoneList();
        $company_id = 0;
        if (isset($this->request->get['company_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('company_id' => $this->request->get['company_id']));
            //d($result, true);
            foreach($result as $field => $value) {
                $this->data[$field] = $value;
            }
            $company_id = $result['company_id'];

            $this->model['policy'] = $this->load->model('setup/company_allowance_policy');
            $this->data['policies'] = $this->model['policy']->getRecords(['p.company_id' => $this->request->get['company_id']],['sort_order']);
        }

        $this->model['allowance_type'] = $this->load->model('setup/special_allowance_type');
        $this->data['allowance_type'] = $this->model['allowance_type']->getRows();

        $this->model['image'] = $this->load->model('tool/image');
        $this->data['no_image'] = $this->model['image']->resize('no_logo.jpg', 300, 100);
        if ($this->data['company_logo'] && file_exists(DIR_IMAGE . $this->data['company_logo']) && is_file(DIR_IMAGE . $this->data['company_logo'])) {
            $this->data['src_company_image'] = $this->model['image']->resize($this->data['company_logo'], 300, 100);
        } else {
            $this->data['src_company_image'] = $this->model['image']->resize('no_logo.jpg', 300, 100);
        }

        $this->model['company_allowance'] = $this->load->model('setup/company_allowance');
        $this->data['company_allowances'] = $this->model['company_allowance']->getCompanyAllowances($company_id);

        $this->model['company_deduction'] = $this->load->model('setup/company_deduction');
        $this->data['company_deductions'] = $this->model['company_deduction']->getCompanyDeductions($company_id);

        $this->model['parent_company'] = $this->load->model('setup/parent_company');
        $this->data['parent_companies'] = $this->model['parent_company']->getRows();

        $this->data['href_allowance_category'] = $this->url->link($this->getAlias() . '/getAllowanceCategory', 'token=' . $this->session->data['token'] . 'SSL');
        $this->data['action_validate_name'] = $this->url->link($this->getAlias() . '/validateCompanyName', 'token=' . $this->session->data['token'] . '&company_id=' . $this->request->get['company_id']);
        $this->data['strValidation']="{
            'rules':{
		        'company_name': {'required':true, 'minlength': 3, 'remote':  {url: '" . $this->data['action_validate_name'] . "', type: 'post'}},
		        'address': {'required':true},
		        'phone_no': {'required':true},
		        'email': {'required':true, 'email': true},
		        'gst_no': {'required':true},
		        'ntn_no': {'required':true},
		        'time_zone': {'required':true},
		        'status': {'required':true},
            },
        }";

        $this->response->setOutput($this->render());
    }

    public function validateCompanyName() {
        $name = $this->request->post['company_name'];
        $company_id = $this->request->get['company_id'];
        $this->load->language('setup/company');
        if ($name) {
            $this->model['company'] = $this->load->model('setup/company');
            $where = "LOWER(company_name) = '".strtolower($name)."' AND company_id != '".$company_id."'";
            $company = $this->model['company']->getRow($where);
            if ($company) {
                echo json_encode($this->language->get('error_duplicate_company_name'));
            } else {
                echo json_encode("true");
            }
        } else {
            echo json_encode($this->language->get('error_name'));
        }
        exit;
    }

    public function getAllowanceCategory()
    {
        $post = $this->request->post;
        $type_id = $post['allowance_type_id'];
        $this->model['allowance_category'] = $this->load->model('setup/special_allowance_category');
        $result = $this->model['allowance_category']->getRows(array('special_allowance_type_id' => $type_id));

        $html = '<option value="0">ALL</option>';
        foreach ($result as $key => $value) {
            $html .= '<option value="'.$value['special_allowance_category_id'].'">'.$value['special_allowance_category'].'</option>';
        }
        $json = array(
            'success' => true,
            'html' => $html,
        );
        echo json_encode($json);
        exit;
    }
    protected function insertData($data) {
        $policies = $data['policies'];
        unset($data['policies']);

        if(!isset($data['include_deduction_in_posting'])) {
            $data['include_deduction_in_posting'] = 'No';
        }

        if(!isset($data['attendance_exempted'])) {
            $data['attendance_exempted'] = 0;
        }
        $company_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);

        $this->model['company_allowance'] = $this->load->model('setup/company_allowance');
        $this->model['company_allowance']->deleteBulk($this->getAlias(), array('company_id' => $company_id));
        foreach($data['company_allowances'] as $allowance) {
            $allowance['company_id'] = $company_id;

            $this->model['company_allowance']->add($this->getAlias(), $allowance);
        }

        $this->model['company_deduction'] = $this->load->model('setup/company_deduction');
        $this->model['company_deduction']->deleteBulk($this->getAlias(), array('company_id' => $company_id));
        foreach($data['company_deductions'] as $deduction) {
            $deduction['company_id'] = $company_id;

            $this->model['company_deduction']->add($this->getAlias(), $deduction);
        }

        $this->model['policy'] = $this->load->model('setup/company_allowance_policy');
        $this->model['policy']->deleteBulk($this->getAlias(), ['company_id' => $primary_key]);
        $sort_order=0;
        foreach ($policies as $policy) {
            $sort_order++;
            $policy['company_id'] = $company_id;
            $policy['sort_order'] = $sort_order;

            $this->model['policy']->add($this->getAlias(),$policy);
        }

        return $company_id;
    }

    protected function updateData($primary_key, $data) {
        $policies = $data['policies'];
        unset($data['policies']);

        if(!isset($data['include_deduction_in_posting'])) {
            $data['include_deduction_in_posting'] = 'No';
        }

        if(!isset($data['attendance_exempted'])) {
            $data['attendance_exempted'] = 0;
        }

        if(!isset($data['is_exempted'])){
            $data['is_exempted'] = 0;
        }

        $company_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);
        $this->model['company_allowance'] = $this->load->model('setup/company_allowance');
        $this->model['company_allowance']->deleteBulk($this->getAlias(), array('company_id' => $company_id));
        foreach($data['company_allowances'] as $allowance) {
            $allowance['company_id'] = $company_id;

            $this->model['company_allowance']->add($this->getAlias(), $allowance);
        }

        $this->model['company_deduction'] = $this->load->model('setup/company_deduction');
        $this->model['company_deduction']->deleteBulk($this->getAlias(), array('company_id' => $company_id));
        foreach($data['company_deductions'] as $deduction) {
            $deduction['company_id'] = $company_id;

            $this->model['company_deduction']->add($this->getAlias(), $deduction);
        }

        $this->model['policy'] = $this->load->model('setup/company_allowance_policy');
        $this->model['policy']->deleteBulk($this->getAlias(), ['company_id' => $primary_key]);
        $sort_order=0;
        foreach ($policies as $policy) {
            $sort_order++;
            $policy['company_id'] = $company_id;
            $policy['sort_order'] = $sort_order;

            $this->model['policy']->add($this->getAlias(),$policy);
        }
        return $company_id;
    }
}

?>