<?php

class ControllerCommonLogin extends Controller {

//    private $error = array();

    public function index() {
        $this->data['lang'] = $this->load->language('common/login');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->data['company_logo']= HTTP_IMAGE.'logo2-light_2x.png';
        if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
            $this->data['base'] = HTTPS_BASE;
        } else {
            $this->data['base'] = HTTP_BASE;
        }

        if ($this->session->data['employee_id'] && isset($this->request->get['token']) && ($this->request->get['token'] == $this->session->data['token'])) {
            $this->redirect($this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'));
        }

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->session->data['token'] = md5(mt_rand());

            $this->redirect($this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'));
        }

        if ((isset($this->session->data['token']) && !isset($this->request->get['token'])) || ((isset($this->request->get['token']) && (isset($this->session->data['token']) && ($this->request->get['token'] != $this->session->data['token']))))) {
            $this->error['warning'] = $this->language->get('error_token');
        }

        if (isset($this->error['error_warning'])) {
            $this->data['error_warning'] = $this->error['error_warning'];
        } elseif (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $this->data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $this->data['success'] = '';
        }

        $this->data['action'] = $this->url->link('common/login', '', 'SSL');

        if (isset($this->request->post['username'])) {
            $this->data['username'] = $this->request->post['username'];
        } else {
            $this->data['username'] = '';
        }

        if (isset($this->request->post['password'])) {
            $this->data['password'] = $this->request->post['password'];
        } else {
            $this->data['password'] = '';
        }


        if (isset($this->request->get['route'])) {
            $route = $this->request->get['route'];

            unset($this->request->get['route']);

            if (isset($this->request->get['token'])) {
                unset($this->request->get['token']);
            }

            $url = '';

            if ($this->request->get) {
                $url .= http_build_query($this->request->get);
            }

            $this->data['redirect'] = $this->url->link($route, $url, 'SSL');
        } else {
            $this->data['redirect'] = '';
        }

        $this->data['forgotten'] = $this->url->link('common/forgotten', '', 'SSL');
        $this->data['ajax_email_url'] = $this->url->link('common/login/RequestOTPEmail', '', 'SSL');
        $this->data['ajax_verify_email'] = $this->url->link('common/login/VerifyEmail', '', 'SSL');
        $this->data['targer_url'] = $this->url->link('common/home&token='. $this->session->data['token'], '', 'SSL');
        $this->data['href_logout'] = $this->url->link('common/logout', 'token=' . $this->session->data['token'], 'SSL');

        $this->template = 'common/login.tpl';
//        $this->children = array(
//            'common/header',
//            'common/footer',
//        );

        $this->response->setOutput($this->render());
    }

    private function validate() {
        if (isset($this->request->post['login_name']) && isset($this->request->post['login_password']))
        {
            $this->model['employee'] = $this->load->model('employee/employee_profile');
            $login_id = $this->request->post['login_name'];
            $login_password = md5($this->request->post['login_password']);
            $employee = $this->model['employee']->getRow(array('login_id' => $login_id, 'login_password' => $login_password));
              // d(array($this->request->post, $login_id, $login_password, $employee), true);
            if($employee) {
                $date = '2021-07-01'; // date('Y-m-d');
                $this->model['fiscal_year'] = $this->load->model('setup/fiscal_year');
                $where = "`date_from` <= '".$date."' AND `date_to` >= '".$date."'";
                $fiscal_year = $this->model['fiscal_year']->getRow($where);
                if($fiscal_year) {
                    $this->session->data['company_id'] = $employee['company_id'];
                    $this->session->data['employee_id'] = $employee['employee_id'];
                    $this->session->data['employee_name'] = $employee['full_name'];
                    $this->session->data['employee_code'] = $employee['employee_code'];
                    $this->session->data['fiscal_year_id'] = $fiscal_year['fiscal_year_id'];
                    $this->session->data['fiscal_title'] = $fiscal_year['name'];
                    $this->session->data['fy_code'] = $fiscal_year['fy_code'];
                    $this->session->data['fiscal_date_from'] = $fiscal_year['date_from'];
                    $this->session->data['fiscal_date_to'] = $fiscal_year['date_to'];
                    $this->session->data['mobile_no'] = $employee['mobile_no'];
                    $this->session->data['email'] = $employee['email'];
                    $this->session->data['is_verify'] = 0;
                    $this->session->data['emp_resent'] = 0;
                } else {
                    $this->error['warning'] = 'Invalid System Date.';
                }
            } else {
                $this->error['warning'] = $this->language->get('error_login');
            }
        }

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    public function isValidSetting($data,$type="email"){
            $responseArr = [];
            $_return = true;
            if($type=='email'){
                foreach ($data as $result) {
                           
                    if($_return){ 
                        if($result['field']=='config_mail_smtp_hostname') {
                            $responseArr['host'] = $result['value'];
                            $_return = empty($responseArr['host']) ? false : true;
                        }elseif($result['field']=='config_mail_engine') {
                            $responseArr['mail_engine'] = $result['value'];
                             $_return = empty($responseArr['mail_engine']) ? false : true;
                        }elseif($result['field']=='config_mail_parameter') {
                            $responseArr['parameter'] = $result['value'];
                             $_return = empty($responseArr['parameter']) ? false : true;
                        }elseif($result['field']=='config_mail_smtp_displayname') {
                            $responseArr['displayname'] = $result['value'];
                             $_return = empty($responseArr['displayname']) ? false : true;
                        }elseif($result['field']=='config_mail_smtp_port') {
                            $responseArr['port'] = $result['value'];
                             $_return = empty($responseArr['port']) ? false : true;
                        }elseif($result['field']=='config_mail_smtp_username') {
                            $responseArr['username'] = $result['value'];
                             $_return = empty($responseArr['username']) ? false : true;
                        }elseif($result['field']=='config_mail_smtp_email') {
                            $responseArr['email'] = $result['value'];
                             $_return = empty($responseArr['email']) ? false : true;
                        }elseif($result['field']=='config_mail_smtp_timeout') {
                            $responseArr['timeout'] = $result['value'];
                             $_return = empty($responseArr['timeout']) ? false : true;
                        }elseif($result['field']=='config_mail_smtp_password') {
                            $responseArr['password'] = $result['value'];
                             $_return = empty($responseArr['password']) ? false : true;
                        } 
                    }

  
                }
            }else{  
                foreach ($data as $result) {
                    if($_return){
                        if($result['field']=='whatsapp_url') {
                            $responseArr['url'] = $result['value'];
                            $_return = empty($responseArr['url']) ? false : true;

                        }elseif($result['field']=='whatsapp_token') {
                            $responseArr['token'] = $result['value'];
                            $_return = empty($responseArr['token']) ? false : true;
                        }
                    }
                }
            }

            return ($_return==true) ? $responseArr : [];
    }
 
    public function email_setting($type="email"){


            $this->model['registration'] = $this->load->model('employee/employee_registration');
            $employee = $this->model['registration']->getRows(array('employee_id'=>$this->session->data['employee_id']));

           
            $results = [];
            $response = false;
            $responseArr = [];
            foreach($employee as $row){
                if($response == false){
                    $this->model['core_setting'] = $this->load->model('common/setting');
                    $filter = array(
                                'company_id' =>$row['company_id'],
                                'module' => 'general',
                            );
                    $results = $this->model['core_setting']->getRows($filter);

                    if($results){ 
                        $responseArr = $this->isValidSetting($results,$type);
                        if(!empty($responseArr))
                            $response = true;
                    }
                }
            }

            return $responseArr;
    }

     public function RequestOTPEmail(){
        require_once (DIR_SYSTEM.'library/PHPMailerOLD/class.phpmailer.php');
        require_once (DIR_SYSTEM.'library/PHPMailerOLD/class.smtp.php');
        $post = $this->request->post;
        $code = str_pad(mt_rand(10000, 99999), 5, '0', STR_PAD_LEFT);
        $mobile_no = $this->session->data['mobile_no'];

        if(!empty($mobile_no)){
            $mobile_no = str_replace('+','',trim($mobile_no));
            $mobile_no = str_replace(' ','',trim($mobile_no));
            $setting = $this->email_setting('whatsapp');

            $data = [
              'chatId'=> $mobile_no."@c.us",
              'message'=> "*".$code."* is your verification code for DHK Payroll, Do not share this code."
            ];
            $this->whatsAppAPI($data ,$setting );
        }

        $setting = $this->email_setting();

        $this->session->data['emp_otp']  = $code;
        $this->session->data['emp_resent']  = 1;

        $Mail_Parameters = '';
        $this_message = '';
        $template='';
        $Host = $setting['host'];
        $Mail_Engine = $setting['mail_engine'];
        $Username = $setting['username'];
        $Password = $setting['password'];
        $Port = $setting['port'];
        $Timeout = $setting['timeout'];
        $Sender = $setting['username'];
        $Display_Name = $setting['display_name'];
        $recipients = explode(",",$this->session->data['email'] );

        $this->template = 'email/verify-email.php';
        $this->data['verify_code'] = $code;
       if($Mail_Engine == 'mail') {
            $mail = new PHPMailer(true);
            try {  
                $mail->isSMTP();
                $mail->Host       = $Host;
                $mail->SMTPAuth   = true;
                $mail->Username   = $Username;
                $mail->Password   = $Password;

                // $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
                $mail->Port       = $Port;
                $mail->Timeout = $Timeout;
                $mail->SMTPOptions = array(
                    'ssl' => array(
                        'verify_peer' => false,
                        'verify_peer_name' => false,
                        'allow_self_signed' => true
                    )
                );
           
                $mail->setFrom($Sender,$Display_Name);
                          foreach (array_filter($recipients) as $email) {
                        $mail->addAddress($email);
                    }
                $mail->isHTML(true);
                $mail->Subject = "OTP Email Verification";
                $mail->Body    =   $this->render();

                if ($mail->send()) {
                    echo json_encode(["msg" =>"Email sent","success" => true]);
                }else{
                    $this->session->data['emp_resent']  = 0;
                    echo json_encode(["msg" =>'Oops, something went wrong with your email! You might want to double-check your settings and try again.',"success" => false]) ;
                }
            } catch (Exception $e) {
                $this->session->data['emp_resent']  = 0;
                echo json_encode(["msg" =>'Email could not be sent. Technical issue please contact to the system administration!  ',"success" => false]);
            }
        }else{
            $this->session->data['emp_resent']  = 0;
            echo json_encode(["msg" => "Email could not be sent. Technical issue please contact to the system administration!", "success" => false]);
        }

    }
    public function VerifyEmail(){
        $post = $this->request->post;
        $session = $this->session->data;
       
        if( $session['emp_otp'] == $post['otp']){
            $this->session->data['is_verify'] = 1;
            echo json_encode(["msg" => "Verify Successfully !", "success" => true]);
        }else{
            echo json_encode(["msg" => "Verification Code not Matched !", "success" => false]);

        }

    }
    

     public function whatsAppAPI($data,$setting){

        $url = $setting['url'];
        $data = json_encode($data);
        $authorization = "Authorization: Bearer ".$setting['token'];
        $headers =  [
                        "Content-Type: application/json",
                        "Accept:application/json",  
                        $authorization      
                    ];

            $cc =  curl_init();
            curl_setopt($cc, CURLOPT_URL, $url); 
            curl_setopt($cc, CURLOPT_POST, true);
            curl_setopt($cc, CURLOPT_POSTFIELDS, $data);
            curl_setopt($cc, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($cc, CURLOPT_HTTPHEADER, $headers);
            $response = curl_exec($cc);
            curl_close($ch);
    }

}

?>