<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header box-default">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $href_print_report; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="nav-tabs-custom">
                                    <ul class="nav nav-tabs nav-fill">
                                        <li class="nav-item active"><a class="nav-link" href="#mail_setting" data-toggle="tab">EMail Setting</a></li>
                                        <li class="nav-item"><a class="nav-link" href="#sms_setting" data-toggle="tab">SMS Setting</a></li>
                                        <li class="nav-item"><a class="nav-link" href="#whatsapp_setting" data-toggle="tab">WhatsApp Setting</a></li>
                                    </ul>
                                    <div class="tab-content">
                                        <div id="mail_setting" class="active tab-pane">
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="mail_engine"><span data-toggle="tooltip" title="" data-original-title="Only choose 'Mail' unless your host has disabled the php mail function.">Mail Engine</span></label>
                                                        <select name="config_mail_engine" id="mail_engine" class="form-control">
                                                            <option value="mail" <?php echo ($config_mail_engine!='smtp'?'selected':''); ?>>Mail</option>
                                                            <option value="smtp" <?php echo ($config_mail_engine=='smtp'?'selected':''); ?>>SMTP</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="smtp_host"><span data-toggle="tooltip" title="" data-original-title="Add 'tls://' or 'ssl://' prefix if security connection is required. (e.g. tls://smtp.gmail.com, ssl://smtp.gmail.com).">SMTP Hostname</span></label>
                                                        <input type="text" id="smtp_host" name="config_mail_smtp_hostname" value="<?php echo $config_mail_smtp_hostname; ?>" placeholder="SMTP Hostname" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="smtp_user_name">SMTP Username</label>
                                                        <input type="text" id="smtp_user_name" name="config_mail_smtp_username" value="<?php echo $config_mail_smtp_username; ?>" placeholder="SMTP Username" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="smtp_password"><span data-toggle="tooltip" title="" data-original-title="For gmail you might need to setup a application specific password here: https://security.google.com/settings/security/apppasswords.">SMTP Password</span></label>
                                                        <input type="text" id="smtp_password" name="config_mail_smtp_password" value="<?php echo $config_mail_smtp_password; ?>" placeholder="SMTP Password" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="smtp_parameter"><span data-toggle="tooltip" title="" data-original-title="When using 'Mail', additional mail parameters can be added here (e.g. -f email@storeaddress.com).">Mail Parameters</span></label>
                                                        <input type="text" id="smtp_parameter" name="config_mail_parameter" value="<?php echo $config_mail_parameter; ?>" placeholder="Mail Parameters" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="input-mail-smtp-port">SMTP Port</label>
                                                        <input type="text" name="config_mail_smtp_port" value="<?php echo $config_mail_smtp_port; ?>" placeholder="SMTP Port" id="smtp_port" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="input-mail-smtp-timeout">SMTP Timeout</label>
                                                        <input type="text" name="config_mail_smtp_timeout" value="<?php echo $config_mail_smtp_timeout; ?>" placeholder="SMTP Timeout" id="smtp_timeout" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="smtp_display_name">SMTP Display Name</label>
                                                        <input type="text" id="smtp_display_name" name="config_mail_smtp_displayname" value="<?php echo $config_mail_smtp_displayname; ?>" placeholder="SMTP Username" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="test_email_address">Test Email Address</label>
                                                        <div class="input-group">
                                                            <input type="text" id="test_email_address" class="form-control">
                                                            <div class="input-group-btn">
                                                                <button id="btnSendTestEmail" class="btn btn-info btn-flat" type="button"><i class="fa fa-envelope"></i>&nbsp;Send</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="sms_setting" class="tab-pane">
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label>User Name:</label>
                                                        <input type="text" class="form-control" id="sms_user_name" name="sms_user_name" value="<?php echo $sms_user_name; ?>" />
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Password:</label>
                                                        <input type="password" class="form-control" id="sms_password" name="sms_password" value="<?php echo $sms_password; ?>" />
                                                    </div>
                                                    <div class="form-group">
                                                        <label>From Mask</label>
                                                        <input type="text" class="form-control" id="sms_from_mask" name="sms_from_mask" value="<?php echo $sms_from_mask; ?>" />
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="test_mobile_no">Test Mobile No.</label>
                                                        <div class="input-group">
                                                            <input type="text" id="test_mobile_no" class="form-control">
                                                            <div class="input-group-btn">
                                                                <button id="btnSendTestSMS" class="btn btn-info btn-flat" type="button"><i class="fa fa-commenting-o"></i>&nbsp;Send SMS</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="whatsapp_setting" class="tab-pane">
                                            <div class="row">
                                                <div class="col-sm-8">
                                                    <div class="form-group">
                                                        <label>WhatsApp Api Url:</label>
                                                        <input type="text" placeholder="Add Url.." class="form-control" id="whatsapp_url" name="whatsapp_url" value="<?php echo $whatsapp_url; ?>" />
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Token:</label>
                                                        <input type="text"  placeholder="Add Token.."  class="form-control" id="whatsapp_token" name="whatsapp_token" value="<?php echo $whatsapp_token; ?>" />
                                                    </div>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script type="text/javascript">
        $(document).on('click','#btnSendTestEmail',function() {
            var $mail_engine = $('#mail_engine').val();
            var $smtp_parameter = $('#smtp_parameter').val();
            var $smtp_host = $('#smtp_host').val();
            var $smtp_user_name = $('#smtp_user_name').val();
            var $smtp_password = $('#smtp_password').val();
            var $smtp_port = $('#smtp_port').val();
            var $smtp_timeout = $('#smtp_timeout').val();
            var $smtp_display_name = $('#smtp_display_name').val();
            var $test_email = $('#test_email_address').val();

            var $data = {
                'mail_engine': $mail_engine,
                'smtp_parameter': $smtp_parameter,
                'smtp_host': $smtp_host,
                'smtp_user_name': $smtp_user_name,
                'smtp_password': $smtp_password,
                'smtp_port': $smtp_port,
                'smtp_timeout': $smtp_timeout,
                'smtp_display_name': $smtp_display_name,
                'test_email': $test_email
            };

            if($smtp_host=='' || $smtp_user_name=='' || $smtp_password=='' || $smtp_port=='') {
                alert('Cannot send Email through missing SMTP Information');
                return;
            }

            if($test_email=='') {
                alert('Test Email Address required.');
                return;
            }

            var $URLSendTestEmail = '<?php echo $href_send_test_email; ?>';
            $.ajax({
                url: $URLSendTestEmail,
                dataType: 'json',
                type: 'post',
                data: $data,
                beforeSend: function() {
                    $('#btnSendTestEmail').find('i').removeClass('fa-envelope').addClass('fa-spin fa-refresh');
                },
                complete: function() {
                    $('#btnSendTestEmail').find('i').removeClass('fa-spin fa-refresh').addClass('fa-envelope');
                },
                success: function(json) {
                    if(json.success) {
                        alert('Email has been sent, Please check if email received on ' + $test_email);
                    } else {
                        alert(json.error);
                    }
                }
            })
        });

        $(document).on('click','#btnSendTestSMS',function() {
            var $sms_user_name = $('#sms_user_name').val();
            var $sms_password = $('#sms_password').val();
            var $sms_from_mask = $('#sms_from_mask').val();
            var $test_mobile_no = $('#test_mobile_no').val();

            var $data = {
                'sms_user_name': $sms_user_name,
                'sms_password': $sms_password,
                'sms_from_mask': $sms_from_mask,
                'test_mobile_no': $test_mobile_no
            };

            if($sms_user_name=='' || $sms_password=='' || $sms_from_mask=='') {
                alert('Cannot send SMS with missing Information');
                return;
            }

            var $URLSendTestSMS = '<?php echo $href_send_test_sms; ?>';
            $.ajax({
                url: $URLSendTestSMS,
                dataType: 'json',
                type: 'post',
                data: $data,
                beforeSend: function() {
                    $('#btnSendTestSMS').find('i').removeClass('fa-commenting-o').addClass('fa-spin fa-refresh');
                },
                complete: function() {
                    $('#btnSendTestSMS').find('i').removeClass('fa-spin fa-refresh').addClass('fa-commenting-o');
                },
                success: function(json) {
                    if(json.success) {
                        alert('SMS has been sent, Please check if it is received on ' + $test_mobile_no);
                    } else {
                        alert(json.error);
                    }
                }
            })
        });

        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>