<?php

class ControllerCommonChangePassword extends Controller {

   // private $error = array();

    public function index() {
        $this->model['user'] = $this->load->model('user/user');
        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            $post = $this->request->post;
            $data = array(
                'login_password' => md5($post['login_password'])
            );

            $this->model['user']->edit('common/change_password',$post['user_id'],$data);

            $data = array(
                'user_id' => $post['user_id'],
                'last_login_ip' => getenv("REMOTE_ADDR"),
                'last_login_date' => date('Y-m-d H:i:s'),
                'last_password_changed' => date('Y-m-d H:i:s')
            );

            $this->model['user_login'] = $this->load->model('user/user_login');
            $user = $this->model['user_login']->getRow(['user_id' => $post['user_id']]);
            if($user) {
                $this->model['user_login']->edit('common/password_changed',$post['user_id'],$data);
            } else {
                $this->model['user_login']->add('common/password_changed',$data);
            }

            $this->redirect($this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $lang = $this->load->language('common/change_password');
        $this->data['lang'] = $lang;
        $this->data['heading_title'] = $lang['heading_title'];
        $this->data['token'] = $this->session->data['token'];

        $this->document->setTitle($lang['heading_title']);
        if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
            $this->data['base'] = HTTPS_BASE;
        } else {
            $this->data['base'] = HTTP_BASE;
        }

        if ((isset($this->session->data['token']) && !isset($this->request->get['token'])) || ((isset($this->request->get['token']) && (isset($this->session->data['token']) && ($this->request->get['token'] != $this->session->data['token']))))) {
            $this->error['warning'] = $this->language->get('error_token');
        }

        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $this->data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $this->data['success'] = '';
        }

        $this->data['action'] = $this->url->link('common/change_password', 'token=' . $this->session->data['token'], 'SSL');

        if (isset($this->request->get['redirect'])) {
            $this->data['redirect'] = base64_decode($this->request->get['redirect']);
        } else {
            $this->data['redirect'] = '';
        }

        $user = $this->model['user']->getRow(['user_id' => $this->session->data['user_id']]);

        $this->data['user_id'] = $user['user_id'];
        $this->data['login_name'] = $user['login_name'];
        //d($this->session->data, true);

        $href_validate_password = $this->url->link('common/change_password/validatePassword', 'token=' . $this->session->data['token'].'&user_id='.$user['user_id']);
        $this->data['strValidation'] = "{
            'rules':{
                'password_strength': {'min': 1},
                'login_password': {'required':true, 'minlength': 8, 'remote':  {url: '" . $href_validate_password . "', type: 'post'}},
                'confirm_password': {'equalTo': '#login_password'},
            },
            'messages': {
                'password_strength': {'min': 'Password is not Healthy.'},
            },
            'ignore':[]
        }";

        $this->template = 'common/change_password.tpl';
//        $this->children = array(
//            'common/header',
//            'common/footer',
//        );

        $this->response->setOutput($this->render());
    }

    public function validatePassword() {
        $user_id = $this->request->get['user_id'];
        $user_password = $this->request->post['login_password'];

        $this->model['user'] = $this->load->model('user/user');
        $md5_password = md5($user_password);
        $user = $this->model['user']->getRow(array('user_id' => $user_id, 'login_password' => $md5_password));
        //d([$user_id, $user_password, $md5_password, $user], true);
        if($user) {
            echo json_encode("Cannot use current password.");
        } else {
            echo json_encode("true");
        }
    }

}

?>