<?php

class ControllerCommonPageHeader extends Controller {

    public function index() {
        $this->data['lang'] = $this->load->language('common/page_header');
        $this->model['image'] = $this->load->model('tool/image');
        $this->model['setting'] = $this->load->model('common/setting');
        $this->model['user_access'] = $this->load->model('user/user_access');

        $this->data['company_name'] = $this->session->data['company_name'];
        $this->data['department_name'] = $this->session->data['department_name'];
        $this->data['fiscal_year'] = $this->session->data['fiscal_title'];
        $this->data['user_name'] =  $this->user->getUserName();
        $this->data['user_companies'] =  $this->model['user_access']->getRows(array('user_id' => $this->session->data['user_id']));

        $settings = $this->model['setting']->getRows(array(
            'company_id' => $this->session->data['company_id'],
            //'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'module' => 'general',
        ));
        foreach($settings as $setting) {
            $this->data[$setting['field']] = $setting['value'];
        }
        $this->data['company_id'] = $this->session->data['company_id'];
        $this->data['company_logo'] = $this->model['image']->resize($this->data['company_logo'],200,50);

        $user_image =  $this->user->getUserImage()?$this->user->getUserImage():'no_user.jpg';
        $this->data['user_image_50_50'] = $this->model['image']->resize($user_image,50,50);
        $this->data['user_image_160_160'] = $this->model['image']->resize($user_image,160,160);

        $this->data['href_logout'] = $this->url->link('common/logout', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_user_profile'] = $this->url->link('user/user_profile', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_update_company'] = $this->url->link('common/page_header/updateCompany', 'token=' . $this->session->data['token'], 'SSL');
        $route = explode('/',$this->request->get['route']);
        $this->data['href_redirect'] = $this->url->link($route[0].'/'.$route[1], 'token=' . $this->session->data['token'], 'SSL');

        $this->template = 'common/page_header.tpl';
        $this->render();
    }

    public function updateCompany() {
        $post = $this->request->post;
        $this->model['company'] = $this->load->model('setup/company');
        $company = $this->model['company']->getRow(array('company_id' => $post['login_company']));
        $this->session->data['parent_company_id'] = $company['parent_company_id'];
        $this->session->data['company_id'] = $company['company_id'];
        $this->session->data['company_name'] = $company['company_name'];
        $this->redirect($post['redirect']);
    }
}

?>