<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require DIR_SYSTEM . 'library/PHPMailer/Exception.php';
require DIR_SYSTEM . 'library/PHPMailer/PHPMailer.php';
require DIR_SYSTEM . 'library/PHPMailer/SMTP.php';
class ControllerCommonPreset extends Controller {

   // private $error = array();

    public function index() {
        $this->data['lang'] = $this->load->language('common/preset');

        $this->document->setTitle($this->language->get('heading_title'));
        if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
            $this->data['base'] = HTTPS_BASE;
        } else {
            $this->data['base'] = HTTP_BASE;
        }
        $model_fiscal_year = $this->load->model('setup/fiscal_year');
        $model_company = $this->load->model('setup/company');
        $model_department = $this->load->model('setup/department');
        $model_setting = $this->load->model('common/setting');
        $model_image = $this->load->model('tool/image');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $company = $model_company->getRow(array('company_id' => $this->request->post['company_id']));

            $partner_types = unserialize($company['partner_types']);
            $department = $model_department->getRow(array('company_id' => $this->request->post['company_id'], 'department_id' => $this->request->post['department_id']));
            $fiscal_year = $model_fiscal_year->getRow(array('fiscal_year_id' => $this->request->post['fiscal_year_id']));
            foreach($partner_types as $partner_type) {
                if(isset($partner_type['selected']) && $partner_type['selected']==1) {
                    $this->session->data['partner_types'][] = array(
                        'partner_type_id' => $partner_type['partner_type_id'],
                        'name' => $partner_type['name']
                    );
                }
            }
            $this->session->data['parent_company_id'] = $company['parent_company_id'];
            $this->session->data['company_id'] = $this->request->post['company_id'];
            $this->session->data['company_name'] = $company['company_name'];
            $this->session->data['department_id'] = $this->request->post['department_id'];
            $this->session->data['department_name'] = $department['department_name'];
            $this->session->data['department_code'] = $department['department_code'];
            $this->session->data['fiscal_year_id'] = $this->request->post['fiscal_year_id'];
            $this->session->data['fiscal_title'] = $fiscal_year['name'];
            $this->session->data['fy_code'] = $fiscal_year['fy_code'];
            $this->session->data['fiscal_date_from'] = $fiscal_year['date_from'];
            $this->session->data['fiscal_date_to'] = $fiscal_year['date_to'];
            $this->session->data['db_name'] = $fiscal_year['db_name'];
            // company vereification check

            if($company['is_exempted']==1 && $this->session->data['is_verify']!=1){
                 $this->session->data['is_verify'] = 1;
            }

            if($company['is_exempted']==0 && $this->session->data['is_verify']!=1){
                 $this->session->data['is_verify'] = 0;
            }

            $this->model['setting'] = $this->load->model('common/setting');
            $settings = $this->model['setting']->getRows(array(
                'company_id' => $this->session->data['company_id'],
                'fiscal_year_id' => $this->session->data['fiscal_year_id'],
                'module' => 'general',
            ));
            foreach($settings as $setting) {
                if($setting['field'] == 'company_logo') {
                    if(file_exists(DIR_IMAGE . $setting['value'])) {
                        $this->session->data['company_logo'] = DIR_IMAGE . $setting['value'];
                        $this->session->data['company_image'] = $setting['value'];
                    } else {
                        $this->session->data['company_logo'] = '';
                        $this->session->data['company_image'] = '';
                    }
                } else {
                    $this->session->data[$setting['field']] = $setting['value'];
                }

            }

            if (isset($this->request->post['redirect'])) {
                $this->redirect($this->request->post['redirect'] . '&token=' . $this->session->data['token']);
            } else {
                $this->redirect($this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'));
            }
        }

        $this->data['heading_title'] = $this->language->get('heading_title');

        $this->data['text_preset'] = $this->language->get('text_preset');

        $this->data['entry_company'] = $this->language->get('entry_company');
        $this->data['entry_department'] = $this->language->get('entry_department');
        $this->data['entry_fiscal_year'] = $this->language->get('entry_fiscal_year');

        $this->data['button_submit'] = $this->language->get('button_submit');

        if ((isset($this->session->data['token']) && !isset($this->request->get['token'])) || ((isset($this->request->get['token']) && (isset($this->session->data['token']) && ($this->request->get['token'] != $this->session->data['token']))))) {
            $this->error['warning'] = $this->language->get('error_token');
        }

        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $this->data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $this->data['success'] = '';
        }

        $this->data['action'] = $this->url->link('common/preset', 'token=' . $this->session->data['token'], 'SSL');

        if (isset($this->request->get['redirect'])) {
            $this->data['redirect'] = base64_decode($this->request->get['redirect']);
        } else {
            $this->data['redirect'] = '';
        }

        $model_user_access = $this->load->model('user/user_access');
        $user_company_accesses = $model_user_access->getArrays('company_id','company_id',array('user_id' => $this->session->data['user_id']));
        //d($user_company_accesses,true);
        $model_company = $this->load->model('setup/company');
        $companies = $model_company->getRows(array('status' => 'Active'));
        //d(array($this->session->data['user_id'], $companies, $user_company_accesses), true);
        foreach($companies as $company) {
            if(in_array($company['company_id'],$user_company_accesses)) {
                $this->data['companys'][] = $company;
            }
        }

        $fiscal_years = $model_fiscal_year->getRows(array('status' => 1), array('date_to DESC'));
        $this->data['fiscal_years'] = $fiscal_years;

        if(isset($this->session->data['fiscal_year_id']) && $this->session->data['fiscal_year_id']) {
            $this->data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        } else {
            foreach($fiscal_years as $fiscal_year) {
                if($fiscal_year['date_from'] <= date('Y-m-d') && $fiscal_year['date_to'] >= date('Y-m-d')) {
                    $this->data['fiscal_year_id'] = $fiscal_year['fiscal_year_id'];
                }
            }
        }
        if(isset($this->session->data['company_id']) && $this->session->data['company_id']) {
            $this->data['company_id'] = $this->session->data['company_id'];
        } else {
            $this->data['company_id'] = 0;
        }

        $this->data['token'] = $this->session->data['token'];
        $this->data['ajax_email_url'] = $this->url->link('common/preset/RequestOTPEmail', '', 'SSL');
        $this->data['ajax_verify_email'] = $this->url->link('common/preset/VerifyEmail', '', 'SSL');
        $this->data['home_url'] = $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_logout'] = $this->url->link('common/logout', 'token=' . $this->session->data['token'], 'SSL');


        $this->template = 'common/preset.tpl';
//        $this->children = array(
//            'common/header',
//            'common/footer',
//        );

        $this->response->setOutput($this->render());
    }

    public function email_setting($type='email'){
           
            $this->model['core_setting'] = $this->load->model('common/setting');
            $filter = array(
                        'company_id' => $this->session->data['company_id'],
                        'module' => 'general',
            );
            $results = $this->model['core_setting']->getRows($filter);
              
            $responseArr = [];
            if($type=='email'){
                foreach ($results as $result) {
                    if($result['field']=='config_mail_smtp_hostname') {
                        $responseArr['host'] = $result['value'];
                    }elseif($result['field']=='config_mail_engine') {
                        $responseArr['mail_engine'] = $result['value'];
                    }elseif($result['field']=='config_mail_parameter') {
                        $responseArr['parameter'] = $result['value'];
                    }elseif($result['field']=='config_mail_smtp_displayname') {
                        $responseArr['displayname'] = $result['value'];
                    }elseif($result['field']=='config_mail_smtp_port') {
                        $responseArr['port'] = $result['value'];
                    }elseif($result['field']=='config_mail_smtp_username') {
                        $responseArr['username'] = $result['value'];
                    }elseif($result['field']=='config_mail_smtp_email') {
                        $responseArr['email'] = $result['value'];
                    }elseif($result['field']=='config_mail_smtp_timeout') {
                        $responseArr['timeout'] = $result['value'];
                    }elseif($result['field']=='config_mail_smtp_password') {
                        $responseArr['password'] = $result['value'];
                    } 
                }
            }else{
                foreach ($results as $result) {
                    if($result['field']=='whatsapp_url') {
                        $responseArr['url'] = $result['value'];
                    }elseif($result['field']=='whatsapp_token') {
                        $responseArr['token'] = $result['value'];
                    }
                }
            }
            return $responseArr;
    }

     public function RequestOTPEmail(){
        $post = $this->request->post;
        $code = str_pad(mt_rand(10000, 99999), 5, '0', STR_PAD_LEFT);
        $mobile_no = $this->session->data['mobile_no'];

        if(!empty($mobile_no)){
            $mobile_no = str_replace('+','',trim($mobile_no));
            $mobile_no = str_replace(' ','',trim($mobile_no));
            $setting = $this->email_setting('whatsapp');
            $data = [
              'chatId'=> $mobile_no."@c.us",
              'message'=> "*".$code."* is your verification code for DHK Payroll, Do not share this code."
            ];
            $this->whatsAppAPI($data ,$setting );
        }
        $setting = $this->email_setting();

        $this->session->data['otp']  = $code;
        $this->session->data['resent']  = 1;

        $Mail_Parameters = '';
        $this_message = '';
        $template='';
        $Host = $setting['host'];
        $Mail_Engine = $setting['mail_engine'];
        $Username = $setting['username'];
        $Password = $setting['password'];
        $Port = $setting['port'];
        $Timeout = $setting['timeout'];
        $Sender = $setting['username'];
        $Display_Name = $setting['display_name'];
        $recipients = explode(",",$this->session->data['email'] );

        $this->template = 'email/verify-email.php';
        $this->data['verify_code'] = $code;
       if($Mail_Engine == 'mail') {
            $mail = new PHPMailer(true);


            try {  
                $mail->isSMTP();
                $mail->Host       = $Host;
                $mail->SMTPAuth   = true;
                $mail->Username   = $Username;
                $mail->Password   = $Password;


                // $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
                $mail->Port       = $Port;
                $mail->Timeout = $Timeout;
                $mail->SMTPOptions = array(
                    'ssl' => array(
                        'verify_peer' => false,
                        'verify_peer_name' => false,
                        'allow_self_signed' => true
                    )
                );
           

                $mail->setFrom($Sender,$Display_Name);
                          foreach (array_filter($recipients) as $email) {
                        $mail->addAddress($email);
                    }
                $mail->isHTML(true);
                $mail->Subject = "OTP Email Verification";
                $mail->Body    =   $this->render();

                if ($mail->send()) {
                    echo json_encode(["msg" =>"Email sent","success" => true]);
                }else{
                    echo json_encode(["msg" =>'Oops, something went wrong with your email! You might want to double-check your settings and try again. Error: ' . $mail->ErrorInfo,"success" => false]) ;
                }
            } catch (Exception $e) {
                echo json_encode(["msg" =>'Email could not be sent. Email setting not Available! ',"success" => false]);
            }
        }else{
            echo json_encode(["msg" => "Email setting not Available!", "success" => false]);
        }

    }
    public function VerifyEmail(){
        $post = $this->request->post;
        $session = $this->session->data;
       
        if( $session['otp'] == $post['otp']){
            $this->session->data['is_verify'] = 1;
            echo json_encode(["msg" => "Verify Successfully !", "success" => true]);
        }else{
            echo json_encode(["msg" => "Verification Code not Matched !", "success" => false]);

        }

    }
    

     public function whatsAppAPI($data,$setting){

        $url = $setting['url'];
        $data = json_encode($data);
        $authorization = "Authorization: Bearer ".$setting['token'];
        $headers =  [
                        "Content-Type: application/json",
                        "Accept:application/json",  
                        $authorization      
                    ];

            $cc =  curl_init();
            curl_setopt($cc, CURLOPT_URL, $url); 
            curl_setopt($cc, CURLOPT_POST, true);
            curl_setopt($cc, CURLOPT_POSTFIELDS, $data);
            curl_setopt($cc, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($cc, CURLOPT_HTTPHEADER, $headers);
            $response = curl_exec($cc);
            curl_close($ch);
    }


    private function validate() {
        $post = $this->request->post;
        if(!$post['fiscal_year_id']) {
            $this->error['warning'] = $this->language->get('error_select_fiscal_year');
        }
        if(!$post['company_id']) {
            $this->error['warning'] = $this->language->get('error_select_company');
        }
        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    public function getDepartments() {
        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->request->post['company_id']) {
            $model_user_access = $this->load->model('user/user_access');
            $user_accesses = $model_user_access->getArrays('department_id','department_id',array('user_id' => $this->session->data['user_id']));

            $this->model['department'] = $this->load->model('setup/department');
            $rows = $this->model['department']->getRows(array('company_id' => $this->request->post['company_id']));
            $html = '';
            foreach($rows as $department) {
                if(in_array($department['department_id'],$user_accesses)) {
                    $html .= '<option value="'.$department['department_id'].'">'.$department['department_name'].'</option>';
                }
            }
            $json = array(
                'success' => true,
                'user_access' => $user_accesses,
                'department_html' => $html
            );
        } else {
//            d(array($this->request->server['REQUEST_METHOD'], $this->request->post));
            $this->load->language('setup/company');
            $json = array(
                'success' => false,
                'error' => $this->language->get('error_select_company')
            );
        }
        $this->response->setOutput(json_encode($json));
    }

    public function getFiscalYear() {
        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->request->post['company_id']) {
            $this->model['fiscal_year'] = $this->load->model('setup/fiscal_year');
            $fiscal_years = $this->model['fiscal_year']->getRows(array('status' => 'Active'));

            if(isset($this->session->data['fiscal_year_id']) && $this->session->data['fiscal_year_id']) {
                $fiscal_year_id = $this->session->data['fiscal_year_id'];
            } else {
                foreach($fiscal_years as $fiscal_year) {
                    if($fiscal_year['date_from'] <= date('Y-m-d') && $fiscal_year['date_to'] >= date('Y-m-d')) {
                        $fiscal_year_id = $fiscal_year['fiscal_year_id'];
                    }
                }
            }

            $json = array(
                'success' => true,
                'fiscal_year_id' => $fiscal_year_id,
                'fiscal_years' => $fiscal_years
            );

        } else {
            $this->load->language('setup/company');
            $json = array(
                'success' => false,
                'error' => $this->language->get('error_select_company')
            );
        }
        $this->response->setOutput(json_encode($json));
    }

}

?>