<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

//require DIR_SYSTEM . 'library/PHPMailer/Exception.php';
//require DIR_SYSTEM . 'library/PHPMailer/PHPMailer.php';
//require DIR_SYSTEM . 'library/PHPMailer/SMTP.php';

class ControllerEmployeeCovidCertificate extends HController
{
    
    protected function getAlias()
    {
        return 'employee/covid_certificate';
    }

    protected function getPrimaryKey()
    {
        return 'covid_certificate_id';
    }

    protected function validateDocument()
    {
        return false;
    }

    protected function getList()
    {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists()
    {

        $this->load->language('employee/covid_certificate');
        $this->model[$this->getAlias()] = $this->load->model('employee/covid_certificate');
        $data = array();
        $aColumns = array('action', 'employee_code', 'employee_name', 'vaccine_type', 'dose1_date', 'dose2_date', 'certificate_no', 'created_at', 'check_box');
        $aFields = array('action', 'employee_code', 'employee_name', 'vaccine_type', 'dose1_date', 'dose2_date', 'certificate_no', 'created_at', 'check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "" . $aColumns[intval($_GET['iSortCol_' . $i])] . " " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            //$data['criteria']['orderby'] = $sOrder;
            $sort_order = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "ud.`company_id` = '" . $this->session->data['company_id'] . "'";
        $arrWhere[] = "ud.`user_id` = '" . $this->session->data['user_id'] . "'";
        $arrWhere[] = "el.`status` != 'Pending'";
        //$arrWhere[] = "`is_post` = 1";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aFields); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(" . $aFields[$i] . ") LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if (!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aFields); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aFields[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            //$data['filter']['RAW'] = implode(' AND ', $arrWhere);
            $filter = implode(' AND ', $arrWhere);
        }

        // d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($filter, $sort_order);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow['employee_covid_certificate_id'], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $this->data['lang']['delete'],
                'href' => 'javascript:void(0);',
                'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow['employee_covid_certificate_id'], 'SSL') . "')",
                'btn_class' => 'btn btn-danger btn-xs',
                'class' => 'fa fa-times'
            );

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a ' . (isset($action['btn_class']) ? 'class="' . $action['btn_class'] . '"' : '') . ' ' . (isset($action['target']) ? 'target="' . $action['target'] . '"' : '') . ' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'request_date') {
                    $row[] = stdDate($aRow['request_date']);
                } elseif ($aColumns[$i] == 'leave_date') {
                    $row[] = '<label class="help-content">From:&nbsp;</label>' . stdDate($aRow['leave_from']) . '<br /><label class="help-content">To:&nbsp;</label>' . stdDate($aRow['leave_to']);
                } elseif ($aColumns[$i] == 'approved_type') {
                    if ($aRow['status'] == 'Approved') {
                        $row[] = ($aRow['approved_type'] == 'LP' ? 'Leave with Pay' : 'Leave with Deduction');
                    } else {
                        $row[] = '';
                    }
                } elseif ($aColumns[$i] == 'approved_date') {
                    if ($aRow['status'] == 'Approved') {
                        $row[] = '<label class="help-content">From:&nbsp;</label>' . stdDate($aRow['approved_from']) . '<br /><label class="help-content">To:&nbsp;</label>' . stdDate($aRow['approved_to']);
                    } else {
                        $row[] = '';
                    }
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm()
    {
        $session = $this->session->data;
        parent::getForm();

        $this->model['employee'] = $this->load->model('employee/employee_profile');
        $this->data['employees'] = $this->model['employee']->getRows([],['full_name']);

        $this->model['vaccine'] = $this->load->model('setup/covid_vaccine');
        $this->data['vaccines'] = $this->model['vaccine']->getRows(['status'=>'Active'],['vaccine_name']);

        $this->model['covid_certificate'] = $this->load->model('employee/covid_certificate');
        if (isset($this->request->get['covid_certificate_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('employee_covid_certificate_id' => $this->request->get['covid_certificate_id']));
            foreach ($result as $field => $value) {
                if ($field == 'dose1_date' && $value != '') {
                    $this->data[$field] = stdDate($value);
                } elseif ($field == 'dose2_date' && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            if($result['certificate_image'] != '' && file_exists(DIR_FILES . $result['certificate_image'])) {
                $this->data['href_certificate'] = HTTPS_FILES . $result['certificate_image'];
            }

            $where = "`status` = 'Active' OR `vaccine_name` = '".$result['vaccine_type']."'";
            $this->data['vaccines'] = $this->model['vaccine']->getRows($where,['vaccine_name']);
        }

        $this->data['href_get_employee_list'] = $this->url->link($this->getAlias() . '/getEmployeeList', 'token=' . $this->session->data['token']);
        $href_validate_duplicate = $this->url->link($this->getAlias() . '/validateDuplicateEmployee', 'token=' . $this->session->data['token'] . '&covid_certificate_id=' . $this->request->get['covid_certificate_id']);
        $this->data['strValidation'] = "{
            'rules':{
		        'employee_id': {'required':true, 'remote': '$href_validate_duplicate'},
		        'vaccine_type': {'required':true},
		        'dose1_date': {'required':true},
		        'dose2_date': {'required': function() {return ($('#certificate_no').val() != '')}},
		        'certificate_no': {'required': function() {return ($('#dose2_date').val() != '')}},
		        'certificate_image': {'required': function() {return ($('#certificate_no').val() != '')},fileType: {types: ['jpg','jpeg','png']},maxFileSize: {unit: 'KB', size:100}},
            },
        }";

        $this->response->setOutput($this->render());
    }

    public function validateDuplicateEmployee() {
        $covid_certificate_id = $this->request->get['covid_certificate_id'];
        $employee_id = $this->request->get['employee_id'];

        $this->model['covid_certificate'] = $this->load->model('employee/covid_certificate');
        $where = "`employee_id` = '$employee_id' AND `employee_covid_certificate_id` != '$covid_certificate_id'";

        $row = $this->model['covid_certificate']->getRow($where);

        if($row) {
            echo json_encode("Data already exist for this employee.");
        } else {
            echo json_encode("true");
        }
    }

    protected function insertData($data)
    {
        if(isset($data['dose1_date']) && $data['dose1_date']) {
            $data['dose1_date'] = MySqlDate($data['dose1_date']);
        } else {
            $data['dose1_date'] = NULL;
        }
        if(isset($data['dose2_date']) && $data['dose2_date']) {
            $data['dose2_date'] = MySqlDate($data['dose2_date']);
        } else {
            $data['dose2_date'] = NULL;
        }


        if(isset($_FILES['certificate_image'])) {
            $check = getimagesize($_FILES["certificate_image"]["tmp_name"]);
            if($check !== false) {
                $extension = pathinfo($_FILES['certificate_image']['name'], PATHINFO_EXTENSION);
                $target_file = 'covid_certificate_'.$data['employee_code'].".".$extension;
                if(move_uploaded_file($_FILES["certificate_image"]["tmp_name"], DIR_FILES.$target_file)) {
                    $data['certificate_image'] = $target_file;
                } else {
                    $data['certificate_image'] = '';
                }
            } else {
                $data['certificate_image'] = '';
            }
        }

        $covid_certificate_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);
        return $covid_certificate_id;
    }

    protected function updateData($primary_key, $data)
    {
        if(isset($data['dose1_date']) && $data['dose1_date']) {
            $data['dose1_date'] = MySqlDate($data['dose1_date']);
        } else {
            $data['dose1_date'] = NULL;
        }
        if(isset($data['dose2_date']) && $data['dose2_date']) {
            $data['dose2_date'] = MySqlDate($data['dose2_date']);
        } else {
            $data['dose2_date'] = NULL;
        }

        if(isset($_FILES['certificate_image'])) {
            $check = getimagesize($_FILES["certificate_image"]["tmp_name"]);
            if($check !== false) {
                $extension = pathinfo($_FILES['certificate_image']['name'], PATHINFO_EXTENSION);
                $target_file = 'covid_certificate_'.$data['employee_code'].".".$extension;
                if(move_uploaded_file($_FILES["certificate_image"]["tmp_name"], DIR_FILES.$target_file)) {
                    $data['certificate_image'] = $target_file;
                } else {
                    $data['certificate_image'] = '';
                }
            } else {
                $data['certificate_image'] = '';
            }
        }

        $covid_certificate_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);
        return $covid_certificate_id;
    }

}

?>