<?php

class ControllerEmployeeEmployeeAttendance extends HController {

    protected function getAlias() {
        return 'employee/employee_attendance';
    }

    protected function getPrimaryKey() {
        return 'employee_attendance_id';
    }

    public function index()
    {
        $this->redirect($this->url->link($this->getAlias() . '/insert', 'token=' . $this->session->data['token'], 'SSL'));
    }

    protected function getForm() {
        parent::getForm();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id'=>$this->session->data['company_id']), array('department_name'));
        //d($this->data['departments'], true);
        if ($this->user->hasPermission('delete', $this->getAlias())) {
            $this->data['can_delete'] = 1;
        } else {
            $this->data['can_delete'] = 0;
        }

        if ($this->user->hasPermission('update', $this->getAlias())) {
            $this->data['can_update'] = 1;
        } else {
            $this->data['can_update'] = 0;
        }

        $this->data['href_delete_attendance'] = $this->url->link($this->getAlias() . '/deleteAttendance', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['href_calculate_attendance'] = $this->url->link($this->getAlias() . '/calculateAttendance', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['href_csv_sample_file'] = HTTP_FILES . 'csv_attendance_format.csv';
        $this->data['href_get_employee'] = $this->url->link($this->getAlias() . '/getEmployee', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['action_download_file'] = $this->url->link($this->getAlias() . '/downloadFile', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['action_save_csv_file'] = $this->url->link($this->getAlias() . '/uploadCSV', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['strDownloadFile']="{
            'rules':{
		        'from_date': {'required':true},
		        'to_date': {'required':true},
            },
            ignore:[]
        }";
        $this->data['strCSVValidation']="{
            'rules':{
		        'from_date': {'required':true},
		        'to_date': {'required':true},
		        'csv_file': {'required':true},
            },
            ignore:[]
        }";
        $this->data['strValidation']="{
            'rules':{
		        'attendance_date': {'required':true},
		        'department_id': {'required':true},
		        'employee_count': {'required':true, 'min':1},
            },
            ignore:[]
        }";

        $this->response->setOutput($this->render());
    }

    public function getEmployee() {
        $post = $this->request->post;
        $attendance_date = MySqlDate($post['attendance_date']);
        $day = date('D', strtotime($attendance_date));

        $this->model['holiday'] = $this->load->model('setup/holiday');
        $this->model['employee_leave'] = $this->load->model('employee/employee_leave');
        $this->model['employee_attendance'] = $this->load->model('employee/employee_attendance');
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['attendance_shift_detail'] = $this->load->model('setup/attendance_shift_detail');

        $holiday = $this->model['holiday']->getRow(array('holiday_date' => $attendance_date));
        $employee_registrations = $this->model['employee_registration']->getArrays('employee_registration_id',array('employee_registration_id','registration_code','employee_name', 'attendance_shift_id'),array('company_id' => $this->session->data['company_id'], 'department_id' => $post['department_id']), array('employee_name'));
        $attendances = $this->model['employee_attendance']->getArrays('employee_registration_id',array('employee_registration_id', 'status', 'attendance_type','time_in', 'time_out', 'shift_in', 'shift_out'),array('company_id' => $this->session->data['company_id'], 'department_id' => $post['department_id'], 'attendance_date' => $attendance_date));
        //d($attendances, true);
        foreach($employee_registrations as $employee_registration_id => $registration) {
            $shift = $this->model['attendance_shift_detail']->getRow(array('attendance_shift_id' => $registration['attendance_shift_id'], 'day' => $day));
            if(isset($attendances[$employee_registration_id])) {
                $registration['status'] = $attendances[$employee_registration_id]['status'];
                $registration['attendance_type'] = $attendances[$employee_registration_id]['attendance_type'];
                $registration['time_in'] = $attendances[$employee_registration_id]['time_in'];
                $registration['time_out'] = $attendances[$employee_registration_id]['time_out'];
                $registration['shift_in'] = $attendances[$employee_registration_id]['shift_in'];
                $registration['shift_out'] = $attendances[$employee_registration_id]['shift_out'];
            } else {
                $where = "`employee_registration_id`='".$employee_registration_id."' AND `status`='Approved' AND '".MysqlDate($post['attendance_date'])."' >=`approved_from` AND '".MysqlDate($post['attendance_date'])."'<=`approved_to`";
                $leave = $this->model['employee_leave']->getRow($where);
                $registration['shift'] = $shift;
                $registration['time_in'] = '';
                $registration['time_out'] = '';
                $registration['shift_in'] = $shift['from_time'];
                $registration['shift_out'] = $shift['to_time'];
                if($leave) {
                    $registration['status'] = $leave['approved_type'];
                    $registration['attendance_type'] = 'Automatic';
                    $registration['desc'] = 'Leave';
                } elseif($shift['day_status']=='Holiday') {
                    $registration['status'] = 'H';
                    $registration['attendance_type'] = 'Automatic';
                    $registration['desc'] = 'Shift Holiday';
                } elseif($holiday) {
                    $registration['status'] = 'H';
                    $registration['attendance_type'] = 'Automatic';
                    $registration['desc'] = 'Public Holiday';
                } else {
                    $registration['status'] = 'A';
                    $registration['attendance_type'] = 'Automatic';
                    $registration['desc'] = 'No Record';
                }
            }

            $employees[] = $registration;
        }

        $html = '';
        foreach($employees as $row_no => $employee) {
            $html .= '<tr>';
            $html .= '<td>'.($row_no+1).'</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" id="employee_'.$row_no.'_employee_registration_id" name="employees['.$row_no.'][employee_registration_id]" value="'.$employee['employee_registration_id'].'"/>';
            $html .= $employee['registration_code'];
            $html .= '</td>';
            $html .= '<td>'.$employee['employee_name'].'</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" id="employee_'.$row_no.'_shift_in" name="employees['.$row_no.'][shift_in]" value="'.$employee['shift_in'].'"/>';
            $html .= $employee['shift_in'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" id="employee_'.$row_no.'_shift_out" name="employees['.$row_no.'][shift_out]" value="'.$employee['shift_out'].'"/>';
            $html .= $employee['shift_out'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" id="employee_'.$row_no.'_time_in" name="employees['.$row_no.'][time_in]" value="'.$employee['time_in'].'"/>';
            $html .= $employee['time_in'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" id="employee_'.$row_no.'_time_out" name="employees['.$row_no.'][time_out]" value="'.$employee['time_out'].'"/>';
            $html .= $employee['time_out'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" id="employee_'.$row_no.'_attendance_type" name="employees['.$row_no.'][attendance_type]" value="'.$employee['attendance_type'].'"/>';
            $html .= '<select class="form-control" id="employee_'.$row_no.'_status" name="employees['.$row_no.'][status]" onChange="updateAttendanceType('.$row_no.');">';
            $html .= '<option value="P" '.($employee['status']=='P'?'selected="true"':'').'>Present</option>';
            $html .= '<option value="H" '.($employee['status']=='H'?'selected="true"':'').'>Holiday</option>';
            $html .= '<option value="A" '.($employee['status']=='A'?'selected="true"':'').'>Absent</option>';
            $html .= '<option value="LP" '.($employee['status']=='LP'?'selected="true"':'').'>Leave with Pay</option>';
            $html .= '<option value="LD" '.($employee['status']=='LD'?'selected="true"':'').'>Leave with Deduction</option>';
            $html .= '<option value="LW" '.($employee['status']=='LW'?'selected="true"':'').'>Leave Waved</option>';
            $html .= '<option value="UA" '.($employee['status']=='UA'?'selected="true"':'').'>Leave Unavailed</option>';
            $html .= '<option value="LT" '.($employee['status']=='LT'?'selected="true"':'').'>Late</option>';
            $html .= '</select>';
            $html .= '</td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'employee_count' => count($employees),
            'holiday' => $holiday,
            'employees' => $employees,
            'html' => $html
        );

        echo json_encode($json);
    }

    public function downloadFile() {
        $this->model['registration'] = $this->load->model('employee/employee_registration');
        $this->model['shift_detail'] = $this->load->model('setup/attendance_shift_detail');
        $post = $this->request->post;
        $session = $this->session->data;

        $from_date = MySqlDate($post['from_date']);
        $to_date = date('Y-m-d',strtotime(MySqlDate($post['to_date']).' +1 days'));

        $start_date = new DateTime($from_date);
        $end_date = new DateTime($to_date);

        $interval = DateInterval::createFromDateString('1 day');
        $period = new DatePeriod($start_date, $interval, $end_date);

        $arrWhere=array();
        $arrWhere[] = "`company_id`='".$session['company_id']."'";
        $arrWhere[] = "`status`='Active'";
        if(isset($post['department_id']) && $post['department_id'] != '') {
            $arrWhere[] = "`department_id`='".$post['department_id']."'";
        }

        $where = implode(' AND ', $arrWhere);
        $employees = $this->model['registration']->getRows($where, array('department_name','employee_name'));
        $arrEmployees = array();
        foreach($employees as $employee) {
            $shifts = $this->model['shift_detail']->getArrays('day',array('day_status','from_time','to_time'));
            foreach ($period as $dt) {
                $day = $dt->format("D");
                $date = $dt->format("d-m-Y");
                if($shifts[$day]['day_status']=='Working Day') {
                    $arrEmployees[] = array(
                        'machine_code' => $employee['attendance_code'],
                        'department_id' => $employee['department_id'],
                        'department_name' => $employee['department_name'],
                        'registration_code' => $employee['registration_code'],
                        'employee_name' => $employee['employee_name'],
                        'date' => $date,
                        'shift_in' => $shifts[$day]['from_time'],
                        'shift_out' => $shifts[$day]['to_time'],
                    );
                }
            }
        }

        include_once(DIR_SYSTEM.'library/PHPExcel.php');
        include_once(DIR_SYSTEM.'library/PHPExcel/Classes/PHPExcel/Writer/Excel5.php');
        include_once(DIR_SYSTEM.'library/PHPExcel/Worksheet.php');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $rowCount = 1;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Machine Code');
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, 'Department');
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, 'Reg. Code');
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, 'Employee');
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, 'Date');
        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, 'Shift IN');
        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, 'Shift OUT');
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, 'Time IN');
        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, 'Time OUT');
        foreach($arrEmployees as $employee) {
            $rowCount++;
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $employee['machine_code']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $employee['department_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $employee['registration_code']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $employee['employee_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $employee['date']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $employee['shift_in']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $employee['shift_out']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, '');
        }
        $objSheet = $objPHPExcel->getActiveSheet();
        $objSheet->protectCells('A2:G'.$rowCount, 'PHP');
        $objSheet->getStyle('H2:I'.$rowCount)->getProtection()->setLocked(PHPExcel_Style_Protection::PROTECTION_UNPROTECTED);
        $objSheet->getProtection()->setSheet(true);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="Attendance.xlsx"');
        header('Cache-Control: max-age=0');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        //$objWriter->save('some_excel_file.xlsx');
        $objWriter->save('php://output');
        exit;
    }

    protected function insertData($data) {
        // d($data,true);
        $attendance_date = MySqlDate($data['attendance_date']);
        $department_id = $data['department_id'];
        $this->model[$this->getAlias()]->deleteBulk($this->getAlias(), array('attendance_date' => $attendance_date, 'department_id' => $department_id));
        foreach($data['employees'] as $employee) {
            $employee['company_id'] = $this->session->data['company_id'];
            $employee['attendance_date'] = $attendance_date;
            $employee['department_id'] = $department_id;
            $this->model[$this->getAlias()]->add($this->getAlias(), $employee);
        }
    }

    public function uploadCSV() {
        ini_set('max_execution_time','0');
        $lang = $this->load->language($this->getAlias());
        $post = $this->request->post;
        $file = $this->request->files['csv_file'];

        $from_date = MySqlDate($post['from_date']);
        $to_date = MySqlDate($post['to_date']);
        $company_id = $this->session->data['company_id'];

        $this->model['machine_attendance'] = $this->load->model('employee/machine_attendance');
        $this->model['attendance_shift_detail'] = $this->load->model('setup/attendance_shift_detail');
        $this->model['employee_attendance'] = $this->load->model('employee/employee_attendance');
        $this->model['employee_leave'] = $this->load->model('employee/employee_leave');
        $this->model['holiday'] = $this->load->model('setup/holiday');
        if($file['tmp_name'] != '') {
            $this->model['machine_attendance']->truncateTempTable();
            $this->model['machine_attendance']->fillTempTable($file['tmp_name']);
            $this->model['machine_attendance']->fillEmployeeAttendance($from_date, $to_date);

            $arrHolidays = $this->model['holiday']->getArrays('holiday_date','holiday_name',"`holiday_date` >= '$from_date' AND `holiday_date` <= '$to_date'");
            $employees = $this->model['machine_attendance']->getArrays('employee_registration_id',array('employee_registration_id','attendance_shift_id','department_id'),"ma.`attendance_date` >='".$from_date."' AND ma.`attendance_date`<='".$to_date."' AND `company_id`='$company_id'");
            $arrData=array();
            foreach($employees as $employee) {
                //d($employee, true);
                $shift = $this->model['attendance_shift_detail']->getArrays('day',array('day','day_status','from_time','to_time'), array('attendance_shift_id' => $employee['attendance_shift_id']));
                $where = "`company_id`='$company_id' AND `employee_registration_id`='".$employee['employee_registration_id']."' AND `attendance_date` >= '$from_date' AND `attendance_date` <= '$to_date'";
                $arrAttendance = $this->model['employee_attendance']->getArrays('attendance_date',['status','employee_attendance_id','time_in','shift_in','attendance_type'], $where);
                //d($arrAttendance);
                $current_date = $from_date;
                while($current_date <= $to_date) {
                    $day = date('D',strtotime($current_date));
                    $day_name = date('l',strtotime($current_date));
                    $data = array();
                    $where = "`employee_registration_id`='".$employee['employee_registration_id']."' AND `status`='Approved' AND '$current_date' >=`approved_from` AND '$current_date'<=`approved_to`";
                    $leave = $this->model['employee_leave']->getRow($where,['created_at desc']);
                    if(!isset($arrAttendance[$current_date])) {
                        $data = array(
                            'company_id' => $company_id,
                            'department_id' => $employee['department_id'],
                            'employee_registration_id' => $employee['employee_registration_id'],
                            'attendance_date' => $current_date,
                            'shift_in' => $shift[$day]['from_time'],
                            'shift_out' => $shift[$day]['to_time'],
                            'attendance_type' => 'Automatic',
                        );

                        if($leave) {
                            $data['status'] = $leave['approved_type'];
                            $data['remarks'] = $leave['reason'];
                            $data['desc'] = 'Leave';
                        } elseif($shift[$day]['day_status']=='Holiday') {
                            $data['status'] = 'H';
                            $data['remarks'] = $day_name;
                            $data['desc'] = 'Shift Holiday';
                        } elseif($arrHolidays[$current_date]) {
                            $data['status'] = 'H';
                            $data['remarks'] = $arrHolidays[$current_date];
                            $data['desc'] = 'Public Holiday';
                        } else {
                            $data['status'] = 'A';
                            $data['remarks'] = 'No Record';
                            $data['desc'] = 'No Record';
                        }

                        $this->model['employee_attendance']->add($this->getAlias(), $data);
                    } elseif($leave && $arrAttendance[$current_date]['attendance_type']=='Automatic') {
                        $data['status'] = $leave['approved_type'];
                        $data['remarks'] = $leave['reason'];
                        $data['desc'] = 'Leave';

                        $this->model['employee_attendance']->edit($this->getAlias(),$arrAttendance[$current_date]['employee_attendance_id'], $data);
                    } elseif($arrAttendance[$current_date]['status']=='LT' && $shift[$day]['day_status']=='Holiday') {
                        $data['status'] = 'P';
                        $data['remarks'] = $arrHolidays[$current_date] . ' but Present';
                        $data['desc'] = 'Shift Holiday but Present';

                        $this->model['employee_attendance']->edit($this->getAlias(),$arrAttendance[$current_date]['employee_attendance_id'], $data);
                    } elseif($arrAttendance[$current_date]['status']=='LT' && isset($arrHolidays[$current_date])) {
                        $data['status'] = 'P';
                        $data['remarks'] = $arrHolidays[$current_date] . ' but Present';
                        $data['desc'] = 'Public Holiday but Present';

                        $this->model['employee_attendance']->edit($this->getAlias(),$arrAttendance[$current_date]['employee_attendance_id'], $data);
                    }

                    $data['leave'] = $leave;
                    $arrData[$employee['employee_registration_id']][] = $data;

                    $current_date = date('Y-m-d', strtotime($current_date . ' +1 Day'));
                }
            }
            //d($arrData, true);

            $this->session->data['success'] = $lang['success_file_upload'];
        } else {
            $this->session->data['error_warning'] = $lang['error_file_upload'];
        }

        $this->redirect($this->url->link($this->getAlias() . '/insert', 'token=' . $this->session->data['token'], 'SSL'));
    }

    public function deleteAttendance() {
        ini_set('max_execution_time','0');
        $post = $this->request->post;
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateDelete()) {
            $this->model['employee_attendance'] = $this->load->model('employee/employee_attendance');

            $arrWhere = [];
            $arrWhere[] = "`attendance_date` >= '".$post['from_date']."'";
            $arrWhere[] = "`attendance_date` <= '".$post['to_date']."'";
            if($post['department_id']) {
                $arrWhere[] = "`department_id` = '".$post['department_id']."'";
            }
            if($post['registration_code']) {
                $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
                $employee = $this->model['employee_registration']->getRow(['company_id' => $this->session->data['company_id'], 'registration_code' => $post['registration_code']]);

                $arrWhere[] = "`employee_registration_id` = '".$employee['employee_registration_id']."'";
            }

            $where = implode(' AND ', $arrWhere);

            //d($where, true);
            $this->model['employee_attendance']->deleteBulk($this->getAlias(), $where);
            $this->session->data['success'] = $this->language->get('success_delete');
        } else {
            $this->redirect($this->url->link($this->getAlias() . '/insert', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $json = [
            'success' => true,
        ];


        echo json_encode($json);
    }

    public function calculateAttendance() {
        ini_set('max_execution_time','0');
        $post = $this->request->post;
        $session = $this->session->data;

        $from_date = $post['from_date'];
        $to_date = $post['to_date'];
        $company_id = $session['company_id'];

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateUpdate()) {
            $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
            $this->model['employee_attendance'] = $this->load->model('employee/employee_attendance');
            $this->model['attendance_shift_detail'] = $this->load->model('setup/attendance_shift_detail');
            $this->model['employee_leave'] = $this->load->model('employee/employee_leave');
            $this->model['holiday'] = $this->load->model('setup/holiday');

            $arrHolidays = $this->model['holiday']->getArrays('holiday_date','holiday_name',"`holiday_date` >= '$from_date' AND `holiday_date` <= '$to_date'");

            $arrWhere = [];
            $arrWhere[] = "`company_id` >= '".$session['company_id']."'";
            if($post['department_id']) {
                $arrWhere[] = "`department_id` = '".$post['department_id']."'";
            }
            if($post['registration_code']) {
                $arrWhere[] = "`registration_code` = '".$post['registration_code']."'";
            }

            $where = implode(' AND ', $arrWhere);

            $employees = $this->model['employee_registration']->getRows($where,['employee_name']);
            foreach($employees as $employee) {
                //d($employee, true);
                $shift = $this->model['attendance_shift_detail']->getArrays('day',array('day','day_status','from_time','to_time'), array('attendance_shift_id' => $employee['attendance_shift_id']));
                $where = "`company_id`='$company_id' AND `employee_registration_id`='".$employee['employee_registration_id']."' AND `attendance_date` >= '$from_date' AND `attendance_date` <= '$to_date'";
                $arrAttendance = $this->model['employee_attendance']->getArrays('attendance_date',['status','employee_attendance_id','time_in','shift_in','attendance_type'], $where);
                //d([$employee, $shift, $arrAttendance], true);
                $current_date = $from_date;
                while($current_date <= $to_date) {
                    $day = date('D',strtotime($current_date));
                    $day_name = date('l',strtotime($current_date));
                    $data = array();
                    $where = "`employee_registration_id`='".$employee['employee_registration_id']."' AND `status`='Approved' AND '$current_date' >=`approved_from` AND '$current_date'<=`approved_to`";
                    $leave = $this->model['employee_leave']->getRow($where,['created_at desc']);
                    if(!isset($arrAttendance[$current_date])) {
                        $data = array(
                            'company_id' => $company_id,
                            'department_id' => $employee['department_id'],
                            'employee_registration_id' => $employee['employee_registration_id'],
                            'attendance_date' => $current_date,
                            'shift_in' => $shift[$day]['from_time'],
                            'shift_out' => $shift[$day]['to_time'],
                            'attendance_type' => 'Automatic',
                        );

                        if($leave) {
                            $data['status'] = $leave['approved_type'];
                            $data['remarks'] = $leave['reason'];
                            $data['desc'] = 'Leave';
                        } elseif($shift[$day]['day_status']=='Holiday') {
                            $data['status'] = 'H';
                            $data['remarks'] = $day_name;
                            $data['desc'] = 'Shift Holiday';
                        } elseif($arrHolidays[$current_date]) {
                            $data['status'] = 'H';
                            $data['remarks'] = $arrHolidays[$current_date];
                            $data['desc'] = 'Public Holiday';
                        } else {
                            $data['status'] = 'A';
                            $data['remarks'] = 'No Record';
                            $data['desc'] = 'No Record';
                        }

                        $this->model['employee_attendance']->add($this->getAlias(), $data);
                    } else {
                        if($leave && $arrAttendance[$current_date]['attendance_type']=='Automatic') {
                            $data['status'] = $leave['approved_type'];
                            $data['remarks'] = $leave['reason'];
                            $data['desc'] = 'Leave';

                            $this->model['employee_attendance']->edit($this->getAlias(),$arrAttendance[$current_date]['employee_attendance_id'], $data);
                        } elseif($arrAttendance[$current_date]['status']=='LT' && $shift[$day]['day_status']=='Holiday') {
                            $data['status'] = 'P';
                            $data['remarks'] = $arrHolidays[$current_date] . ' but Present';
                            $data['desc'] = 'Shift Holiday but Present';

                            $this->model['employee_attendance']->edit($this->getAlias(),$arrAttendance[$current_date]['employee_attendance_id'], $data);
                        } elseif($arrAttendance[$current_date]['status']=='LT' && isset($arrHolidays[$current_date])) {
                            $data['status'] = 'P';
                            $data['remarks'] = $arrHolidays[$current_date] . ' but Present';
                            $data['desc'] = 'Public Holiday but Present';

                            $this->model['employee_attendance']->edit($this->getAlias(),$arrAttendance[$current_date]['employee_attendance_id'], $data);
//                        } elseif($arrAttendance[$current_date]['status']=='P' && (strtotime($arrAttendance[$current_date]['time_in']) > strtotime($arrAttendance[$current_date]['shift_in']) || strtotime($arrAttendance[$current_date]['time_out']) < strtotime($arrAttendance[$current_date]['shift_out']) || $arrAttendance[$current_date]['time_out'] == "")) {
//                            $data['status'] = 'LT';
//                            $data['remarks'] = 'Present but Early Going';
//                            $data['desc'] = 'Late or Missing Out';
//
//                            $this->model['employee_attendance']->edit($this->getAlias(),$arrAttendance[$current_date]['employee_attendance_id'], $data);
                        } elseif($arrAttendance[$current_date]['status']=='P' && (strtotime($arrAttendance[$current_date]['time_in']) > strtotime($arrAttendance[$current_date]['shift_in']))) {
                            $data['status'] = 'LT';
                            $data['remarks'] = 'Present but Late';
                            $data['desc'] = 'Late';

                            $this->model['employee_attendance']->edit($this->getAlias(),$arrAttendance[$current_date]['employee_attendance_id'], $data);
                        }
                    }
                    $arrData[$employee['employee_registration_id']][] = $data;
                    $current_date = date('Y-m-d', strtotime($current_date . ' +1 Day'));
                }
            }
            //d([$where, $employees], true);
            $this->session->data['success'] = $this->language->get('success_delete');
        } else {
            $this->redirect($this->url->link($this->getAlias() . '/insert', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $json = [
            'success' => true,
        ];


        echo json_encode($json);
    }
}
?>