<?php

class ControllerEmployeeEmployeeProfile extends HController {

    protected function getAlias() {
        return 'employee/employee_profile';
    }

    protected function getPrimaryKey() {
        return 'employee_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $this->load->language('employee/employee_profile');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'employee_code', 'full_name','cnic_no', 'mobile_no', 'phone_no', 'email','login_id','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        //$arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "(employee_id IN (SELECT employee_id FROM `employee_registration` WHERE `status` = 'Active' AND company_id = '".$this->session->data['company_id']."') OR `company_id`='".$this->session->data['company_id']."')";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            if($aRow['total_registration']==0) {
                $actions[] = array(
                    'text' => $this->data['lang']['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $this->model['school'] = $this->load->model('setup/school');
        $this->data['schools'] = $this->model['school']->getRows(array(), array('school_name'));

        $this->model['class'] = $this->load->model('setup/class');
        $this->data['classes'] = $this->model['class']->getRows(array(), array('class_name'));

        $this->model['bank'] = $this->load->model('setup/bank');
        $this->data['banks'] = $this->model['bank']->getRows(array(), array('bank_name'));

        $this->model['qualification'] = $this->load->model('setup/qualification');
        $this->data['qualifications'] = $this->model['qualification']->getRows(array(), array('qualification'));

        $this->model['employee_category'] = $this->load->model('setup/employee_category');
        $this->data['employee_categories'] = $this->model['employee_category']->getRows(array(), array('employee_category'));

        $this->model['image'] = $this->load->model('tool/image');
        $this->data['no_image'] = $this->model['image']->resize('no_user.jpg', 225, 225);
        $this->data['src_employee_image'] = $this->model['image']->resize('no_user.jpg', 225, 225);
        if (isset($this->request->get['employee_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('employee_id' => $this->request->get['employee_id']));
            foreach($result as $field => $value) {
                if(($field=='dob' || $field=='cnic_expiry' || $field=='eobi_expiry' || $field=='probation_from' || $field=='probation_to' || $field=='passport_expiry'||$field=='nicop_expiry'||$field=='eobi_date'||$field=='joining_date') && $value != '' || $field=='dob_date_hijri' || $field=='joining_date_hijri') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            if ($this->data['employee_image'] && file_exists(DIR_IMAGE . $this->data['employee_image']) && is_file(DIR_IMAGE . $this->data['employee_image'])) {
                $this->data['src_employee_image'] = $this->model['image']->resize($this->data['employee_image'], 225, 225);
            }
            //d(array($this->data['employee_image'],$this->data['src_employee_image']), true);
            $this->model['employee_family'] = $this->load->model('employee/employee_family');
            $this->data['employee_families'] = $this->model['employee_family']->getRows(array('employee_id' => $result['employee_id']), array('sort_order'));

            $this->model['employee_qualification'] = $this->load->model('employee/employee_qualification');
            $employee_qualifications = $this->model['employee_qualification']->getRows(array('employee_id' => $result['employee_id']), array('sort_order'));
            foreach($employee_qualifications as $qualification) {
                if($qualification['completion_date'] != '') {
                    $qualification['completion_date'] = stdDate($qualification['completion_date']);
                }
                $this->data['employee_qualifications'][] = $qualification;
            }

            $this->model['employee_bank'] = $this->load->model('employee/employee_bank');
            $this->data['employee_banks'] = $this->model['employee_bank']->getRows(array('employee_id' => $result['employee_id']), array('sort_order'));
        }

        $this->data['action_validate_login_id'] = $this->url->link($this->getAlias() . '/validateLoginID', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['action_validate_code'] = $this->url->link($this->getAlias() . '/validateCode', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['action_validate_name'] = $this->url->link($this->getAlias() . '/validateName', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['action_validate_its'] = $this->url->link($this->getAlias() . '/validateITS', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['action_validate_cnic'] = $this->url->link($this->getAlias() . '/validateCNIC', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['action_validate_nicob'] = $this->url->link($this->getAlias() . '/validateNICOB', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['strValidation']="{
            'rules':{
		        'login_id': {'remote':  {url: '" . $this->data['action_validate_login_id'] . "', type: 'post'}},
		        'first_name': {'required':true},
		        'middle_name': {'required':true},
		        'surname': {'required':true},
		        'full_name': {'required':true, 'minlength': 3, 'remote':  {url: '" . $this->data['action_validate_name'] . "', type: 'post'}},
		        'its_no': {'remote':  {url: '" . $this->data['action_validate_its'] . "', type: 'post'}},
		        'cnic_no': {'remote':  {url: '" . $this->data['action_validate_cnic'] . "', type: 'post'}},
		        'nicob_no': {'remote':  {url: '" . $this->data['action_validate_nicob'] . "', type: 'post'}},
            },
        }";

        $this->response->setOutput($this->render());
    }

    public function validateLoginID()
    {
        $login_id = $this->request->post['login_id'];
        $employee_id = $this->request->get['employee_id'];

        $this->load->language('employee/employee_profile');
        if ($login_id) {
            $this->model['employee'] = $this->load->model('employee/employee_profile');
            $where = " LOWER(login_id) = '".strtolower($login_id)."' AND employee_id != '".$employee_id."'";
            //$where .= " AND company_id='" . $company_id . "' AND company_branch_id='" . $company_branch_id . "'";
            $row = $this->model['employee']->getRow($where);
            if ($row) {
                echo json_encode($this->language->get('error_duplicate_login'));
            } else {
                echo json_encode("true");
            }
        } else {
            echo json_encode($this->language->get('error_login'));
        }
        exit;
    }

    public function validateCode()
    {
        $code = $this->request->post['employee_code'];
        //$company_id = $this->session->data['company_id'];
        //$company_branch_id = $this->session->data['company_branch_id'];
        $employee_id = $this->request->get['employee_id'];

        $this->load->language('employee/employee_profile');
        if ($code) {
            $this->model['employee'] = $this->load->model('employee/employee_profile');
            $where = " LOWER(employee_code) = '".strtolower($code)."' AND employee_id != '".$employee_id."'";
            //$where .= " AND company_id='" . $company_id . "' AND company_branch_id='" . $company_branch_id . "'";
            $row = $this->model['employee']->getRow($where);
            if ($row) {
                echo json_encode($this->language->get('error_duplicate_name'));
            } else {
                echo json_encode("true");
            }
        } else {
            echo json_encode($this->language->get('error_name'));
        }
        exit;
    }

    public function validateName()
    {
        $name = $this->request->post['full_name'];
        //$company_id = $this->session->data['company_id'];
        //$company_branch_id = $this->session->data['company_branch_id'];
        $employee_id = $this->request->get['employee_id'];

        $this->load->language('employee/employee_profile');
        if ($name) {
            $this->model['employee'] = $this->load->model('employee/employee_profile');
            $where = " LOWER(full_name) = '".strtolower($name)."' AND employee_id != '".$employee_id."'";
            //$where .= " AND company_id='" . $company_id . "' AND company_branch_id='" . $company_branch_id . "'";
            $row = $this->model['employee']->getRow($where);
            if ($row) {
                echo json_encode($this->language->get('error_duplicate_name'));
            } else {
                echo json_encode("true");
            }
        } else {
            echo json_encode($this->language->get('error_name'));
        }
        exit;
    }

    public function validateITS()
    {
        $its_no = $this->request->post['its_no'];
        //$company_id = $this->session->data['company_id'];
        //$company_branch_id = $this->session->data['company_branch_id'];
        $employee_id = $this->request->get['employee_id'];

        $this->load->language('employee/employee_profile');
        if ($its_no) {
            $this->model['employee'] = $this->load->model('employee/employee_profile');
            $where = " LOWER(its_no) = '".strtolower($its_no)."' AND employee_id != '".$employee_id."'";
            //$where .= " AND company_id='" . $company_id . "' AND company_branch_id='" . $company_branch_id . "'";
            $row = $this->model['employee']->getRow($where);
            if ($row) {
                echo json_encode($this->language->get('error_duplicate_its'));
            } else {
                echo json_encode("true");
            }
        } else {
            echo json_encode($this->language->get('error_name'));
        }
        exit;
    }

    public function validateCNIC()
    {
        $cnic_no = $this->request->post['cnic_no'];
        //$company_id = $this->session->data['company_id'];
        //$company_branch_id = $this->session->data['company_branch_id'];
        $employee_id = $this->request->get['employee_id'];

        $this->load->language('employee/employee_profile');
        if ($cnic_no) {
            $this->model['employee'] = $this->load->model('employee/employee_profile');
            $where = " LOWER(cnic_no) = '".strtolower($cnic_no)."' AND employee_id != '".$employee_id."'";
            //$where .= " AND company_id='" . $company_id . "' AND company_branch_id='" . $company_branch_id . "'";
            $row = $this->model['employee']->getRow($where);
            if ($row) {
                echo json_encode($this->language->get('error_duplicate_its'));
            } else {
                echo json_encode("true");
            }
        } else {
            echo json_encode($this->language->get('error_required'));
        }
        exit;
    }

    public function validateNICOB()
    {
        $nicob_no = $this->request->post['nicob_no'];
        //$company_id = $this->session->data['company_id'];
        //$company_branch_id = $this->session->data['company_branch_id'];
        $employee_id = $this->request->get['employee_id'];

        $this->load->language('employee/employee_profile');
        if ($nicob_no) {
            $this->model['employee'] = $this->load->model('employee/employee_profile');
            $where = " LOWER(nicob_no) = '".strtolower($nicob_no)."' AND employee_id != '".$employee_id."'";
            //$where .= " AND company_id='" . $company_id . "' AND company_branch_id='" . $company_branch_id . "'";
            $row = $this->model['employee']->getRow($where);
            if ($row) {
                echo json_encode($this->language->get('error_duplicate_nicob'));
            } else {
                echo json_encode("true");
            }
        } else {
            echo json_encode($this->language->get('error_required'));
        }
        exit;
    }

    protected function insertData($data) {
        $data['company_id'] = $this->session->data['company_id'];
        $data['employee_code'] = $this->model[$this->getAlias()]->getEmployeeCode();
        if($data['login_password']=='' || $data['login_id']=='') {
            unset($data['login_password']);
            unset($data['login_id']);
        } else {
            $data['login_password'] = md5($data['login_password']);
        }
        if($data['joining_date'] != '') {
            $data['joining_date'] = MySqlDate($data['joining_date']);
        } else {
            $data['joining_date'] = NULL;
        }
        if($data['dob'] != '') {
            $data['dob'] = MySqlDate($data['dob']);
        } else {
            $data['dob'] = NULL;
        }
        if($data['dob_date_hijri'] != '') {
            $data['dob_date_hijri'] = MySqlDate($data['dob_date_hijri']);
        } else {
            $data['dob_date_hijri'] = NULL;
        }
        if($data['joining_date_hijri'] != '') {
            $data['joining_date_hijri'] = MySqlDate($data['joining_date_hijri']);
        } else {
            $data['joining_date_hijri'] = NULL;
        }
        if($data['cnic_expiry'] != '') {
            $data['cnic_expiry'] = MySqlDate($data['cnic_expiry']);
        } else {
            $data['cnic_expiry'] = NULL;
        }
        if($data['probation_from'] != '') {
            $data['probation_from'] = MySqlDate($data['probation_from']);
        } else {
            $data['probation_from'] = NULL;
        }
        if($data['probation_to'] != '') {
            $data['probation_to'] = MySqlDate($data['probation_to']);
        } else {
            $data['probation_to'] = NULL;
        }
        if($data['eobi_date'] != '') {
            $data['eobi_date'] = MySqlDate($data['eobi_date']);
        } else {
            $data['eobi_date'] = NULL;
        }
        if($data['nicop_expiry'] != '') {
            $data['nicop_expiry'] = MySqlDate($data['nicop_expiry']);
        } else {
            $data['nicop_expiry'] = NULL;
        }
        if($data['passport_expiry'] != '') {
            $data['passport_expiry'] = MySqlDate($data['passport_expiry']);
        } else {
            $data['passport_expiry'] = NULL;
        }
        if(!isset($data['ramzan_enayat'])) {
            $data['ramzan_enayat'] =0;
        }
        $primary_key = $this->model[$this->getAlias()]->add($this->getAlias(), $data);

        $this->model['employee_bank'] = $this->load->model('employee/employee_bank');
        foreach($data['employee_banks'] as $sort_order => $bank) {
            $bank['employee_id'] = $primary_key;
            $bank['sort_order'] = $sort_order;

            $this->model['employee_bank']->add($this->getAlias(), $bank);
        }

        $this->model['employee_family'] = $this->load->model('employee/employee_family');
        $this->model['employee_family']->deleteBulk($this->getAlias(), array('employee_id' => $primary_key));
        foreach($data['families'] as $family) {
            $family['employee_id'] = $primary_key;
            if($family['dob']  != '') {
                $family['dob'] = MySqlDate($family['dob']);
            } else {
                unset($family['dob']);
            }
            if($family['period_start_date']  != '') {
                $family['period_start_date'] = MySqlDate($family['period_start_date']);
            } else {
                unset($family['period_start_date']);
            }
            if($family['period_end_date']  != '') {
                $family['period_end_date'] = MySqlDate($family['period_end_date']);
            } else {
                unset($family['period_end_date']);
            }

            $this->model['employee_family']->add($this->getAlias(), $family);
        }

        $this->model['employee_qualification'] = $this->load->model('employee/employee_qualification');
        $this->model['employee_qualification']->deleteBulk($this->getAlias(), array('employee_id' => $primary_key));
        foreach($data['qualifications'] as $qualification) {
            $qualification['employee_id'] = $primary_key;
            if($qualification['completion_date'] != '') {
                $qualification['completion_date'] = MySqlDate($qualification['completion_date']);
            }

            $this->model['employee_qualification']->add($this->getAlias(), $qualification);
        }

        return $primary_key;
    }

    protected function updateData($primary_key, $data) {
        //d($data, true);
        if($data['login_password']=='') {
            unset($data['login_password']);
        } else {
            $data['login_password'] = md5($data['login_password']);
        }
        if($data['joining_date'] != '') {
            $data['joining_date'] = MySqlDate($data['joining_date']);
        } else {
            $data['joining_date'] = NULL;
        }
        if($data['dob'] != '') {
            $data['dob'] = MySqlDate($data['dob']);
        } else {
            $data['dob'] = NULL;
        }
        if($data['dob_date_hijri'] != '') {
            $data['dob_date_hijri'] = MySqlDate($data['dob_date_hijri']);
        } else {
            $data['dob_date_hijri'] = NULL;
        }
        if($data['joining_date_hijri'] != '') {
            $data['joining_date_hijri'] = MySqlDate($data['joining_date_hijri']);
        } else {
            $data['joining_date_hijri'] = NULL;
        }
        if($data['cnic_expiry'] != '') {
            $data['cnic_expiry'] = MySqlDate($data['cnic_expiry']);
        } else {
            $data['cnic_expiry'] = NULL;
        }
        if($data['probation_from'] != '') {
            $data['probation_from'] = MySqlDate($data['probation_from']);
        } else {
            $data['probation_from'] = NULL;
        }
        if($data['probation_to'] != '') {
            $data['probation_to'] = MySqlDate($data['probation_to']);
        } else {
            $data['probation_to'] = NULL;
        }
        if($data['eobi_date'] != '') {
            $data['eobi_date'] = MySqlDate($data['eobi_date']);
        } else {
            $data['eobi_date'] = NULL;
        }
        if($data['nicop_expiry'] != '') {
            $data['nicop_expiry'] = MySqlDate($data['nicop_expiry']);
        } else {
            $data['nicop_expiry'] = NULL;
        }
        if($data['passport_expiry'] != '') {
            $data['passport_expiry'] = MySqlDate($data['passport_expiry']);
        } else {
            $data['passport_expiry'] = NULL;
        }
        if(!isset($data['ramzan_enayat'])) {
            $data['ramzan_enayat']=0;
        }


        $primary_key = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);

        $this->model['employee_bank'] = $this->load->model('employee/employee_bank');
        $this->model['employee_bank']->deleteBulk($this->getAlias(), array('employee_id' => $primary_key));
        foreach($data['employee_banks'] as $sort_order => $bank) {
            $bank['employee_id'] = $primary_key;
            $bank['sort_order'] = $sort_order;

            $this->model['employee_bank']->add($this->getAlias(), $bank);
        }

        $this->model['employee_family'] = $this->load->model('employee/employee_family');
        $this->model['employee_family']->deleteBulk($this->getAlias(), array('employee_id' => $primary_key));
        foreach($data['families'] as $sort_order => $family) {
            $family['employee_id'] = $primary_key;
            $family['sort_order'] = $sort_order;
            if($family['dob'] != '') {
                $family['dob'] = MySqlDate($family['dob']);
            } else {
                $family['dob'] = NULL;
            }
            if($family['period_start_date']  != '') {
                $family['period_start_date'] = MySqlDate($family['period_start_date']);
            } else {
                unset($family['period_start_date']);
            }
            if($family['period_end_date']  != '') {
                $family['period_end_date'] = MySqlDate($family['period_end_date']);
            } else {
                unset($family['period_end_date']);
            }

            $this->model['employee_family']->add($this->getAlias(), $family);
        }

        $this->model['employee_qualification'] = $this->load->model('employee/employee_qualification');
        $this->model['employee_qualification']->deleteBulk($this->getAlias(), array('employee_id' => $primary_key));
        foreach($data['qualifications'] as $sort_order => $qualification) {
            $qualification['employee_id'] = $primary_key;
            $qualification['sort_order'] = $sort_order;
            if($qualification['completion_date'] != '') {
                $qualification['completion_date'] = MySqlDate($qualification['completion_date']);
            }
            $this->model['employee_qualification']->add($this->getAlias(), $qualification);
        }
        return $primary_key;
    }
}
?>