<?php

class ControllerEmployeeEmployeeRegistration extends HController {

    protected function getAlias() {
        return 'employee/employee_registration';
    }

    protected function getPrimaryKey() {
        return 'employee_registration_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $this->load->language('employee/employee_profile');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'company_name', 'department_name','attendance_code', 'employee_code', 'registration_code', 'employee_name', 'designation_name', 'joining_date', 'leaving_date','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            if($aRow['paid_payroll']==0) {
                $actions[] = array(
                    'text' => $this->data['lang']['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }


            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'joining_date') {
                    $row[] = stdDate($aRow['joining_date']);
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();
        $this->model['department'] = $this->load->model('setup/department');
        $this->model['designation'] = $this->load->model('setup/designation');
        $this->model['employee'] = $this->load->model('employee/employee_profile');

        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));
        $this->data['designations'] = $this->model['designation']->getRows();
        $this->data['employees'] = $this->model['employee']->getRows();

        $this->model['allowance'] = $this->load->model('setup/company_allowance');
        $this->data['allowances'] = $this->model['allowance']->getArrays('allowance_id',array('allowance_id','allowance_name'),array('company_id' => $this->session->data['company_id']), array('allowance_name'));

        $this->model['deduction'] = $this->load->model('setup/company_deduction');
        $this->data['deductions'] = $this->model['deduction']->getArrays('deduction_id',array('deduction_id','deduction_name','default_value'),array('company_id' => $this->session->data['company_id']), array('deduction_name'));

        $this->model['allowance_type'] = $this->load->model('setup/special_allowance_type');
        $this->data['allowance_type'] = $this->model['allowance_type']->getRows();

        $this->model['attendance_shift'] = $this->load->model('setup/attendance_shift');
        $this->data['attendance_shifts'] = $this->model['attendance_shift']->getRows(array('company_id' => $this->session->data['company_id']), array('shift_title'));

        $this->data['status'] = "Inactive";
        if (isset($this->request->get['employee_registration_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('employee_registration_id' => $this->request->get['employee_registration_id']));
            foreach($result as $field => $value) {
                if($field=='joining_date' && $value!='') {
                    $this->data[$field] = stdDate($value);
                } elseif($field=='leaving_date' && $value!='') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
            $employee_salaries = $this->model['employee_salary']->getRows(array('employee_registration_id' => $result['employee_registration_id']));
            foreach($employee_salaries as $employee_salary) {
                $employee_salary['wef_date'] = stdDate($employee_salary['wef_date']);
                $this->data['employee_salaries'][] = $employee_salary;
            }

            $this->model['allowance_category'] = $this->load->model('setup/special_allowance_category');
            $allowance_categories = $this->model['allowance_category']->getRows();
            foreach($allowance_categories as $category) {
                $this->data['allowance_categories'][$category['special_allowance_type_id']][] = $category;
            }

            // d($this->data['allowance_categories'],true);

            $this->model['employee_allowance_policy'] = $this->load->model('employee/employee_allowance_policy');
            $this->data['employee_allowance_policy'] = $this->model['employee_allowance_policy']->getRows(array('employee_registration_id' => $result['employee_registration_id']),array('sort_order desc'));
            // d($this->data['employee_allowance_policy'],true);
            $this->model['employee_bank'] = $this->load->model('employee/employee_bank');
            $this->data['employee_banks'] = $this->model['employee_bank']->getRows(array('employee_id' => $result['employee_id']),array('sort_order desc'));

            //d($this->data['banks'], true);
        }

        $this->data['href_get_allowance_category'] = $this->url->link($this->getAlias() . '/getAllowanceCategory', 'token=' . $this->session->data['token']);

        $this->data['href_get_employee'] = $this->url->link($this->getAlias() . '/getEmployee', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['href_validate_attendance'] = $this->url->link($this->getAlias() . '/validateAttendanceCode', 'token=' . $this->session->data['token']);
        $this->data['href_get_employee_salary'] = $this->url->link($this->getAlias() . '/getEmployeeSalary', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['href_get_salary_info'] = $this->url->link($this->getAlias() . '/getSalaryInfo', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['href_get_tax_info'] = $this->url->link($this->getAlias() . '/getTaxInfo', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['action_validate_registration_code'] = $this->url->link($this->getAlias() . '/validateRegistrationCode', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['action_validate_employee'] = $this->url->link($this->getAlias() . '/validateEmployee', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['href_check_emp_loan'] = $this->url->link($this->getAlias() . '/checkEmployeeLoan', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);

        $this->data['strValidation']="{
            'rules':{
		        'registration_code': {'remote':  {url: '" . $this->data['action_validate_registration_code'] . "', type: 'post'}},
		        'employee_code': {'required':true},
		        'department_id': {'required':true},
		        'joining_date': {'required':true},
		        'leaving_date': {'required':true},
		        'status': {'required':true},
                'attendance_code': {'required':true},
            },
        }";

        $this->response->setOutput($this->render());
    }

    public function checkEmployeeLoan()
    {
        $post = $this->request->post;
        $this->model['loan_installment'] = $this->load->model('payroll/loan_installment');
        $results = $this->model['loan_installment']->getRows(array('employee_registration_id' => $post['employee_registration_id'], 'adjustment_type' => 'Payroll'));
        $flag = 0;
        foreach ($results as $key => $value) {
            if($value['payroll_id'] == '')
            {
                $flag = 1;
            }
        }
        $json = array(
            'success' => true,
            'loan_status' => $flag,
        );
        echo json_encode($json);
        exit;
    }

    public function getAllowanceCategory()
    {
        $post = $this->request->post;
        $type_id = $post['allowance_type'];
        $this->model['allowance_category'] = $this->load->model('setup/special_allowance_category');
        $result = $this->model['allowance_category']->getRows(array('special_allowance_type_id' => $type_id));

        $html = '<option value="0">ALL</option>';
        foreach ($result as $key => $value) {
            $html .= '<option value="'.$value['special_allowance_category_id'].'">'.$value['special_allowance_category'].'</option>';
        }
        $json = array(
            'success' => true,
            'html' => $html,
        );
        echo json_encode($json);
        exit;
    }

    public function getEmployee() {
        $post = $this->request->post;
        $employee_code = $post['employee_code'];
        $department_id = $post['department_id'];

        $this->model['employee'] = $this->load->model('employee/employee_profile');
        $employee = $this->model['employee']->getRow(array('employee_code' => $employee_code));
        if($employee) {
            $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
            $registration = $this->model['employee_registration']->getRow(array('company_id' => $this->session->data['company_id'], 'employee_id' => $employee['employee_id'], 'department_id' => $department_id));
            if($registration) {
                $json = array(
                    'success' => false,
                    'post' => $post,
                    'error' => 'Employee already registered.'
                );
            } else {
                $this->model['employee_bank'] = $this->load->model('employee/employee_bank');
                $banks = $this->model['employee_bank']->getRows(array('employee_id' => $employee['employee_id']));

                $html = '<option value="" data-bank_id="" data-bank_title="" data-bank_iban="">&nbsp;</option>';
                foreach($banks as $bank) {
                    $html .= '<option value="'.$bank['employee_bank_id'].'" data-bank_id="'.$bank['bank_id'].'" data-bank_title="'.$bank['account_title'].'" data-bank_account="'.$bank['account_no'].'" data-bank_iban="'.$bank['iban_no'].'">'.$bank['bank_name'].' - '.$bank['account_no'].'</option>';
                }
                $json = array(
                    'success' => true,
                    'post' => $post,
                    'employee_id' => $employee['employee_id'],
                    'employee_code' => $employee['employee_code'],
                    'employee_name' => $employee['full_name'],
                    'banks' => $html
                );
            }
        } else {
            $json = array(
                'success' => false,
                'post' => $post,
                'error' => 'Invalid Code. You might need to add profile or contact system administrator.'
            );
        }

        //d($json, true);
        echo json_encode($json);
        exit;
    }

    public function validateRegistrationCode()
    {
        $registration_code = $this->request->post['registration_code'];
        //$company_id = $this->session->data['company_id'];
        //$company_branch_id = $this->session->data['company_branch_id'];
        $employee_registration_id = $this->request->get['employee_registration_id'];

        $this->load->language('employee/employee');
        if ($registration_code) {
            $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
            $where = " LOWER(registration_code) = '".strtolower($registration_code)."' AND employee_registration_id != '".$employee_registration_id."'";
            //$where .= " AND company_id='" . $company_id . "' AND company_branch_id='" . $company_branch_id . "'";
            $row = $this->model['employee_registration']->getRow($where);
            if ($row) {
                echo json_encode($this->language->get('error_duplicate_name'));
            } else {
                echo json_encode("true");
            }
        }
        exit;
    }

    public function validateAttendanceCode()
    {
        $post = $this->request->post;
        $attendance_code = $post['attendance_code'];
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $result = $this->model['employee_registration']->validateAttendanceCode($attendance_code);
        if(!$result)
        {
            echo json_encode("Duplicate Attendance Code");
        }
    }

    public function validateEmployee() {
        $employee_id = $this->request->post['employee_id'];
        $company_id = $this->session->data['company_id'];
        //$company_branch_id = $this->session->data['company_branch_id'];
        $employee_registration_id = $this->request->get['employee_registration_id'];

        $this->load->language('employee/employee');
        if ($employee_id) {
            $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
            $where = " LOWER(employee_id) = '".strtolower($employee_id)."' AND employee_registration_id != '".$employee_registration_id."'";
            $where .= " AND company_id='" . $company_id . "'";
            //$where .= " AND company_branch_id='" . $company_branch_id . "'";
            $row = $this->model['employee']->getRow($where);
            if ($row) {
                echo json_encode($this->language->get('error_duplicate_employee'));
            } else {
                echo json_encode("true");
            }
        }
        exit;
    }

    public function getSalaryInfo() {
        $department_id = $this->request->post['department_id'];
        $employee_id = $this->request->post['employee_id'];
        $wef_date = $this->request->post['wef_date'];
        $basic_salary = $this->request->post['basic_salary'];
        $this->model['registration'] = $this->load->model('employee/employee_registration');
        $this->model['salary'] = $this->load->model('employee/employee_salary');
        $this->model['payroll'] = $this->load->model('payroll/payroll');

        //$registrations = $this->model['registration']->getRows(array('employee_id' => $employee_id, 'status' => 'Active'));
        $parent_company_id = $this->session->data['parent_company_id'];
        $company_id = $this->session->data['company_id'];
        if($parent_company_id != 0) {
            $registrations = $this->model['registration']->getRows(array('employee_id'=>$employee_id,'parent_company_id' => $parent_company_id, 'status'=>'Active'));
        } else {
            $registrations = $this->model['registration']->getRows(array('employee_id'=>$employee_id,'company_id'=>$company_id, 'status'=>'Active'));
        }
        $count = 0;
        $is_taxable = 0;
        //d([$department_id, $registrations], true);
        foreach($registrations as $registration) {
            if($registration['department_id'] != $department_id) {
                $count++;

                $arrWhere = array();
                $arrWhere[] = "`employee_registration_id`='".$registration['employee_registration_id']."'";
                $arrWhere[] = "`wef_date` <='".MySqlDate()."'";
                $salary = $this->model['salary']->getRow(implode(' AND ', $arrWhere), array('wef_date desc, created_at desc'));
                if($salary['taxable']=='Yes') {
                    $is_taxable = 1;
                }
            } else {
                $last_salary = $this->model['salary']->getRow(['employee_registration_id' => $registration['employee_registration_id']],['wef_date desc']);
                if($last_salary['wef_date'] > MySqlDate($wef_date)) {
                    $error_message = 'WEF Date should not be less than Last Salary Date.';
                } else {
                    $error_message = '';
                    $arrWhere = array();
                    $arrWhere[] = "`employee_registration_id`='".$registration['employee_registration_id']."'";
                    $arrWhere[] = "`document_date` >='".MySqlDate($wef_date)."'";
                    $arrWhere[] = "`exclude_payroll` = 0";
                    $payrolls = $this->model['payroll']->getRows(implode(' AND ', $arrWhere));
                    //d([$arrWhere, $payrolls], true);
                    $arrears = 0;
                    foreach($payrolls as $payroll) {
                        $arrears += $basic_salary-$payroll['basic_salary'];
                    }
                }
            }
        }
        if($error_message != '') {
            echo json_encode(
                array(
                    'success' => false,
                    'error' => $error_message,
                )
            );

        } else {
            $arrMessage = array();
            if($count > 0) {
                $arrMessage[] = 'Employee already registered in other ' . $count . ' Departments';
            }
            if($is_taxable == 1) {
                $arrMessage[] = 'Employee already marked as taxable in other Departments';
            }
            if($arrears != 0) {
                $arrMessage[] = 'Total '.number_format($arrears,0).' Arrears will be paid in next payroll';
            }

            $message = implode('<br />', $arrMessage);

            echo json_encode(
                array(
                    'success' => true,
                    'message' => $message,
                    'arrears' => $arrears,
                    'taxable' => $is_taxable
                )
            );
        }
    }

    public function getTaxInfo() {
        $post = $this->request->post;
        $employee_registration_id = $this->request->get['employee_registration_id'];
        $employee_id = $post['employee_id'];
        $document_date = MySqlDate($post['wef_date']);
        $taxable_salary = $post['taxable_amount'];

        $this->model['employee'] = $this->load->model('employee/employee_profile');
        $employee = $this->model['employee']->getRow(['employee_id' => $employee_id]);
        //d($post,true);
        $d1 = new DateTime($document_date);
        $d2 = new DateTime($employee['dob']);
        $diff = $d2->diff($d1);
        $age = $diff->y;
        $gender = $employee['gender'];

        $filter = array(
            'parent_company_id' => $this->session->data['parent_company_id'],
            'company_id' => $this->session->data['company_id'],
            'employee_registration_id' => $employee_registration_id,
            'employee_id' => $employee_id,
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'document_date' => $document_date,
            'taxable_salary' => $taxable_salary,
            'age' => $age,
            'gender' => $gender,
            'exclude_payroll' => 0,
            'registration' => 1,
        );
        //d($filter, true);

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $tax_info = $this->model['payroll']->getTaxDetail($filter);
        $arrTaxDescription = $tax_info['tax_description'];

        $html = '';
        $html .= '<table class="table table-bordered table-striped">';
        $html .= '<thead>';
        $html .= '<tr>';
        $html .= '<td>Description</td>';
        $html .= '<td>Amount</td>';
        $html .= '</tr>';
        $html .= '<tbody>';
        foreach($arrTaxDescription as $row) {
            $html .= '<tr>';
            if($row['break']) {
                $html .= '<td class="text-left" style="border-bottom: 1px solid black;">'.$row['description'].'</td>';
                $html .= '<td class="text-right" style="border-bottom: 1px solid black;">'.$row['value'].'</td>';
            } else {
                $html .= '<td class="text-left">'.$row['description'].'</td>';
                $html .= '<td class="text-right">'.$row['value'].'</td>';
            }
            $html .= '</tr>';
        }
        $html .= '</tbody>';

        $json = array(
            'success' => true,
            'html' => $html
        );

        echo json_encode($json);
    }

    protected function insertData($data) {
        // d($data,true);
        $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
        $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance');
        $this->model['employee_deduction'] = $this->load->model('employee/employee_deduction');
        $this->model['employee_allowance_policy'] = $this->load->model('employee/employee_allowance_policy');
        $this->model['employee_medical'] = $this->load->model('employee/employee_medical');
        $company_id = $this->session->data['company_id'];
        $data['registration_code'] = $this->model[$this->getAlias()]->getRegistrationCode($company_id);
        $data['company_id'] = $company_id;
        $data['joining_date'] = MySqlDate($data['joining_date']);
        if($data['leaving_date'] != '') {
            $data['leaving_date'] = MySqlDate($data['leaving_date']);
        } else {
            $data['leaving_date'] = NULL;
        }

        $employee_registration_id =  $this->model[$this->getAlias()]->add($this->getAlias(), $data);

        if($data['wef_date']!='' && $data['basic_salary']!='') {
            $data['wef_date'] = MySqlDate($data['wef_date']);
            if(isset($data['employee_salary_id']) && $data['employee_salary_id']) {
                $update_data = array(
                    'company_id' => $this->session->data['company_id'],
                    'employee_registration_id' => $employee_registration_id,
                    'employee_id' => $data['employee_id'],
                    'department_id' => $data['department_id'],
                    'wef_date' => $data['wef_date'],
                    'basic_salary' => $data['basic_salary'],
                    'total_allowance' => $data['total_allowance'],
                    'gross_amount' => $data['gross_amount'],
                    'taxable_amount' => $data['taxable_amount'],
                    'total_deduction' => $data['total_deduction'],
                    'net_amount' => $data['net_amount'],
                    'taxable' => (isset($data['taxable'])?'Yes':'No'),
                    'taxable_house_rent' => (isset($data['taxable_house_rent'])?'Yes':'No'),
                    'taxable_house_rent_percent' => $data['taxable_house_rent_percent'],
                );

                $employee_salary_id = $this->model['employee_salary']->edit($this->getAlias(), $data['employee_salary_id'], $update_data);
                $this->model['employee_allowance']->deleteBulk($this->getAlias(), array('employee_salary_id' => $data['employee_salary_id']));
                $this->model['employee_deduction']->deleteBulk($this->getAlias(), array('employee_salary_id' => $data['employee_salary_id']));

            } else {
                $insert_data = array(
                    'company_id' => $this->session->data['company_id'],
                    'employee_registration_id' => $employee_registration_id,
                    'employee_id' => $data['employee_id'],
                    'department_id' => $data['department_id'],
                    'wef_date' => $data['wef_date'],
                    'basic_salary' => $data['basic_salary'],
                    'total_allowance' => $data['total_allowance'],
                    'gross_amount' => $data['gross_amount'],
                    'taxable_amount' => $data['taxable_amount'],
                    'total_deduction' => $data['total_deduction'],
                    'net_amount' => $data['net_amount'],
                    'taxable' => (isset($data['taxable'])?'Yes':'No'),
                    'taxable_house_rent' => (isset($data['taxable_house_rent'])?'Yes':'No'),
                    'taxable_house_rent_percent' => $data['taxable_house_rent_percent'],
                );

                $employee_salary_id = $this->model['employee_salary']->add($this->getAlias(), $insert_data);
            }

            foreach($data['employee_allowances'] as $allowance) {
                $allowance['employee_salary_id'] = $employee_salary_id;

                $this->model['employee_allowance']->add($this->getAlias(), $allowance);
            }

            foreach($data['employee_deductions'] as $deduction) {
                $deduction['employee_salary_id'] = $employee_salary_id;

                $this->model['employee_deduction']->add($this->getAlias(), $deduction);
            }
        }

        foreach($data['employee_scholarships'] as $scholarship) {
            $scholarship['employee_registration_id'] = $employee_registration_id;
            // d($scholarship,true);
            $this->model['employee_allowance_policy']->add($this->getAlias(), $scholarship);
        }

        return $employee_registration_id;
    }

    protected function updateData($primary_key, $data) {
        if(!isset($data['override_attendance_policy'])) {
            $data['override_attendance_policy']=0;
        }
        if(!isset($data['override_allowance_policy'])) {
            $data['override_allowance_policy']=0;
        }
        if(!isset($data['attendance_exempted'])) {
            $data['attendance_exempted']=0;
        }
        // d($primary_key);
        // d($data,true);
        $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
        $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance');
        $this->model['employee_deduction'] = $this->load->model('employee/employee_deduction');
        $this->model['employee_allowance_policy'] = $this->load->model('employee/employee_allowance_policy');

        foreach($data['removeSalaries'] as $employee_salary_id) {
            $this->model['employee_allowance']->deleteBulk($this->getAlias(), array('employee_salary_id' => $employee_salary_id));
            $this->model['employee_deduction']->deleteBulk($this->getAlias(), array('employee_salary_id' => $employee_salary_id));
            $this->model['employee_salary']->delete($this->getAlias(), $employee_salary_id);
        }

        $data['company_id'] = $this->session->data['company_id'];
        $data['joining_date'] = MySqlDate($data['joining_date']);
        if($data['leaving_date'] != '') {
            $data['leaving_date'] = MySqlDate($data['leaving_date']);
        } else {
            $data['leaving_date'] = NULL;
        }

        if(!isset($data['attendance_exempted']))
        {
            $data['attendance_exempted'] = 0;
        }

        $employee_registration_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);

        if($data['wef_date']!='' && $data['basic_salary']!='') {
            $data['wef_date'] = MySqlDate($data['wef_date']);

            if(isset($data['employee_salary_id']) && $data['employee_salary_id']) {
                $update_data = array(
                    'company_id' => $this->session->data['company_id'],
                    'employee_registration_id' => $employee_registration_id,
                    'employee_id' => $data['employee_id'],
                    'department_id' => $data['department_id'],
                    'wef_date' => $data['wef_date'],
                    'basic_salary' => $data['basic_salary'],
                    'total_allowance' => $data['total_allowance'],
                    'gross_amount' => $data['gross_amount'],
                    'taxable_amount' => $data['taxable_amount'],
                    'total_deduction' => $data['total_deduction'],
                    'net_amount' => $data['net_amount'],
                    'taxable' => (isset($data['taxable'])?'Yes':'No'),
                    'taxable_house_rent' => (isset($data['taxable_house_rent'])?'Yes':'No'),
                    'taxable_house_rent_percent' => $data['taxable_house_rent_percent'],
                );

                $employee_salary_id = $this->model['employee_salary']->edit($this->getAlias(), $data['employee_salary_id'], $update_data);
                $this->model['employee_allowance']->deleteBulk($this->getAlias(), array('employee_salary_id' => $data['employee_salary_id']));
                $this->model['employee_deduction']->deleteBulk($this->getAlias(), array('employee_salary_id' => $data['employee_salary_id']));

            } else {
                $insert_data = array(
                    'company_id' => $this->session->data['company_id'],
                    'employee_registration_id' => $employee_registration_id,
                    'employee_id' => $data['employee_id'],
                    'department_id' => $data['department_id'],
                    'wef_date' => $data['wef_date'],
                    'basic_salary' => $data['basic_salary'],
                    'total_allowance' => $data['total_allowance'],
                    'gross_amount' => $data['gross_amount'],
                    'taxable_amount' => $data['taxable_amount'],
                    'total_deduction' => $data['total_deduction'],
                    'net_amount' => $data['net_amount'],
                    'taxable' => (isset($data['taxable'])?'Yes':'No'),
                    'taxable_house_rent' => (isset($data['taxable_house_rent'])?'Yes':'No'),
                    'taxable_house_rent_percent' => $data['taxable_house_rent_percent'],
                );

                $employee_salary_id = $this->model['employee_salary']->add($this->getAlias(), $insert_data);
            }

            //d($data['employee_allowances'], true);
            foreach($data['employee_allowances'] as $allowance) {
                $allowance['employee_salary_id'] = $employee_salary_id;
                $allowance['employee_registration_id'] = $employee_registration_id;

                $this->model['employee_allowance']->add($this->getAlias(), $allowance);
            }

            foreach($data['employee_deductions'] as $deduction) {
                $deduction['employee_salary_id'] = $employee_salary_id;
                $deduction['employee_registration_id'] = $employee_registration_id;

                $this->model['employee_deduction']->add($this->getAlias(), $deduction);
            }
        }

        $this->model['employee_allowance_policy']->deleteBulk($this->getAlias(), array('employee_registration_id' => $employee_registration_id));

        foreach($data['employee_scholarships'] as $scholarship) {
            $scholarship['employee_registration_id'] = $employee_registration_id;
            // d($scholarship,true);
            $this->model['employee_allowance_policy']->add($this->getAlias(), $scholarship);
        }

        return $employee_registration_id;
    }

    public function getEmployeeSalary() {
        $post = $this->request->post;
        $employee_salary_id = $post['employee_salary_id'];

        $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
        $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance');
        $this->model['employee_deduction'] = $this->load->model('employee/employee_deduction');

        $employee_salary = $this->model['employee_salary']->getRow(array('employee_salary_id' => $employee_salary_id));
        $employee_allowances = $this->model['employee_allowance']->getRows(array('employee_salary_id' => $employee_salary_id));
        $employee_deductions = $this->model['employee_deduction']->getRows(array('employee_salary_id' => $employee_salary_id));

        //d($employee_salary, true);
        $data['employee_salary_id'] = $employee_salary['employee_salary_id'];
        $data['wef_date'] = stdDate($employee_salary['wef_date']);
        $data['basic_salary'] = $employee_salary['basic_salary'];
        $data['taxable'] = $employee_salary['taxable'];
        $data['taxable_house_rent'] = $employee_salary['taxable_house_rent'];
        $data['taxable_house_rent_percent'] = $employee_salary['taxable_house_rent_percent'];
        $total_allowance = 0;
        $total_deduction = 0;
        foreach($employee_allowances as $allowance) {
            $data['employee_allowance_'.$allowance['allowance_id'].'_allowance_amount'] = $allowance['allowance_amount'];
            $data['employee_allowance_'.$allowance['allowance_id'].'_grossable'] = $allowance['grossable'];
            $data['employee_allowance_'.$allowance['allowance_id'].'_taxable'] = $allowance['taxable'];
            $total_allowance += $allowance['allowance_amount'];
        }
        foreach($employee_deductions as $deduction) {
            $data['employee_deduction_'.$deduction['deduction_id'].'_deduction_amount'] = $deduction['deduction_amount'];
            $total_deduction += $deduction['deduction_amount'];
        }
        $data['total_allowance'] = $total_allowance;
        $data['gross_amount'] = $employee_salary['gross_amount'];
        $data['taxable_amount'] = $employee_salary['taxable_amount'];
        $data['total_deduction'] = $total_deduction;
        $data['net_amount'] = $data['gross_amount'] - $total_deduction;

        $json = array(
            'success' => true,
            'post' => $post,
            'data' => $data
        );

        echo json_encode($json);
    }
}

?>