<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require DIR_SYSTEM . 'library/PHPMailer/Exception.php';
require DIR_SYSTEM . 'library/PHPMailer/PHPMailer.php';
require DIR_SYSTEM . 'library/PHPMailer/SMTP.php';

class ControllerEmployeeHODLeave extends HController
{

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('employee/employee_leave');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getAlias()
    {
        return 'employee/hod_leave';
    }

    protected function getPrimaryKey()
    {
        return 'employee_leave_id';
    }

    protected function validateDocument()
    {
        return false;
    }

    protected function getList()
    {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists()
    {

        $this->load->language('employee/employee_leave');
        $this->model[$this->getAlias()] = $this->load->model('employee/hod_leave');
        $data = array();
        $aColumns = array('action', 'request_date', 'employee_name', 'leave_date', 'reason', 'status', 'approved_type', 'approved_date', 'created_at', 'check_box');
        $aFields = array('action', 'el.request_date', 'e.full_name', 'el.leave_date', 'el.reason', 'el.status', 'el.approved_type', 'el.approved_date', 'el.created_at', 'check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "" . $aColumns[intval($_GET['iSortCol_' . $i])] . " " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            //$data['criteria']['orderby'] = $sOrder;
            $sort_order = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "ud.`company_id` = '" . $this->session->data['company_id'] . "'";
        $arrWhere[] = "ud.`user_id` = '" . $this->session->data['user_id'] . "'";
        $arrWhere[] = "el.`status` != 'Pending'";
        //$arrWhere[] = "`is_post` = 1";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aFields); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(" . $aFields[$i] . ") LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if (!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aFields); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aFields[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            //$data['filter']['RAW'] = implode(' AND ', $arrWhere);
            $filter = implode(' AND ', $arrWhere);
        }

        // d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($filter, $sort_order);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            if($aRow['status']=='Pending Verification') {
                $actions[] = array(
                    'text' => $this->data['lang']['edit'],
                    'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                    'btn_class' => 'btn btn-primary btn-xs',
                    'class' => 'fa fa-pencil'
                );

                $actions[] = array(
                    'text' => $this->data['lang']['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $actions[] = array(
                'text' => $this->data['lang']['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printLetter', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a ' . (isset($action['btn_class']) ? 'class="' . $action['btn_class'] . '"' : '') . ' ' . (isset($action['target']) ? 'target="' . $action['target'] . '"' : '') . ' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'request_date') {
                    $row[] = stdDate($aRow['request_date']);
                } elseif ($aColumns[$i] == 'leave_date') {
                    $row[] = '<label class="help-content">From:&nbsp;</label>' . stdDate($aRow['leave_from']) . '<br /><label class="help-content">To:&nbsp;</label>' . stdDate($aRow['leave_to']);
                } elseif ($aColumns[$i] == 'approved_type') {
                    if ($aRow['status'] == 'Approved') {
                        $row[] = ($aRow['approved_type'] == 'WV' ? 'Leave Waved' : ($aRow['approved_type'] == 'LP' ? 'Leave with Pay' : 'Leave with Deduction'));
                    } else {
                        $row[] = '';
                    }
                } elseif ($aColumns[$i] == 'approved_date') {
                    if ($aRow['status'] == 'Approved') {
                        $row[] = '<label class="help-content">From:&nbsp;</label>' . stdDate($aRow['approved_from']) . '<br /><label class="help-content">To:&nbsp;</label>' . stdDate($aRow['approved_to']);
                    } else {
                        $row[] = '';
                    }
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm()
    {
        $session = $this->session->data;
        parent::getForm();

        $this->model['user_department'] = $this->load->model('user/user_department');
        $departments = $this->model['user_department']->getArrays('department_id','department_id',['company_id'=> $session['company_id'],'user_id'=>$session['user_id']]);
        $department_ids = implode("','",$departments);

        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        //$this->data['employee_registrations'] = $this->model['employee_registration']->getRows(array('company_id' => $this->session->data['company_id']));

        $arrWhere = [];
        $arrWhere[] = "er.company_id = '".$session['company_id']."'";
        $arrWhere[] = "er.status = 'Active'";
        $arrWhere[] = "er.department_id IN ('$department_ids')";
        $where = implode(" AND ", $arrWhere);
        $this->data['employee_registrations'] = $this->model['employee_registration']->getRecords($where, ['employee_name']);

        $this->data['request_date'] = stdDate();
        if (isset($this->request->get['employee_leave_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('employee_leave_id' => $this->request->get['employee_leave_id']));
            foreach ($result as $field => $value) {
                if ($field == 'request_date') {
                    $this->data[$field] = stdDate($value);
                } elseif ($field == 'leave_from') {
                    $this->data[$field] = stdDate($value);
                } elseif ($field == 'leave_to') {
                    $this->data[$field] = stdDate($value);
                } elseif ($field == 'approved_from' && $value != '') {
                    $this->data[$field] = stdDate($value);
                } elseif ($field == 'approved_to' && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->data['leaves'] = $this->model[$this->getAlias()]->getRows(array('company_id' => $this->session->data['company_id'], 'employee_registration_id' => $result['employee_registration_id']));
        }

        $this->data['href_return'] = $this->url->link($this->getAlias() . '/returnDocument', 'token=' . $this->session->data['token'] . '&employee_leave_id=' . $this->request->get['employee_leave_id']);
        $this->data['action_validate_name'] = $this->url->link($this->getAlias() . '/validateName', 'token=' . $this->session->data['token'] . '&employee_leave_id=' . $this->request->get['employee_leave_id']);
        $this->data['strValidation'] = "{
            'rules':{
		        'request_date': {'required':true},
		        'employee_registration_id': {'required':true},
		        'leave_from': {'required':true},
		        'leave_to': {'required':true},
		        'reason': {'required':true},
            },
        }";

        $this->response->setOutput($this->render());
    }

    public function returnDocument() {
        $employee_leave_id = $this->request->get['employee_leave_id'];

        $this->model['employee_leave'] = $this->load->model('employee/employee_leave');
        $leave = $this->model['employee_leave']->getRow(['employee_leave_id' => $employee_leave_id]);
        if($leave['status']=='Pending Verification') {
            $this->model['employee_leave']->edit($this->getAlias(), $employee_leave_id, ['status' => 'Pending']);
            $this->session->data['success'] = 'Document Updated Successfully';
        } else {
            $this->session->data['error'] = 'Error in Processing the Document';
        }

        $this->redirect($this->url->link($this->getAlias(), 'token=' . $this->session->data['token'], 'SSL'));
    }

    protected function insertData($data)
    {
        $submit = $this->request->get['submit'];
        $this->model['company'] = $this->load->model('setup/company');
        $company = $this->model['company']->getRow(['company_id' => $this->session->data['company_id']]);
        $data['company_id'] = $this->session->data['company_id'];
        $data['request_date'] = MySqlDate($data['request_date']);
        $data['leave_from'] = MySqlDate($data['leave_from']);
        $data['leave_to'] = MySqlDate($data['leave_to']);
        if($submit==1) {
            $data['status'] = 'Requested';
        } else {
            $data['status'] = 'Pending Verification';
        }
        $employee_leave_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);

        //If Requested then Send SMS & Email to Authorize Person.
        if($data['status']=='Requested' && $submit==1) {
            $this->model['core_setting'] = $this->load->model('setup/core_setting');
            $config = $this->model['core_setting']->getConfig(['company_id' => $this->session->data['company_id']]);

            $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
            $employee = $this->model['employee_registration']->getRow(['employee_registration_id' => $data['employee_registration_id']]);
            if($company['approval_authority_mobile']) {
                $arrMobiles = explode(",", $company['approval_authority_mobile']);
                foreach($arrMobiles as $mobile_no) {
                    $user_name = $config['sms_user_name'];
                    $password = $config['sms_password'];
                    $from_mask = $config['sms_from_mask'];

                    $employee_name = $employee['employee_name'];
                    $message = "Leave application has been submitted by $employee_name for your approval.";
                    //d($config, true);
                    $mobile_no = str_replace("+92","0",str_replace(" ","",$mobile_no));
                    //$mobile_no = '03332221175';
                    $url = 'https://connect.jazzcmt.com/sendsms_url.html?Username='.$user_name.'&Password='.$password.'&From='.$from_mask.'&To='.$mobile_no.'&Message=' . urlencode($message);
                    $response = file_get_contents($url);
                }
            }

            if($company['approval_authority_email']) {
                $arrEmails = explode(",", $company['approval_authority_email']);
                $html_body = '';
                $html_body .= 'Company: '. $employee['company_name'].'<br />';
                $html_body .= 'Department: '. $employee['department_name'].'<br />';
                $html_body .= 'Employee Code: '. $employee['registration_code'].'<br />';
                $html_body .= 'Employee Name: '. $employee['employee_name'].'<br />';
                foreach($arrEmails as $email) {
                    try {
                        $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
                        $mail->SMTPOptions = array(
                            'ssl' => array(
                                'verify_peer' => false,
                                'verify_peer_name' => false,
                                'allow_self_signed' => true
                            )
                        );
                        //Server settings
                        $mail->SMTPDebug = 0;                                 // Enable verbose debug output
                        $mail->isSMTP();                                      // Set mailer to use SMTP
                        $mail->Host = $config['config_mail_smtp_hostname'];
                        $mail->SMTPAuth = true;
                        $mail->Username = $config['config_mail_smtp_username']; //paste one generated by Mailtrap
                        $mail->Password = $config['config_mail_smtp_password']; //paste one generated by Mailtrap
                        //$mail->SMTPSecure = 'tls';
                        $mail->Port = $config['config_mail_smtp_port'];
                        $mail->setFrom($config['config_mail_smtp_username'], $config['config_mail_smtp_displayname']);
                        $mail->addAddress($email);
                        //$mail->addAddress('huzaifa.khambaty@gmail.com');
                        $mail->isHTML(true);
                        // Set email format to HTML
                        $mail->Subject = "New Leave request";
                        $mail->Body    = $html_body;
                        $mail->Send();
                    } catch(Exception $e) {

                    }
                }
            }
        }

        return $employee_leave_id;
    }

    protected function updateData($primary_key, $data)
    {
        $this->model['company'] = $this->load->model('setup/company');
        $company = $this->model['company']->getRow(['company_id' => $this->session->data['company_id']]);
        $submit = $this->request->get['submit'];
        $data['request_date'] = MySqlDate($data['request_date']);
        $data['leave_from'] = MySqlDate($data['leave_from']);
        $data['leave_to'] = MySqlDate($data['leave_to']);
        if($submit==1) {
            $data['status'] = 'Requested';
        } else {
            $data['status'] = 'Pending Verification';
        }
        $employee_leave_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);

        //If Requested then Send SMS & Email to Authorize Person.
        if($data['status']=='Requested' && $submit==1) {
            $this->model['core_setting'] = $this->load->model('setup/core_setting');
            $config = $this->model['core_setting']->getConfig(['company_id' => $this->session->data['company_id']]);

            $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
            $employee = $this->model['employee_registration']->getRow(['employee_registration_id' => $data['employee_registration_id']]);
            if($company['approval_authority_mobile']) {
                $arrMobiles = explode(",", $company['approval_authority_mobile']);
                foreach($arrMobiles as $mobile_no) {
                    $user_name = $config['sms_user_name'];
                    $password = $config['sms_password'];
                    $from_mask = $config['sms_from_mask'];

                    $employee_name = $employee['employee_name'];
                    $message = "Leave application has been submitted by $employee_name for your approval.";
                    //d($config, true);
                    $mobile_no = str_replace("+92","0",str_replace(" ","",$mobile_no));
                    //$mobile_no = '03332221175';
                    $url = 'https://connect.jazzcmt.com/sendsms_url.html?Username='.$user_name.'&Password='.$password.'&From='.$from_mask.'&To='.$mobile_no.'&Message=' . urlencode($message);
                    $response = file_get_contents($url);
                }
            }

            if($company['approval_authority_email']) {
                $arrEmails = explode(",", $company['approval_authority_email']);
                $html_body = '';
                $html_body .= 'Company: '. $employee['company_name'].'<br />';
                $html_body .= 'Department: '. $employee['department_name'].'<br />';
                $html_body .= 'Employee Code: '. $employee['registration_code'].'<br />';
                $html_body .= 'Employee Name: '. $employee['employee_name'].'<br />';
                foreach($arrEmails as $email) {
                    try {
                        $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
                        $mail->SMTPOptions = array(
                            'ssl' => array(
                                'verify_peer' => false,
                                'verify_peer_name' => false,
                                'allow_self_signed' => true
                            )
                        );
                        //Server settings
                        $mail->SMTPDebug = 0;                                 // Enable verbose debug output
                        $mail->isSMTP();                                      // Set mailer to use SMTP
                        $mail->Host = $config['config_mail_smtp_hostname'];
                        $mail->SMTPAuth = true;
                        $mail->Username = $config['config_mail_smtp_username']; //paste one generated by Mailtrap
                        $mail->Password = $config['config_mail_smtp_password']; //paste one generated by Mailtrap
                        //$mail->SMTPSecure = 'tls';
                        $mail->Port = $config['config_mail_smtp_port'];
                        $mail->setFrom($config['config_mail_smtp_username'], $config['config_mail_smtp_displayname']);
                        $mail->addAddress($email);
                        //$mail->addAddress('huzaifa.khambaty@gmail.com');
                        $mail->isHTML(true);
                        // Set email format to HTML
                        $mail->Subject = "New Leave request";
                        $mail->Body    = $html_body;
                        $mail->Send();
                    } catch(Exception $e) {

                    }
                }
            }
        }

        return $employee_leave_id;
    }

    public function printLetter()
    {
        $employee_leave_id = $this->request->get['employee_leave_id'];
        $lang = $this->load->language('employee/employee_leave');
        $session = $this->session->data;

        $this->model['employee_leave'] = $this->load->model('employee/employee_leave');
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['employee'] = $this->load->model('employee/employee_profile');
        $this->model['employee_attendance'] = $this->load->model('employee/employee_attendance');

        $leave = $this->model['employee_leave']->getRow(array('employee_leave_id' => $employee_leave_id));
        $registration = $this->model['employee_registration']->getRow(array('employee_registration_id' => $leave['employee_registration_id']));
        $employee = $this->model['employee']->getRow(array('employee_id' => $registration['employee_id']));
        $YA = $this->model['employee_attendance']->getYearlyAttendance($leave['employee_registration_id'], $session['fiscal_date_from'], $session['fiscal_date_to']);

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Covering Letter:' . $registration['registration_code'] . '|' . $registration['employee_code'] . '@' . date('YmdHis'));
        $pdf->SetSubject('Leave Covering Letter');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 20, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        $pdf->data = array(
            'company_name' => $registration['company_name'],
        );
        $pdf->lang = $lang;
        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();
        if ($employee['employee_image'] != '' && file_exists(DIR_IMAGE . $employee['employee_image'])) {
            $employee_image = DIR_IMAGE . $employee['employee_image'];
        } else {
            $employee_image = DIR_IMAGE . 'no_user.jpg';
        }
        $pdf->Image($employee_image, 15, 20, 25, 25);

        $pdf->SetDrawColor(205, 205, 205);
        $pdf->SetFillColor(255, 127, 80);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(25, 6, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(120, 6, 'Name: ' . $registration['employee_name'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(35, 6, 'Leave Request', 0, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->ln(6);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(120, 6, 'Department: ' . $registration['department_name'], '', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(35, 6, 'Date: ' . stdDate($leave['request_date']), 0, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->ln(6);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(120, 6, 'Designation: ' . $registration['designation_name'], '', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(25, 6, 'No. of Leaves:', 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(10, 6, $YA['yearly_leave'], 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->ln(6);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(120, 6, 'Joining Date: ' . stdDate($registration['joining_date']), '', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(25, 6, 'Applied Leaves:', 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(10, 6, ($YA['LD']+$YA['LP']), 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->ln(6);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(120, 6, 'ITS No.' . $employee['its_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(25, 6, 'Late:', 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(10, 6, round($YA['Late']/$YA['late_deduction']), 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->ln(6);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(120, 6, '', '', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(25, 6, 'Balance:', 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(10, 6, $YA['yearly_leave']-($YA['LP']+$YA['LD']+round($YA['Late']/$YA['late_deduction'])), 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->ln(6);

        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(20, 8, 'Subject:', 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(160, 8, $leave['reason'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(8);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(20, 8, 'From Date:', 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(20, 8, stdDate($leave['leave_from']), 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(20, 8, '', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(20, 8, 'To Date:', 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(20, 8, stdDate($leave['leave_to']), 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(8);
        $pdf->MultiCell(180, 24, $leave['description'], 1, 'L');
        $pdf->ln(32);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(135, 8, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(45, 8, 'Applicant Signature', 'T', false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->ln(16);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(0, 8, 'For Office Use', 'TB', 0, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->ln(16);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(30, 8, 'Status:', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(15, 8, 'Approve', 1, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(15, 8, 'Reject', 1, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 8, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(30, 8, 'Approve Type:', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(15, 8, 'LP', 1, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(15, 8, 'LD', 1, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->ln(16);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(30, 8, 'From Date:', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 8, '', 'B', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 8, '', '', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 8, 'To Date:', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 8, '', 'B', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(32);
        $pdf->Cell(120, 8, '', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 8, 'Authorize Signature', 'T', false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->Ln("20");
        $pdf->SetFont('helvetica', 'B', 16);
        $pdf->Cell(150, 8, 'Previous Leaves', 'B', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Ln("15");
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(20, 8, 'Request On', 'BT', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(50, 8, 'Leave Request', 'BT', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 8, 'Reason', 'BT', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(20, 8, 'Status', 'BT', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(50, 8, 'Leave Approved:', 'BT', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(20, 8, 'Leave Type', 'BT', false, 'L', 0, '', 0, false, 'T', 'M');
        $this->model[$this->getAlias()] = $this->load->model('employee/employee_leave');
        $leaves = $this->model[$this->getAlias()]->getRows(array('company_id' => $this->session->data['company_id'],
            'employee_registration_id' => $leave['employee_registration_id']));
//        $pdf->Ln("10");
        $employee_leave_id = $leave['employee_leave_id'];
        $pdf->SetFont('helvetica', '', 8);

        foreach ($leaves as $detail) {
            if ($detail['employee_leave_id'] != $employee_leave_id) {
                $pdf->Ln("10");

                $pdf->Cell(20, 8, stdDate($detail['request_date']), 'BT', false, 'L', 0, '', 0, false, 'T', 'M');
                $pdf->Cell(50, 8, stdDate($detail['leave_from']) . ' - ' . stdDate($detail['leave_to']), 'BT', false, 'L', 0, '', 0, false, 'T', 'M');
                $pdf->Cell(30, 8, $detail['reason'], 'BT', false, 'L', 0, '', 1, false, 'T', 'M');
                $pdf->Cell(20, 8, $detail['status'], 'BT', false, 'L', 0, '', 0, false, 'T', 'M');

                if ($detail['status'] == 'Approved') {
                    $leave_approved = stdDate($detail['approved_from']) . ' - ' . stdDate($detail['approved_to']);
                    $leave_approved_type = $detail['approved_type'] == 'LP' ? 'Leave with Pay' : 'Leave with Deduction';
                } else {
                    $leave_approved = "";
                    $leave_approved_type = "";
                }

                $pdf->Cell(50, 8, $leave_approved, 'BT', false, 'L', 0, '', 0, false, 'T', 'M');
                $pdf->Cell(20, 8, $leave_approved_type, 'BT', false, 'L', 0, '', 0, false, 'T', 'M');
                $pdf->Ln("5");
                $pdf->Cell(500, 8, 'Reason :'.$detail['description'], 'T', false, 'L', 0, '', 0, false, 'T', 'T');
            }
        }


        $pdf->Output('Covering Letter:' . $registration['registration_code'] . '|' . $registration['employee_code'] . '@' . date('YmdHis') . '.pdf', 'I');
    }
}

class PDF extends TCPDF
{
    public $lang;
    public $data;

    //Page header
    public function Header()
    {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        // Title
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('helvetica', 'B', 14);
//        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('helvetica', '', 14);
//        $this->Cell(0, 10, $this->data['subtitle'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(60, 10, 'Ref: ' . $this->data['document_identity'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Page ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Date: ' . date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}

?>