<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

//require DIR_SYSTEM . 'library/PHPMailer/Exception.php';
//require DIR_SYSTEM . 'library/PHPMailer/PHPMailer.php';
//require DIR_SYSTEM . 'library/PHPMailer/SMTP.php';

class ControllerEmployeeHospitalRecommendation extends HController
{
    
    protected function getAlias()
    {
        return 'employee/hospital_recommendation';
    }

    protected function getPrimaryKey()
    {
        return 'hospital_recommendation_id';
    }

    protected function validateDocument()
    {
        return false;
    }

    protected function getList()
    {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists()
    {

        $lang = $this->load->language('employee/hospital_recommendation');
        $this->model[$this->getAlias()] = $this->load->model('employee/hospital_recommendation');
        $data = array();
        $aColumns = array('action', 'employee_code', 'employee_name', 'hospital_name', 'document_date', 'document_identity', 'created_at', 'check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow['hospital_recommendation_id'], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $lang['print'],
                'href' => $this->url->link($this->getAlias() . '/printLetter', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow['hospital_recommendation_id'], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-print'
            );

            $actions[] = array(
                'text' => $lang['delete'],
                'href' => 'javascript:void(0);',
                'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow['hospital_recommendation_id'], 'SSL') . "')",
                'btn_class' => 'btn btn-danger btn-xs',
                'class' => 'fa fa-times'
            );

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a ' . (isset($action['btn_class']) ? 'class="' . $action['btn_class'] . '"' : '') . ' ' . (isset($action['target']) ? 'target="' . $action['target'] . '"' : '') . ' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm()
    {
        $session = $this->session->data;
        parent::getForm();

        $this->model['company'] = $this->load->model('setup/company');
        $this->data['companies'] = $this->model['company']->getRows([],['company_name']);

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee']->getRows(['status'=>'Active'],['employee_name']);

        $this->data['document_no'] = 'AUTO';
        $this->data['document_date'] = stdDate();

        $this->model['hospital_recommendation'] = $this->load->model('employee/hospital_recommendation');
        if (isset($this->request->get['hospital_recommendation_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('hospital_recommendation_id' => $this->request->get['hospital_recommendation_id']));
            foreach ($result as $field => $value) {
                if ($field == 'document_date' && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }
        }

        $this->data['href_get_company_employees'] = $this->url->link($this->getAlias() . '/getCompanyEmployees', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['strValidation'] = "{
            'rules':{
		        'document_date': {'required':true},
		        'employee_id': {'required':true},
		        'document_date': {'required':true},
		        'hospital_name': {'required':true},
		        'hospital_address_1': {'required':true},
		        'hospital_address_2': {'required':true},
		        'signatory_name': {'required':true},
            },
        }";

        $this->response->setOutput($this->render());
    }

    public function getCompanyEmployees() {
        $company_id = $this->request->post['company_id'];

        if($company_id != '') {
            $filter['company_id'] = $company_id;
        }

        $filter['status'] = 'Active';
        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $employees = $this->model['employee']->getDistinctRows(['employee_id','employee_code','employee_name','its_no'],$filter, ['employee_name']);

        $html = '<option data-employee_code="" data-employee_name="" value="">&nbsp;</option>'.PHP_EOL;
        foreach($employees as $employee) {
            $html .= '<option data-employee_code="'.$employee['employee_code'].'" data-employee_name="'.$employee['employee_name'].'" value="'.$employee['employee_id'].'">'.$employee['employee_code'].': '.$employee['employee_name']. ($employee['its_no']==''?'':' - '.$employee['its_no']).'</option>'.PHP_EOL;
        }

        $json = [
            'success' => true,
            'employees' => $html
        ];
        echo json_encode($json);
    }

    protected function insertData($data)
    {
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $record = $this->model[$this->getAlias()]->getDocumentNo($data['employee_code']);

        $data['emp_sr_no'] = $record['emp_sr_no'];
        $data['tot_sr_no'] = $record['tot_sr_no'];
        $data['document_identity'] = $record['document_identity'];
        $data['document_date'] = MySqlDate($data['document_date']);

        $hospital_recommendation_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);
        return $hospital_recommendation_id;
    }

    protected function updateData($primary_key, $data)
    {
        $data['document_date'] = MySqlDate($data['document_date']);

        $hospital_recommendation_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);
        return $hospital_recommendation_id;
    }

    public function printLetter()
    {
        $hospital_recommendation_id = $this->request->get['hospital_recommendation_id'];
        $lang = $this->load->language('employee/hospital_recommendation');
        $session = $this->session->data;

        $this->model['hospital_recommendation'] = $this->load->model('employee/hospital_recommendation');
        $data = $this->model['hospital_recommendation']->getRow(array('hospital_recommendation_id' => $hospital_recommendation_id));

        $this->model['employee'] = $this->load->model('employee/employee_profile');
        $employee = $this->model['employee']->getRow(array('employee_id' => $data['employee_id']));

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Hospital Recommendation Letter:' . $data['employee_code'] . '@' . date('YmdHis', strtotime($data['created_at'])));
        $pdf->SetSubject('Hospital Recommendation Letter');

        $pdf->data['document_identity'] = $data['document_identity'];

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(30, 15, 30);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        $pdf->lang = $lang;
        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(120, 5, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 5, 'BARHANI MAHAL', 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->ln(6);
        $pdf->Cell(120, 5, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 5, 'McIVER ROAD', 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->ln(6);
        $pdf->Cell(120, 5, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 5, 'KARACHI - 75530', 'B', false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->ln(6);
        $pdf->Cell(120, 5, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 5, 'TEL     : 35646666', 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->ln(6);
        $pdf->Cell(120, 5, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 5, 'FAX     : 35681418', 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->ln(6);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->Cell(10, 5, 'Date:', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(25, 5, stdDate($data['document_date']), 'B', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(70, 5, '', '', false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(45, 5, 'Email : dawatkhi@gmail.com', 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->ln(10);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->Cell(15, 5, 'Ref No.:', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(25, 5, $data['document_identity'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(30);
        $pdf->Cell(25, 5, $data['hospital_name'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(5);
        $pdf->Cell(25, 5, $data['hospital_address_1'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(5);
        $pdf->Cell(25, 5, $data['hospital_address_2'], 0, false, 'L', 0, '', 0, false, 'T', 'M');

        $description1 = "I am sending {$data['employee_name']} ( CNIC # {$employee['cnic_no']} ) to the hospital.";
        $description2 = "Please send all his bills to Dawat-e-Hadiyah, Karachi for payment.";
        $description3 = "Please mention above RefNo. and Date in all correspondence to Burhani Mahal";
        $description4 = "with respect to this letter";

        $pdf->ln(10);
        $pdf->Cell(150, 5, $description1, 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(10);
        $pdf->Cell(150, 5, $description2, 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(10);
        $pdf->Cell(150, 5, $description3, 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(10);
        $pdf->Cell(150, 5, $description4, 0, false, 'L', 0, '', 0, false, 'T', 'M');

        $pdf->ln(30);
        $pdf->Cell(150, 5, 'Yours faithfully', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(30);
        $pdf->Cell(150, 5, '( '.$data['signatory_name'].' )', 0, false, 'L', 0, '', 0, false, 'T', 'M');

        $pdf->Output('Covering Letter:' . $data['employee_code'] . '@' . date('YmdHis', strtotime($data['created_at'])) . '.pdf', 'I');
    }
}

class PDF extends TCPDF
{
    public $lang;
    public $data;

    //Page header
    public function Header(){

    }

    // Page footer
    public function Footer()
    {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(50, 10, 'Ref: ' . $this->data['document_identity'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(50, 10, 'Page ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(50, 10, 'Date: ' . date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}

?>