<?php

class ControllerEmployeeSesiContribution extends HController {

    protected function getAlias() {
        return 'employee/sesi_contribution';
    }

    protected function getPrimaryKey() {
        return 'sesi_contribution_id';
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $this->load->language('employee/sesi_contribution');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'document_identity', 'document_date','for_month','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                    ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $this->data['lang']['delete'],
                'href' => 'javascript:void(0);',
                'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                'btn_class' => 'btn btn-danger btn-xs',
                'class' => 'fa fa-times'
            );

            $actions[] = array(
                'text' => $this->data['lang']['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );


            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'].'" '.(isset($action['target'])?'target="'.$action['target'].'"':''). ' data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }


    protected function getForm() {
        parent::getForm();
        $this->data['href_get_member'] = $this->url->link($this->getAlias() . '/getMemberList', 'token=' . $this->session->data['token']);
        
        if (isset($this->request->get['sesi_contribution_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['isEdit'] = 1;
            $result = $this->model[$this->getAlias()]->getRow(array('sesi_contribution_id' => $this->request->get['sesi_contribution_id']));
            // d($result,true);
            foreach($result as $field => $value) {
                if($field=='joining_date' && $value!='') {
                    $this->data[$field] = stdDate($value);
                } elseif($field=='leaving_date' && $value!='') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->model['contribution_detail'] = $this->load->model('employee/sesi_contribution_detail');
            $this->data['contribution_details'] = $this->model['contribution_detail']->getEmployeeSesiDetails($result['sesi_contribution_id']);
            // d($this->data['contribution_details'],true);
        }

        $this->response->setOutput($this->render());
    }

    protected function insertData($data) {
        // d($data);
        $this->model['sesi_contribution_detail'] = $this->load->model('employee/sesi_contribution_detail');
        $this->model['sesi_contribution'] = $this->load->model('employee/sesi_contribution');
        
        $prefix = 'sc-'.$this->session->data['fy_code'].'/';
        // d($prefix,true);
        $max = $this->model['sesi_contribution']->getMaxDocNo();
        // d($max);
        $max = $max['doc_no'];
        if(!empty($max))
        {
            $max = $max+1;
        }
        else
        {
            $max = 1;
        }
        // d($max,true);

        $document_identity = $prefix . str_pad($max,4,"0",STR_PAD_LEFT);
        $data_insert['document_identity'] = $document_identity;
        $data_insert['document_date'] =  MySqlDate($data['document_date']);
        $data_insert['for_month'] = $data['for_month'];
        $data_insert['company_id'] = $this->session->data['company_id'];
        $data_insert['document_no'] = $max;
        // d($data_insert,true);
        $sesi_contribution_id =  $this->model[$this->getAlias()]->add($this->getAlias(), $data_insert);
        // d($sesi_contribution_id);
        $size = sizeof($data['sesi_member_id']);
        for($i = 0; $i < $size; $i++)
        {
            $detail['sesi_contribution_id'] = $sesi_contribution_id;
            $detail['sesi_member_id'] = $data['sesi_member_id'][$i];
            $detail['amount'] = $data['amount'][$i];
            $detail['basic_salary'] = $data['basic_salary'][$i];
            $detail['company_id'] = $this->session->data['company_id'];
            $sesi_contribution_detail_id = $this->model['sesi_contribution_detail']->add($this->getAlias(), $detail);
        }

        return $sesi_contribution_id;
    }

    public function getMemberList()
    {
        $post = $this->request->post;
        $this->model['sesi_contribution'] = $this->load->model('employee/sesi_contribution');
        $results = $this->model['sesi_contribution']->getSesiMembers($post['document_date']);
        // d($results,true);
        $html = '';
        foreach ($results as $key => $member) {
            $html .= '<tr>';
            $html .= '<input type="hidden" name="employee_registration_id[]" value="'.$member["employee_registration_id"].'" />';
            $html .= '<input type="hidden" name="sesi_member_id[]" value="'.$member["sesi_member_id"].'" />';
            $html .= '<input type="hidden" name="basic_salary[]" value="'.$member["basic_salary"].'" />';
            $html .= '<td>'.$member["registration_code"].'</td>';
            $html .= '<td>'.$member["employee_name"].'</td>';
            $html .= '<td>'.$member["cnic_no"].'</td>';
            $html .= '<td>'.$member["department_name"].'</td>';
            $html .= '<td>'.$member["designation_name"].'</td>';
            $html .= '<td>'.$member["social_security_no"].'</td>';
            $html .= '<td>'.number_format($member["basic_salary"],2).'</td>';
            $html .= '<td><input type="text" name="amount[]" value="'.$member['amount'].'"/></td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'html' => $html,
        );
        echo json_encode($json);
        exit;
    }

    public function printDocument()
    {
        ini_set('max_execution_time',400);
        ini_set('memory_limit','3072M');

        $lang=$this->load->language($this->getAlias());
        $get = $this->request->get;
        $session = $this->session->data;
        // d($session,true);
        // d($this->request->get,true);

        $this->model['sesi_contribution'] = $this->load->model('employee/sesi_contribution_detail');
        $rows = $this->model['sesi_contribution']->getEmployeeSesiDetails($get['sesi_contribution_id']);
        // d($rows,true);
        
        $this->model['setting'] = $this->load->model('common/setting');
        $setting = $this->model['setting']->getRow(array(
            'company_id' => $this->session->data['company_id'],
            // 'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'module' => 'general',
            'field' => 'company_logo',
        ));

        $company_logo = $setting['value'];

        if($session['parent_company_id'] == 0)
        {
            $company_name = $session['company_name'];
        }
        else
        {
            $this->model['parent_company'] = $this->load->model('setup/parent_company');
            $parent_company_name = $this->model['parent_company']->getRow(array('parent_company_id' => $session['parent_company_id']));
            $company_name = $parent_company_name['parent_company'];

        }

        $this->model['company'] = $this->load->model('setup/company');
        $company = $this->model['company']->getRow(array('company_id' => $session['company_id']));
        // d($company);
        $sesi_registration_no = $company['sesi_registration_no'];
        // d($sesi_registration_no,true);
        // d($parent_company_name,true);
        $pdf = new PDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Hira Anwer');
        $pdf->SetTitle('Sesi Contribution');
        $pdf->SetSubject('Sesi Contribution');


        $this->model['sesi_contribution'] = $this->load->model('employee/sesi_contribution');
        $sesi_contribution = $this->model['sesi_contribution']->getRow(array('sesi_contribution_id' => $get['sesi_contribution_id']));
        // d($sesi_contribution,true);

        //Set Header
        $pdf->data = array(
            'company_name' => $company_name,
            'report_name' => $lang['heading_title'],
            'company_logo' => $company_logo,
            'for_month' => date('M Y', strtotime($sesi_contribution['document_date'])),
            'document_no' => $sesi_contribution['document_identity'],
            'employer_name' => $session['company_name'],
            'registration_no' => $sesi_registration_no,
        );

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(10, 56, 3);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        // set font
        $pdf->AddPage();
        $pdf->SetFont('helvetica', 'B', 10);
        $sr =0;
        $total_amount = 0;
        foreach($rows as $key => $detail) {
            $total_amount += $detail['amount'];
            $sr++;
            $pdf->Ln(7);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(7, 7, $sr, 1, false, 'R');
            $pdf->Cell(20, 7, $detail['social_security_no'], 1, false, 'L');
            $pdf->Cell(30, 7, $detail['cnic_no'], 1, false, 'L');
            $pdf->Cell(130, 7, $detail['employee_name'], 1, false, 'L');
            $pdf->Cell(35, 7, $detail['designation_name'], 1, false, 'L');
            $pdf->Cell(30, 7, number_format($detail['basic_salary'],2), 1, false, 'L');
            $pdf->Cell(30, 7, number_format($detail['amount'],2), 1, false, 'R');
        }
        $pdf->Ln(7);
        $pdf->Cell(252, 7,'', 0, false, 'R');
        $pdf->Cell(30, 7, number_format($total_amount,2), 1, false, 'R');
        $pdf->Ln(10);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(90, 7, 'C E R T I F I C A T E', 0, false, 'C');
        $pdf->Ln(7);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(90, 7, 'I CERTIFY that this schedule includes the names of all insurable', 0, false, 'L');
        $pdf->Ln(7);
        $pdf->Cell(90, 7, 'employees of this firm, and all that information given regarding their', 0, false, 'L');
        $pdf->Ln(7);
        $pdf->Cell(90, 7, 'employement and wages is correct.', 0, false, 'L');
        $pdf->Ln(7);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(22, 7, 'Signature', 0, false, 'L');
        $pdf->Cell(90, 7, '', 'B', false, 'C');
        $pdf->ln(7);
        $pdf->Cell(22, 7, 'Position in firm', 0, false, 'L');
        $pdf->Cell(90, 7, '', 'B', false, 'C');
        $pdf->ln(7);
        $pdf->Cell(22, 7, 'Date : ', 0, false, 'L');
        $pdf->Cell(90, 7, '', 'B', false, 'C');

        //Close and output PDF document
        $pdf->Output('Sesi Contribution.pdf', 'I');
    }

}

class PDF extends TCPDF {
    public $data = array();
    //Page header
    public function Header() {
        if($this->data['company_logo'] != '') {
            $image_file = DIR_IMAGE.$this->data['company_logo'];
            $this->Image($image_file, 10, 10, 30, '', '', '', 'T', false, 300, '', false, false, 0, false, false, false);
        }

        $this->SetFont('times', 'B', 20);
        $this->Ln(2);
        // Title
        $this->Cell(0, 10, 'SINDH EMPLOYEES\' SOCIAL SECURITY INSTITUTION', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->Cell(0, 10, 'Contribution Schedule No. '.$this->data['document_no'] , 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(8);
        $this->SetFont('helvetica', '', 12);
        $this->Cell(40, 10, 'Month of '. $this->data['for_month'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $this->ln(8);
        $this->Cell(40, 10, 'Name of Employer : '. $this->data['employer_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $this->ln(5);
        $this->Cell(0, 10, 'Registration No. : '. $this->data['document_no'], 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $this->ln(20);
        $this->SetFont('helvetica', '', 8);
        $this->Cell(  7, 10, 'Sr.', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Cell( 20, 10, 'SS No.', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Cell( 30, 10, 'CNIC No.', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Cell( 130, 10, 'Member Name', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Cell( 35, 10, 'Designation', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Cell( 30, 10, 'Wages per Month', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Cell( 30, 10, 'Contribution Payable', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        // $this->ln();
        // $this->Cell( 100, 10, '', 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
        // $this->Cell( 10, 10, 'Day', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        // $this->Cell( 10, 10, 'Week', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        // $this->Cell( 10, 10, 'Month', 1, false, 'C', 0, '', 0, false, 'M', 'M');


    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('times', 'I', 8);
        // Page number
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

?>