<?php

class ControllerEmployeeSesiMember extends HController {

    protected function getAlias() {
        return 'employee/sesi_member';
    }

    protected function getPrimaryKey() {
        return 'sesi_member_id';
    }

    protected function getForm() {
        parent::getForm();
        $this->data['updateData'] = $this->url->link($this->getAlias() . '/updateData', 'token=' . $this->session->data['token'], 'SSL');
        $this->model['sesi_member'] = $this->load->model('employee/sesi_member');
        $this->data['sesi_members'] = $this->model['sesi_member']->getEmployeeSesiInfo();
        // d($this->data['sesi_members'],true);
        $this->response->setOutput($this->render());
    }

    protected function updateData() {
        $post = $this->request->post;
        // d($post,true);
        $this->model['sesi_member'] = $this->load->model('employee/sesi_member');
        $size = sizeof($post['employee_registration_id']);
        for($i = 0; $i < $size; $i++)
        {
            if(!empty($post['social_security_no'][$i]) || !empty($post['amount'][$i]))
            {

                $data['employee_registration_id'] = $post['employee_registration_id'][$i];
                $data['social_security_no'] = $post['social_security_no'][$i];
                $data['amount'] = $post['amount'][$i];
                $data['company_id'] = $this->session->data['company_id'];
                if(!empty($post['sm_employee_reg_id'][$i]))
                {
                    $this->model['sesi_member']->edit($this->getAlias(), $post['sm_employee_reg_id'][$i],$data);
                }
                else
                {
                    $this->model['sesi_member']->add($this->getAlias(), $data);    
                }
                
            }
        }

        return;
    }

    protected function updateRedirect() {
        // $url = $this->getURL();
        // d()
        $this->redirect(($this->url->link($this->getAlias() .'/update', 'token=' . $this->session->data['token'], 'SSL')));
    }

}

?>