<?php

class ControllerEmployeeTotalPayroll extends HController{

    protected function getAlias() {
        return 'employee/total_payroll';
    }

    protected function getPrimaryKey() {
        return 'employee_registration_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('employee/employee_registration');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    public function index()
    {
        $this->redirect($this->url->link($this->getAlias() . '/insert', 'token=' . $this->session->data['token'], 'SSL'));
    }

    protected function getForm(){
        parent::getForm();
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['department'] = $this->load->model('setup/department');

        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));
        //d($this->data['departments'], true);
        $this->data['href_get_payroll'] = $this->url->link($this->getAlias() . '/getData', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->response->setOutput($this->render());
    }

    public function getData(){

        $post = $this->request->post;
        $this->model['department'] = $this->load->model('setup/department');
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $id = 0;
        $html = '';
        $filter['company_id'] = $this->session->data['company_id'];
        if($post['department_id'] != ''){
            $filter['department_id'] = $post['department_id'];
        }

        $employees = $this->model['employee_registration']->getRows($filter);
        foreach($employees as $employee){
            $html .= '<tr>';
            $html .= '<td>';
            $html .= '<input type="hidden" class="form-control" id="payroll_'.$id.'_employee_registration_id" name="payrolls['.$id.'][employee_registration_id]" value="'.$employee['employee_registration_id'].'" />';
            $html .= '<input type="text" class="form-control" id="payroll_'.$id.'_employee_registration_code" name="payrolls['.$id.'][employee_registration_code]" value="'.$employee['registration_code'].'" readonly />';
            $html .= '</td>';
            $html .= '<td><input type="text" class="form-control" id="payroll_'.$id.'_employee_registration_id" name="payrolls['.$id.'][employee_name]" value="'.$employee['employee_name'].'" readonly></td>';
            $html .= '<td><input type="text" class="form-control" id="payroll_'.$id.'_employee_registration_id" name="payrolls['.$id.'][department_name]" value="'.$employee['department_name'].'" readonly></td>';

            $html .= '<td><input type="text" class="form-control" id="payroll_'.$id.'_employee_registration_id" name="payrolls['.$id.'][designation_name]" value="'.$employee['designation_name'].'" readonly></td>';
            $html .= '<td><input type="text" class="form-control" id="payroll_'.$id.'_employee_registration_id" name="payrolls['.$id.'][total_payroll]" value="'.$employee['total_payroll'].'"></td>';
            $html .= '</tr>';

        }
        $json = array(
            'success' => true,
            'employees' => $employees,
            'html' => $html
        );

        echo json_encode($json);
    }

    public function insertData($data){
        //d($data, true);
        foreach($data['payrolls'] as $employee) {
            //d($employee,true);
             $this->model[$this->getAlias()]->edit($this->getAlias(), $employee['employee_registration_id'], array('total_payroll' => $employee['total_payroll']));

        }
    }
}

?>