<?php

class ControllerPayrollAccountPosting extends HController {

    protected function getAlias() {
        return 'payroll/account_posting';
    }

    protected function getPrimaryKey() {
        return 'account_posting_id';
    }

//    protected function init() {
//        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
//        $this->data['lang'] = $this->load->language($this->getAlias());
//        $this->document->setTitle($this->data['lang']['heading_title']);
//        $this->data['token'] = $this->session->data['token'];
//    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $lang = $this->load->language($this->getAlias());
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'document_date', 'document_no', 'from_date','to_date','pay_date','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-search'
            );

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['target'])?'target="'.$action['target'].'"':'').' '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'allowance_posting_date') {
                    $row[] = stdDate($aRow['allowance_posting_date']);
                } elseif ($aColumns[$i] == 'cheque_date') {
                    $row[] = stdDate($aRow['cheque_date']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();
        $this->data['pay_date'] = stdDate();

        if (isset($this->request->get['account_posting_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['is_edit'] = 1;
            $result = $this->model[$this->getAlias()]->getRow(array('account_posting_id' => $this->request->get['account_posting_id']));
            foreach($result as $field => $value) {
                if(($field=='document_date' || $field=='from_date' || $field=='to_date' || $field=='pay_date') && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->model['account_posting_slip'] = $this->load->model('payroll/account_posting_slip');
            $this->model['account_posting_ledger'] = $this->load->model('payroll/account_posting_ledger');
            $this->model['account_posting_budget'] = $this->load->model('payroll/account_posting_budget');

            $this->data['account_posting_slips'] = $this->model['account_posting_slip']->getRows(array('account_posting_id' => $result['account_posting_id']));
            $this->data['account_posting_ledgers'] = $this->model['account_posting_ledger']->getRows(array('account_posting_id' => $result['account_posting_id']),array('sort_order'));
            $this->data['account_posting_budgets'] = $this->model['account_posting_budget']->getRows(array('account_posting_id' => $result['account_posting_id']),array('sort_order'));

        }
        $this->data['strValidation']="{
            'rules':{
		        'from_date': {'required':true},
		        'to_date': {'required':true},
		        'pay_date': {'required':true},
            },
        }";

        $this->data['href_get_data'] = $this->url->link($this->getAlias() . '/getData', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->response->setOutput($this->render());
    }

    public function getData() {
        ini_set('max_execution_time','400');
        $lang = $this->load->language($this->getAlias());
        $post = $this->request->post;
        $from_date = MySqlDate($post['from_date']);
        $to_date = MySqlDate($post['to_date']);
        $pay_date = date('Ymd',strtotime(MySqlDate($post['pay_date'])));

        $arrParties[35] = 'Employee OLD Age Benefits Institution';
        $arrParties[105] = 'National bank of Pakistan';
        $arrParties[158] = 'Yourself';
        $arrParties[28] = 'National Bank of Pakistan';
        $this->model['company'] = $this->load->model('setup/company');
        $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));
        $comp = $company['ref_id'];

        $this->model['fiscal_year'] = $this->load->model('setup/fiscal_year');
        $year = $this->model['fiscal_year']->getRow(array('fiscal_year_id' => $this->session->data['fiscal_year_id']));
        $Year = $year['ref_id'];

        $this->model['account'] = $this->load->model('payroll/account_posting');
        $this->model['account']->fillTable($from_date, $to_date);
        //$distributions = $this->model['account']->getDistributionList();
        $sys_key = $this->model['account']->getNextVoucher();
        //$this->session->data['deposit_slips'] = $distributions;
        $html_distribution='';
//        if($distributions) {
//            $html_distribution .= '<table class="table table-bordered">';
//            $html_distribution .= '<thead>';
//            $html_distribution .= '<tr><th colspan="10">Deposit Slips</th></tr>';
//            $html_distribution .= '<tr>';
//            $html_distribution .= '<th>Payroll Date</th>';
//            $html_distribution .= '<th>Deposit Slip Date</th>';
//            $html_distribution .= '<th>Deposit Slip No.</th>';
//            $html_distribution .= '<th>Deposit Slip Title</th>';
//            $html_distribution .= '<th>Account Title</th>';
//            $html_distribution .= '<th>Account No.</th>';
//            $html_distribution .= '<th>Cheque Date</th>';
//            $html_distribution .= '<th>Cheque No.</th>';
//            $html_distribution .= '<th>Amount</th>';
//            $html_distribution .= '<th>Post</th>';
//            $html_distribution .= '</tr>';
//            $html_distribution .= '</thead>';
//            $html_distribution .= '<tbody>';
//            $total_amount =0;
//            foreach($distributions as $distribution) {
//                $html_distribution .= '<tr>';
//                $html_distribution .= '<td>'.stdDate($distribution['payroll_date']);
//                $html_distribution .= '<input type="hidden" class="form-control" name="deposits[]" value="'.$distribution['deposit_slip_id'].'" /></td>';
//                $html_distribution .= '<td>'.stdDate($distribution['deposit_slip_date']).'</td>';
//                $html_distribution .= '<td>'.$distribution['deposit_slip_no'].'</td>';
//                $html_distribution .= '<td>'.$distribution['deposit_slip_title'].'</td>';
//                $html_distribution .= '<td>'.$distribution['account_title'].'</td>';
//                $html_distribution .= '<td>'.$distribution['account_no'].'</td>';
//                $html_distribution .= '<td>'.stdDate($distribution['cheque_date']).'</td>';
//                $html_distribution .= '<td>'.$distribution['cheque_no'].'</td>';
//                $html_distribution .= '<td class="text-right">'.number_format($distribution['cheque_amount'],2).'</td>';
//                $html_distribution .= '<td>'.$distribution['is_post'].'</td>';
//                $html_distribution .= '</tr>';
//                $total_amount += $distribution['cheque_amount'];
//            }
//            $html_distribution .= '<tr>';
//            $html_distribution .= '<td colspan="8" class="text-right">Total:</td>';
//            $html_distribution .= '<td class="text-right"><b>'.number_format($total_amount,2).'</b></td>';
//            $html_distribution .= '<td>&nbsp;</td>';
//            $html_distribution .= '</tr>';
//            $html_distribution .= '</tbody>';
//            $html_distribution .= '</table>';
//        }

        $ledgers = $this->model['account']->getLedger($this->session->data['company_id'], $from_date, $to_date);
        //d($ledgers, true);
        $html_ledger='';
        if($ledgers) {
            $row_id=0;
            $html_ledger .= '<table class="table table-striped">';
            $html_ledger .= '<thead>';
            $html_ledger .= '<tr><th colspan="17">Account Entry</th></tr>';
            $html_ledger .= '<tr>';
            $html_ledger .= '<th>PayDate</th>';
            $html_ledger .= '<th>SysKey</th>';
            $html_ledger .= '<th>SysTag</th>';
            $html_ledger .= '<th>TranCategory</th>';
            $html_ledger .= '<th>Year</th>';
            $html_ledger .= '<th>Comp</th>';
            $html_ledger .= '<th>PartyID</th>';
            $html_ledger .= '<th>Party</th>';
            $html_ledger .= '<th>trans_type</th>';
            $html_ledger .= '<th>BAHKey</th>';
            $html_ledger .= '<th>AHKey</th>';
            $html_ledger .= '<th>CCKey</th>';
            $html_ledger .= '<th>BudKey</th>';
            $html_ledger .= '<th>Narr</th>';
            $html_ledger .= '<th>Ref</th>';
            $html_ledger .= '<th>taxType</th>';
            $html_ledger .= '<th>Pamount</th>';
            $html_ledger .= '<th>Bamount</th>';
            $html_ledger .= '</tr>';
            $html_ledger .= '</thead>';
            $html_ledger .= '<tbody>';
            $total_debit = 0;
            $total_credit = 0;
            foreach($ledgers as $ledger) {
                if($ledger['Amount'] != 0) {
                    if($ledger['trans_type']=='D') {
                        $total_debit += $ledger['Amount'];
                    } elseif($ledger['trans_type']=='C') {
                        $total_credit += $ledger['Amount'];
                    }
                    $html_ledger .= '<tr>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_PayDate" name="ledgers['.$row_id.'][PayDate]" value="'.$pay_date.'" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_SysKey" name="ledgers['.$row_id.'][SysKey]" value="'.$sys_key.'" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_SysTag" name="ledgers['.$row_id.'][SysTag]" value="PR" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_TranCategory" name="ledgers['.$row_id.'][TranCategory]" value="S" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_Year" name="ledgers['.$row_id.'][Year]" value="'.$Year.'" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_Comp" name="ledgers['.$row_id.'][Comp]" value="'.$comp.'" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" required="true" id="ledger_'.$row_id.'_PartyID" name="ledgers['.$row_id.'][PartyID]" value="'.$ledger['PartyID'].'" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_Party" name="ledgers['.$row_id.'][Party]" value="'.(empty($ledger['Party'])?$arrParties[$ledger['PartyID']]:$ledger['Party']).'" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_tran_type" name="ledgers['.$row_id.'][tran_type]" value="'.$ledger['trans_type'].'" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_BAHKey" name="ledgers['.$row_id.'][BAHKey]" value="0" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_AHKey" name="ledgers['.$row_id.'][AHKey]" value="'.$ledger['AHKey'].'" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_CCKey" name="ledgers['.$row_id.'][CCKey]" value="0" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_BudKey" name="ledgers['.$row_id.'][BudKey]" value="0" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_Narr" name="ledgers['.$row_id.'][Narr]" value="" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_Ref" name="ledgers['.$row_id.'][Ref]" value="'.$ledger['Ref'].'" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_taxType" name="ledgers['.$row_id.'][taxType]" value="N" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_Pamount" name="ledgers['.$row_id.'][Pamount]" value="'.$ledger['Amount'].'" /></td>';
                    $html_ledger .= '<td><input type="text" class="form-control" id="ledger_'.$row_id.'_Bamount" name="ledgers['.$row_id.'][Bamount]" value="'.$ledger['Amount'].'" /></td>';
                    $html_ledger .= '<input type="hidden" class="form-control" id="ledger_'.$row_id.'_Ctrl_No" name="ledgers['.$row_id.'][Ctrl_No]" value="1" /></td>';
                    $html_ledger .= '</tr>';
                    $row_id++;
                }
            }
            $html_ledger .= '<tr>';
            $html_ledger .= '<td colspan="16">&nbsp;</td>';
            $html_ledger .= '<td>Debit</td>';
            $html_ledger .= '<td>Credit</td>';
            $html_ledger .= '</tr>';
            $html_ledger .= '<tr>';
            $html_ledger .= '<td colspan="16">&nbsp;</td>';
            $html_ledger .= '<td>'.number_format($total_debit,2).'</td>';
            $html_ledger .= '<td>'.number_format($total_credit,2).'</td>';
            $html_ledger .= '</tr>';
            $html_ledger .= '</tbody>';
            $html_ledger .= '</table>';
        }

        $budgets = $this->model['account']->getBudgets();
        if($budgets) {
            $row_id=0;
            $html_budget = '';
            $html_budget .= '<table class="table table-striped">';
            $html_budget .= '<thead>';
            $html_budget .= '<tr><th colspan="6">Budget Entry</th></tr>';
            $html_budget .= '<tr>';
            $html_budget .= '<th>Comp</th>';
            $html_budget .= '<th>Year</th>';
            $html_budget .= '<th>BudKey</th>';
            $html_budget .= '<th>Ref</th>';
            $html_budget .= '<th>budAmount</th>';
            $html_budget .= '<th>Status</th>';
            $html_budget .= '<th>PartyID</th>';
            $html_budget .= '<th>AHKey</th>';
            $html_budget .= '</tr>';
            $html_budget .= '</thead>';
            $html_budget .= '<tbody>';
            foreach($budgets as $budget) {
                $html_budget .= '<tr>';
                $html_budget .= '<td><input type="text" class="form-control" id="budget_'.$row_id.'_Comp" name="budgets['.$row_id.'][Comp]" value="'.$comp.'" /></td>';
                $html_budget .= '<td><input type="text" class="form-control" id="budget_'.$row_id.'_Year" name="budgets['.$row_id.'][Year]" value="'.$Year.'" /></td>';
                $html_budget .= '<td><input type="text" class="form-control" id="budget_'.$row_id.'_BudKey" name="budgets['.$row_id.'][BudKey]" required="true" onfocusout="check(this);" value="'.$budget['BudKey'].'" /></td>';
                $html_budget .= '<td><input type="text" class="form-control" id="budget_'.$row_id.'_Ref" name="budgets['.$row_id.'][Ref]" value="'.$sys_key.'" /></td>';
                $html_budget .= '<td><input type="text" class="form-control" id="budget_'.$row_id.'_budAmt" name="budgets['.$row_id.'][budAmt]" value="'.$budget['budAmount'].'" /></td>';
                $html_budget .= '<td><input type="text" class="form-control" id="budget_'.$row_id.'_Status" name="budgets['.$row_id.'][Status]" value="F" /></td>';
                $html_budget .= '<td><input type="text" class="form-control" required="true" id="budget_'.$row_id.'_PartyID" name="budgets['.$row_id.'][PartyID]" value="'.$budget['PartyID'].'" /></td>';
                $html_budget .= '<td><input type="text" class="form-control" id="budget_'.$row_id.'_AHKey" name="budgets['.$row_id.'][AHKey]" value="'.$budget['AHKey'].'" /></td>';
                $html_budget .= '</tr>';
                $row_id++;
            }
            $html_budget .= '</tbody>';
            $html_budget .= '</table>';
        }
        //d(array($payrolls, $html), true);
        $json = array(
            'success' => true,
            'post' => $post,
            'html_distribution' => $html_distribution,
            'html_ledger' => $html_ledger,
            'html_budget' => $html_budget,
        );

        echo json_encode($json);
        exit;
    }

    public function insert() {
        $this->init();

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateInsert()) {
            $this->db->beginTransaction();
            $id = $this->insertData($this->request->post);
            $this->db->commit();

            $this->insertRedirect($id, $this->request->post);
        }

        $this->getForm();
    }

    protected function insertData($data) {
        /*For Future Reference
        ======================

        Fetch Data:
        -------------
        Payroll Date should be withing the selected date and Bank Letter should be created.

        HardCoded Parties
        ---------------------
        $arrParties[35] = 'Employee OLD Age Benefits Institution';
        $arrParties[105] = 'National bank of Pakistan';
        $arrParties[158] = 'Yourself';
        $arrParties[28] = 'National Bank of Pakistan';


        For Account Data
        -------------------
        PayDate: "account_posting" => pay_date
        SysKey: "account_posting" => document_no
        SysTag: "PR" fixed
        TranCategory: "S" fixed
        Year: "fiscal_year" => ref_id
        Comp: "company" => ref_id
        PartyID: "company_account"=>party_id, "company" => eobi_party_id", "company" => tax_party_id, "department" => party_id
        Party: from HardCoded Parties with reference to PartyID
        tran_type: C for (Bank Letter / Payable Amount, EOBI Amount, Tax Amount), D for "payroll" => (payable_salary+tax_deduction+other_deduction)
        BAHKey: 0
        AHKey: "company_account" => ah_key, "company"=>eobi_ah_key, "company" => tax_ah_key
        CCKey: 0
        BudKey: 0
        Narr: ""
        Ref: cheque_no for Bank Letter Entry, "" for all other
        taxType: "N"
        Pamount: (Bank Letter / Payable Amount, EOBI Amount, Tax Amount) for C, (payable_salary+tax_deduction+other_deduction) for D
        Bamount: same as Pamount

        For Budget Data
        -------------------
        Year: "fiscal_year" => ref_id
        Comp: "company" => ref_id
        BudKey: "department" => budget_key
        Ref: ""
        budAmt: (payable_salary+tax_deduction+other_deduction)
        Status: "F"
        PartyID: "department"=>PartyID
        AHKey: "department" => AHKey */

        ini_set('max_execution_time','400');
        $this->model['deposit_slip'] = $this->load->model('payroll/deposit_slip');
        $this->model['account_posting'] = $this->load->model('payroll/account_posting');
        $this->model['account_posting_slip'] = $this->load->model('payroll/account_posting_slip');
        $this->model['account_posting_ledger'] = $this->load->model('payroll/account_posting_ledger');
        $this->model['account_posting_budget'] = $this->load->model('payroll/account_posting_budget');

        foreach($data['deposits'] as $deposit_slip_id) {
            $this->model['deposit_slip']->edit($this->getAlias(), $deposit_slip_id, array('is_post' => 'Yes'));
        }

        $deposit_slips = $this->session->data['deposit_slips'];
        $ledgers = $data['ledgers'];
        $budgets = $data['budgets'];
        unset($data['deposits']);
        unset($data['ledgers']);
        unset($data['budgets']);
        $data['from_date'] = MySqlDate($data['from_date']);
        $data['to_date'] = MySqlDate($data['to_date']);
        $data['pay_date'] = MySqlDate($data['pay_date']);
        $data['company_id'] = $this->session->data['company_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['document_date'] = date('Y-m-d');

        //d($data, true);

        $this->db->beginTransaction();
        $account_posting_id = $this->model['account_posting']->add($this->getAlias(), $data);
        foreach($deposit_slips as $sort_order => $row) {
            $row['account_posting_id'] = $account_posting_id;
            $row['sort_order'] = $sort_order;

            $this->model['account_posting_slip']->add($this->getAlias(), $row);
        }
        foreach($ledgers as $sort_order => $row) {
            $row['account_posting_id'] = $account_posting_id;
            $row['sort_order'] = $sort_order;

            $this->model['account_posting_ledger']->add($this->getAlias(), $row);
        }
        foreach($budgets as $sort_order => $row) {
            $row['account_posting_id'] = $account_posting_id;
            $row['sort_order'] = $sort_order;

            $this->model['account_posting_budget']->add($this->getAlias(), $row);
        }
        $this->db->Commit();
        try {
            $file = fopen(DIR_ROOT ."account_posting_".date('YmdHi').".txt","a+");
            fwrite($file,'Request:'.date('YmdHis')."\n");
            fwrite($file,json_encode(array('ledgers'=>$ledgers, 'budgets'=>$budgets)));
            fclose($file);

            $client = new SoapClient(ACC_SERV_URL);
            //$functions = $client->__getFunctions ();
            //d($functions, true);
            //d([$ledgers, $budgets, $response]);
            $response = $client->Payroll(array('Payrolldata' => json_encode($ledgers), 'Payrollbuddata' => json_encode($budgets)));
            //d($response, true);
            $file = fopen(DIR_ROOT ."account_posting_".date('YmdHi').".txt","a+");
            fwrite($file,'Response:'.date('YmdHis'));
            fwrite($file,json_encode($response)."\n");
            fclose($file);
            //d($response->PayrollResult->string[0], true);
            //$response = json_decode($response, true);
            //d($response, true);
            //$result = $response['PayrollResult']['string'];


            //$client = new SoapClient(ACC_SERV_URL);
            //$response = $client->BudgetUtilizePayroll(array('Payrolldata' => json_encode($records)));
            //$file = fopen(DIR_ROOT ."budget_posting_response_".MySqlDate($data['pay_date']).".txt","a+");
            //fwrite($file,json_encode($records));
            //fwrite($file,$response);
            //fclose($file);
            //$response = json_decode($response, true);
            //$result = $response['PayrollResult']['string'];
            //d($response, true);
            if($response->PayrollResult->string[0]=='Success') {
                $data = array(
                    'is_post' => 1,
                    'post_at' => date('Y-m-d H:i:s'),
                    'post_by_id' => $this->session->data['user_id'],
                    'bno' => $response->PayrollResult->string[1]
                );
                //$this->model[$this->getAlias()]->edit($this->getAlias(),$this->request->get[$this->getPrimaryKey()],$data);
                $this->session->data['success'] = 'Payroll Posted Successfully on BNO: '. $response->PayrollResult->string[1];
            } else {
                $this->session->data['error_warning'] = $response->PayrollResult->string[1];
            }
        } catch (Exception $e) {
            d($e, true);
            $this->session->data['error_warning'] = $e->getMessage();
        }

    }
}

?>