<?php

class ControllerPayrollAdvance extends HController {

    protected function getAlias() {
        return 'payroll/advance';
    }

    protected function getPrimaryKey() {
        return 'advance_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $this->load->language('payroll/advance');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'employee_code', 'employee_name', 'date', 'amount','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            if($aRow['is_post'] != 1) {
                $actions[] = array(
                    'text' => $this->data['lang']['post'],
                    'target' => '_blank',
                    'href' => $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                    'btn_class' => 'btn btn-info btn-xs',
                    'class' => 'fa fa-thumbs-up'
                );

                $actions[] = array(
                    'text' => $this->data['lang']['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'date') {
                    $row[] = stdDate($aRow['date']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $this->model['company_account'] = $this->load->model('setup/company_account');
        $filter = [];
        if($this->session->data['is_all_company_account']!=1){
            $filter['company_id'] = $this->session->data['company_id'];
        }

        $this->data['company_accounts'] = $this->model['company_account']->getRows($filter, array('account_title'));

        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee_registration']->getRows(array('company_id' => $this->session->data['company_id'], 'status' => 'Active'), array('employee_name'));

        $this->data['date'] = stdDate();
        if (isset($this->request->get['advance_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('advance_id' => $this->request->get['advance_id']));
            foreach($result as $field => $value) {
                if(($field=='date' || $field=='start_date' || $field=='cheque_date') && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }
        }

        $this->data['strValidation']="{
            'rules':{
		        'date': {'required':true},
		        'company_account_id': {'required':true},
		        'amount': {'required':true},
		        'employee_registration_id': {'required':true},
            },
        }";

        $this->response->setOutput($this->render());
    }

    protected function insertData($data) {
        $data['company_id'] = $this->session->data['company_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['date'] = MySqlDate($data['date']);

        if($data['cheque_date']=='') {
            $data['cheque_date']=NULL;
        } else {
            $data['cheque_date']=MySqlDate($data['cheque_date']);
        }
        $this->model[$this->getAlias()]->add($this->getAlias(), $data);
    }

    protected function updateData($primary_key, $data) {
        $data['date'] = MySqlDate($data['date']);

        if($data['cheque_date']=='') {
            $data['cheque_date']=NULL;
        } else {
            $data['cheque_date']=MySqlDate($data['cheque_date']);
        }
        $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);

    }

    public function post() {
        parent::getForm();
        $advance_id = $this->request->get['advance_id'];

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            $this->db->beginTransaction();
            $id = $this->postData($this->request->post);
            $this->db->commit();

            //$this->session->data['success'] = $this->language->get('success_insert');
            $this->redirect($this->url->link($this->getAlias(), 'token=' . $this->session->data['token'], 'SSL'));
        }

        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->model['advance'] = $this->load->model('payroll/advance');
        $this->model['company_account'] = $this->load->model('setup/company_account');
        $this->model['company'] = $this->load->model('setup/company');

        $result = $this->model['advance']->getRow(['advance_id' => $advance_id]);
        $company_account = $this->model['company_account']->getRow(['company_account_id' => $result['company_account_id']]);
        $company = $this->model['company']->getRow(['company_id' => $company_account['company_id']]);

        foreach($result as $field => $value) {
            if($field=='date') {
                $this->data[$field] = stdDate($value);
            } else {
                $this->data[$field] = $value;
            }
        }
        foreach($company_account as $field => $value) {
            if($field=='document_date') {
                $this->data[$field] = stdDate($value);
            } else {
                $this->data[$field] = $value;
            }
        }

        $this->data['document_identity'] = $result['registration_code'].'-'.$result['cheque_no'];
        $this->data['document_title'] = 'Advance Salary ';

        $cheque_details = [];
        $cheque_details[] = [
            'employee_name' => $result['employee_name'],
            'cheque_date' => $result['cheque_date'],
            'cheque_no' => $result['cheque_no'],
            'cheque_amount' => $result['amount'],
        ];
        $this->data['cheque_details'] = $cheque_details;
        $this->data['pay_from_company_id'] = $company['ref_id'];
        $this->data['companies'] = $this->model['company']->getRows(array(), array('company_name'));

        $this->data['href_get_accounts_data'] = $this->url->link($this->getAlias() . '/getAccountsData', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_save'] = $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->template = $this->getAlias() . '_post.tpl';
        $this->response->setOutput($this->render());
    }

    public function getAccountsData() {
        $this->model['advance'] = $this->load->model('payroll/advance');

        $post = $this->request->post;
        $advance_id = $this->request->get['advance_id'];

        $pay_date = $post['pay_date'];
        $account_details = $this->model['advance']->getPostData($advance_id);

        $ctrl_no = 0;
        $budgets = array();
        //d($account_details, true);
        foreach($account_details as $detail) {
            $budgets[] = array(
                'Comp' => $post['Comp'],
                'Year' => $detail['Year'],
                'BudKey' => $detail['budget_key'],
                'Ref' => str_replace('/','-',$detail['document_identity']),
                'budAmount' => $detail['Bamount'],
                'Status' => 'F',
                'PartyID' => $detail['PartyID'],
                'AHKey' => $detail['dah_key'],
            );
            $ctrl_no++;
            $data[] = array (
                //'PayDate' => date('Ymd',strtotime($detail['document_date'])),
                'PayDate' => date('Ymd',strtotime($pay_date)),
                'SysKey' => str_replace('/','-',$detail['document_identity']),
                'SysTag' => 'PR',
                'TranCategory' => $detail['TranCategory'],
                'Year' => $detail['Year'],
                //'Comp' => '',
                'Comp' => $post['Comp'],
                'PartyID' => $detail['PartyID'],
                'Party' => str_replace('/','',$detail['Party']),
                'tran_type' => 'D',
                'BAHKey' => 0,
                'AHKey' => $detail['dah_key'],
                'CCKey' => 0,
                'BudKey' => 0,
                'Narr' => $detail['Narr'],
                'Ref' => '',
                //'Ref' => $detail['cheque_no'],
                'taxType' => 'N',
                'Pamount' => $detail['Pamount'],
                'Bamount' => $detail['Bamount'],
                'Ctrl_No' => $ctrl_no,
            );

            $data[] = array (
                //'PayDate' => date('Ymd',strtotime($detail['document_date'])),
                'PayDate' => date('Ymd',strtotime($pay_date)),
                'SysKey' => str_replace('/','-',$detail['document_identity']),
                'SysTag' => 'PR',
                'TranCategory' => $detail['TranCategory'],
                'Year' => $detail['Year'],
                //'Comp' => '',
                'Comp' => $post['Comp'],
                'PartyID' => $detail['PartyID'],
                'Party' => str_replace('/','',$detail['Party']),
                //'tran_type' => 'D',
                'tran_type' => 'C',
                'BAHKey' => $detail['cah_key'],
                'AHKey' => $detail['cah_key'],
                'CCKey' => 0,
                'BudKey' => 0,
                'Narr' => $detail['Narr'],
                //'Ref' => '',
                'Ref' => $detail['cheque_no'],
                'taxType' => 'N',
                'Pamount' => $detail['Pamount'],
                'Bamount' => $detail['Bamount'],
                'Ctrl_No' => $ctrl_no,
            );
        }

        $json = [
            'success' => true,
            'budgets' => $budgets,
            'accounts' => $data
        ];

        echo json_encode($json, true);
        exit;

    }

    private function postData($data) {
        $this->model['advance'] = $this->load->model('payroll/advance');
        try {
            $file_name = DIR_ROOT ."AdvancePosting_".date('Ymd').".txt";
            $file = fopen($file_name,"a+");
            fwrite($file,'Request:'.date('YmdHis')."\n");
            fwrite($file,json_encode(array('ledgers'=>$data['account_details'], 'budgets'=>$data['budgets'])));
            fclose($file);

            $client = new SoapClient(ACC_SERV_URL);
            $response = $client->Payroll(array('Payrolldata' => json_encode($data['account_details']), 'Payrollbuddata' => json_encode($data['budgets'])));
            //d($response, true);
            $file = fopen($file_name,"a+");
            fwrite($file,'Response:'.date('YmdHis'));
            fwrite($file,json_encode($response)."\n");
            fclose($file);
            if($response->PayrollResult->string[0]=='Success') {
                $data = array(
                    'is_post' => 1,
                    'post_at' => date('Y-m-d H:i:s'),
                    'post_by_id' => $this->session->data['user_id'],
                    'bno' => $response->PayrollResult->string[1]
                );
                $this->model['advance']->edit($this->getAlias(),$this->request->get[$this->getPrimaryKey()],$data);
                $this->session->data['success'] = 'Data Posted Successfully on BNO: '. $response->PayrollResult->string[1];
            } else {
                $this->session->data['error_warning'] = $response->PayrollResult->string[1];
            }
        } catch (Exception $e) {
            d($e, true);
            $this->session->data['error_warning'] = $e->getMessage();
        }
    }
}

?>