<?php

class ControllerPayrollAllowancePosting extends HController {

    protected function getAlias() {
        return 'payroll/allowance_posting';
    }

    protected function getPrimaryKey() {
        return 'allowance_posting_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_emp_data'] = $this->url->link($this->getAlias() . '/getDocNo', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

     public function getDocNo()
    {
        $post = $this->request->post;
        // d($post);
        $this->model['allowance_posting'] = $this->load->model('payroll/allowance_posting');
        $results = $this->model['allowance_posting']->getDocNo($post);
        // d($results,true);
        $html = '';
        foreach ($results as $key => $value) {
            $html .= '<tr>';
            $html .= '<td>';
            $html .= $value['employee_name'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= $value['employee_code'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= $value['registration_code'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= $value['document_identity'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= $value['cheque_date'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= $value['cheque_no'];
            $html .= '</td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'html' => $html,
        );

        echo json_encode($json);
        exit;

    }

    public function getAjaxLists() {

        $lang = $this->load->language($this->getAlias());
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'document_date', 'document_identity', 'document_title','total_amount','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );
            /*
            $actions[] = array(
                'text' => $this->data['lang']['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printStatement', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );
            */


            $actions[] = array(
                'text' => $this->data['lang']['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );


            if($aRow['is_post'] != 1) {
                $actions[] = array(
                    'text' => $lang['post'],
                    'href' => $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                    'btn_class' => 'btn btn-info btn-xs',
                    'class' => 'fa fa-upload'
                );

                $actions[] = array(
                    'text' => $lang['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['target'])?'target="'.$action['target'].'"':'').' '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'allowance_posting_date') {
                    $row[] = stdDate($aRow['allowance_posting_date']);
                } elseif ($aColumns[$i] == 'cheque_date') {
                    $row[] = stdDate($aRow['cheque_date']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $this->model['company_account'] = $this->load->model('setup/company_account');
        $this->data['company_accounts'] = $this->model['company_account']->getArrays('company_account_id',array('company_account_id','bank_id','bank_name','bank_branch','account_title','account_no','iban','party_id','ah_key'),array(), array('account_title'));

        $this->model['allowance_type'] = $this->load->model('setup/special_allowance_type');
        $this->data['special_allowance_types'] = $this->model['allowance_type']->getRows(array(), array('special_allowance_type'));

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']), array('department_name'));

        $this->model['company'] = $this->load->model('setup/company');
        $this->data['companies'] = $this->model['company']->getRows(array('status' => 'Active'), array('company_name'));

        $this->data['document_date'] = stdDate();
        if (isset($this->request->get['allowance_posting_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('allowance_posting_id' => $this->request->get['allowance_posting_id']));
            foreach($result as $field => $value) {
                if(($field=='document_date' || $field=='from_allowance_date' || $field=='to_allowance_date') && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->model['allowance_posting_detail'] = $this->load->model('payroll/allowance_posting_detail');
            $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
            $details = $this->model['allowance_posting_detail']->getRows(array('allowance_posting_id' => $result['allowance_posting_id']),array('sort_order'));
            foreach($details as $detail) {
                if($detail['cheque_date'] != '') {
                    $detail['cheque_date'] = stdDate($detail['cheque_date']);
                }
                $this->data['details'][] = $detail;
            }
        }

        $this->data['strValidation']="{
            'rules':{
		        'document_date': {'required':true},
		        'document_title': {'required':true},
		        'pay_from_company_id': {'required':true},
		        'company_account_id': {'required':true},
		        'special_allowance_type_id': {'required':true},
		        'from_allowance_date': {'required':true},
		        'to_allowance_date': {'required':true},
            },
        }";

        $this->data['href_get_allowances'] = $this->url->link($this->getAlias() . '/getAllowances', 'token=' . $this->session->data['token'] . '&allowance_posting_id=' . $this->request->get['allowance_posting_id']);
        $this->response->setOutput($this->render());
    }

    public function getAllowances() {
        $post = $this->request->post;
        // d($post, true);
        $arrWhere = array();
        
        $arrWhere['from_date'] = MySqlDate($post['from_allowance_date']);
        $arrWhere['to_date'] = MySqlDate($post['to_allowance_date']);
        
        if(isset($post['department_id']) && !empty($post['department_id'])) {
            $arrWhere['department_id'] = implode(',',$post['department_id']);
        }
        if($post['special_allowance_type_id'] != '') {
            $arrWhere['special_allowance_type_id'] = $post['special_allowance_type_id'];
        }
        // $where = implode(' AND ', $arrWhere);
        // d($arrWhere, true);
        $this->model['allowance'] = $this->load->model('payroll/special_allowance');
        $allowances = $this->model['allowance']->getSpecialAllowanceInstallmentWise($arrWhere);
        //d($allowances,true);
        /*
        $arrAllowance = array();
        foreach($allowances as $allowance) {
            if(isset($arrAllowance[$allowance['employee_id']])) {
                $arrAllowance[$allowance['employee_id']]['amount'] += $allowance['approved_amount'];
            } else {
                $arrAllowance[$allowance['employee_id']] = array(
                    'employee_id' => $allowance['employee_id'],
                    'employee_code' => $allowance['employee_code'],
                    'employee_name' => $allowance['employee_name'],
                    'employee_image' => $allowance['employee_image'],
                    'amount' => $allowance['approved_amount'],
                    'special_allowance_id' => array()
                );
            }
            $arrAllowance[$allowance['employee_id']]['special_allowance_id'][] = $allowance['special_allowance_id'];
        }
        */
        $html = '';
        $row_no=0;
        $total_amount=0;
        foreach($allowances as $row_id => $allowance) {
            $row_no++;
            $total_amount += $allowance['installment_amount'];
            $html .= '<tr>';
            $html .= '<td><button type="button" class="btn btn-danger btn-xs" onclick="removeRow(this);"><i class="fa fa-times"></i></button></td>';
            $html .= '<td>'.$row_no.'</td>';
            $html .= '<td>'.$allowance['document_identity'].'</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" name="allowances['.$row_id.'][special_allowance_id]" value="'.$allowance['special_allowance_id'].'" />';
            $html .= '<input type="hidden" name="allowances['.$row_id.'][special_allowance_installment_id]" value="'.$allowance['special_allowance_installment_id'].'" />';
            $html .= $allowance['employee_code'];
            $html .= '</td>';
            $html .= '<td>'.$allowance['employee_name'].'</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control dtpDate required" name="allowances['.$row_id.'][cheque_date]" value=""/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control required" name="allowances['.$row_id.'][cheque_no]" value=""/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control text-right amount" name="allowances['.$row_id.'][amount]" value="'.$allowance['installment_amount'].'" readonly/>';
            $html .= '</td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'allowances' => $allowances,
            'html' => $html,
            'total_amount' => $total_amount
        );

        echo json_encode($json);
    }

    protected function insertData($data) {
        // d($this->session->data);
        //d($data,true);
        $this->model['company_account'] = $this->load->model('setup/company_account');
        $this->model['allowance_posting_detail'] = $this->load->model('payroll/allowance_posting_detail');
        $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
        $this->model['special_allowance_installment'] = $this->load->model('payroll/special_allowance_installment');

        $company_account = $this->model['company_account']->getRow(array('company_account_id' => $data['company_account_id']));

        $data['document_no'] = $this->model[$this->getAlias()]->getNextNumber();
        $data['company_id'] = $this->session->data['company_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['document_identity'] = $this->session->data['fy_code'].'/'.str_pad($data['document_no'],4,"0",STR_PAD_LEFT);
        $data['document_date']=MySqlDate($data['document_date']);
        $data['from_allowance_date']=MySqlDate($data['from_allowance_date']);
        $data['to_allowance_date']=MySqlDate($data['to_allowance_date']);
        $data['department_id']=implode(',', $data['department_id']);
        $data['bank_id'] = $company_account['bank_id'];
        $data['bank_name'] = $company_account['bank_name'];
        $data['bank_branch'] = $company_account['bank_branch'];
        $data['account_title'] = $company_account['account_title'];
        $data['account_no'] = $company_account['account_no'];
        $data['iban'] = $company_account['iban'];
        $data['party_id'] = $company_account['party_id'];
        $data['ah_key'] = $company_account['ah_key'];

        $allowance_posting_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);
        foreach($data['allowances'] as $row) {
            $allowance = $this->model['special_allowance']->getRow(array('special_allowance_id' => $row['special_allowance_id'], 'approved_status'=>'Approved'));
            if($allowance) {
                $detail = array(
                    'allowance_posting_id' => $allowance_posting_id,
                    'special_allowance_id' => $allowance['special_allowance_id'],
                    'special_allowance_identity' => $allowance['document_identity'],
                    'special_allowance_installment_id' => $row['special_allowance_installment_id'],
                    'special_allowance_date' => $allowance['document_date'],
                    'employee_registration_id' => $allowance['employee_registration_id'],
                    'cheque_date' => ($row['cheque_date'] !=''?MySqlDate($row['cheque_date']):''),
                    'cheque_no' => $row['cheque_no'],
                    'remarks' => $row['remarks'],
                    'amount' => $row['amount'],
                );

                $this->model['allowance_posting_detail']->add($this->getAlias(), $detail);
                $this->model['special_allowance']->edit($this->getAlias(),$allowance['special_allowance_id'],array('is_post'=>1, 'post_at'=>date('Y-m-d H:i:s'), 'post_by_id'=>$this->session->data['user_id']));
            }

        }
    }

    protected function updateData($primary_key, $data) {
        //d($data, true);
        $this->model['company_account'] = $this->load->model('setup/company_account');
        $this->model['allowance_posting_detail'] = $this->load->model('payroll/allowance_posting_detail');
        $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');

        $company_account = $this->model['company_account']->getRow(array('company_account_id' => $data['company_account_id']));

        $data['document_date']=MySqlDate($data['document_date']);
        $data['from_allowance_date']=MySqlDate($data['from_allowance_date']);
        $data['to_allowance_date']=MySqlDate($data['to_allowance_date']);
        $data['department_id']=implode(',', $data['department_id']);
        $data['bank_id'] = $company_account['bank_id'];
        $data['bank_name'] = $company_account['bank_name'];
        $data['bank_branch'] = $company_account['bank_branch'];
        $data['account_title'] = $company_account['account_title'];
        $data['account_no'] = $company_account['account_no'];
        $data['iban'] = $company_account['iban'];
        $data['party_id'] = $company_account['party_id'];
        $data['ah_key'] = $company_account['ah_key'];
        $allowance_posting_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);

        $allowances = $this->model['allowance_posting_detail']->getRows(array('allowance_posting_id' => $primary_key));
        foreach($allowances as $allowance) {
            $this->model['special_allowance']->edit($this->getAlias(),$allowance['special_allowance_id'], array('is_post'=>0, 'post_at'=>NULL, 'post_by_id'=>NULL));
        }

        $this->model['allowance_posting_detail']->deleteBulk($this->getAlias(), array('allowance_posting_id' => $primary_key));
        $sort_order=0;
        foreach($data['allowances'] as $row) {
            $allowance = $this->model['special_allowance']->getRow(array('special_allowance_id' => $row['special_allowance_id'], 'approved_status'=>'Approved'));
            if($allowance) {
                $detail = array(
                    'sort_order' => $sort_order,
                    'allowance_posting_id' => $allowance_posting_id,
                    'special_allowance_id' => $allowance['special_allowance_id'],
                    'special_allowance_identity' => $allowance['document_identity'],
                    'special_allowance_date' => $allowance['document_date'],
                    'employee_registration_id' => $allowance['employee_registration_id'],
                    'cheque_date' => ($row['cheque_date'] !=''?MySqlDate($row['cheque_date']):''),
                    'cheque_no' => $row['cheque_no'],
                    'remarks' => $row['remarks'],
                    'amount' => $row['amount'],
                );
                //d(array($allowance['special_allowance_id'], $detail), true);
                $this->model['allowance_posting_detail']->add($this->getAlias(), $detail);
                $this->model['special_allowance']->edit($this->getAlias(),$allowance['special_allowance_id'],array('is_post'=>1, 'post_at'=>date('Y-m-d H:i:s'), 'post_by_id'=>$this->session->data['user_id']));
                $sort_order++;
            }

        }
        //d($data['allowances'], true);
    }

    protected function deleteData($primary_key) {
        //d($primary_key, true);
        $this->model['allowance_posting_detail'] = $this->load->model('payroll/allowance_posting_detail');
        $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');

        $details = $this->model['allowance_posting_detail']->getRows(array('allowance_posting_id' => $primary_key));
        $this->model['allowance_posting_detail']->deleteBulk($this->getAlias(), array('allowance_posting_id' => $primary_key));
        foreach($details as $row) {
            $this->model['special_allowance']->edit($this->getAlias(), $row['special_allowance_id'], array('is_post' => 0, 'post_at'=>NULL, 'post_by_id'=>NULL));
        }

        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);
    }

    public function post() {
        parent::getForm();
        $allowance_posting_id = $this->request->get['allowance_posting_id'];

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            $this->db->beginTransaction();
            $id = $this->postData($this->request->post);
            $this->db->commit();

            $this->session->data['success'] = $this->language->get('success_insert');
            $this->redirect($this->url->link($this->getAlias(), 'token=' . $this->session->data['token'], 'SSL'));
        }

        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->model['year'] = $this->load->model('setup/fiscal_year');
        $this->model['company'] = $this->load->model('setup/company');
        $this->model['company_account'] = $this->load->model('setup/company_account');
        $this->model['allowance_posting'] = $this->load->model('payroll/allowance_posting');
        $this->model['allowance_posting_detail'] = $this->load->model('payroll/allowance_posting_detail');
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['allowance_type'] = $this->load->model('setup/special_allowance_type');

        $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));
        $year = $this->model['year']->getRow(array('fiscal_year_id' => $this->session->data['fiscal_year_id']));
        $document = $this->model['allowance_posting']->getRow(array('allowance_posting_id' => $allowance_posting_id));
        $details = $this->model['allowance_posting_detail']->getRows(array('allowance_posting_id' => $allowance_posting_id), array('cheque_no'));
        $this->data['company_accounts'] = $this->model['company_account']->getRows(array(),array('account_title','account_no'));
        $this->data['special_allowance_types'] = $this->model['allowance_type']->getRows(array(), array('special_allowance_type'));
        $this->data['companies'] = $this->model['company']->getRows(array(), array('company_name'));

        /*
        $AHKeys = array (
            0 => 0,
            1 => 111,
            2 => 112,
            3 => 116,
            4 => 104,
            5 => 111
        );*/

        //d($details, true);
        $ctrl_no = 0;
        $budgets = array();
        foreach($details as $detail) {
            /*if(isset($budgets[$detail['budget_key']])) {
                $budgets[$detail['budget_key']]['budAmount'] += $detail['amount'];
            } else {
                $budgets[$detail['budget_key']] = array(
                    'Comp' => $detail['Comp'],
                    'Year' => $year['ref_id'],
                    'BudKey' => $detail['budget_key'],
                    'Ref' => str_replace('/','-',$document['document_identity']),
                    'budAmount' => $detail['amount'],
                    'Status' => 'F',
                );
            }*/
            $budgets[] = array(
                'Comp' => $detail['Comp'],
                'Year' => $year['ref_id'],
                'BudKey' => $detail['budget_key'],
                'Ref' => str_replace('/','-',$document['document_identity']),
                'budAmount' => $detail['amount'],
                'Status' => 'F',
                'PartyID' => $detail['party_id'],
                'AHKey' => $detail['ah_key'],
            );
            $ctrl_no++;
            $data[] = array (
                'PayDate' => date('Ymd',strtotime($document['document_date'])),
                'SysKey' => str_replace('/','-',$document['document_identity']),
                'SysTag' => 'PR',
                'TranCategory' => $detail['TranCategory'],
                'Year' => $year['ref_id'],
                //'Comp' => '',
                'Comp' => $detail['Comp'],
                'PartyID' => $detail['party_id'],
                'Party' => str_replace('/','',$detail['cnic_name']),
//                'tran_type' => 'C',
                'tran_type' => 'D',
                'BAHKey' => 0,
                'AHKey' => $detail['ah_key'],
                'CCKey' => 0,
                'BudKey' => 0,
                'Narr' => $document['document_title'],
                'Ref' => '',
                //'Ref' => $detail['cheque_no'],
                'taxType' => 'N',
                'Pamount' => $detail['amount'],
                'Bamount' => $detail['amount'],
                'Ctrl_No' => $ctrl_no,
            );

            $data[] = array (
                'PayDate' => date('Ymd',strtotime($document['document_date'])),
                'SysKey' => str_replace('/','-',$document['document_identity']),
                'SysTag' => 'PR',
                'TranCategory' => $detail['TranCategory'],
                'Year' => $year['ref_id'],
                //'Comp' => '',
                'Comp' => $detail['Comp'],
                'PartyID' => $detail['party_id'],
                'Party' => str_replace('/','',$detail['cnic_name']),
                //'tran_type' => 'D',
                'tran_type' => 'C',
                'BAHKey' => $document['bank_ah_key'],
                'AHKey' => $document['bank_ah_key'],
                'CCKey' => 0,
                'BudKey' => 0,
                'Narr' => $document['document_title'],
                //'Ref' => '',
                'Ref' => $detail['cheque_no'],
                'taxType' => 'N',
                'Pamount' => $detail['amount'],
                'Bamount' => $detail['amount'],
                'Ctrl_No' => $ctrl_no,
            );
        }

        foreach($document as $field => $value) {
            $this->data[$field] = $value;
        }
        $this->data['details'] = $details;
        $this->data['budgets'] = $budgets;
        //d($budgets, true);
        $this->data['posting_details'] = $data;

        $this->data['action_save'] = $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->template = $this->getAlias() . '_post.tpl';
        $this->response->setOutput($this->render());
    }

    private function postData($data) {
        // d($data, true);
        /*For Future Reference (Allowance Posting)
        ==============

        To Fetch records:
            allowance should be approved and data should be in allowance_installment and installment date should be within selected date with login company and fiscal_year

        For Account Data
        ----------------------------
        PayDate: Curent date in "YYYYmmdd"
        SysKey: Document No
        SysTag: "PR" Fixed
        TranCategory: Table "special_allowance_type" => SysKey
        Year: Table "fiscal_year" => ref_id
        Comp: Table "company" => ref_id
        PartyID: Table "employee_registration" => party_id
        Party: Table "employee" => cnic_name else employee_full_name
        tran_type: Fixed D or C
        BAHKey: Table "company_account" => ah_key
        AHKey: if tran_type = C then "company_account" => ah_key else if tran_type= D then "special_allowance_type"=>ah_key
        CCKey: 0 fixed
        BudKey: 0 fixed
        Narr: "allowance_posting" => document_title
        Ref: Cheque No for C, blank for D
        taxType: N fixed
        Pamount: "special_allowance"=>approved_amount => "allowance_posting_detail"=>amount
        Bamount: "special_allowance"=>approved_amount => "allowance_posting_detail"=>amount
        Ctrl_No: increment no.


        For Budget Data
        -------------------
        Comp: Table "company" => ref_id
        Year: Table "fiscal_year" => ref_id
        BudKey: "special_allowance_type"=>budget_key
        Ref: Document No
        budAmount: "special_allowance"=>approved_amount => "allowance_posting_detail"=>amount
        Status => "F" fixed
        PartyID: Table "employee_registration" => party_id
        AHKey: "special_allowance_type"=>ah_key*/
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        try {
            $client = new SoapClient(ACC_SERV_URL);
            //$functions = $client->__getFunctions ();
            //d($functions, true);
            //d([$ledgers, $budgets, $response]);
            $file = fopen(DIR_ROOT ."allowance_posting_request_".MySqlDate($data['pay_date']).".txt","a+");
            fwrite($file,json_encode(array('ledgers' => $data['account_details'], 'budgets'=> $data['budgets'])));
            fclose($file);

            //$response = $client->Payroll(array('Payrolldata' => json_encode($ledgers), 'Payrollbuddata' => json_encode($budgets)));
            $response = $client->Payroll(array('Payrolldata' => json_encode($data['account_details']), 'Payrollbuddata' => json_encode($data['budgets'])));
            //d($response, true);
            $file = fopen(DIR_ROOT ."allowance_posting_response_".MySqlDate($data['pay_date']).".txt","a+");
            fwrite($file,json_encode($data));
            fwrite($file,$response);
            fclose($file);

            if($response->PayrollResult->string[0]=='Success') {
                $data = array(
                    'is_post' => 1,
                    'post_at' => date('Y-m-d H:i:s'),
                    'post_by_id' => $this->session->data['user_id'],
                    'bno' => $response->PayrollResult->string[1]
                );
                //$this->model[$this->getAlias()]->edit($this->getAlias(),$this->request->get[$this->getPrimaryKey()],$data);
                $this->session->data['success'] = 'Payroll Posted Successfully on BNO: '. $response->PayrollResult->string[1];
            } else {
                $this->session->data['error_warning'] = $response->PayrollResult->string[1];
            }
        } catch (Exception $e) {
            $this->session->data['error_warning'] = $e->getMessage();
        }
    }

    /*
    public function post() {
        $lang = $this->load->language($this->getAlias());
        if (!$this->user->hasPermission('post', $this->getAlias())) {
            $this->session->data['error_warning'] = $lang['error_permission_post'];
        } else {
            $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
            $this->model['allowance_posting_detail'] = $this->load->model('payroll/allowance_posting_detail');
            $this->model['fiscal_year'] = $this->load->model('setup/fiscal_year');
            $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
            $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
            $this->model['company'] = $this->load->model('setup/company');

            $allowance_posting_id = $this->request->get[$this->getPrimaryKey()];
            $document = $this->model[$this->getAlias()]->getRow(array('allowance_posting_id' => $allowance_posting_id));
            $details = $this->model['allowance_posting_detail']->getRows(array('allowance_posting_id' => $allowance_posting_id));
            $year = $this->model['fiscal_year']->getRow(array('fiscal_year_id' => $this->session->data['fiscal_year_id']));
            $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));
            $AHKeys = array (
                0 => 0,
                1 => 111,
                2 => 112,
                3 => 116,
                4 => 104
            );
            //d($details, true);
            $total_amount = 0;
            $ctrl_no = 0;
            foreach($details as $detail) {
                $ctrl_no++;
                $employee = $this->model['employee_registration']->getRow(array('employee_registration_id' => $detail['employee_registration_id']));
                $data[] = array (
                    'PayDate' => date('Ymd',strtotime($document['document_date'])),
                    'SysKey' => str_replace('/','-',$document['document_identity']),
                    'SysTag' => 'MT',
                    'Year' => $year['ref_id'],
                    'Comp' => $company['ref_id'],
                    'PartyID' => '158',
                    'Party' => $employee['cnic_name'],
                    'tran_type' => 'C',
                    'BAHKey' => $AHKeys[$document['special_allowance_type_id']],
                    'AHKey' => $AHKeys[$document['special_allowance_type_id']],
                    'CCKey' => 0,
                    'BudKey' => 0,
                    'Narr' => $document['document_title'],
                    'Ref' => $detail['cheque_no'],
                    'taxType' => 'N',
                    'Pamount' => $detail['amount'],
                    'Bamount' => $detail['amount'],
                    'Ctrl_No' => $ctrl_no,
                );

                $data[] = array (
                    'PayDate' => date('Ymd',strtotime($document['document_date'])),
                    'SysKey' => str_replace('/','-',$document['document_identity']),
                    'SysTag' => 'MT',
                    'Year' => $year['ref_id'],
                    'Comp' => $company['ref_id'],
                    'PartyID' => $document['party_id'],
                    'Party' => ' ',
                    'tran_type' => 'D',
                    'BAHKey' => 0,
                    'AHKey' => $document['ah_key'],
                    'CCKey' => 0,
                    'BudKey' => 0,
                    'Narr' => $document['document_title'],
                    'Ref' => '',
                    'taxType' => 'N',
                    'Pamount' => $detail['amount'],
                    'Bamount' => $detail['amount'],
                    'Ctrl_No' => $ctrl_no,
                );
            }

            //d($data, true);
            try {
                $client = new SoapClient(ACC_SERV_URL);
                $response = $client->Payroll(array('Payrolldata' => json_encode($data)));
                $file = fopen(DIR_ROOT ."payroll_posting_".date('Ymd').".txt","a+");
                fwrite($file,json_encode($data));
                fwrite($file,$response);
                fclose($file);
                $response = json_decode($response, true);
                $result = $response['PayrollResult']['string'];
                //d($response, true);
                if($result[0]=='Success') {
                    $data = array(
                        'is_post' => 1,
                        'post_at' => date('Y-m-d H:i:s'),
                        'post_by_id' => $this->session->data['user_id']
                    );
                    $this->model[$this->getAlias()]->edit($this->getAlias(),$this->request->get[$this->getPrimaryKey()],$data);
                } else {
                    $this->session->data['error_warning'] = $result[1];
                }
            } catch (Exception $e) {
                $this->session->data['error_warning'] = $e->getMessage();
            }
        }

        $this->redirect($this->url->link($this->getAlias(), 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL'));
    }
    */

    public function printDocument() {
        ini_set('max_execution_time',0);
        ini_set('memory_limit',-1);

        $lang = $this->load->language($this->getAlias());
        $allowance_posting_id = $this->request->get['allowance_posting_id'];
        $post = $this->request->post;
        $session = $this->session->data;

//        $this->model['company'] = $this->load->model('setup/company');
        $this->model['allowance_posting'] = $this->load->model('payroll/allowance_posting');
        $this->model['allowance_posting_detail'] = $this->load->model('payroll/allowance_posting_detail');


//        $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));
        $allowance_posting = $this->model['allowance_posting']->getRow(array('allowance_posting_id' => $allowance_posting_id));
        $allowance_posting_detail = $this->model['allowance_posting_detail']->getRows(array('allowance_posting_id' => $allowance_posting_id),array('cheque_no asc'));
//        d(array($allowance_posting, $allowance_posting_detail), true);

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Saif Zakir');
        $pdf->SetTitle('Allowance Posting');
        $pdf->SetSubject('Allowance Posting');

        //Set Header
        $pdf->data = array(
            //'company_name' => $this->session->data['company_name'] ,
            'company_name' => 'Dawat e Hadiyah',
            'report_name' => 'Allowance Posting',
            'status' => 'Print',
        );


        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(2, 2, 2);
        $pdf->SetHeaderMargin(2);
        $pdf->SetFooterMargin(2);

        // set auto page breaks
        //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set font
        $pdf->SetFont('times', 'B', 10);

        // add a page
        $pdf->AddPage();

//        $pdf->SetFont('helvetica', 'B', 30);
//        $pdf->SetTextColor(255, 0, 0);
//        $pdf->MultiCell(200, 5, $pdf->data['company_name'], 0, 'C', 0, 0, '', '', true);
//        $pdf->Ln(12);
//        $pdf->SetTextColor(0, 0, 0);
//        $pdf->SetFont('helvetica', 'B', 8);
//        $pdf->MultiCell(200, 5, $pdf->data['company_address'], 0, 'C', 0, 0, '', '', true);
//        $pdf->Ln(4);
//        $pdf->SetFont('helvetica', 'B', 8);
//        $pdf->MultiCell(200, 5, 'Phone: '.$pdf->data['company_phone'].' Mobile: '.$pdf->data['company_mobile'], 0, 'C', 0, 0, '', '', true);
//        $pdf->Ln(4);
//        $pdf->SetFont('helvetica', 'B', 8);
//        $pdf->MultiCell(200, 5, 'Website: '.$pdf->data['company_web'], 0, 'C', 0, 0, '', '', true);
//        $pdf->Ln(4);
//        $pdf->SetFont('helvetica', 'B', 8);
//        $pdf->MultiCell(200, 5, 'Email: '.$pdf->data['company_email'], 0, 'C', 0, 0, '', '', true);
//        $pdf->Ln(10);
//        $pdf->SetFont('helvetica', 'B', 20);
//        $pdf->MultiCell(200, 5, $pdf->data['report_name'], 0, 'C', 0, 0, '', '', true);

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('times', 'B', 15);
        $pdf->Ln(2);
        //$pdf->Cell(207,6, $session['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(207,6, 'Dawat e Hadiyah', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        //$pdf->Ln(7);
        //$pdf->SetFont('times', 'B', 14);
        //$pdf->Cell(207,6, $pdf->data['report_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');


        $pdf->SetFont('times', '', 10);
        $pdf->Ln(10);
        $pdf->Cell(26,6, 'Document Title : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(181,6, $allowance_posting['document_title'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');

        $pdf->Ln(10);
        $pdf->Cell(25,6, 'Document No. : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(22,6, $allowance_posting['document_identity'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(27,6, 'Document Date : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(22,6, stdDate($allowance_posting['document_date']), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(36,6, 'From Allowance Date : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(22,6, $allowance_posting['from_allowance_date'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(32,6, 'To Allowance Date : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(21,6, $allowance_posting['to_allowance_date'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');

        $pdf->Ln(10);
        $pdf->Cell(22,6, 'Bank Name : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(73,6, $allowance_posting['bank_name'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(39,6, 'Special Allowance Type : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(73,6, $allowance_posting['special_allowance_type'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');

        $pdf->Ln(10);
        $pdf->SetFont('times', 'B', 8);
        $pdf->Cell(10, 8, 'No.', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25, 8, 'Reg. Code', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(97, 8, 'Employee Name', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25, 8, 'Cheque Date', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25, 8, 'Cheque No.', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25, 8, 'Amount', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $sr = 0;
        $pdf->Ln(0);

        $Amount = 0;

        $pdf->SetFont('times', '', 9);
        foreach($allowance_posting_detail as $detail) {
            $sr++;
            $pdf->Ln(8);
            $pdf->Cell(10, 8, $sr, 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 8, $detail['registration_code'], 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(97, 8, $detail['employee_name'], 'LR',false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 8, stdDate($detail['cheque_date']), 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 8, $detail['cheque_no'], 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 8, number_format($detail['amount'],2), 'LR', false, 'R', 0, '', 0, false, 'M', 'M');

        }

        $x = $pdf->GetX();
        $y = $pdf->GetY();


        for ($i = $y; $i <= 220; $i++) {

            $pdf->Ln(1);
            $pdf->Cell(10, 7, '', 'L',  false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(97, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 7, '', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 7, '', 'L,R', false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 7, '', 'L,R', false, 'R', 0, '', 0, false, 'M', 'M');
            $y =$i;
        }
        $pdf->Ln(-1);
        $pdf->Ln(1);
        $pdf->Cell(207, 7, '', 'B', false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->setXY($x,$y);

        $pdf->SetFont('times', 'B', 8);
        $pdf->Ln(8);
        $pdf->Cell(182, 7, '', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25, 7, number_format($allowance_posting['total_amount'],2), 1, false, 'R', 0, '', 0, false, 'M', 'M');

        $data= $allowance_posting;
        //Close and output PDF document
        $pdf->Output('Allowance Posting :'.date('YmdHis').'.pdf', 'I');
    }

}

class PDF extends TCPDF {
    public $lang;
    public $header;
    public $footer;
    //Page header
    public function Header() {

    }

    // Page footer
    public function Footer() {
        $data = $this->footer;
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('freesans', 'I', 8);
        // Page number
        $this->Cell(60, 10, $this->lang['ref'].': '.$data['allowance_posting_title'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>
