<?php

class ControllerPayrollDepositSlip extends HController {

    protected function getAlias() {
        return 'payroll/deposit_slip';
    }

    protected function getPrimaryKey() {
        return 'deposit_slip_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $this->load->language('payroll/advance');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'deposit_slip_date', 'deposit_slip_no', 'deposit_slip_title', 'bank_name','bank_branch','cheque_amount','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $this->data['lang']['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printStatement', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );

            $actions[] = array(
                'text' => $this->data['lang']['excel'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/downloadExcel', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-download'
            );

            $actions[] = array(
                'text' => $this->data['lang']['delete'],
                'href' => 'javascript:void(0);',
                'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                'btn_class' => 'btn btn-danger btn-xs',
                'class' => 'fa fa-times'
            );

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['target'])?'target="'.$action['target'].'"':'').' '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'deposit_slip_date') {
                    $row[] = stdDate($aRow['deposit_slip_date']);
                } elseif ($aColumns[$i] == 'cheque_date') {
                    $row[] = stdDate($aRow['cheque_date']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $this->model['company_account'] = $this->load->model('setup/company_account');
        $this->data['company_accounts'] = $this->model['company_account']->getRows(array(), array('account_title'));

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']), array('department_name'));

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $this->data['employees'] = $this->model['payroll']->getPendingEmployees();

        $this->data['deposit_slip_date'] = stdDate();
        if (isset($this->request->get['deposit_slip_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('deposit_slip_id' => $this->request->get['deposit_slip_id']));
            foreach($result as $field => $value) {
                if(($field=='deposit_slip_date' || $field=='cheque_date' || $field=='payroll_date') && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->model['deposit_slip_detail'] = $this->load->model('payroll/deposit_slip_detail');
            $this->data['details'] = $this->model['deposit_slip_detail']->getRows(array('deposit_slip_id' => $result['deposit_slip_id']));
        }

        $this->data['strValidation']="{
            'rules':{
		        'deposit_slip_date': {'required':true},
		        'deposit_slip_title': {'required':true},
		        'company_account_id': {'required':true},
		        'payroll_date': {'required':true},
		        'bank_branch': {'required':true},
		        'cheque_date': {'required':true},
		        'cheque_no': {'required':true},
		        'cheque_amount': {'required':true,'min':1},
            },
        }";

        $this->data['href_get_payrolls'] = $this->url->link($this->getAlias() . '/getPayrolls', 'token=' . $this->session->data['token'] . '&deposit_slip_id=' . $this->request->get['deposit_slip_id']);
        $this->response->setOutput($this->render());
    }

    public function getPayrolls() {
        $post = $this->request->post;
        $arrWhere = array();
        $arrWhere[] = "`deposit_slip_id` = ''";
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        $arrWhere[] = "`document_date` = '".MySqlDate($post['payroll_date'])."'";
        if(isset($post['department_id']) && !empty($post['department_id'])) {
            $arrWhere[] = "`department_id` IN (".implode(',',$post['department_id']).")";
        }
        if($post['employee_registration_id'] != '') {
            $arrWhere[] = "`employee_registration_id` = '".$post['employee_registration_id']."'";
        } else {
            $arrWhere[] = "`bank_id` = '".$post['bank_id']."'";
        }
        $where = implode(' AND ', $arrWhere);

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $payrolls = $this->model['payroll']->getRows($where);

        $this->model['deposit_slip'] = $this->load->model('payroll/deposit_slip');
        //$accounts = $this->model['deposit_slip']->getdeductionAmount(MySqlDate($post['payroll_date']), $post['bank_id'], $post['department_id'], $post['employee_registration_id']);
        $accounts = $this->model['deposit_slip']->getDeductionAmount(MySqlDate($post['payroll_date']), $post['bank_id']);

        $html = '';
        $row_no=0;
        $total_amount=0;
        foreach($payrolls as $row_id => $payroll) {
            $row_no++;
            $total_amount += $payroll['payable_salary'];
            $html .= '<tr>';
            $html .= '<td><input onclick="calculateAmount();" type="checkbox" data-amount="'.$payroll['payable_salary'].'" id="payroll_'.$row_id.'_payroll_id" name="payrolls['.$row_id.'][payroll_id]" value="'.$payroll['payroll_id'].'" checked /></td>';
            $html .= '<td>'.$row_no.'</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" name="payrolls['.$row_id.'][employee_id]" value="'.$payroll['employee_id'].'" />';
            $html .= '<input type="hidden" name="payrolls['.$row_id.'][employee_registration_id]" value="'.$payroll['employee_registration_id'].'" />';
            $html .= '<input type="hidden" name="payrolls['.$row_id.'][employee_code]" value="'.$payroll['employee_code'].'" />';
            $html .= '<input type="hidden" name="payrolls['.$row_id.'][registration_code]" value="'.$payroll['registration_code'].'" />';
            $html .= '<input type="text" class="form-control" name="payrolls['.$row_id.'][employee_name]" value="'.$payroll['employee_name'].'" readonly/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" class="form-control" name="payrolls['.$row_id.'][bank_id]" value="'.$payroll['bank_id'].'" readonly/>';
            $html .= '<input type="text" class="form-control" name="payrolls['.$row_id.'][account_title]" value="'.$payroll['bank_account_title'].'" readonly/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control" name="payrolls['.$row_id.'][account_no]" value="'.$payroll['bank_account_no'].'" readonly/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control text-right" name="payrolls['.$row_id.'][amount]" value="'.$payroll['payable_salary'].'" readonly/>';
            $html .= '</td>';
            $html .= '</tr>';
        }

        foreach($accounts as $payroll) {
			if($payroll['amount'] != 0) {
				$row_no++;
				$row_id++;
				$total_amount += $payroll['amount'];
				$html .= '<tr>';
				$html .= '<td><input onclick="calculateAmount();" type="checkbox" data-amount="'.$payroll['amount'].'" id="payroll_'.$row_id.'_payroll_id" name="payrolls['.$row_id.'][payroll_id]" value="'.$payroll['payroll_id'].'" checked /></td>';
				$html .= '<td>'.$row_no.'</td>';
				$html .= '<td>';
				$html .= '<input type="hidden" name="payrolls['.$row_id.'][employee_id]" value="'.$payroll['employee_id'].'" />';
				$html .= '<input type="hidden" name="payrolls['.$row_id.'][employee_registration_id]" value="'.$payroll['employee_registration_id'].'" />';
				$html .= '<input type="hidden" name="payrolls['.$row_id.'][employee_code]" value="'.$payroll['employee_code'].'" />';
				$html .= '<input type="hidden" name="payrolls['.$row_id.'][registration_code]" value="'.$payroll['registration_code'].'" />';
				$html .= '<input type="text" class="form-control" name="payrolls['.$row_id.'][employee_name]" value="'.$payroll['employee_name'].'" readonly/>';
				$html .= '</td>';
				$html .= '<td>';
				$html .= '<input type="hidden" class="form-control" name="payrolls['.$row_id.'][bank_id]" value="'.$payroll['bank_id'].'" readonly/>';
				$html .= '<input type="text" class="form-control" name="payrolls['.$row_id.'][account_title]" value="'.$payroll['account_title'].'" readonly/>';
				$html .= '</td>';
				$html .= '<td>';
				$html .= '<input type="text" class="form-control" name="payrolls['.$row_id.'][account_no]" value="'.$payroll['account_no'].'" readonly/>';
				$html .= '</td>';
				$html .= '<td>';
				$html .= '<input type="text" class="form-control text-right" name="payrolls['.$row_id.'][amount]" value="'.$payroll['amount'].'" readonly/>';
				$html .= '</td>';
				$html .= '</tr>';
			}
        }

        $json = array(
            'success' => true,
            'filter' => $where,
            'payrolls' => $payrolls,
            'html' => $html,
            'total_amount' => $total_amount
        );

        echo json_encode($json);
    }

    protected function insertData($data) {
        $data['deposit_slip_no'] = $this->model[$this->getAlias()]->getNextNumber();
        $data['company_id'] = $this->session->data['company_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['deposit_slip_date']=MySqlDate($data['deposit_slip_date']);
        $data['cheque_date']=MySqlDate($data['cheque_date']);
        $data['payroll_date']=MySqlDate($data['payroll_date']);
        $data['department_id']=implode(',', $data['department_id']);

        $deposit_slip_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);
        $this->model['deposit_slip_detail'] = $this->load->model('payroll/deposit_slip_detail');
        $this->model['payroll'] = $this->load->model('payroll/payroll');
        foreach($data['payrolls'] as $payroll) {
			if(isset($payroll['payroll_id'])) {				
				$payroll_id = $payroll['payroll_id'];
				$this->model['payroll']->edit($this->getAlias(), $payroll_id, array('deposit_slip_id' => $deposit_slip_id));

				$payroll['deposit_slip_id'] = $deposit_slip_id;
				$payroll['company_id'] = $data['company_id'];
				$payroll['fiscal_year_id'] = $data['fiscal_year_id'];

				$this->model['deposit_slip_detail']->add($this->getAlias(), $payroll);
			}
        }
    }

    protected function updateData($primary_key, $data) {
        $data['company_id'] = $this->session->data['company_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['deposit_slip_date']=MySqlDate($data['deposit_slip_date']);
        $data['cheque_date']=MySqlDate($data['cheque_date']);
        $data['payroll_date']=MySqlDate($data['payroll_date']);
        $data['department_id']=implode(',', $data['department_id']);

        $deposit_slip_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);
        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $this->model['deposit_slip_detail'] = $this->load->model('payroll/deposit_slip_detail');
        $this->model['deposit_slip_detail']->deleteBulk($this->getAlias(), array('deposit_slip_id' => $deposit_slip_id));

        $rows = $this->model['payroll']->getRows(array('deposit_slip_id' => $deposit_slip_id));
        foreach($rows as $row) {
            $this->model['payroll']->edit($this->getAlias(), $row['payroll_id'], array('deposit_slip_id' => ''));
        }
        foreach($data['payrolls'] as $payroll) {
			if(isset($payroll['payroll_id'])) {				
				$payroll_id = $payroll['payroll_id'];
				$this->model['payroll']->edit($this->getAlias(), $payroll_id, array('deposit_slip_id' => $deposit_slip_id));

				$payroll['deposit_slip_id'] = $deposit_slip_id;
				$payroll['company_id'] = $data['company_id'];
				$payroll['fiscal_year_id'] = $data['fiscal_year_id'];

				$this->model['deposit_slip_detail']->add($this->getAlias(), $payroll);
			}
        }

    }

    protected function deleteData($primary_key) {
        $this->model['deposit_slip_detail'] = $this->load->model('payroll/deposit_slip_detail');
        $this->model['deposit_slip_detail']->deleteBulk($this->getAlias(), array('deposit_slip_id' => $primary_key));
        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $rows = $this->model['payroll']->getRows(array('deposit_slip_id' => $primary_key));
        foreach($rows as $row) {
            $this->model['payroll']->edit($this->getAlias(), $row['payroll_id'], array('deposit_slip_id' => ''));
        }
        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);
    }

    public function printStatement() {
        $deposit_slip_id = $this->request->get['deposit_slip_id'];

        $lang = $this->load->language('payroll/deposit_slip');
        $this->model['deposit_slip'] = $this->load->model('payroll/deposit_slip');
        $this->model['deposit_slip_detail'] = $this->load->model('payroll/deposit_slip_detail');

        $voucher = $this->model['deposit_slip']->getRow(array('deposit_slip_id' => $deposit_slip_id));
        $details = $this->model['deposit_slip_detail']->getRows(array('deposit_slip_id' => $deposit_slip_id), array('employee_name'));

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
        //TCPDF_FONTS::addTTFfont(K_PATH_FONTS .'/Open_Sans/freesans-Bold.ttf', 'TrueTypeUnicode', '', 96);
        //TCPDF_FONTS::addTTFfont(K_PATH_FONTS .'/Open_Sans/freesans-BoldItalic.ttf', 'TrueTypeUnicode', '', 96);
        //TCPDF_FONTS::addTTFfont(K_PATH_FONTS .'/Open_Sans/freesans-ExtraBold.ttf', 'TrueTypeUnicode', '', 96);
        //TCPDF_FONTS::addTTFfont(K_PATH_FONTS .'/Open_Sans/freesans-ExtraBoldItalic.ttf', 'TrueTypeUnicode', '', 96);
        //TCPDF_FONTS::addTTFfont(K_PATH_FONTS .'/Open_Sans/freesans-Italic.ttf', 'TrueTypeUnicode', '', 96);
        //TCPDF_FONTS::addTTFfont(K_PATH_FONTS .'/Open_Sans/freesans-Light.ttf', 'TrueTypeUnicode', '', 96);
        //TCPDF_FONTS::addTTFfont(K_PATH_FONTS .'/Open_Sans/freesans-LightItalic.ttf', 'TrueTypeUnicode', '', 96);
        //TCPDF_FONTS::addTTFfont(K_PATH_FONTS .'/Open_Sans/freesans-Regular.ttf', 'TrueTypeUnicode', '', 96);
        //TCPDF_FONTS::addTTFfont(K_PATH_FONTS .'/Open_Sans/freesans-SemiBold.ttf', 'TrueTypeUnicode', '', 96);
        //TCPDF_FONTS::addTTFfont(K_PATH_FONTS .'/Open_Sans/freesans-SemiBoldItalic.ttf', 'TrueTypeUnicode', '', 96);
        // set document information
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Bank Letter:'.$voucher['deposit_slip_no'].'@'.date('YmdHis'));
        $pdf->SetSubject('Bank Letter');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 10, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(0);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        $pdf->footer = array(
            'deposit_slip_title' => $voucher['deposit_slip_title']
        );
        $pdf->lang = $lang;
        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();
        $pdf->SetFont('freesans','',10);
        $pdf->Cell(30,7,stdDate($voucher['deposit_slip_date']));
        $pdf->ln(7);
        $pdf->Cell(60,7,$voucher['bank_name'].',');
        $pdf->ln(7);
        $pdf->Cell(60,7,$voucher['bank_branch']);
        $pdf->ln(14);
        $pdf->Cell(30,7,'Dear Sir,');
        $pdf->ln(7);
        $pdf->Cell(15,7,'');
        $pdf->Cell(150,7,'We are enclosing herewith Cheque No. '.$voucher['cheque_no'].'  Dated: '.stdDate($voucher['cheque_date']));
        $pdf->ln(7);
        $pdf->Cell(15,7,'');
        $pdf->Cell(150,7,'for Rs. '.number_format($voucher['cheque_amount'],2).' drawn on '.$voucher['bank_name'].' being '.$voucher['deposit_slip_title'].'.');
        $pdf->ln(7);
        $pdf->Cell(15,7,'');
        $pdf->Cell(150,7,'kindly credit the following accounts');
        $pdf->ln(14);
        $pdf->SetFont('freesans','B',10);
        $pdf->Cell(30,7,'SNo.','TB','','C');
        $pdf->Cell(95,7,'Account Title','TB','','C');
        $pdf->Cell(25,7,'Account No.','TB','','C');
        $pdf->Cell(30,7,'Rupees','TB','','C');
        $pdf->SetFont('freesans','',10);
        $sr_no=0;
        foreach($details as $detail) {
            $sr_no++;
            $pdf->ln(7);
            $pdf->Cell(30,7,$sr_no,'B','','C');
            $pdf->Cell(95,7,$detail['account_title'],'B','','L');
            $pdf->Cell(25,7,$detail['account_no'],'B','','R');
            $pdf->Cell(30,7,number_format($detail['amount'],2),'B','','R');
        }
        $pdf->ln(14);
        $pdf->Cell(125,7,'','','','R');
        $pdf->Cell(25,7,'Total Rupees:','TB','','R');
        $pdf->Cell(30,7,number_format($voucher['cheque_amount'],2),'TB','','R');
        $pdf->ln(8);
        $pdf->Cell(125,7,'','','','R');
        $pdf->Cell(25,7,'Yours truly','T','','LB');
        $pdf->Cell(30,7,'','T','','R');
        $pdf->ln(20);
        $pdf->Cell(125,7,'','','','R');
        if($this->session->data['parent_company_id'] != 0) {
            $pdf->Cell(55,7,'For DAWAT-E-HADIYAH','','','L');
        } else {
            $pdf->Cell(55,7,$this->session->data['company_name'],'','','R');
        }

        $pdf->Output('Bank Letter:'.$voucher['deposit_slip_no'].'@'.date('YmdHis').'.pdf', 'I');
    }

    public function downloadExcel() {
        include_once(DIR_SYSTEM.'library/PHPExcel.php');
        include_once(DIR_SYSTEM.'library/PHPExcel/Classes/PHPExcel/Writer/Excel5.php');
        $deposit_slip_id = $this->request->get['deposit_slip_id'];

        $lang = $this->load->language('payroll/deposit_slip');
        $this->model['deposit_slip'] = $this->load->model('payroll/deposit_slip');
        $this->model['deposit_slip_detail'] = $this->load->model('payroll/deposit_slip_detail');

        $voucher = $this->model['deposit_slip']->getRow(array('deposit_slip_id' => $deposit_slip_id));
        $rows = $this->model['deposit_slip_detail']->getRows(array('deposit_slip_id' => $deposit_slip_id), array('employee_name'));

        //d($rows, true);
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $rowCount = 1;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, stdDate($voucher['deposit_slip_date']));
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $voucher['bank_name']);
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $voucher['bank_branch']);
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $voucher['Dear Sir,']);
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, 'We are enclosing herewith Cheque No. '.$voucher['cheque_no'].'  Dated: '.stdDate($voucher['cheque_date']));
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, 'for Rs. '.number_format($voucher['cheque_amount'],2).' drawn on '.$voucher['bank_name'].' being '.$voucher['deposit_slip_title'].'.');
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, 'kindly credit the following accounts');
        $rowCount++;
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'SNo.')->getStyle('A'.$rowCount)->getFont()->setBold( true );
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, 'Account Title')->getStyle('B'.$rowCount)->getFont()->setBold( true );
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, 'Account No.')->getStyle('C'.$rowCount)->getFont()->setBold( true );
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, 'Rupees')->getStyle('D'.$rowCount)->getFont()->setBold( true );
        $rowCount++;
        $sr_no=0;
        foreach($rows as $detail){
            $sr_no++;
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $sr_no);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $detail['account_title']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $detail['account_no']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, number_format($detail['amount'],2));
            $rowCount++;
        }
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, 'Total Rupees:')->getStyle('C'.$rowCount)->getFont()->setBold( true );
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, number_format($voucher['cheque_amount'],2));
        $rowCount++;
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, 'Yours truly,')->getStyle('C'.$rowCount)->getFont()->setBold( true );
        $rowCount++;
        $rowCount++;
        $rowCount++;
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $this->session->data['company_name'])->getStyle('C'.$rowCount)->getFont()->setBold( true );

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="Bank_Letter.xls"');
        header('Cache-Control: max-age=0');
        //$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        //$objWriter->save('some_excel_file.xlsx');
        $objWriter->save('php://output');
        exit;
    }
}

class PDF extends TCPDF {
    public $lang;
    public $header;
    public $footer;
    //Page header
    public function Header() {

    }

    // Page footer
    public function Footer() {
        $data = $this->footer;
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('freesans', 'I', 8);
        // Page number
        $this->Cell(60, 10, $this->lang['ref'].': '.$data['deposit_slip_title'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>