<?php

class ControllerPayrollGeneratePayroll extends HController {

    protected function getAlias() {
        return 'payroll/generate_payroll';
    }

    protected function getPrimaryKey() {
        return 'payroll_id';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    public function index() {
        $this->redirect($this->url->link($this->getAlias() . '/insert', 'token=' . $this->session->data['token'], 'SSL'));
    }

    protected function getForm() {
        parent::getForm();
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee_registration']->getArrays('registration_code',array('employee_registration_id', 'registration_code', 'employee_id', 'employee_code', 'employee_name'),array('company_id' => $this->session->data['company_id'], 'status' => 'Active'), array('employee_name'));

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']), array('department_name'));

        $this->data['document_date'] = stdDate();
        $this->data['strValidation']="{
            'rules':{
		        'from_date': {'required':true},
		        'to_date': {'required':true},
		        'working_days': {'required':true},
		        'document_date': {'required':true},
		        'document_title': {'required':true},
            },
        }";

        // this url is to check for uploaded file
        $this->data['href_upload_payroll_file'] = $this->url->link($this->getAlias() . '/upload_payroll_file', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['href_update_data_from_file'] = $this->url->link($this->getAlias() . '/updatePayrollDataFromFile', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['href_get_payroll'] = $this->url->link($this->getAlias() . '/getPayroll', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['href_download_excel'] = $this->url->link($this->getAlias() . '/downloadExcel', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['href_get_payroll_data'] = $this->url->link($this->getAlias() . '/getPayrollData', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['href_get_tax_amount'] = $this->url->link($this->getAlias() . '/getTaxAmount', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['href_update_payroll_data'] = $this->url->link($this->getAlias() . '/updatePayrollData', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->response->setOutput($this->render());
    }

    public function getPayroll() {
        ini_set('max_execution_time','0');
        $lang = $this->load->language($this->getAlias());
        $post = $this->request->post;
        $document_date = MySqlDate($post['document_date']);
        $from_date = MySqlDate($post['from_date']);
        $to_date = MySqlDate($post['to_date']);
        $registration_code = $post['registration_code'];
        $department_id = $post['department_id'];
        $fiscal_year_id = $this->session->data['fiscal_year_id'];

        $arrTime = [];

        $eobi_female_age_limit = 55;
        $eobi_male_age_limit = 60;
        //$tax_age_limit = 60;
        $tax_age_limit = 150;
        $amount_limit = 1000000;
        //$tax_leniency_percent = 50;
        $tax_leniency_percent = 0;

        if(isset($_FILES['userfile']['name']) && !empty($_FILES['userfile']['name']))
        {
            $this->load->library('SimpleXLSX');
            // upload file on the directory
            $uploaddir = DIR_ROOT.'files/';
            $uploadfile = $uploaddir . basename($_FILES['userfile']['name']);

            if (move_uploaded_file($_FILES['userfile']['tmp_name'], $uploadfile)) {
                if ( $xlsx = SimpleXLSX::parse($uploadfile) )
                {
                    $rows = $xlsx->rows();
                    $size = sizeof($rows);
                    $arrXLS=[];
                    for($i = 1; $i < $size; $i++)
                    {
                        //$arrXLS[$rows[$i][0]]['arrears'] = $rows[$i][6];
                        $arrXLS[$rows[$i][0]]['overtime'] = $rows[$i][7];
                        $arrXLS[$rows[$i][0]]['manual_deduction'] = $rows[$i][10];
                        $arrXLS[$rows[$i][0]]['total_absent'] = $rows[$i][13];
                    }
                } else {
                    echo SimpleXLSX::parse_error();
                }
            } else {
                echo "Possible file upload attack!\n";
                exit;
            }
        }

        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
        $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance');
        $this->model['employee_deduction'] = $this->load->model('employee/employee_deduction');
        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $this->model['advance'] = $this->load->model('payroll/advance');
        $this->model['loan_installment'] = $this->load->model('payroll/loan_installment');
        $this->model['department'] = $this->load->model('setup/department');
        $this->model['company'] = $this->load->model('setup/company');
        $this->model['covid_certificate'] = $this->load->model('employee/covid_certificate');

//        $arrWhere = array();
//        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
//        $arrWhere[] = "`status` = 'Active'";
//        if($department_id)
//        {
//            $arrWhere[] = "`department_id` IN ('".implode("','", $department_id)."')";
//        }
//        if($registration_code != '')
//        {
//            $arrWhere[] = "`registration_code` ='".$registration_code."'";
//        }
//
//        $where = implode(' AND ', $arrWhere);
//        $employees = $this->model['employee_registration']->getRows($where); //Get All Active Employee against Filter

        $arrWhere = array();
        $arrWhere[] = "er.`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "er.`status` = 'Active'";
        if($department_id)
        {
            $arrWhere[] = "er.`department_id` IN ('".implode("','", $department_id)."')";
        }
        if($registration_code != '')
        {
            $arrWhere[] = "er.`registration_code` ='".$registration_code."'";
        }

        $where = implode(' AND ', $arrWhere);
        $arrTime[] = ['line'=> 143, 'where'=> $arrWhere, 'CT' => date('His')];
        $employees = $this->model['employee_registration']->getRecords($where); //Get All Active Employee against Filter
        $arrTime[] = ['line'=> 145, 'count'=> count($employees), 'CT' => date('His')];
        // d(array($arrWhere, $employees), true);
        $payrolls = array();
        foreach($employees as $employee) {
            $arrTime[] = ['line'=> 149, 'Employee'=> $employee['employee_name'], 'CT' => date('His')];
            $covid_certificate = $this->model['covid_certificate']->getRow(['employee_id' => $employee['employee_id']]);
            if($covid_certificate) {
                if($covid_certificate['dose2_date'] == NULL) {
                    $covid_status_color = '#db8b0b';
                    $covid_status = 'Covid Vaccine: 1st Dose';
                } else {
                    $covid_status_color = '';
                    $covid_status = 'Covid Vaccine: Completed';
                }
            } else {
                $covid_status_color = '#fb8aa9';
                $covid_status = 'Covid Vaccine: Pending';
            }
            $arrWhere = array();
            $arrWhere[] = "`employee_registration_id`='" . $employee['employee_registration_id'] . "'";
            $arrWhere[] = "`wef_date` <='$document_date'";
            $where = implode(' AND ', $arrWhere);
            $arrTime[] = ['line'=> 167, 'where'=> $where, 'CT' => date('His')];
            $salary = $this->model['employee_salary']->getRow($where, array('wef_date desc, created_at desc'));
            $arrTime[] = ['line'=> 169, 'salary'=> $salary, 'CT' => date('His')];
            if($salary) {
                $total_payroll = $employee['total_payroll'];
//                $filter = array (
//                    'document_date' => $document_date,
//                    'employee_registration_id' => $employee['employee_registration_id']
//                );
//                $payroll = $this->model['payroll']->getRow($filter);
                $filter = array (
                    'p.company_id' => $this->session->data['company_id'],
                    'p.fiscal_year_id' => $fiscal_year_id,
                    'p.document_date' => $document_date,
                    'p.employee_registration_id' => $employee['employee_registration_id']
                );
                $arrTime[] = ['line'=> 183, 'where'=> $filter, 'CT' => date('His')];
                $payroll = $this->model['payroll']->getRecord($filter);
                $arrTime[] = ['line'=> 185, 'payroll'=> $payroll, 'CT' => date('His')];

                $filter = array (
                    'fiscal_year_id' => $fiscal_year_id,
                    'exclude_payroll' => 0,
                    'employee_registration_id' => $employee['employee_registration_id'],
                );
                $arrTime[] = ['line'=> 192, 'where'=> $filter, 'CT' => date('His')];
                $paid_payroll = $this->model['payroll']->getCount($filter);
                $arrTime[] = ['line'=> 194, 'where'=> $where, 'CT' => date('His')];
                //d([$filter, $paid_payroll], true);
                if(empty($payroll) && $paid_payroll < $total_payroll) { //Check if Payroll is not already created.
                    $gender = $employee['gender'];
                    $d1 = new DateTime($post['document_date']);
                    $d2 = new DateTime($employee['dob']);
                    $diff = $d2->diff($d1);
                    $age = $diff->y;

                    $objPayroll = array(
                        'employee_registration_id' => $employee['employee_registration_id'],
                        'registration_code' => $employee['registration_code'],
                        'employee_id' => $employee['employee_id'],
                        'employee_code' => $employee['employee_code'],
                        'employee_name' => $employee['employee_name'],
                        'department_id' => $employee['department_id'],
                        'dob' => $employee['dob'],
                        'gender' => $employee['gender'],
                        'eobi_no' => $employee['eobi_no'],
                        'department' => $employee['department_name'],
                        'designation' => $employee['designation_name'],
                        'covid_status_color' => $covid_status_color,
                        'covid_status' => $covid_status,
                        'basic_salary' => $salary['basic_salary'],
                        'house_rent_percent' => '',
                        'house_rent_allowance' => '',
                        'grossable_allowance' => '',
                        'taxable_allowance' => '',
                        'arrears' => '',
                        'manual_addition' => '',
                        'overtime' => '',
                        'gross_salary' => '',
                        'taxable_salary' => '',
                        'manual_deduction' => '',
                        'other_deduction' => '',
                        'net_salary' => '',
                        'total_present' => '',
                        'total_absent' => '',
                        'attendance_deduction' => '',
                        'tax_deduction' => '',
                        'payable_salary' => '',
                        'bank_id' =>$employee['bank_id'],
                        'bank_account_no' =>$employee['bank_account'],
                        'bank_account_title' =>$employee['bank_title'],
                        'bank_account_iban' =>$employee['bank_iban'],
                        'annual_taxable_salary' => '',
                        'annual_tax_amount' => '',
                        'annual_tax_remaining' => '',
                        'salary_count' => '',
                    );
                    if($salary['taxable_house_rent']=='Yes') {
                        $objPayroll['house_rent_percent'] = $salary['taxable_house_rent_percent'];
                        $objPayroll['house_rent_allowance'] = round($salary['basic_salary']*$salary['taxable_house_rent_percent']/100);
                    } else {
                        $objPayroll['house_rent_percent'] = 0;
                        $objPayroll['house_rent_allowance'] = 0;
                    }

                    $arrTime[] = ['line'=> 252, 'where'=> $arrWhere, 'CT' => date('His')];
                    $allowances = $this->model['employee_allowance']->getRows(array('employee_salary_id' => $salary['employee_salary_id']));
                    $arrTime[] = ['line'=> 254, 'count'=> count($allowances), 'CT' => date('His')];
                    $total_allowance = 0;
                    $grossable_allowance = 0;
                    $taxable_allowance = 0;
                    $arrAllowances = array();
                    //d($allowances);
                    foreach($allowances as $allowance) {
                        $total_allowance += $allowance['allowance_amount'];
                        if($allowance['grossable']==1) {
                            $grossable_allowance += $allowance['allowance_amount'];
                        }
                        if($allowance['taxable']==1) {
                            $taxable_allowance += $allowance['allowance_amount'];
                        }

                        $arrAllowances[] = array(
                            'allowance_id' => $allowance['allowance_id'],
                            'allowance_code' => $allowance['allowance_code'],
                            'allowance_name' => $allowance['allowance_name'],
                            'allowance_amount' => $allowance['allowance_amount'],
                            'grossable' => $allowance['grossable'],
                            'taxable' => $allowance['taxable'],
                        );
                    }
                    $arrTime[] = ['line'=> 278, 'end'=> 'Allowances', 'CT' => date('His')];
                    $objPayroll['allowances'] = $arrAllowances;
                    $objPayroll['grossable_allowance'] = $grossable_allowance;
                    $objPayroll['taxable_allowance'] = $taxable_allowance;
                    $objPayroll['arrears'] = $employee['arrears'];
                    $objPayroll['manual_addition'] = 0;
                    if(isset($arrXLS[$employee['employee_registration_id']])) {
                        $objPayroll['overtime'] = $arrXLS[$employee['employee_registration_id']]['overtime'];
                    } else {
                        $objPayroll['overtime'] = 0;
                    }
                    $objPayroll['gross_salary'] = $objPayroll['basic_salary']+$objPayroll['grossable_allowance']+$objPayroll['arrears']+$objPayroll['manual_addition']+$objPayroll['overtime'];
                    $objPayroll['taxable_salary'] = $objPayroll['basic_salary']+$objPayroll['house_rent_allowance']+$objPayroll['taxable_allowance']+$objPayroll['arrears']+$objPayroll['manual_addition']+$objPayroll['overtime'];
                    if(isset($arrXLS[$employee['employee_registration_id']])) {
                        $objPayroll['manual_deduction'] = $arrXLS[$employee['employee_registration_id']]['manual_deduction'];
                    } else {
                        $objPayroll['manual_deduction'] = 0;
                    }

                    $arrDeductions = array();
                    $arrTime[] = ['line'=> 298, 'start'=> 'Get Deductions', 'CT' => date('His')];
                    $deductions = $this->model['employee_deduction']->getRows(array('employee_salary_id' => $salary['employee_salary_id']));
                    $arrTime[] = ['line'=> 300, 'count'=> count($deductions), 'CT' => date('His')];
                    $total_deduction = 0;
                    foreach($deductions as $deduction) {
                        //Checks if deduction is EOBI and Age Exceeded the EOBI Rule.
                        if($deduction['deduction_id']==8 && (($gender=='Female' && $age > $eobi_female_age_limit) || ($gender=='Male' && $age > $eobi_male_age_limit))) {
                            $deduction['deduction_amount'] = 0;
                        }
                        $total_deduction += $deduction['deduction_amount'];

                        $arrDeductions[] = array(
                            'ref_document_id' => $deduction['deduction_id'],
                            'ref_document_type' => 'Deduction',
                            'ref_document' => 'Employee Deduction',
                            'deduction_id' => $deduction['deduction_id'],
                            'deduction_code' => $deduction['deduction_code'],
                            'deduction_name' => $deduction['deduction_name'],
                            'deduction_amount' => $deduction['deduction_amount'],
                            'bank_id' => $deduction['bank_id'],
                            'bank_account_no' => $deduction['account_no'],
                            'bank_account_title' => $deduction['account_title'],
                            'bank_iban' => $deduction['iban'],
                        );
                    }
                    $arrTime[] = ['line'=> 323, 'end'=> 'getDeductions', 'CT' => date('His')];

                    $arrWhere = array();
                    $arrWhere[] = "`employee_registration_id` = '".$employee['employee_registration_id']."'";
                    $arrWhere[] = "`date` <= '$document_date'";
                    $arrWhere[] = "(`payroll_deduction_id` IS NULL OR `payroll_deduction_id` = '')";
                    $where = implode(' AND ', $arrWhere);
                    //d($where, true);
                    $arrTime[] = ['line'=> 331, 'where'=> $where, 'CT' => date('His')];
                    $objAdvances = $this->model['advance']->getRows($where);
                    $arrTime[] = ['line'=> 333, 'count'=> count($objAdvances), 'CT' => date('His')];
                    foreach($objAdvances as $objAdvance) {
                        $total_deduction += $objAdvance['amount'];

                        $arrDeductions[] = array(
                            'ref_document_id' => $objAdvance['advance_id'],
                            'ref_document_type' => 'Advance',
                            'ref_document' => 'Advance',
                            'deduction_id' => $objAdvance['advance_id'],
                            'deduction_code' => 'ADV',
                            'deduction_name' => 'Advance',
                            'deduction_amount' => $objAdvance['amount'],
                            'bank_id' => $objAdvance['bank_id'],
                            'bank_account_no' => $objAdvance['account_no'],
                            'bank_account_title' => $objAdvance['account_title'],
                            'bank_iban' => $objAdvance['iban'],
                        );
                    }
                    $arrTime[] = ['line'=> 351, 'end'=> 'Advances', 'CT' => date('His')];
                    //d(array($arrWhere, $objAdvances), true);

                    $arrWhere = array();
                    $arrWhere[] = "`employee_registration_id` = '".$employee['employee_registration_id']."'";
                    $arrWhere[] = "`installment_date` <= '$document_date'";
                    $arrWhere[] = "`payroll_deduction_id` = ''";
                    $where = implode(' AND ', $arrWhere);
                    $arrTime[] = ['line'=> 359, 'where'=> $where, 'CT' => date('His')];
                    $objLoans = $this->model['loan_installment']->getRows($where);
                    $arrTime[] = ['line'=> 361, 'count'=> count($objLoans), 'CT' => date('His')];
                    /*d($objLoans,true);*/
                    foreach($objLoans as $objLoan) {
                        //d($objLoan, true);
                        if($objLoan['adjustment_type'] != 'Cash'){
                            /*d($objLoan['allowance_for'],true);*/
                            $total_deduction += $objLoan['installment_amount'];

                            $arrDeductions[] = array(
                                'ref_document_id' => $objLoan['loan_installment_id'],
                                'ref_document_type' => 'Qarzan Hasana',
                                'ref_document' => 'Qarzan Hasana ['.stdDate($objLoan['installment_date']).']',
                                'deduction_id' => $objLoan['deduction_id'],
                                'deduction_code' => $objLoan['deduction_code'],
                                'deduction_name' => $objLoan['deduction_name'],
                                'deduction_amount' => $objLoan['installment_amount'],
                                'bank_id' => $objLoan['bank_id'],
                                'bank_account_no' => $objLoan['account_no'],
                                'bank_account_title' => $objLoan['account_title'],
                                'bank_iban' => $objLoan['iban'],
                            );
                        }
                    }
                    $arrTime[] = ['line'=> 384, 'end'=> 'Loans', 'CT' => date('His')];

                    $objPayroll['deductions'] = $arrDeductions;
                    $objPayroll['other_deduction'] = $total_deduction;
                    $objPayroll['net_salary'] = $objPayroll['gross_salary']-$objPayroll['manual_deduction']-$objPayroll['other_deduction'];

                    if($salary['taxable']=='Yes') { //Check if Salary is Taxable than calculateTaxAmount
                        $objPayroll['taxable'] = 1;
                        $filter = array(
                            'parent_company_id' => $this->session->data['parent_company_id'],
                            'company_id' => $this->session->data['company_id'],
                            'employee_registration_id' => $employee['employee_registration_id'],
                            'employee_id' => $employee['employee_id'],
                            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
                            'document_date' => MySqlDate($post['document_date']),
                            'from_date' => MySqlDate($post['from_date']),
                            'to_date' => MySqlDate($post['to_date']),
                            'taxable_salary' => $objPayroll['taxable_salary'],
                            'age' => $age,
                            'gender' => $gender,
                            'exclude_payroll' => 0,
                        );
                        $arrTime[] = ['line'=> 406, 'where'=> $filter, 'CT' => date('His')];
                        $tax_info = $this->model['payroll']->getTaxDetail($filter);
                        $arrTime[] = ['line'=> 408, 'count'=> count($tax_info), 'CT' => date('His')];
                    } else {
                        $objPayroll['taxable'] = 0;
                        $tax_info = array(
                            'tax_description' => array(),
                            'annual_taxable_salary' => 0,
                            'annual_tax_amount' => 0,
                            'remaining_tax' => 0,
                            'monthly_tax' => 0,
                            'salary_count' => 1
                        );
                    }
                    $objPayroll['annual_taxable_salary'] = $tax_info['annual_taxable_salary'];
                    $objPayroll['annual_tax_amount'] = $tax_info['annual_tax_amount'];
                    $objPayroll['annual_tax_remaining'] = $tax_info['remaining_tax'];
                    $objPayroll['tax_deduction'] = $tax_info['monthly_tax'];
                    $objPayroll['tax_description'] = $tax_info['tax_description'];
                    $objPayroll['salary_count'] = $tax_info['salary_count'];

                    if($employee['override_attendance_policy']==1) {
                        $attendance_exempted = $employee['attendance_exempted'];
                    } else {
                        $department = $this->model['department']->getRow(['department_id' => $employee['department_id']]);
                        if($department['override_attendance_policy']==1) {
                            $attendance_exempted = $department['attendance_exempted'];
                        } else {
                            $company = $this->model['company']->getRow(['company_id' => $employee['company_id']]);
                            $attendance_exempted = $company['attendance_exempted'];
                        }
                    }
                    /*
                    d([
                        'employee_override' => $employee['override_attendance_policy'],
                        'employee_exempted' => $employee['attendance_exempted'],
                        'department_override' => $department['override_attendance_policy'],
                        'department_exempted' => $department['attendance_exempted'],
                        'company_exempted' => $company['attendance_exempted'],
                        'attendance_exempted' => $attendance_exempted,
                    ], true);
                    */
                    if(isset($arrXLS[$employee['employee_registration_id']])) {
                        $total_absent = $arrXLS[$employee['employee_registration_id']]['total_absent'];
                    } else {
                        $total_absent = '';
                    }
                    $filter = array(
                        'from_date' => $from_date,
                        'to_date' => $to_date,
                        'company_id' => $this->session->data['company_id'],
                        'department_id' => $employee['department_id'],
                        'employee_registration_id' => $employee['employee_registration_id'],
                        'basic_salary' => $salary['basic_salary'],
                        'attendance_shift_id' => $employee['attendance_shift_id'],
                        'attendance_exempted' => $attendance_exempted,
                        'total_absent' => $total_absent,
                    );
                    $arrTime[] = ['line'=> 464, 'Attendance'=> $filter, 'CT' => date('His')];
                    $attendance = $this->getAttendance($filter);
                    $arrTime[] = ['line'=> 466, 'count'=> count($attendance), 'CT' => date('His')];
                    $objPayroll['working_days'] = $attendance['working_days'];
                    $objPayroll['total_present'] = $attendance['total_present'];
                    $objPayroll['total_absent'] = $attendance['total_absent'];
                    $objPayroll['daily_deduction'] = $attendance['daily_deduction'];
                    if($attendance['absent_deduction'] > ($objPayroll['net_salary']-$objPayroll['tax_deduction'])) {
                        $objPayroll['attendance_deduction'] = ($objPayroll['net_salary']-$objPayroll['tax_deduction']);
                    } else {
                        $objPayroll['attendance_deduction'] = $attendance['absent_deduction'];
                    }

                    $objPayroll['payable_salary'] = $objPayroll['net_salary'] - $objPayroll['attendance_deduction'] - $objPayroll['tax_deduction'];

                    $payrolls[$employee['employee_registration_id']] = $objPayroll;
                }
            }
            $arrTime[] = ['line'=> 482, 'Employee END'=> $employee['employee_name'], 'CT' => date('His')];
        }

        $this->session->data['payrolls'] = $payrolls;
        $arrTime[] = ['line'=> 486, 'HTML'=> 'start', 'CT' => date('His')];
        $html = $this->getPayrollTable();
        $arrTime[] = ['line'=> 488, 'HTML'=> 'end', 'CT' => date('His')];

        $json = array(
            'success' => true,
            //'post' => $post,
            'time' => $arrTime,
            'payrolls' => $payrolls,
            'html' => $html
        );
        echo json_encode($json);
        exit;
    }

    private function getAttendance($data) {
        $company_id = $data['company_id'];
        $department_id = $data['department_id'];
        $employee_registration_id = $data['employee_registration_id'];
        $from_date = $data['from_date'];
        $to_date = $data['to_date'];
        $attendance_shift_id = $data['attendance_shift_id'];
        $attendance_exempted = $data['attendance_exempted'];
        $basic_salary = $data['basic_salary'];

        $this->model['attendance_shift'] = $this->load->model('setup/attendance_shift');
        $this->model['attendance_shift_detail'] = $this->load->model('setup/attendance_shift_detail');
        $this->model['holiday'] = $this->load->model('setup/holiday');
        $this->model['company'] = $this->load->model('setup/company');
        $this->model['employee_attendance'] = $this->load->model('employee/employee_attendance');

        $date_diff = strtotime($to_date.' 23:59:59')-strtotime($from_date.' 00:00:00');
        $working_days = round($date_diff / (60 * 60 * 24));

        if($attendance_exempted) {
            $total_absent = 0;
        } else {
            if(isset($data['total_absent']) && $data['total_absent'] !== '') {
                $total_absent = $data['total_absent'];
            } else {
                $shift = $this->model['attendance_shift']->getRow(['attendance_shift_id' => $attendance_shift_id]);
                $shift_status = $this->model['attendance_shift_detail']->getArrays('day',array('day', 'day_status'), array('attendance_shift_id' => $attendance_shift_id));
                //d($shift_status,true);
                $where = " `holiday_date` BETWEEN '". $from_date."' AND '".$to_date."'";
                $where .= " AND company_id=".$this->session->data['company_id'];
                //holidays
                $holidays = $this->model['holiday']->getArrays('holiday_date','holiday_date',$where);
                /*d(array($current_date,$to_date,$holidays),true);*/

                $arrWhere = [];
                $arrWhere[] = "`employee_registration_id` = '$employee_registration_id'";
                $arrWhere[] = "`attendance_date` >= '$from_date' AND `attendance_date` <= '$to_date'";
                $where = implode(" AND ", $arrWhere);
                $arrEmployeeAttendance = $this->model['employee_attendance']->getArrays('attendance_date','status', $where, ['attendance_date']);
                //d($arrEmployeeAttendance, true);
                $current_date = $from_date;
                $total_absent = 0;
                $total_late = 0;
                while($current_date <= $to_date) {
                    if(isset($arrEmployeeAttendance[$current_date])) {
                        if($arrEmployeeAttendance[$current_date]=='A') {
                            $total_absent++;
                        } elseif($arrEmployeeAttendance[$current_date]=='LD') {
                            $total_absent++;
                        } elseif($arrEmployeeAttendance[$current_date]=='LT') {
                            $total_late++;
                        }
                    } else {
                        $day = date('D',strtotime($current_date));
                        if($shift_status[$day]['day_status']=='Working Day') {
                            if(!in_array($current_date, $holidays)) {
                                $total_absent++;
                            }
                        }
                    }

                    $current_date = date('Y-m-d', strtotime($current_date . ' +1 Day'));
                }

                if($shift && $shift['late_deduction'] > 0 && $total_late > 0) {
                    $total_absent += floor($total_late/$shift['late_deduction']);
                }
            }
        }

        $employee = $this->model['employee_registration']->getRecord(array('employee_registration_id' => $employee_registration_id));
        if($employee['override_attendance_policy']) {
            $deduction_days = $employee['deduction_days']===''?0:$employee['deduction_days'];
            $deduction_percent = $employee['deduction_percent']===''?0:$employee['deduction_percent'];
        } else {
            $department = $this->model['department']->getRow(array('department_id' => $department_id));
            if($department['override_attendance_policy']) {
                $deduction_days = $department['deduction_days']===''?0:$department['deduction_days'];
                $deduction_percent = $department['deduction_percent']===''?0:$department['deduction_percent'];
            } else {
                $company_info = $this->model['company']->getRow(array('company_id' => $company_id));
                $deduction_days = $company_info['deduction_days']===''?0:$company_info['deduction_days'];
                $deduction_percent = $company_info['deduction_percent']===''?0:$company_info['deduction_percent'];
            }
        }

        if($deduction_days==0) {
            $daily_deduction=0;
        } else {
            $daily_deduction = round(($basic_salary / $deduction_days)*(1+($deduction_percent/100)));
        }

        $absent_deduction = $daily_deduction * $total_absent;

        return array(
            'working_days' => $working_days,
            'total_absent' => $total_absent,
            'total_present' => $working_days - $total_absent,
            'daily_deduction' => $daily_deduction,
            'absent_deduction' => $absent_deduction,
        );
    }

    public function getTaxAmount() {
        $post = $this->request->post;

        if($post['taxable']) { //Check if Salary is Taxable than calculateTaxAmount
            $this->model['payroll'] = $this->load->model('payroll/payroll');
            $filter = array(
                'parent_company_id' => $this->session->data['parent_company_id'],
                'company_id' => $this->session->data['company_id'],
                'employee_registration_id' => $post['employee_registration_id'],
                'employee_id' => $post['employee_id'],
                'fiscal_year_id' => $this->session->data['fiscal_year_id'],
                'document_date' => MySqlDate($post['document_date']),
                'taxable_salary' => $post['taxable_salary'],
                'exclude_payroll' => 0,
            );
            $tax_info = $this->model['payroll']->getTaxDetail($filter);
        } else {
            $tax_info = array(
                'tax_description' => array(),
                'annual_taxable_salary' => 0,
                'annual_tax_amount' => 0,
                'remaining_tax' => 0,
                'monthly_tax' => 0,
                'salary_count' => 1
            );
        }

        $json = array(
            'success' => true,
            'tax_deduction' => $tax_info['monthly_tax']
        );

        echo json_encode($json);
    }

//    public function getPayrollO() {
//        ini_set('max_execution_time','400');
//        $lang = $this->load->language($this->getAlias());
//        $post = $this->request->post;
//
//        $payrolls = array();
//        /**
//         * Check if file exists
//         * then read the overtime,arrears,manual deduction and total absent from file
//         * set these values in variables
//         */
//        if(isset($_FILES['userfile']['name']) && !empty($_FILES['userfile']['name']))
//        {
//            $this->load->library('SimpleXLSX');
//            // upload file on the directory
//            $uploaddir = DIR_ROOT.'files/';
//            $uploadfile = $uploaddir . basename($_FILES['userfile']['name']);
//
//            if (move_uploaded_file($_FILES['userfile']['tmp_name'], $uploadfile)) {
//                if ( $xlsx = SimpleXLSX::parse($uploadfile) )
//                {
//                    $rows = $xlsx->rows();
//                    //d($rows, true);
//                    $size = sizeof($rows);
//                    for($i = 1; $i < $size; $i++)
//                    {
//                        $payrolls[$rows[$i][0]]['arrears'] = $rows[$i][6];
//                        $payrolls[$rows[$i][0]]['overtime'] = $rows[$i][7];
//                        $payrolls[$rows[$i][0]]['manual_deduction'] = $rows[$i][10];
//                        $payrolls[$rows[$i][0]]['total_absent'] = $rows[$i][13];
//                    }
//
//                }
//
//
//                else {
//                    echo SimpleXLSX::parse_error();
//                }
//            } else {
//                echo "Possible file upload attack!\n";
//                exit;
//            }
//        }
//
//        //d($payrolls, true);
//        $financial_start_date = $this->session->data['fiscal_date_from'];
//        $eobi_female_age_limit = 55;
//        $eobi_male_age_limit = 60;
//        //$tax_age_limit = 60;
//        $tax_age_limit = 150;
//        $amount_limit = 1000000;
//        //$tax_leniency_percent = 50;
//        $tax_leniency_percent = 0;
//
//        $this->model['company'] = $this->load->model('setup/company');
//        $this->model['department'] = $this->load->model('setup/department');
//        $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
//        $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance');
//        $this->model['employee_deduction'] = $this->load->model('employee/employee_deduction');
//        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
//        $this->model['attendance_shift_detail'] = $this->load->model('setup/attendance_shift_detail');
//        $this->model['holiday'] = $this->load->model('setup/holiday');
//        $this->model['payroll'] = $this->load->model('payroll/payroll');
//        $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
//        $this->model['tax_slab'] = $this->load->model('setup/tax_slab');
//        $this->model['advance'] = $this->load->model('payroll/advance');
//        $this->model['loan_installment'] = $this->load->model('payroll/loan_installment');
//        $this->model['employee_attendance'] = $this->load->model('employee/employee_attendance');
//
//        $arrWhere = array();
//        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
//        $arrWhere[] = "`status` = 'Active'";
//        $post['department_id'] = implode("','", $post['department_id']);
//        if(!empty($post['department_id']))
//        {
//            $arrWhere[] = "`department_id` IN ('".$post['department_id']."')";
//        }
//        if($post['registration_code'] != '')
//        {
//            $arrWhere[] = "`registration_code` ='".$post['registration_code']."'";
//        }
//
//        $where = implode(' AND ', $arrWhere);
//        $employees = $this->model['employee_registration']->getRows($where);
//        //d([$where, $employees], true);
//
//        foreach($employees as $employee) {
//            $d1 = new DateTime($financial_start_date);
//            $d2 = new DateTime($employee['dob']);
//            $diff = $d2->diff($d1);
//            $age = $diff->y;
//            $gender = $employee['gender'];
//
//            $filter = array(
//                'fiscal_year_id' => $this->session->data['fiscal_year_id'],
//                'employee_registration_id' => $employee['employee_registration_id'],
//                'exclude_payroll' => 0
//            );
//            $total_payroll = $this->model['payroll']->getTotalPayrolls($filter);
//            $filter = array (
//                'document_date' => MySqlDate($post['document_date']),
//                'employee_registration_id' => $employee['employee_registration_id']
//            );
//            $payroll = $this->model['payroll']->getRow($filter);
//            //d(['total_payroll' => $total_payroll, 'payroll' => $payroll, 'filter' => $filter], true);
//            if(empty($payroll) && $total_payroll < $employee['total_payroll']) {
//                $arrWhere = array();
//                $arrWhere[] = "`employee_registration_id`='".$employee['employee_registration_id']."'";
//                $arrWhere[] = "`wef_date` <='".MySqlDate($post['to_date'])."'";
//                $salary = $this->model['employee_salary']->getRow(implode(' AND ', $arrWhere), array('wef_date desc, created_at desc'));
//                //d($salary, true);
//                if($salary) {
//                    $allowances = $this->model['employee_allowance']->getRows(array('employee_salary_id' => $salary['employee_salary_id']));
//                    $total_allowance = 0;
//                    $grossable_allowance = 0;
//                    $taxable_allowance = 0;
//                    $arrAllowances = array();
//                    //d($allowances);
//                    foreach($allowances as $allowance) {
//                        $total_allowance += $allowance['allowance_amount'];
//                        if($allowance['grossable']==1) {
//                            $grossable_allowance += $allowance['allowance_amount'];
//                        }
//                        if($allowance['taxable']==1) {
//                            $taxable_allowance += $allowance['allowance_amount'];
//                        }
//
//                        $arrAllowances[] = array(
//                            'allowance_id' => $allowance['allowance_id'],
//                            'allowance_code' => $allowance['allowance_code'],
//                            'allowance_name' => $allowance['allowance_name'],
//                            'allowance_amount' => $allowance['allowance_amount'],
//                            'grossable' => $allowance['grossable'],
//                            'taxable' => $allowance['taxable'],
//                        );
//                    }
//                    // d($arrAllowances);
//                    // exit;
//                    $id = $employee['employee_registration_id'];
//                    if(isset($payrolls[$id]['arrears']) && !empty($payrolls[$id]['arrears']))
//                    {
//                        $employee['arrears'] = $payrolls[$id]['arrears'];
//                    }
//                    $taxable_salary = $salary['basic_salary']+$employee['arrears']+$taxable_allowance;
//                    $arrTaxDescription = array();
//                    $total_house_rent_allowance=0;
//                    $house_rent_percent=$salary['taxable_house_rent_percent'];
//                    $tax_discount = 0;
//                    if($salary['taxable']=='Yes') {
//                        $parent_company_id = $this->session->data['parent_company_id'];
//                        $company_id = $this->session->data['company_id'];
//                        if($parent_company_id != 0) {
//                            $registrations = $this->model['employee_registration']->getRows(array('employee_id'=>$employee['employee_id'],'parent_company_id' => $parent_company_id,'status'=>'Active'));
//                        } else {
//                            $registrations = $this->model['employee_registration']->getRows(array('employee_id'=>$employee['employee_id'],'company_id'=>$company_id,'status'=>'Active'));
//                        }
//                        $total_gross_salary = 0;
//                        if($employee['arrears'] != 0) {
//                            $arrTaxDescription[] = array(
//                                'description' => 'Arrears',
//                                'amount' => $employee['arrears']
//                            );
//                        }
//
//                        if($parent_company_id != 0) {
//                            $filter = array(
//                                'fiscal_year_id' => $this->session->data['fiscal_year_id'],
//                                'employee_id' => $employee['employee_id'],
//                                'parent_company_id' => $parent_company_id,
//                            );
//                        } else {
//                            $filter = array(
//                                'fiscal_year_id' => $this->session->data['fiscal_year_id'],
//                                'employee_id' => $employee['employee_id'],
//                                'company_id' => $company_id,
//                            );
//                        }
//                        $paid_gross = $this->model['payroll']->getTotalGross($filter);
//                        $paid_tax = $this->model['payroll']->getTotalTax($filter);
//                        $arrTaxDescription[] = array (
//                            'description' => 'Paid Gross',
//                            'amount' => $paid_gross
//                        );
//
//                        foreach($registrations as $registration) {
//                            $arrWhere = array();
//                            $arrWhere[] = "`employee_registration_id`='".$registration['employee_registration_id']."'";
//                            $arrWhere[] = "`wef_date` <='".MySqlDate($post['to_date'])."'";
//                            $loop_salary = $this->model['employee_salary']->getRow(implode(' AND ', $arrWhere), array('wef_date desc'));
//                            $loop_total_allowance = $this->model['employee_allowance']->getTotalAllowance(array('employee_salary_id' => $loop_salary['employee_salary_id'], 'taxable'=>1));
//                            if($loop_salary['taxable_house_rent']=='Yes') {
//                                $taxable_house_rent_allowance = round($loop_salary['basic_salary']*$loop_salary['taxable_house_rent_percent']/100);
//                            } else {
//                                $taxable_house_rent_allowance = 0;
//                            }
//                            $loop_gross_salary = $loop_salary['basic_salary']+$taxable_house_rent_allowance+$loop_total_allowance;
//
//                            $total_gross_salary += $loop_gross_salary;
//                            $total_house_rent_allowance += $taxable_house_rent_allowance;
//                        }
//
//                        //Remaining Payrolls calculated here
//                        $this->model['payroll'] = $this->load->model('payroll/payroll');
//                        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
//
//                        $total_payrolls =  $employee['total_payroll'];
//                        $generated_payrolls = $this->model['payroll']->getTotalPayrolls("employee_registration_id='".$employee['employee_registration_id']."' AND `fiscal_year_id`='".$this->session->data['fiscal_year_id']."' AND `exclude_payroll` = 0");
//                        $remaining_payrolls = $total_payrolls - $generated_payrolls;
//                        $estimated_remaining_gross = $total_gross_salary * $remaining_payrolls;
//                        $arrTaxDescription[] = array (
//                            'description' => 'Payroll Payable ('.$total_gross_salary.' x '.$remaining_payrolls.')',
//                            'amount' => $estimated_remaining_gross
//                        );
//
//                        $arrWhere = array();
//                        $arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
//                        $arrWhere[] = "`employee_id` = '".$employee['employee_id']."'";
//                        $arrWhere[] = "`is_taxable` = 1";
//                        $arrWhere[] = "(`document_date` >= '".MySqlDate($post['from_date'])."' AND `document_date` <= '".MySqlDate($post['to_date'])."')";
//                        $where = implode(' AND ', $arrWhere);
//                        $paid_taxable_allowance = $this->model['special_allowance']->getTotalAllowance($where);
//                        $arrTaxDescription[] = array (
//                            'description' => 'Special Allowance',
//                            'amount' => $paid_taxable_allowance
//                        );
//
//                        $estimated_annual_gross = $paid_gross + $paid_taxable_allowance + $estimated_remaining_gross;
//                        $arrTaxDescription[] = array(
//                            'description' => 'Estimated Annual Gross',
//                            'amount' => $estimated_annual_gross,
//                            'break' => true
//                        );
//
//                        $arrWhere = array();
//                        $arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
//                        $arrWhere[] = "`range_from` <= '".$estimated_annual_gross."' AND `range_to` >= '".$estimated_annual_gross."'";
//                        $where = implode(' AND ', $arrWhere);
//                        $tax = $this->model['tax_slab']->getRow($where);
//                        //d(array($where, $tax), true);
//                        if($tax['tax_type']=='Difference') {
//                            $taxable_amount = $estimated_annual_gross - round($tax['range_from']);
//                            $annual_tax_amount = round(($taxable_amount * $tax['tax_percent']/100),0) + $tax['additional'];
//                        } elseif($tax['tax_type']=='Fixed') {
//                            $taxable_amount = $estimated_annual_gross;
//                            $annual_tax_amount = round(($taxable_amount * $tax['tax_percent']/100),0) + $tax['additional'];
//                        }
//                        $arrTaxDescription[] = array(
//                            'description' => 'Estimated Annual Tax',
//                            'amount' => $annual_tax_amount,
//                        );
//                        if($age >= $tax_age_limit && $estimated_annual_gross < $amount_limit) {
//                            $tax_discount = round($annual_tax_amount * $tax_leniency_percent / 100);
//                            $arrTaxDescription[] = array(
//                                'description' => 'Leniency on Age above ' . $tax_age_limit . ' ('.$tax_leniency_percent.'%)',
//                                'amount' => $tax_discount,
//                            );
//                        }
//                        $arrTaxDescription[] = array(
//                            'description' => 'Paid Tax',
//                            'amount' => $paid_tax,
//                        );
//                        //d(array($total_gross_salary, $estimated_remaining_gross, $paid_gross, $paid_taxable_allowance, $estimated_annual_gross), true);
//                        $remaining_tax_amount = $annual_tax_amount - $tax_discount - $paid_tax;
//                        $arrTaxDescription[] = array(
//                            'description' => 'Payable Tax',
//                            'amount' => $remaining_tax_amount,
//                            'break' => true
//                        );
//                        if($remaining_tax_amount <= 0) {
//                            $current_tax_amount = 0;
//                        } else {
//                            //$current_tax_amount = ceil($remaining_tax_amount/$remaining_payrolls);
//                            // update by fahad 08-07-2019
//                            $current_tax_amount = round($remaining_tax_amount/$remaining_payrolls);
//                        }
//
//                        $arrTaxDescription[] = array(
//                            'description' => 'Current Tax ('.$remaining_tax_amount.' / '.$remaining_payrolls.')',
//                            'amount' => $current_tax_amount,
//                        );
//                    } else {
//                        $current_tax_amount = 0;
//                    }
//
//                    $arrDeductions = array();
//                    $deductions = $this->model['employee_deduction']->getRows(array('employee_salary_id' => $salary['employee_salary_id']));
//                    //d($deductions, true);
//
//                    if(isset($payrolls[$id]['manual_deduction']) &&
//                        !empty($payrolls[$id]['manual_deduction']))
//                    {
//                        $total_deduction = $payrolls[$id]['manual_deduction'];
//                    } else {
//                        $total_deduction = 0;
//                    }
//
//                    $total_deduction = 0;
//                    foreach($deductions as $deduction) {
//                        //Checks if deduction is EOBI and Age Exceeded the EOBI Rule.
//                        if($deduction['deduction_id']==8 && (($gender=='Female' && $age > $eobi_female_age_limit) || ($gender=='Male' && $age > $eobi_male_age_limit))) {
//                            $deduction['deduction_amount'] = 0;
//                        }
//                        $total_deduction += $deduction['deduction_amount'];
//
//                        $arrDeductions[] = array(
//                            'ref_document_id' => $deduction['deduction_id'],
//                            'ref_document_type' => 'Deduction',
//                            'ref_document' => 'Employee Deduction',
//                            'deduction_id' => $deduction['deduction_id'],
//                            'deduction_code' => $deduction['deduction_code'],
//                            'deduction_name' => $deduction['deduction_name'],
//                            'deduction_amount' => $deduction['deduction_amount'],
//                            'bank_id' => $deduction['bank_id'],
//                            'bank_account_no' => $deduction['account_no'],
//                            'bank_account_title' => $deduction['account_title'],
//                            'bank_iban' => $deduction['iban'],
//                        );
//                    }
//
//                    $arrWhere = array();
//                    $arrWhere[] = "`employee_registration_id` = '".$employee['employee_registration_id']."'";
//                    $arrWhere[] = "(`date` >= '".MySqlDate($post['from_date'])."' AND `date` <= '".MySqlDate($post['to_date'])."')";
//                    $arrWhere[] = "`payroll_deduction_id` IS NULL";
//                    $objAdvances = $this->model['advance']->getRows(implode(' AND ', $arrWhere));
//                    foreach($objAdvances as $objAdvance) {
//                        $total_deduction += $objAdvance['amount'];
//
//                        $arrDeductions[] = array(
//                            'ref_document_id' => $objAdvance['advance_id'],
//                            'ref_document_type' => 'Advance',
//                            'ref_document' => 'Advance',
//                            'deduction_id' => $objAdvance['advance_id'],
//                            'deduction_code' => 'ADV',
//                            'deduction_name' => 'Advance',
//                            'deduction_amount' => $objAdvance['amount'],
//                            'bank_id' => $objAdvance['bank_id'],
//                            'bank_account_no' => $objAdvance['account_no'],
//                            'bank_account_title' => $objAdvance['account_title'],
//                            'bank_iban' => $objAdvance['iban'],
//                        );
//                    }
//                    //d(array($arrWhere, $objAdvances), true);
//
//                    $arrWhere = array();
//                    $arrWhere[] = "`employee_registration_id` = '".$employee['employee_registration_id']."'";
//                    $arrWhere[] = "`installment_date` <= '".MySqlDate($post['to_date'])."'";
//                    $arrWhere[] = "`payroll_deduction_id` = ''";
//                    $where = implode(' AND ', $arrWhere);
//                    $objLoans = $this->model['loan_installment']->getRows($where);
//                    /*d($objLoans,true);*/
//                    foreach($objLoans as $objLoan) {
//                        //d($objLoan, true);
//                        if($objLoan['adjustment_type'] != 'Cash'){
//                            /*d($objLoan['allowance_for'],true);*/
//                            $total_deduction += $objLoan['installment_amount'];
//
//                            $arrDeductions[] = array(
//                                'ref_document_id' => $objLoan['loan_installment_id'],
//                                'ref_document_type' => 'Qarzan Hasana',
//                                'ref_document' => 'Qarzan Hasana ['.stdDate($objLoan['installment_date']).']',
//                                'deduction_id' => $objLoan['deduction_id'],
//                                'deduction_code' => $objLoan['deduction_code'],
//                                'deduction_name' => $objLoan['deduction_name'],
//                                'deduction_amount' => $objLoan['installment_amount'],
//                                'bank_id' => $objLoan['bank_id'],
//                                'bank_account_no' => $objLoan['account_no'],
//                                'bank_account_title' => $objLoan['account_title'],
//                                'bank_iban' => $objLoan['iban'],
//                            );
//                        }
//                    }
//
//                    //$net_salary = $gross_salary-$total_deduction-$current_tax_amount;
//                    $current_date = MySqlDate($post['from_date']);
//                    $to_date = MySqlDate($post['to_date']);
//                    $date_diff = strtotime($to_date.' 23:59:59')-strtotime($current_date.' 00:00:00');
//                    $working_day = round($date_diff / (60 * 60 * 24));
//
//                    $shift_status = $this->model['attendance_shift_detail']->getArrays('day',array('day', 'day_status'), array('attendance_shift_id' => $employee['attendance_shift_id']));
//                    //d($shift_status,true);
//                    $where = " `holiday_date` BETWEEN '". $current_date."' AND '".$to_date."'";
//                    $where .= " AND company_id=".$this->session->data['company_id'];
//                    //holidays
//                    $holidays = $this->model['holiday']->getArrays('holiday_date','holiday_date',$where);
//                    /*d(array($current_date,$to_date,$holidays),true);*/
//                    $shift_days = 0;
//
//                    while($current_date <= $to_date) {
//                        $day = date('D',strtotime($current_date));
//                        if($shift_status[$day]['day_status']=='Working Day') {
//                            if(!in_array($current_date, $holidays)) {
//                                $shift_days++;
//                            }
//                        }
//
//                        $current_date = date('Y-m-d', strtotime($current_date . ' +1 Day'));
//                    }
//                    // d($employee,true);
//                    if(isset($post['all_present'])) {
//                        $total_present = $working_day;
//                        $total_absent = 0;
//                    } else {
//
//                        if(isset($employee['attendance_exempted']) && $employee['attendance_exempted'] == 1)
//                        {
//                            $total_present = $working_day;
//                            $total_absent = 0;
//                        } else {
//                            // check if department is exempted
//                            $department = $this->model['department']->getRow(array('department_id' => $employee['department_id']));
//                            if(isset($department['attendance_exempted']) && $department['attendance_exempted'] == 1)
//                            {
//                                $total_present = $working_day;
//                                $total_absent = 0;
//                            }
//                            else
//                            {
//                                $id = $employee['employee_registration_id'];
//                                if(isset($payrolls[$id]['total_absent']))
//                                {
//                                    $total_absent = $payrolls[$id]['total_absent'];
//                                    $total_present = $working_day-$total_absent;
//                                } else {
//                                    /*
//                                    $arrWhere = array();
//                                    $arrWhere[] = "ea.`employee_registration_id` = '".$employee['employee_registration_id']."'";
//                                    $arrWhere[] = "(`attendance_date` >= '".MySqlDate($post['from_date'])."' AND `attendance_date` <= '".MySqlDate($post['to_date'])."')";
//                                    $where = implode(' AND ', $arrWhere);
//                                    $attendances = $this->model['employee_attendance']->getAttendanceSummary($where);
//                                    */
//
//                                    $filter = array(
//                                        'company_id' => $this->session->data['company_id'],
//                                        'employee_registration_id' => $employee['employee_registration_id'],
//                                        'from_date' => MySqlDate($post['from_date']),
//                                        'to_date' => $to_date
//                                    );
//                                    $attendances = $this->model['employee_attendance']->getAttendanceSummary($filter);
//                                    $attendance = $attendances[0];
//                                    if($attendance['total_holiday']=='') {
//                                        $attendance['total_holiday'] = 0;
//                                    }
//                                    if($attendance['total_pay_leave']=='') {
//                                        $attendance['total_pay_leave'] = 0;
//                                    }
//                                    if($attendance['total_present']=='') {
//                                        $attendance['total_present'] = 0;
//                                    }
//                                    if($attendance['total_late']=='') {
//                                        $attendance['total_late'] = 0;
//                                    }
//                                    $total_present = $attendance['total_present'] + $attendance['total_holiday']+ $attendance['total_pay_leave'] + ($attendance['total_late'] - ($attendance['late_deduction']==0?0:floor($attendance['total_late']/$attendance['late_deduction'])));
//                                    $total_absent = $working_day - $total_present;
//                                    //d([$filter, $attendance, $total_present, $total_absent], true);
//                                }
//                            }
//                        }
//                    }
//
//                    //$post['working_days']
//                    $id = $employee['employee_registration_id'];
//
//                    if(isset($payrolls[$id]['overtime']) &&
//                        !empty($payrolls[$id]['overtime']))
//                    {
//                        $overtime = $payrolls[$id]['overtime'];
//                    }
//                    else{
//                        $overtime = 0;
//                    }
//                    $gross_salary = $salary['basic_salary']+$employee['arrears']+$grossable_allowance +$overtime;
//
//                    // -------------- absent deduction calculation ------------
//
//                    $company_info = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));
//                    if(empty($company_info['deduction_percent'])) {
//                        $company_info['deduction_percent'] = 0;
//                    }
//                    if($company_info['deduction_percent']==0) {
//                        $temp = 0;
//                    } else {
//                        $temp = round($salary['basic_salary']/$company_info['deduction_days']);
//                    }
//                    $panelty = ($temp/100)*$company_info['deduction_percent'];
//                    $absent_deduction = ($temp + $panelty) * $total_absent;
//                    if(isset($payrolls[$id]['manual_deduction']) &&
//                        !empty($payrolls[$id]['manual_deduction']))
//                    {
//                        $manual_deduction = $payrolls[$id]['manual_deduction'];
//                    }
//                    else{
//                        $manual_deduction = 0;
//                    }
//
//                    $net_salary = $gross_salary-$total_deduction - $manual_deduction;
//                    if(($net_salary - $current_tax_amount) < $absent_deduction) {
//                        $absent_deduction = ($net_salary - $current_tax_amount);
//                    }
//                    $payable_salary = round($net_salary - $absent_deduction - $current_tax_amount);
//
//
//                    $payrolls[$employee['employee_registration_id']] = array(
//                        'employee_registration_id' => $employee['employee_registration_id'],
//                        'registration_code' => $employee['registration_code'],
//                        'employee_id' => $employee['employee_id'],
//                        'employee_code' => $employee['employee_code'],
//                        'employee_name' => $employee['employee_name'],
//                        'employee_age' => $age,
//                        'department_id' => $employee['department_id'],
//                        'department_name' => $employee['department_name'],
//                        'eobi_no' => $employee['eobi_no'],
//                        'department' => $employee['department_name'],
//                        'designation' => $employee['designation_name'],
//                        'basic_salary' => $salary['basic_salary'],
//                        'house_rent_percent' => $house_rent_percent,
//                        'house_rent_allowance' => $total_house_rent_allowance,
//                        'other_allowance' => $total_allowance,
//                        'arrears' => $employee['arrears'],
//                        'grossable_allowance' => $grossable_allowance,
//                        'gross_salary' => $gross_salary,
//                        'other_deduction' => $total_deduction,
//                        'tax_discount' => $tax_discount,
//                        'tax_deduction' => $current_tax_amount,
//                        'manual_addition' => 0,
//                        'manual_deduction' => $manual_deduction,
//                        'overtime' => $overtime,
//                        'net_salary' => $net_salary,
//                        'total_present' => $total_present,
//                        'total_absent' => $total_absent,
//                        'attendance_deduction' => $absent_deduction,
//                        'payable_salary' => $payable_salary,
//                        'allowances' => $arrAllowances,
//                        'deductions' => $arrDeductions,
//                        'tax_slab' => $tax,
//                        'taxable_allowance' => $taxable_allowance,
//                        'taxable_salary' => $taxable_salary + $total_house_rent_allowance,
//                        'taxable' => $salary['taxable'] + $total_house_rent_allowance,
//                        'annual_gross' => $estimated_annual_gross,
//                        'tax_description' => $arrTaxDescription,
//                        'working_days' =>$working_day,
//                        'bank_id' =>$employee['bank_id'],
//                        'bank_account_no' =>$employee['bank_account'],
//                        'bank_account_title' =>$employee['bank_title'],
//                        'bank_account_iban' =>$employee['bank_iban'],
//                    );
////                    $taxes[$employee['employee_registration_id']] = array(
////                        'tax_description' => $arrTaxDescription,
////                    );
//                }
//            }
//        }
//
//
//        //d($payrolls, true);
//        $this->session->data['payrolls'] = $payrolls;
//        $html = $this->getPayrollTable();
//
//        //d($html, true);
//        $json = array(
//            'success' => true,
//            'post' => $post,
//            'payrolls' => $payrolls,
//            //'taxes' => $taxes,
//            'html' => $html
//        );
//
//        //d($json, true);
//        echo json_encode($json);
//        exit;
//    }

    public function downloadExcel() {
        $payrolls = $this->session->data['payrolls'];
        //d($payrolls, true);
        $this->model['department'] = $this->load->model('setup/department');
        $arrDepartments = $this->model['department']->getArrays('department_id','department_name', array('company_id' => $this->session->data['company_id']));
        //d($arrDepartments, true);
        include_once(DIR_SYSTEM.'library/PHPExcel.php');
        include_once(DIR_SYSTEM.'library/PHPExcel/Classes/PHPExcel/Writer/Excel5.php');
        include_once(DIR_SYSTEM.'library/PHPExcel/Worksheet.php');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $rowCount = 1;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Reg. ID.');
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, 'Department');
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, 'Reg. Code');
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, 'Employee');
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, 'Basic');
        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, 'Other Allowances');
        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, 'Arrears');
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, 'Over Time');
        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, 'Gross Salary');
        $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, 'Other Deduction');
        $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, 'Manual Deduction');
        $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, 'Net Salary');
        $objPHPExcel->getActiveSheet()->SetCellValue('M'.$rowCount, 'Working Days');
        $objPHPExcel->getActiveSheet()->SetCellValue('N'.$rowCount, 'Total Absent');
        $objPHPExcel->getActiveSheet()->SetCellValue('O'.$rowCount, 'Absent Deduction');
        $objPHPExcel->getActiveSheet()->SetCellValue('P'.$rowCount, 'Tax Deduction');
        $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$rowCount, 'Payable Amount');
        $objPHPExcel->getActiveSheet()->SetCellValue('R'.$rowCount, 'Reg. Count');
        $objPHPExcel->getActiveSheet()->SetCellValue('S'.$rowCount, 'Annual Taxable Salary');
        $objPHPExcel->getActiveSheet()->SetCellValue('T'.$rowCount, 'Annual Tax Amount');
        $objPHPExcel->getActiveSheet()->SetCellValue('U'.$rowCount, 'Annual Tax Remaining');
        foreach($payrolls as $employee) {
            $rowCount++;
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $employee['employee_registration_id']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $arrDepartments[$employee['department_id']]);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $employee['registration_code']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $employee['employee_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $employee['basic_salary']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $employee['other_allowance']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $employee['arrears']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $employee['overtime']);
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, '=(E'.$rowCount.'+F'.$rowCount.'+G'.$rowCount.'+H'.$rowCount.')');
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, $employee['other_deduction']);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, $employee['manual_deduction']);
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, '=(I'.$rowCount.'-J'.$rowCount.'-K'.$rowCount.')');
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$rowCount, $employee['working_days']);
            $objPHPExcel->getActiveSheet()->SetCellValue('N'.$rowCount, $employee['total_absent']);
            $objPHPExcel->getActiveSheet()->SetCellValue('O'.$rowCount, '=ROUND(I'.$rowCount.'/M'.$rowCount.'*N'.$rowCount.',0)');
            $objPHPExcel->getActiveSheet()->SetCellValue('P'.$rowCount, $employee['tax_deduction']);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$rowCount, '=(L'.$rowCount.'-O'.$rowCount.'-P'.$rowCount.')');
            $objPHPExcel->getActiveSheet()->SetCellValue('R'.$rowCount, $employee['salary_count']);
            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$rowCount, $employee['annual_taxable_salary']);
            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$rowCount, $employee['annual_tax_amount']);
            $objPHPExcel->getActiveSheet()->SetCellValue('U'.$rowCount, $employee['annual_tax_remaining']);
        }
        $objPHPExcel->getActiveSheet()->getStyle('H2:H'.$rowCount)->getFill()
            ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
            ->getStartColor()->setARGB('FFE8E5E5');
        $objPHPExcel->getActiveSheet()->getStyle('K2:K'.$rowCount)->getFill()
            ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
            ->getStartColor()->setARGB('FFE8E5E5');
        $objPHPExcel->getActiveSheet()->getStyle('N2:N'.$rowCount)->getFill()
            ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
            ->getStartColor()->setARGB('FFE8E5E5');
        $objSheet = $objPHPExcel->getActiveSheet();
        //$objSheet->protectCells('A2:G'.$rowCount, 'PHP');

        //This will fill background with grey color.
        $objSheet->getStyle('H2:H'.$rowCount)->getProtection()->setLocked(PHPExcel_Style_Protection::PROTECTION_UNPROTECTED);
        $objSheet->getStyle('K2:K'.$rowCount)->getProtection()->setLocked(PHPExcel_Style_Protection::PROTECTION_UNPROTECTED);
        $objSheet->getStyle('N2:N'.$rowCount)->getProtection()->setLocked(PHPExcel_Style_Protection::PROTECTION_UNPROTECTED);

        //This will Hide Column
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setVisible(false);

        $objSheet->getProtection()->setSheet(true);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="Payroll.xlsx"');
        header('Cache-Control: max-age=0');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        //$objWriter->save('some_excel_file.xlsx');
        $objWriter->save('php://output');
        exit;

        //d($payrolls, true);
    }

    private function getPayrollTable() {
        $lang = $this->load->language($this->getAlias());
        $payrolls = $this->session->data['payrolls'];
        $total_basic_salary = 0;
        $total_other_allowance = 0;
        $total_arrears = 0;
        $total_gross_salary = 0;
        $total_taxable_salary = 0;
        $total_tax_deduction = 0;
        $total_house_rent_allowance = 0;
        $total_other_deduction = 0;
        $total_manual_addition = 0;
        $total_manual_deduction = 0;
        $total_overtime = 0;
        $total_net_salary = 0;
        $total_payable_salary = 0;
        $total_attendance_deduction = 0;
        $id= 0;
        $html = '';
        $html .= '<table id="tblPayroll" class="table table-striped" style="max-height: 500px;">';
        $html .= '<thead>';
        $html .= '<tr>';
        $html .= '<th class="freeze">&nbsp;</th>';
        $html .= '<th class="freeze">Sr.</th>';
        $html .= '<th class="freeze">'.$lang['registration_code'].'</th>';
        $html .= '<th class="freeze">'.$lang['employee_name'].'</th>';
        $html .= '<th>'.$lang['basic_salary'].'</th>';
        $html .= '<th>'.$lang['other_allowance'].'</th>';
        //$html .= '<th>'.$lang['arrears'].'</th>';
        $html .= '<th>'.$lang['gross_salary'].'</th>';
        $html .= '<th>'.$lang['other_deduction'].'</th>';
        //$html .= '<th>'.$lang['manual_addition'].'</th>';
        //$html .= '<th>'.$lang['manual_deduction'].'</th>';
        //$html .= '<th>'.$lang['overtime'].'</th>';
        $html .= '<th>'.$lang['net_salary'].'</th>';
        //$html .= '<th>'.$lang['working_days'].'</th>';
        $html .= '<th>'.$lang['total_absent'].'</th>';
        $html .= '<th>'.$lang['payable_salary'].'</th>';
        $html .= '<th>'.$lang['taxable_salary'].'</th>';
        $html .= '<th>'.$lang['tax_deduction'].'</th>';
        $html .= '</tr>';
        $html .= '</thead>';
        $html .= '<tbody>';

        foreach($payrolls as $registration_id => $payroll) {
            $html .= '<tr '.($payroll['covid_status_color']?'style="background-color:'.$payroll['covid_status_color'].'"':'').' data-id="'.$id.'" data-registration_id="'.$registration_id.'">';
            $html .= '<td class="text-center freeze">';
            if($payroll['covid_status_color']=='') {
                $html .= '<input type="checkbox" title="'.$payroll['covid_status'].'" data-toggle="tooltip" data-placement="right" id="payroll_'.$id.'_selected" name="payrolls['.$registration_id.'][selected]" value="1" checked />';
            } else {
                $html .= '<input type="checkbox" title="'.$payroll['covid_status'].'" data-toggle="tooltip" data-placement="right" id="payroll_'.$id.'_selected" name="payrolls['.$registration_id.'][selected]" value="1" />';
            }
            $html .= '</td>';
            $html .= '<td data-search="'.($id+1).'" data-order="'.($id+1).'" class="text-center">'.($id+1).'</td>';
            $html .= '<td data-search="'.$payroll['registration_code'].'" data-order="'.$payroll['registration_code'].'">';
            $html .= '<span class="registration_code">'.$payroll['registration_code'].'</span>';
            $html .= '</td>';
            $html .= '<td data-search="'.$payroll['employee_name'].'" data-order="'.$payroll['employee_name'].'">';
            $html .= '<a href="javascript:void(0);" onclick="displayPopup(this);" class="employee_name">'.$payroll['employee_name'].'</a>';
            $html .= '</td>';
            $html .= '<td data-search="'.$payroll['basic_salary'].'" data-order="'.$payroll['basic_salary'].'" class="text-center">';
            $html .= '<span class="basic_salary">'.$payroll['basic_salary'].'</span>';
            $html .= '</td>';
            $html .= '<td data-search="'.$payroll['other_allowance'].'" data-order="'.$payroll['other_allowance'].'" class="text-center">';
            $html .= '<a href="javascript:void(0);" onclick="displayAllowance(this);">'.$payroll['other_allowance'].'</a>';
            $html .= '</td>';
            $html .= '<td data-search="'.$payroll['gross_salary'].'" data-order="'.$payroll['gross_salary'].'" class="text-center">';
            $html .= '<span class="gross_salary">'.$payroll['gross_salary'].'</span>';
            $html .= '<td data-search="'.$payroll['other_deduction'].'" data-order="'.$payroll['other_deduction'].'" class="text-center">';
            $html .= '<a href="javascript:void(0);" onclick="displayDeduction(this);" class="other_deduction">'.$payroll['other_deduction'].'</a>';
            $html .= '</td>';
            $html .= '<td data-search="'.$payroll['net_salary'].'" data-order="'.$payroll['net_salary'].'" class="text-center">';
            $html .= '<span class="net_salary">'.$payroll['net_salary'].'</span>';
            $html .= '</td>';
            $html .= '<td data-search="'.$payroll['total_absent'].'" data-order="'.$payroll['total_absent'].'" class="text-center">';
            $html .= '<span class="total_absent">'.$payroll['total_absent'].'</span>';
            $html .= '</td>';
            $html .= '<td data-search="'.$payroll['payable_salary'].'" data-order="'.$payroll['payable_salary'].'" class="text-center">';
            $html .= '<span class="payable_salary">'.$payroll['payable_salary'].'</span>';
            $html .= '</td>';
            $html .= '</td>';
            $html .= '<td data-search="'.$payroll['taxable_salary'].'" data-order="'.$payroll['taxable_salary'].'" class="text-center">';
            $html .= '<span class="taxable_salary">'.$payroll['taxable_salary'].'</span>';
            $html .= '</td>';
            $html .= '<td data-search="'.$payroll['tax_deduction'].'" data-order="'.$payroll['tax_deduction'].'" '.($payroll['tax_discount']?'class="bg-green text-center"':'class="bg-yellow text-center"').'>';
            $html .= '<a href="javascript:void(0);" onclick="getTaxDescription(this);" class="tax_deduction">'.$payroll['tax_deduction'].'</a>';
            $html .= '</td>';
            $html .= '</tr>';

            $id++;
            if($payroll['covid_status_color']=='') {
                $total_house_rent_allowance += $payroll['house_rent_allowance'];
                $total_basic_salary += $payroll['basic_salary'];
                $total_other_allowance += $payroll['other_allowance'];
                $total_arrears += $payroll['arrears'];
                $total_gross_salary += $payroll['gross_salary'];
                $total_taxable_salary += $payroll['taxable_salary'];
                $total_tax_deduction += $payroll['tax_deduction'];
                $total_other_deduction += $payroll['other_deduction'];
                $total_manual_addition += $payroll['manual_addition'];
                $total_manual_deduction += $payroll['manual_deduction'];
                $total_overtime += $payroll['overtime'];
                $total_net_salary += $payroll['net_salary'];
                $total_payable_salary += $payroll['payable_salary'];
                $total_attendance_deduction = ($total_net_salary - $total_payable_salary);
            }
        }
        $html .= '</tbody>';
        $html .= '<tfoot>';
        $html .= '<tr>';
        $html .= '<td>&nbsp;</td>';
        $html .= '<td>&nbsp;</td>';
        $html .= '<td class="text-right">Total:</td>';
        $html .= '<td class="text-right">S&A: <span id="total_sa">'.($total_house_rent_allowance + $total_gross_salary-$total_attendance_deduction).'</span></td>';
        $html .= '<td class="text-right"><span id="total_basic_salary">'.$total_basic_salary.'</span></td>';
        $html .= '<td class="text-right"><span id="total_other_allowance">'.$total_other_allowance.'</span></td>';
        //$html .= '<td class="text-right"><span id="total_arrears">'.$total_arrears.'</span></td>';
        $html .= '<td class="text-right"><span id="total_gross_salary">'.$total_gross_salary.'</span></td>';
        $html .= '<td class="text-right"><span id="total_other_deduction">'.$total_other_deduction.'</span></td>';
        //$html .= '<td class="text-right"><span id="total_manual_addition">'.$total_manual_addition.'</span></td>';
        //$html .= '<td class="text-right"><span id="total_manual_deduction">'.$total_manual_deduction.'</span></td>';
        //$html .= '<td class="text-right"><span id="total_overtime">'.$total_overtime.'</span></td>';
        $html .= '<td class="text-right"><span id="total_net_salary">'.$total_net_salary.'</span></td>';
        //$html .= '<td class="text-right">&nbsp;</td>';
        $html .= '<td class="text-right">&nbsp;</td>';
        $html .= '<td class="text-right"><span id="total_payable_salary">'.$total_payable_salary.'</span></td>';
        $html .= '<td class="text-right"><span id="total_taxable_salary">'.$total_taxable_salary.'</span></td>';
        $html .= '<td class="text-right"><span id="total_tax_deduction">'.$total_tax_deduction.'</span></td>';
        $html .= '</tr>';
        $html .= '</tfoot>';
        $html .= '</table>';


        return $html;
    }

    public function getPayrollData() {
        $employee_registration_id = $this->request->post['registration_id'];
        $payrolls = $this->session->data['payrolls'];
        $payroll = $payrolls[$employee_registration_id];

        $json = array(
            'success' => true,
            'employee_registration_id' => $employee_registration_id,
            'payroll' => $payroll
        );

        echo json_encode($json);
        exit;
    }

    public function updatePayrollData() {
        $post = $this->request->post;
        $employee_registration_id = $post['employee_registration_id'];
        $payrolls = $this->session->data['payrolls'];
        $objPayroll = $payrolls[$employee_registration_id];
        $objPayroll['arrears'] = $post['arrears'];
        $objPayroll['manual_addition'] = $post['manual_addition'];
        $objPayroll['overtime'] = $post['overtime'];

        $objPayroll['taxable_salary'] = $objPayroll['basic_salary']
            +$objPayroll['house_rent_allowance']
            +$objPayroll['taxable_allowance']
            +$objPayroll['arrears']
            +$objPayroll['manual_addition']
            +$objPayroll['overtime'];
        $objPayroll['gross_salary'] = $objPayroll['basic_salary']
            +$objPayroll['grossable_allowance']
            +$objPayroll['arrears']
            +$objPayroll['manual_addition']
            +$objPayroll['overtime'];

        $objPayroll['manual_deduction'] = $post['manual_deduction'];
        $objPayroll['net_salary'] = $objPayroll['gross_salary']-$objPayroll['other_deduction']-$objPayroll['manual_deduction'];

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $filter = array(
            'parent_company_id' => $this->session->data['parent_company_id'],
            'company_id' => $this->session->data['company_id'],
            'employee_registration_id' => $post['employee_registration_id'],
            'employee_id' => $post['employee_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'document_date' => MySqlDate($post['document_date']),
            'taxable_salary' => $objPayroll['taxable_salary'],
            'exclude_payroll' => 0,
        );
        $tax_info = $this->model['payroll']->getTaxDetail($filter);
        //d([$filter, $tax_info], true);
        //$objPayroll['tax_deduction'] = $post['tax_deduction'];
        $objPayroll['tax_description'] = $tax_info['tax_description'];
        //$objPayroll['tax_deduction'] = $tax_info['monthly_tax'];
        $objPayroll['tax_deduction'] = $post['tax_deduction'];
        $objPayroll['total_absent'] = $post['total_absent'];
        $objPayroll['total_present'] = $objPayroll['working_days']-$objPayroll['total_absent'];
        $objPayroll['attendance_deduction'] = ($objPayroll['daily_deduction']*$objPayroll['total_absent']);
        if($objPayroll['attendance_deduction'] > ($objPayroll['net_salary'] - $objPayroll['tax_deduction'])) {
            $objPayroll['attendance_deduction'] = ($objPayroll['net_salary'] - $objPayroll['tax_deduction']);
        }
        $objPayroll['payable_salary'] = $objPayroll['net_salary']-$objPayroll['tax_deduction']-$objPayroll['attendance_deduction'];

        $payrolls[$employee_registration_id] = $objPayroll;

        $this->session->data['payrolls'] = $payrolls;
        $html = $this->getPayrollTable();
        //d($payrolls[$employee_registration_id], true);
        $json = array(
            'success' => true,
            'html' => $html,
            'payrolls' => $payrolls
        );

        echo json_encode($json);
        exit;
    }

    // This function is to update user
    // payroll from the given values in excel file
    public function updatePayrollDataFromFile($post) {

        // d($post,true);
        $employee_registration_id = $post['employee_registration_id'];
        $payrolls = $this->session->data['payrolls'];
        $payroll = $payrolls[$employee_registration_id];

        $payrolls[$employee_registration_id]['basic_salary'] = $post['basic_salary'];
        $payrolls[$employee_registration_id]['other_allowance'] = $post['other_allowance'];
        $payrolls[$employee_registration_id]['arrears'] = $post['arrears'];
        $payrolls[$employee_registration_id]['gross_salary'] = $post['gross_salary'];
        $payrolls[$employee_registration_id]['other_deduction'] = $post['other_deduction'];
        $payrolls[$employee_registration_id]['manual_addition'] = $post['manual_addition'];
        $payrolls[$employee_registration_id]['manual_deduction'] = $post['manual_deduction'];
        $payrolls[$employee_registration_id]['overtime'] = $post['overtime'];
        $payrolls[$employee_registration_id]['net_salary'] = $post['net_salary'];
        $payrolls[$employee_registration_id]['working_days'] = $post['working_days'];
        $payrolls[$employee_registration_id]['total_absent'] = $post['total_absent'];
        $payrolls[$employee_registration_id]['total_present'] = $post['working_days'] - $post['total_absent'];
        $payrolls[$employee_registration_id]['attendance_deduction'] = round($post['basic_salary']/$post['working_days']*$post['total_absent']);
        $payrolls[$employee_registration_id]['taxable_allowance'] = $post['taxable_allowance'];
        $payrolls[$employee_registration_id]['taxable_salary'] = $post['taxable_salary'];
        $payrolls[$employee_registration_id]['tax_deduction'] = $post['tax_deduction'];
        $payrolls[$employee_registration_id]['payable_salary'] = $post['payable_salary'];

        return $payrolls;

    }

    protected function insertData($data) {
        $payrolls = $this->session->data['payrolls'];
        // d(array($data, $payrolls),true);
        ini_set('max_execution_time','400');
        $this->model['loan_installment'] = $this->load->model('payroll/loan_installment');
        $this->model['advance'] = $this->load->model('payroll/advance');
        $this->model['payroll_allowance'] = $this->load->model('payroll/payroll_allowance');
        $this->model['payroll_deduction'] = $this->load->model('payroll/payroll_deduction');
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');

        //d($payrolls, true);
        foreach($data['payrolls'] as $employee_registration_id => $payroll) {
            if($payroll['selected']==1) {
                $payroll = $payrolls[$employee_registration_id];
                $payroll['company_id'] = $this->session->data['company_id'];
                $payroll['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
                $payroll['document_date'] = MySqlDate($data['document_date']);
                $payroll['document_title'] = $data['document_title'];
                $payroll['from_date'] = MySqlDate($data['from_date']);
                $payroll['to_date'] = MySqlDate($data['to_date']);
                $payroll['remaining_payroll'] = $data['remaining_payroll'];
                if(isset($payroll['exclude_payroll'])) {
                    $payroll['exclude_payroll']=1;
                } else {
                    $payroll['exclude_payroll']=0;
                }
                //d($payroll,true);
                $payroll_id = $this->model[$this->getAlias()]->add($this->getAlias(), $payroll);

                foreach($payroll['allowances'] as $allowance) {
                    $allowance['payroll_id'] = $payroll_id;

                    $this->model['payroll_allowance']->add($this->getAlias(), $allowance);
                }

                //d($payroll['other_deductions'], true);
                foreach($payroll['deductions'] as $deduction) {
                    $deduction['payroll_id'] = $payroll_id;

                    $payroll_deduction_id = $this->model['payroll_deduction']->add($this->getAlias(), $deduction);

                    if($deduction['ref_document_type']=='Qarzan Hasana') {
                        $this->model['loan_installment']->edit($this->getAlias(), $deduction['ref_document_id'], array('payroll_id' => $payroll_id, 'payroll_deduction_id' => $payroll_deduction_id));
                    } elseif($deduction['ref_document_type']=='Advance') {
                        $this->model['advance']->edit($this->getAlias(), $deduction['ref_document_id'], array('payroll_id' => $payroll_id, 'payroll_deduction_id' => $payroll_deduction_id));
                    }
                }
                $this->model['employee_registration']->edit($this->getAlias(), $payroll['employee_registration_id'], array('arrears' => 0));
            }
        }
    }
}

?>