<?php

class ControllerPayrollLoan extends HController {

    protected function getAlias() {
        return 'payroll/loan';
    }

    protected function getPrimaryKey() {
        return 'loan_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $this->load->language('payroll/loan');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'employee_code', 'employee_name', 'date', 'total_amount', 'total_installment','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        //$arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $this->data['lang']['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printCovering', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );

            if($aRow['is_post'] != 1) {
                $actions[] = array(
                    'text' => $this->data['lang']['post'],
                    'target' => '_blank',
                    'href' => $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                    'btn_class' => 'btn btn-info btn-xs',
                    'class' => 'fa fa-thumbs-up'
                );

                $actions[] = array(
                    'text' => $this->data['lang']['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' ' .(isset($action['target'])?'target="'.$action['target'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'date') {
                    $row[] = stdDate($aRow['date']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();


        $filter = [];
        $join = ' Left ';
        if($this->session->data['is_all_company_account']!=1){
           $join = ' Inner';
           $filter['company_id'] = $this->session->data['company_id'];
        }
        $this->model['company_deduction'] = $this->load->model('setup/company_deduction');
        $this->data['deductions'] = $this->model['company_deduction']->getCompanyDeductions($filter['company_id'] ,$join);

        // Bank Company Wise
        $this->model['company_account'] = $this->load->model('setup/company_account');
        $this->data['company_accounts'] = $this->model['company_account']->getRows($filter, array('account_title'));

        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee_registration']->getRows(array('company_id' => $this->session->data['company_id'], 'status' => 'Active'), array('employee_name'));

        $this->data['date'] = stdDate();
        if (isset($this->request->get['loan_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['is_edit'] = 1;
            $result = $this->model[$this->getAlias()]->getRow(array('loan_id' => $this->request->get['loan_id']));
            foreach($result as $field => $value) {
                if(($field=='date' || $field=='start_date' || $field=='cheque_date') && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }

            }

            $this->model['loan_installment'] = $this->load->model('payroll/loan_installment');
            $installments = $this->model['loan_installment']->getRows(array('loan_id' => $result['loan_id']), array('installment_date'));
            /*d($installments,true);*/
            $this->data['lock'] = 0;
            foreach($installments as $installment) {
                $this->data['installments'][] = array(
                    'installment_date' => stdDate($installment['installment_date']),
                    'installment_amount' => $installment['installment_amount'],
                    'adjustment_type' => $installment['adjustment_type'],
                    'installment_remarks' => $installment['installment_remarks'],
                    'payroll_id' => $installment['payroll_id'],
                    'payroll_deduction_id' => $installment['payroll_deduction_id']
                );
                if($installment['payroll_id'] != '') {
                    $this->data['lock'] = 1;
                }

            }
        }

        $this->data['strValidation']="{
            'rules':{
		        'employee_registration_id': {'required':true},
		        'date': {'required':true},
		        'total_amount': {'required':true},
		        'total_installment': {'required':true},
		        'start_date': {'required':true},
		        'total_installment_amount': {equalTo: '#total_amount'},
            },
            'messages':{
		        'total_installment_amount': {equalTo: 'Must be Equal to Total Amount'},
            }
        }";

        $this->data['href_get_installment'] = $this->url->link($this->getAlias() . '/getInstallment', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->response->setOutput($this->render());
    }

    public function getInstallment() {
        $post = $this->request->post;
        $start_date = date('Y-m-01',strtotime(MySqlDate($post['start_date'])));
        $total_amount = $post['total_amount'];
        $total_installment = $post['total_installment'];
        $installment_amount = ceil($total_amount/$total_installment);
        $running_amount=0;
        $html = '';

        for($i=0; $i<$total_installment; $i++) {
            $date = date("Y-m-d", strtotime("+".$i." month", strtotime($start_date)));
            if($i==($total_installment-1)) {
                $installment_amount = ($total_amount - $running_amount);
            }
            $html .= '<tr id="grid_row_installment_'.$i.'" data-grid_row_installment="'.$i.'">';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control dtpDate" id="installment_'.$i.'_installment_date" name="installments['.$i.'][installment_date]" value="'.stdDate($date).'" />';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input onchange="calculateTotal();" type="text" class="form-control text-right fPDecimal" id="installment_'.$i.'_installment_amount" name="installments['.$i.'][installment_amount]" value="'.$installment_amount.'" />';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<select class="form-control" id="installment_'.$i.'_adjustment_type" name="installments['.$i.'][adjustment_type]" >';
            $html .= '<option value="Payroll">Payroll</option>';
            $html .= '<option value="Cash" >Cash</option>';
            $html .= '</select>';
            $html .= '</td>';

            $html .= '<td>';
            $html .= '<input type="text" class="form-control" id="installment_'.$i.'_remarks" name="installments['.$i.'][installment_remarks]" value="" />';
            $html .= '</td>';
            $html .= '<td><a title="Remove" class="btnRemoveGrid btn btn-xs btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a></td>';
            $html .= '</tr>';

            $running_amount += $installment_amount;
        }

        $json = array(
            'success' => true,
            'post' => $post,
            'html' => $html,
            'grid_row_installment' => $i,
            'running_amount' => $running_amount
        );
        /*d($json,true);*/
        echo json_encode($json);
    }

    protected function insertData($data) {
        $this->model['loan_installment'] = $this->load->model('payroll/loan_installment');
        $data['company_id'] = $this->session->data['company_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['date'] = MySqlDate($data['date']);
        $data['start_date'] = MySqlDate($data['start_date']);

        if($data['cheque_date']=='') {
            $data['cheque_date']=NULL;
        } else {
            $data['cheque_date']=MySqlDate($data['cheque_date']);
        }
        $loan_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);

        foreach($data['installments'] as $installment) {
            $installment['loan_id'] = $loan_id;
            $installment['installment_date'] = MySqlDate($installment['installment_date']);

            $this->model['loan_installment']->add($this->getAlias(), $installment);
        }
    }

    protected function updateData($primary_key, $data) {
        $this->model['loan_installment'] = $this->load->model('payroll/loan_installment');
        $this->model['loan_installment']->deleteBulk($this->getAlias(), array('loan_id' => $primary_key));

        $data['date'] = MySqlDate($data['date']);
        $data['start_date'] = MySqlDate($data['start_date']);

        if($data['cheque_date']=='') {
            $data['cheque_date']=NULL;
        } else {
            $data['cheque_date']=MySqlDate($data['cheque_date']);
        }

        $loan_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);
            /*d(array($data),true);*/
        foreach($data['installments'] as $installment) {
            /*d($installment,true);*/
            $installment['loan_id'] = $loan_id;
            $installment['installment_date'] = MySqlDate($installment['installment_date']);
            /*$installment['payroll_id'] = $installment['payroll_id'];*/

            $this->model['loan_installment']->add($this->getAlias(), $installment);
        }

    }

    protected function deleteData($primary_key) {
        $this->model['loan_installment'] = $this->load->model('payroll/loan_installment');
        $this->model['loan_installment']->deleteBulk($this->getAlias(), array('loan_id' => $primary_key));

        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);
    }

    public function post() {
        parent::getForm();
        $loan_id = $this->request->get['loan_id'];

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            $this->db->beginTransaction();
            $id = $this->postData($this->request->post);
            $this->db->commit();

            //$this->session->data['success'] = $this->language->get('success_insert');
            $this->redirect($this->url->link($this->getAlias(), 'token=' . $this->session->data['token'], 'SSL'));
        }

        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->model['loan'] = $this->load->model('payroll/loan');
        $this->model['company_account'] = $this->load->model('setup/company_account');
        $this->model['company'] = $this->load->model('setup/company');

        $result = $this->model['loan']->getRow(['loan_id' => $loan_id]);
        $company_account = $this->model['company_account']->getRow(['company_account_id' => $result['company_account_id']]);
        $company = $this->model['company']->getRow(['company_id' => $company_account['company_id']]);

        foreach($result as $field => $value) {
            if($field=='date') {
                $this->data[$field] = stdDate($value);
            } else {
                $this->data[$field] = $value;
            }
        }
        foreach($company_account as $field => $value) {
            if($field=='document_date') {
                $this->data[$field] = stdDate($value);
            } else {
                $this->data[$field] = $value;
            }
        }

        $this->data['document_identity'] = $result['registration_code'].'-'.$result['cheque_no'];
        $this->data['document_title'] = 'Qardan Hasana ';

        $cheque_details = [];
        $cheque_details[] = [
            'employee_name' => $result['employee_name'],
            'cheque_date' => $result['cheque_date'],
            'cheque_no' => $result['cheque_no'],
            'cheque_amount' => $result['total_amount'],
        ];
        $this->data['cheque_details'] = $cheque_details;
        $this->data['pay_from_company_id'] = $company['ref_id'];
        $this->data['companies'] = $this->model['company']->getRows(array(), array('company_name'));

        $this->data['href_get_accounts_data'] = $this->url->link($this->getAlias() . '/getAccountsData', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_save'] = $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->template = $this->getAlias() . '_post.tpl';
        $this->response->setOutput($this->render());
    }

    public function getAccountsData() {
        $this->model['loan'] = $this->load->model('payroll/loan');

        $post = $this->request->post;
        $loan_id = $this->request->get['loan_id'];

        $pay_date = $post['pay_date'];
        $account_details = $this->model['loan']->getPostData($loan_id);

        $ctrl_no = 0;
        $budgets = array();
        //d($account_details, true);
        foreach($account_details as $detail) {
            $budgets[] = array(
                'Comp' => $post['Comp'],
                'Year' => $detail['Year'],
                'BudKey' => $detail['budget_key'],
                'Ref' => str_replace('/','-',$detail['document_identity']),
                'budAmount' => $detail['Bamount'],
                'Status' => 'F',
                'PartyID' => $detail['PartyID'],
                'AHKey' => $detail['dah_key'],
            );
            $ctrl_no++;
            $data[] = array (
                //'PayDate' => date('Ymd',strtotime($detail['document_date'])),
                'PayDate' => date('Ymd',strtotime($pay_date)),
                'SysKey' => str_replace('/','-',$detail['document_identity']),
                'SysTag' => 'PR',
                'TranCategory' => $detail['TranCategory'],
                'Year' => $detail['Year'],
                //'Comp' => '',
                'Comp' => $post['Comp'],
                'PartyID' => $detail['PartyID'],
                'Party' => str_replace('/','',$detail['Party']),
                'tran_type' => 'D',
                'BAHKey' => 0,
                'AHKey' => $detail['dah_key'],
                'CCKey' => 0,
                'BudKey' => 0,
                'Narr' => $detail['Narr'],
                'Ref' => '',
                //'Ref' => $detail['cheque_no'],
                'taxType' => 'N',
                'Pamount' => $detail['Pamount'],
                'Bamount' => $detail['Bamount'],
                'Ctrl_No' => $ctrl_no,
            );

            $data[] = array (
                //'PayDate' => date('Ymd',strtotime($detail['document_date'])),
                'PayDate' => date('Ymd',strtotime($pay_date)),
                'SysKey' => str_replace('/','-',$detail['document_identity']),
                'SysTag' => 'PR',
                'TranCategory' => $detail['TranCategory'],
                'Year' => $detail['Year'],
                //'Comp' => '',
                'Comp' => $post['Comp'],
                'PartyID' => $detail['PartyID'],
                'Party' => str_replace('/','',$detail['Party']),
                //'tran_type' => 'D',
                'tran_type' => 'C',
                'BAHKey' => $detail['cah_key'],
                'AHKey' => $detail['cah_key'],
                'CCKey' => 0,
                'BudKey' => 0,
                'Narr' => $detail['Narr'],
                //'Ref' => '',
                'Ref' => $detail['cheque_no'],
                'taxType' => 'N',
                'Pamount' => $detail['Pamount'],
                'Bamount' => $detail['Bamount'],
                'Ctrl_No' => $ctrl_no,
            );
        }

        $json = [
            'success' => true,
            'budgets' => $budgets,
            'accounts' => $data
        ];

        echo json_encode($json, true);
        exit;

    }

    private function postData($data) {
        $this->model['loan'] = $this->load->model('payroll/loan');
        try {
            $file_name = DIR_ROOT ."QHPosting_".date('Ymd').".txt";
            $file = fopen($file_name,"a+");
            fwrite($file,'Request:'.date('YmdHis')."\n");
            fwrite($file,json_encode(array('ledgers'=>$data['account_details'], 'budgets'=>$data['budgets'])));
            fclose($file);

            $client = new SoapClient(ACC_SERV_URL);
            $response = $client->Payroll(array('Payrolldata' => json_encode($data['account_details']), 'Payrollbuddata' => json_encode($data['budgets'])));
            //d($response, true);
            $file = fopen($file_name,"a+");
            fwrite($file,'Response:'.date('YmdHis'));
            fwrite($file,json_encode($response)."\n");
            fclose($file);
            if($response->PayrollResult->string[0]=='Success') {
                $data = array(
                    'is_post' => 1,
                    'post_at' => date('Y-m-d H:i:s'),
                    'post_by_id' => $this->session->data['user_id'],
                    'bno' => $response->PayrollResult->string[1]
                );
                $this->model['loan']->edit($this->getAlias(),$this->request->get[$this->getPrimaryKey()],$data);
                $this->session->data['success'] = 'Data Posted Successfully on BNO: '. $response->PayrollResult->string[1];
            } else {
                $this->session->data['error_warning'] = $response->PayrollResult->string[1];
            }
        } catch (Exception $e) {
            d($e, true);
            $this->session->data['error_warning'] = $e->getMessage();
        }
    }

    public function printCovering() {
        $loan_id = $this->request->get['loan_id'];
        $lang = $this->load->language('payroll/special_allowance');

        $this->model['loan'] = $this->load->model('payroll/loan');
        $this->model['loan_detail'] = $this->load->model('payroll/loan_installment');

        $voucher = $this->model['loan']->getRow(array('loan_id' => $loan_id));
        $details = $this->model['loan_detail']->getRows(array('loan_id' => $loan_id),array('installment_date'));
        //d(array($voucher, $details), true);

//        $footer = '<table width="100%" style="border-top: 1px solid #000000; vertical-align: bottom; font-family: serif; font-size: 9pt; color: #000088;" class="no-border">';
//        $footer .= '<tr>';
//        $footer .= '<td width="33%" style="text-align: left;">&nbsp;</td>';
//        $footer .= '<td width="33%" style="text-align: center;"><span style="font-size:10pt;">{PAGENO}</span></td>';
//        $footer .= '<td width="33%" style="text-align: right;"><span style="font-size:10pt;">'.date('d-m-Y H:i').'</span></td>';
//        $footer .= '</tr>';
//        $footer .= '</table>';

        $body = '';
        $body .= '<style>';
        $body .= 'body { font-family: "Ariel"; font-size: 11pt;  }';
        $body .= 'table {font-size: 8pt; line-height: 1.2; margin-top: 2pt; margin-bottom: 5pt; border-collapse: collapse; }';
        $body .= 'thead {font-weight: bold; vertical-align: bottom; }';
        $body .= 'tbody td {font-size: 9px; font-weight: normal; vertical-align: center; }';
        $body .= 'tfoot {font-weight: bold; vertical-align: top; }';
        $body .= 'thead td { font-weight: bold; }';
        $body .= 'tfoot td { font-weight: bold; }';
        $body .= 'thead td, thead th { background-gradient: linear #b7cebd #f5f8f5 0 1 0 0.2;  }';
        //$body .= 'tfoot td, tfoot th { background-gradient: linear #b7cebd #f5f8f5 0 1 0 0.2;  }';
        $body .= 'th {font-weight: bold; vertical-align: top; adding-left: 2mm; padding-right: 2mm; padding-top: 0.5mm; padding-bottom: 0.5mm;}';
        $body .= 'td {padding-left: 2mm; vertical-align: top; padding-right: 2mm; padding-top: 0.5mm; padding-bottom: 0.5mm;}';
        //$body .= '.no-border > td, .no-border > th {border: 0;}';
        $body .= '.with-border > tr > td, .with-border > tr > th {border: 1px solid #dddddd;}';
        $body .= '</style>';

        $body .= '<table style="width: 100%" cellpadding="3">' . PHP_EOL;
        $body .= '<tbody>' . PHP_EOL;
        $body .= '<tr>' . PHP_EOL;
        $body .= '  <td style="width: 50%;">' . PHP_EOL;
        $body .= '      <table style="width; 100%;" cellpadding="3" class="with-border">' . PHP_EOL;
        $body .= '          <tr>' . PHP_EOL;
        $body .= '              <th style="width: 35%;">Date:</th>' . PHP_EOL;
        $body .= '              <td style="width: 65%;">'.stdDate($voucher['date']).'</td>' . PHP_EOL;
        $body .= '          </tr>' . PHP_EOL;
        $body .= '          <tr>' . PHP_EOL;
        $body .= '              <th>Employee:</th>' . PHP_EOL;
        $body .= '              <td>'.$voucher['employee_name'].' ['.$voucher['registration_code'].'/'.$voucher['employee_code'].']'.'</td>' . PHP_EOL;
        $body .= '          </tr>' . PHP_EOL;
        $body .= '          <tr>' . PHP_EOL;
        $body .= '              <th>Bank Account:</th>' . PHP_EOL;
        $body .= '              <td>'.$voucher['account_title'].' ['.$voucher['bank_name'].' - '.$voucher['account_no'].']'.'</td>' . PHP_EOL;
        $body .= '          </tr>' . PHP_EOL;
        $body .= '          <tr>' . PHP_EOL;
        $body .= '              <th>Cheque Date:</th>' . PHP_EOL;
        $body .= '              <td>'.stdDate($voucher['cheque_date']).'</td>' . PHP_EOL;
        $body .= '          </tr>' . PHP_EOL;
        $body .= '          <tr>' . PHP_EOL;
        $body .= '              <th>Cheque No:</th>' . PHP_EOL;
        $body .= '              <td>'.$voucher['cheque_no'].'</td>' . PHP_EOL;
        $body .= '          </tr>' . PHP_EOL;
        $body .= '          <tr>' . PHP_EOL;
        $body .= '              <th>Total Installment:</th>' . PHP_EOL;
        $body .= '              <td>'.$voucher['total_installment'].'</td>' . PHP_EOL;
        $body .= '          </tr>' . PHP_EOL;
        $body .= '          <tr>' . PHP_EOL;
        $body .= '              <th>Total Amount:</th>' . PHP_EOL;
        $body .= '              <td>'.number_format($voucher['total_amount'],2).'</td>' . PHP_EOL;
        $body .= '          </tr>' . PHP_EOL;
        $body .= '          <tr>' . PHP_EOL;
        $body .= '              <th>Description:</th>' . PHP_EOL;
        $body .= '              <td>'.$voucher['description'].'</td>' . PHP_EOL;
        $body .= '          </tr>' . PHP_EOL;
        $body .= '      </table>' . PHP_EOL;
        $body .= '      <table style="width; 100%;" cellpadding="3">' . PHP_EOL;
        $body .= '          <tr>' . PHP_EOL;
        $body .= '          <td>&nbsp;</td>' . PHP_EOL;
        $body .= '          </tr>' . PHP_EOL;
        $body .= '          <tr>' . PHP_EOL;
        $body .= '          <td>&nbsp;</td>' . PHP_EOL;
        $body .= '          </tr>' . PHP_EOL;
        $body .= '          <tr>' . PHP_EOL;
        $body .= '          <td>&nbsp;</td>' . PHP_EOL;
        $body .= '          </tr>' . PHP_EOL;
        $body .= '          <tr>' . PHP_EOL;
        $body .= '          <td style="border-top: 1px solid 0000;" align="center">'.$this->session->data['company_name'].'</td>' . PHP_EOL;
        $body .= '          </tr>' . PHP_EOL;
        $body .= '      </table>' . PHP_EOL;
        $body .= '  </td>' . PHP_EOL;
        $body .= '  <td style="width: 50%;">' . PHP_EOL;
        $body .= '      <table style="width; 100%;" cellpadding="3" class="with-border">' . PHP_EOL;
        $body .= '          <thead>' . PHP_EOL;
        $body .= '              <tr>' . PHP_EOL;
        $body .= '                  <th style="width: 20%;" align="center">Inst. Date:</th>' . PHP_EOL;
        $body .= '                  <th style="width: 20%;" align="center">Inst. Amount:</th>' . PHP_EOL;
        $body .= '                  <th style="width: 20%;" align="center">Adj. Via:</th>' . PHP_EOL;
        $body .= '                  <th style="width: 40%;" align="center">Remarks:</th>' . PHP_EOL;
        $body .= '              </tr>' . PHP_EOL;
        $body .= '          </thead>' . PHP_EOL;
        $body .= '          <tbody>' . PHP_EOL;
        foreach($details as $detail) {
            $body .= '              <tr>' . PHP_EOL;
            $body .= '                  <td>'.stdDate($detail['installment_date']).'</td>' . PHP_EOL;
            $body .= '                  <td align="right">'.number_format($detail['installment_amount'],2).'</td>' . PHP_EOL;
            $body .= '                  <td>'.$detail['adjustment_type'].'</td>' . PHP_EOL;
            $body .= '                  <td>'.$detail['remarks'].'</td>' . PHP_EOL;
            $body .= '              </tr>' . PHP_EOL;
        }
        $body .= '          </tbody>' . PHP_EOL;
        $body .= '      </table>' . PHP_EOL;
        $body .= '  </td>' . PHP_EOL;
        $body .= '</tr>' . PHP_EOL;
        $body .= '</tbody>' . PHP_EOL;
        $body .= '</table>' . PHP_EOL;

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Covering Letter:'.$voucher['document_identity'].'@'.date('YmdHis'));
        $pdf->SetSubject('Covering Letter');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'document_identity' => $voucher['document_identity']
        );
        $pdf->lang = $lang;
        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();

        //$pdf->Cell(0,10,'',1,1);
        //$pdf->Cell(180,10,'',1,1);
        $pdf->writeHTML($body);

        $pdf->Output('Covering Letter:'.$voucher['document_identity'].'@'.date('YmdHis').'.pdf', 'I');
    }
}

class PDF extends TCPDF {
    public $lang;
    public $data;

    //Page header
    public function Header() {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        // Title
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->SetFont('helvetica', 'B', 14);
        $this->Cell(0, 10, 'QH Covering Letter', 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('helvetica', '', 14);
//        $this->Cell(0, 10, $this->data['subtitle'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(60, 10, 'Ref: '.$this->data['document_identity'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>