<?php

class ControllerPayrollManualAllowance extends HController {

    protected function getAlias() {
        return 'payroll/manual_allowance';
    }

    protected function getPrimaryKey() {
        return 'manual_allowance_id';
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $this->load->language('payroll/manual_allowance');

        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        //$this->model['manual_allowance_detail'] = $this->load->model('payroll/manual_allowance_detail');

        $data = array();
        $aColumns = array('action','document_date', 'document_identity', 'document_title','total_allowance','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        //$arrWhere[] = "`approved_status` != 'Pending'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $this->data['lang']['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );

            if($aRow['is_post']==0) {
                $actions[] = array(
                    'text' => $this->data['lang']['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['target'])?'target="'.$action['target'].'"':'').' '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }
            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee_registration']->getArrays('registration_code',array('employee_registration_id', 'registration_code', 'employee_id', 'employee_code', 'employee_name'),array('company_id' => $this->session->data['company_id'], 'status' => 'Active'), array('employee_name'));

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']), array('department_name'));

        $this->model['company_account'] = $this->load->model('setup/company_account');
        $this->data['company_accounts'] = $this->model['company_account']->getRows([],array('account_title','account_no'));

        $this->model['bank'] = $this->load->model('setup/bank');
        $this->data['banks'] = $this->model['bank']->getRows([], array('bank_name'));

        $this->data['document_date'] = stdDate();
        $this->data['document_identity'] = 'Auto';
        $this->data['total_allowance'] = '0';
        if (isset($this->request->get[$this->getPrimaryKey()]) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['isEdit']=1;
            $result = $this->model[$this->getAlias()]->getRow(array($this->getPrimaryKey() => $this->request->get[$this->getPrimaryKey()]));
            // d($result);
            foreach($result as $field => $value) {
                if($field=='document_date') {
                    $this->data[$field] = stdDate($value);
                } elseif($field=='department_id') {
                    $this->data[$field] = explode(",", $value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->model['manual_allowance_detail'] = $this->load->model('payroll/manual_allowance_detail');
            $this->data['manual_allowance_details'] = $this->model['manual_allowance_detail']->getRows(array($this->getPrimaryKey() => $this->request->get[$this->getPrimaryKey()]),array('sort_order'));
        }

        $this->data['strValidation']="{
            'rules':{
		        'document_date': {'required':true},
		        'document_title': {'required':true},
		        'company_account_id': {'required':true},
		        'total_allowance': {'required':true,'min':1},
            },
        }";

        $this->data['href_get_employee_data'] = $this->url->link($this->getAlias() . '/getEmployeeData', 'token=' . $this->session->data['token'] . '&manual_allowance_id=' . $this->request->get['manual_allowance_id']);
        $this->response->setOutput($this->render());
    }

    public function getEmployeeData() {
        $post = $this->request->post;
        $document_date = MySqlDate($post['document_date']);
        $registration_code = $post['registration_code'];
        $department_id = $post['department_id'];
        $bank_id = $post['bank_id'];
        $manual_allowance_id = $this->request->get['manual_allowance_id'];

        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['manual_allowance_detail'] = $this->load->model('payroll/manual_allowance_detail');

        $arrWhere = [];
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        $arrWhere[] = "`document_date` = '".$document_date."'";
        $arrWhere[] = "`manual_allowance_id` != '".$manual_allowance_id."'";
        $where = implode(" AND ", $arrWhere);
        $arrEmployeeRegistrationIDs = $this->model['manual_allowance_detail']->getArrays('employee_registration_id','employee_registration_id',$where);
        //d([$arrWhere, $arrEmployeeRegistrationIDs], true);
        $arrWhere = [];
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`status` = 'Active'";
        if($arrEmployeeRegistrationIDs) {
            $arrWhere[] = "`employee_registration_id` NOT IN ('".implode("','", $arrEmployeeRegistrationIDs)."')";
        }
        if($bank_id != '') {
            $arrWhere[] = "`bank_id` = '$bank_id'";
        }
        if($department_id != '') {
            $arrWhere[] = "`department_id` IN (".implode(',', $department_id).")";
        } else {
            $arrWhere[] = "`registration_code` = '".$registration_code."'";
        }

        $where = implode(" AND ", $arrWhere);
        $rows = $this->model['employee_registration']->getRows($where,['employee_name']);
        $html = '';
        $sr = 0;
        foreach($rows as $index => $row) {
            $sr++;
            $html .= '<tr data-index="'.$index.'">';
            $html .= '<td>';
            $html .= '<input type="checkbox" class="check_box" id="detail_'.$index.'_selected" name="details['.$index.'][selected]" value="1" />';
            $html .= '<input type="hidden" id="detail_'.$index.'_employee_registration_id" name="details['.$index.'][employee_registration_id]" value="'.$row['employee_registration_id'].'" readonly/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control" id="detail_'.$index.'_sr" name="details['.$index.'][sr]" value="'.$sr.'" readonly style="min-width: 75px; width: 75px;"/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control" id="detail_'.$index.'_registration_code" name="details['.$index.'][registration_code]" value="'.$row['registration_code'].'" readonly/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control" id="detail_'.$index.'_employee_name" name="details['.$index.'][employee_name]" value="'.$row['employee_name'].'" readonly/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" class="form-control" id="detail_'.$index.'_bank_id" name="details['.$index.'][bank_id]" value="'.$row['bank_id'].'" readonly/>';
            $html .= '<input type="text" class="form-control" id="detail_'.$index.'_bank_name" name="details['.$index.'][bank_name]" value="'.$row['bank_name'].'" readonly/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control" id="detail_'.$index.'_account_no" name="details['.$index.'][account_no]" value="'.$row['bank_account'].'" readonly/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control" id="detail_'.$index.'_account_title" name="details['.$index.'][account_title]" value="'.$row['bank_title'].'" readonly/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control fPDecimal text-right" id="detail_'.$index.'_allowance_amount" name="details['.$index.'][allowance_amount]" value="0" required readonly/>';
            $html .= '</td>';
            $html .= '</tr>';
        }

        $json = [
            'success' => true,
            'html' => $html
        ];

        echo json_encode($json);
    }

    protected function insertData($data) {
        $this->model['manual_allowance'] = $this->load->model('payroll/manual_allowance');
        $this->model['manual_allowance_detail'] = $this->load->model('payroll/manual_allowance_detail');

        $details = $data['details'];
        unset($data['details']);
        $arrDetails = [];
        foreach($details as $detail) {
            if($detail['selected']) {
                $arrDetails[] = $detail;
            }
        }


        if($arrDetails) {
            $data['document_no'] = $this->model['manual_allowance']->getNextNumber();
            $data['document_identity'] = str_pad($data['document_no'],4,"0",STR_PAD_LEFT);
            $data['document_date'] = MySqlDate($data['document_date']);
            $data['company_id'] = $this->session->data['company_id'];
            $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $data['department_id'] = implode(",", $data['department_id']);
            $manual_allowance_id = $this->model['manual_allowance']->add($this->getAlias(), $data);

            foreach($arrDetails as $detail) {
                $detail['manual_allowance_id'] = $manual_allowance_id;

                $manual_allowance_detail_id = $this->model['manual_allowance_detail']->add($this->getAlias(), $detail);
            }

            return $manual_allowance_id;
        } else {
            $this->session->data['error_warning'] = 'Error: Record not saved. Select atleast one record';
            return '';
        }
    }

    protected function updateData($primary_key, $data) {
        $this->model['manual_allowance'] = $this->load->model('payroll/manual_allowance');
        $this->model['manual_allowance_detail'] = $this->load->model('payroll/manual_allowance_detail');

        $details = $data['details'];
        unset($data['details']);
        $arrDetails = [];
        foreach($details as $detail) {
            if($detail['selected']) {
                $arrDetails[] = $detail;
            }
        }


        if($arrDetails) {
            $this->model['manual_allowance_detail']->deleteBulk($this->getAlias(), array('manual_allowance_id' => $primary_key));

            $data['document_date'] = MySqlDate($data['document_date']);
            $data['department_id'] = implode(",", $data['department_id']);

            $manual_allowance_id = $this->model['manual_allowance']->edit($this->getAlias(), $primary_key, $data);
            foreach($arrDetails as $detail) {
                $detail['manual_allowance_id'] = $manual_allowance_id;

                $manual_allowance_detail_id = $this->model['manual_allowance_detail']->add($this->getAlias(), $detail);
            }

            return $manual_allowance_id;
        } else {
            $this->session->data['error_warning'] = 'Error: Record not saved. Select atleast one record';
            return '';
        }
    }

    protected function deleteData($primary_key) {
        $this->model['manual_allowance_detail'] = $this->load->model('payroll/manual_allowance_detail');
        $this->model['manual_allowance_detail']->deleteBulk($this->getAlias(), array('manual_allowance_id' => $primary_key));

        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);
    }

}

?>