<?php

class ControllerPayrollManualPayroll extends HController {

    protected function getAlias() {
        return 'payroll/manual_payroll';
    }

    protected function getPrimaryKey() {
        return 'payroll_id';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    public function index()
    {
        $this->redirect($this->url->link($this->getAlias() . '/insert', 'token=' . $this->session->data['token'], 'SSL'));
    }

    protected function getForm() {
        parent::getForm();
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee_registration']->getArrays('registration_code',array('employee_registration_id', 'registration_code', 'employee_id', 'employee_code', 'employee_name'),array('company_id' => $this->session->data['company_id'], 'status' => 'Active'), array('employee_name'));

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']), array('department_name'));

        $this->data['strValidation']="{
            'rules':{
		        'from_date': {'required':true},
		        'to_date': {'required':true},
		        'working_days': {'required':true},
		        'document_date': {'required':true},
		        'document_title': {'required':true},
            },
        }";

        $this->data['href_get_payroll'] = $this->url->link($this->getAlias() . '/getPayroll', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['href_get_tax_amount'] = $this->url->link($this->getAlias() . '/getTaxAmount', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->response->setOutput($this->render());
    }

    public function getPayroll() {
        ini_set('max_execution_time',0);
        ini_set('memory_limit','5120M');

        $post = $this->request->post;
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
        $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance');
        $this->model['employee_deduction'] = $this->load->model('employee/employee_deduction');
        $this->model['payroll'] = $this->load->model('payroll/payroll');

        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`status` = 'Active'";
        if(!empty($post['department_id']))
        {
            $arrWhere[] = "`department_id` IN ('".implode("','", $post['department_id'])."')";
        }
        if($post['registration_code'] != '')
        {
            $arrWhere[] = "`registration_code` ='".$post['registration_code']."'";
        }
        if(isset($post['exclude_payroll'])) {
            $post['exclude_payroll'] = 1;
        } else {
            $post['exclude_payroll'] = 0;
        }

        $where = implode(' AND ', $arrWhere);
        $employees = $this->model['employee_registration']->getRows($where); //Get All Active Employee against Filter
        //d(array($arrWhere, $employees), true);
        $payrolls = array();
        foreach($employees as $employee) {
            $filter = array (
                'document_date' => MySqlDate($post['document_date']),
                'employee_registration_id' => $employee['employee_registration_id']
            );
            $payroll = $this->model['payroll']->getRow($filter);
            if(empty($payroll)) { //Check if Payroll is not already created
                $arrWhere = array();
                $arrWhere[] = "`employee_registration_id`='".$employee['employee_registration_id']."'";
                $arrWhere[] = "`wef_date` <='".MySqlDate($post['to_date'])."'";
                $salary = $this->model['employee_salary']->getRow(implode(' AND ', $arrWhere), array('wef_date desc, created_at desc'));
                if($salary) {
                    $payrolls[$employee['employee_registration_id']] = array(
                        'employee_registration_id' => $employee['employee_registration_id'],
                        'registration_code' => $employee['registration_code'],
                        'employee_id' => $employee['employee_id'],
                        'employee_code' => $employee['employee_code'],
                        'employee_name' => $employee['employee_name'],
                        'department_id' => $employee['department_id'],
                        'dob' => $employee['dob'],
                        'gender' => $employee['gender'],
                        'eobi_no' => $employee['eobi_no'],
                        'department' => $employee['department_name'],
                        'designation' => $employee['designation_name'],
                        'basic_salary' => $salary['basic_salary'],
                        'house_rent_percent' => 0,
                        'house_rent_allowance' => 0,
                        'grossable_allowance' => 0,
                        'taxable_allowance' => 0,
                        'other_allowance' => 0,
                        'arrears' => 0,
                        'gross_salary' => $salary['basic_salary'],
                        'taxable_salary' => $salary['basic_salary'],
                        'other_deduction' => 0,
                        'tax_deduction' => 0, //This needs to be updated after Tax Calculation
                        'manual_addition' => 0,
                        'overtime' => 0,
                        'net_salary' => $salary['basic_salary'],
                        'payable_salary' => $salary['basic_salary'], //This needs to be updated after Tax Calculation
                        'bank_id' =>$employee['bank_id'],
                        'bank_account_no' =>$employee['bank_account'],
                        'bank_account_title' =>$employee['bank_title'],
                        'bank_account_iban' =>$employee['bank_iban'],
                        'tax_description' => [],
                    );

                    if($salary['taxable']=='Yes') { //Check if Salary is Taxable than calculateTaxAmount
                        $d1 = new DateTime($post['document_date']);
                        $d2 = new DateTime($employee['dob']);
                        $diff = $d2->diff($d1);
                        $age = $diff->y;
                        $gender = $employee['gender'];

                        $filter = array(
                            'parent_company_id' => $this->session->data['parent_company_id'],
                            'company_id' => $this->session->data['company_id'],
                            'employee_registration_id' => $employee['employee_registration_id'],
                            'employee_id' => $employee['employee_id'],
                            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
                            'document_date' => MySqlDate($post['document_date']),
                            'from_date' => MySqlDate($post['from_date']),
                            'to_date' => MySqlDate($post['to_date']),
                            'taxable_salary' => $salary['basic_salary'],
                            'age' => $age,
                            'gender' => $gender,
                            'exclude_payroll' => $post['exclude_payroll'],
                        );
                        //$tax_info = $this->calculateTaxAmount($filter);
                        $tax_info = $this->model['payroll']->getTaxDetail($filter);
                        $payable_salary = $salary['basic_salary'] - $tax_info['remaining_tax'];
                        $payrolls[$employee['employee_registration_id']]['tax_deduction'] = $tax_info['remaining_tax'];
                        $payrolls[$employee['employee_registration_id']]['payable_salary'] = $payable_salary;
                        $payrolls[$employee['employee_registration_id']]['tax_description'] = $tax_info['tax_description'];
                    }
                    //d([$salary, $payrolls[$employee['employee_registration_id']]]);
                }
            }
        }
        //d("ME HERE", true);
        $this->session->data['payrolls'] = $payrolls;

        $html = '';
        $total_basic_salary = 0;
        $total_payable_salary = 0;
        $total_tax_deduction = 0;
        $id= 0;
        foreach($payrolls as $registration_id => $payroll) {
            $html .= '<tr data-id="'.$id.'" data-registration_id="'.$registration_id.'">';
            $html .= '<td class="text-center">';
            $html .= '<input type="checkbox" id="payroll_'.$id.'_selected" name="payrolls['.$id.'][selected]" value="1" checked />';
            $html .= '</td>';
            $html .= '<td class="text-center">'.($id+1).'</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" class="form-control" id="payroll_'.$id.'_department_id" name="payrolls['.$id.'][department_id]" value="'.$payroll['department_id'].'" />';
            $html .= '<input type="hidden" class="form-control" id="payroll_'.$id.'_department" name="payrolls['.$id.'][department]" value="'.$payroll['department'].'" />';
            $html .= '<input type="hidden" class="form-control" id="payroll_'.$id.'_eobi_no" name="payrolls['.$id.'][eobi_no]" value="'.$payroll['eobi_no'].'" />';
            $html .= '<input type="hidden" class="form-control" id="payroll_'.$id.'_designation" name="payrolls['.$id.'][designation]" value="'.$payroll['designation'].'" />';
            $html .= '<input type="text" class="form-control text-left" id="payroll_'.$id.'_employee_code" name="payrolls['.$id.'][employee_code]" value="'.$payroll['employee_code'].'" readonly/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" class="form-control" id="payroll_'.$id.'_employee_registration_id" name="payrolls['.$id.'][employee_registration_id]" value="'.$payroll['employee_registration_id'].'" />';
            $html .= '<input type="text" class="form-control text-left" id="payroll_'.$id.'_registration_code" name="payrolls['.$id.'][registration_code]" value="'.$payroll['registration_code'].'" readonly/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" class="form-control" id="payroll_'.$id.'_employee_id" name="payrolls['.$id.'][employee_id]" value="'.$payroll['employee_id'].'" />';
            $html .= '<input type="text" class="form-control text-center" style="min-width: 200px;" id="payroll_'.$id.'_employee_name" name="payrolls['.$id.'][employee_name]" value="'.$payroll['employee_name'].'" readonly/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input onchange="calculatePayable('.$id.');" type="text" class="form-control text-right fPDecimal" id="payroll_'.$id.'_basic_salary" name="payrolls['.$id.'][basic_salary]" value="'.$payroll['basic_salary'].'" />';

            $html .= '<input type="hidden" id="payroll_'.$id.'_gross_salary" name="payrolls['.$id.'][gross_salary]" value="'.$payroll['basic_salary'].'" />';
            $html .= '<input type="hidden" id="payroll_'.$id.'_taxable_salary" name="payrolls['.$id.'][taxable_salary]" value="'.$payroll['basic_salary'].'" />';
            $html .= '<input type="hidden" id="payroll_'.$id.'_net_salary" name="payrolls['.$id.'][net_salary]" value="'.$payroll['basic_salary'].'" />';

            $html .= '</td>';
            $html .= '<td>';
            $html .= '<div class="input-group input-group-sm">';
            $html .= '<input onchange="updatePayable('.$id.');" type="text" class="form-control text-right fPDecimal" id="payroll_'.$id.'_tax_deduction" name="payrolls['.$id.'][tax_deduction]" value="'.$payroll['tax_deduction'].'" />';
            $html .= '<div class="input-group-btn">';
            $html .= '<button onclick="getTaxDescription(this);" class="btn btn-info btn-flat" type="button"><i class="fa fa-calculator"></i></button>';
            $html .= '</div>';
            $html .= '</div>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control text-right" id="payroll_'.$id.'_payable_salary" name="payrolls['.$id.'][payable_salary]" value="'.$payroll['payable_salary'].'" readonly/>';
            $html .= '<input type="hidden" class="form-control text-right" id="payroll_'.$id.'_bank_id" name="payrolls['.$id.'][bank_id]" value="'.$payroll['bank_id'].'" readonly/>';
            $html .= '<input type="hidden" class="form-control text-right" id="payroll_'.$id.'_bank_account_no" name="payrolls['.$id.'][bank_account_no]" value="'.$payroll['bank_account_no'].'" readonly/>';
            $html .= '<input type="hidden" class="form-control text-right" id="payroll_'.$id.'_bank_account_title" name="payrolls['.$id.'][bank_account_title]" value="'.$payroll['bank_account_title'].'" readonly/>';
            $html .= '<input type="hidden" class="form-control text-right" id="payroll_'.$id.'_bank_iban" name="payrolls['.$id.'][bank_iban]" value="'.$payroll['bank_iban'].'" readonly/>';
            $html .= '</td>';
            $html .= '</tr>';

            $id++;
            $total_basic_salary += $payroll['basic_salary'];
            $total_tax_deduction += $payroll['tax_deduction'];
            $total_payable_salary += $payroll['payable_salary'];
        }
        $html .= '<tr>';
        $html .= '<td colspan="3" class="text-right">Total:</td>';
        $html .= '<td class="text-right">&nbsp;</td>';
        $html .= '<td class="text-right">&nbsp;</td>';
        $html .= '<td class="text-right"><span id="total_basic_salary">'.$total_basic_salary.'</span></td>';
        $html .= '<td class="text-right"><span id="total_tax_deduction">'.$total_tax_deduction.'</span></td>';
        $html .= '<td class="text-right"><span id="total_payable_salary">'.$total_payable_salary.'</span></td>';
        $html .= '</tr>';
        //d(array($payrolls, $html), true);
        $json = array(
            'success' => true,
            'post' => $post,
            'payrolls' => $payrolls,
            'html' => $html
        );

        echo json_encode($json);
        exit;
    }

    public function getTaxAmount() {
        $post = $this->request->post;
        $document_date = MySqlDate($post['document_date']);
        $from_date = MySqlDate($post['from_date']);
        $to_date = MySqlDate($post['to_date']);
        $employee_registration_id = $post['employee_registration_id'];
        $taxable_salary = $post['basic_salary'];

        $payrolls = $this->session->data['payrolls'];
        $employee = $payrolls[$employee_registration_id];
        $d1 = new DateTime($document_date);
        $d2 = new DateTime($employee['dob']);
        $diff = $d2->diff($d1);
        $age = $diff->y;
        $gender = $employee['gender'];

        $filter = array(
            'parent_company_id' => $this->session->data['parent_company_id'],
            'company_id' => $this->session->data['company_id'],
            'employee_registration_id' => $employee_registration_id,
            'employee_id' => $employee['employee_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'document_date' => $document_date,
            'from_date' => $from_date,
            'to_date' => $to_date,
            'taxable_salary' => $taxable_salary,
            'age' => $age,
            'gender' => $gender,
            'exclude_payroll' => ($post['exclude_payroll']?1:0),
        );

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $tax_info = $this->model['payroll']->getTaxDetail($filter);
        $payable_salary = $post['basic_salary'] - $tax_info['remaining_tax'];
        $payrolls[$employee_registration_id]['basic_salary'] = $post['basic_salary'];
        $payrolls[$employee_registration_id]['gross_salary'] = $post['basic_salary'];
        $payrolls[$employee_registration_id]['taxable_salary'] = $post['basic_salary'];
        $payrolls[$employee_registration_id]['tax_deduction'] = $tax_info['remaining_tax'];
        $payrolls[$employee_registration_id]['payable_salary'] = $payable_salary;
        $payrolls[$employee_registration_id]['tax_description'] = $tax_info['tax_description'];

        //d([$tax_info, $payrolls], true);
        $this->session->data['payrolls'] = $payrolls;
        $json = array(
            'success' => true,
            'payrolls' => $payrolls,
            'row_id' => $post['row_id'],
            'basic_salary' => $post['basic_salary'],
            'remaining_tax_amount' => $tax_info['remaining_tax'],
        );
        echo json_encode($json);
    }

    protected function insertData($data) {
        ini_set('max_execution_time',0);
        ini_set('memory_limit','5120M');

        $document_date = MySqlDate($data['document_date']);
        $from_date = MySqlDate($data['from_date']);
        $to_date = MySqlDate($data['to_date']);
        $date_diff = strtotime($to_date.' 23:59:59')-strtotime($from_date.' 00:00:00');
        $working_day = round($date_diff / (60 * 60 * 24));
        $total_present = $working_day;


        if(isset($data['exclude_payroll'])) {
            $data['exclude_payroll']=1;
        } else {
            $data['exclude_payroll']=0;
        }
        foreach($data['payrolls'] as $payroll) {
            if($payroll['selected']==1) {
                $insert_data = array(
                    'company_id' => $this->session->data['company_id'],
                    'fiscal_year_id' => $this->session->data['fiscal_year_id'],
                    'document_date' => $document_date,
                    'document_title' => $data['document_title'],
                    'from_date' => $from_date,
                    'to_date' => $to_date,
                    'working_days' => $total_present,
                    'department' => $payroll['department'],
                    'designation' => $payroll['designation'],
                    'eobi_no' => $payroll['eobi_no'],
                    'department_id' => $payroll['department_id'],
                    'employee_registration_id' => $payroll['employee_registration_id'],
                    'employee_id' => $payroll['employee_id'],
                    'exclude_payroll' => $data['exclude_payroll'],
                    'house_rent_percent' => 0,
                    'house_rent_allowance' => 0,
                    'basic_salary' => $payroll['basic_salary'],
                    'grossable_allowance' => 0,
                    'taxable_allowance' => 0,
                    'other_allowance' => 0,
                    'arrears' => 0,
                    'gross_salary' => $payroll['gross_salary'],
                    'taxable_salary' => $payroll['taxable_salary'],
                    'other_deduction' => 0,
                    'tax_deduction' => $payroll['tax_deduction'],
                    'manual_addition' => 0,
                    'manual_deduction' => 0,
                    'overtime' => 0,
                    'net_salary' => $payroll['net_salary'],
                    'total_present' => $total_present,
                    'total_absent' => 0,
                    'attendance_deduction' => 0,
                    'payable_salary' => $payroll['payable_salary'],
                    'bank_id' => $payroll['bank_id'],
                    'bank_account_no' => $payroll['bank_account_no'],
                    'bank_account_title' => $payroll['bank_account_title'],
                    'bank_iban' => $payroll['bank_iban'],
                );

                $payroll_id = $this->model[$this->getAlias()]->add($this->getAlias(), $insert_data);
            }
        }
    }
}

?>