<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

//require DIR_SYSTEM . 'library/PHPMailer/Exception.php';
//require DIR_SYSTEM . 'library/PHPMailer/PHPMailer.php';
//require DIR_SYSTEM . 'library/PHPMailer/SMTP.php';

class ControllerPayrollPaymentLetter extends HController
{
    
    protected function getAlias()
    {
        return 'payroll/payment_letter';
    }

    protected function getPrimaryKey()
    {
        return 'payment_letter_id';
    }

    protected function validateDocument()
    {
        return false;
    }

    protected function getList()
    {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists()
    {

        $lang = $this->load->language('payroll/payment_letter');
        $this->model[$this->getAlias()] = $this->load->model('payroll/payment_letter');
        $data = array();
        $aColumns = array('action', 'document_date', 'document_identity','employee_name','payment_for','reason_for','nominee_name','created_at');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow['payment_letter_id'], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $lang['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printLetter', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow['payment_letter_id'], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-print'
            );

            $actions[] = array(
                'text' => $lang['delete'],
                'href' => 'javascript:void(0);',
                'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow['payment_letter_id'], 'SSL') . "')",
                'btn_class' => 'btn btn-danger btn-xs',
                'class' => 'fa fa-times'
            );

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a ' . (isset($action['btn_class']) ? 'class="' . $action['btn_class'] . '"' : '') . ' ' . (isset($action['target']) ? 'target="' . $action['target'] . '"' : '') . ' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm()
    {
        $session = $this->session->data;
        parent::getForm();

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $employees = $this->model['employee']->getDistinctRows(['employee_registration_id','company_name','employee_code','registration_code','employee_name','cnic_address'],['status'=> 'Active'],['company_name','employee_name']);
        //d($employees, true);
        foreach($employees as $employee) {
            $this->data['company_employees'][$employee['company_name']][] = $employee;
        }

        $this->data['document_identity'] = 'AUTO';
        $this->data['document_date'] = stdDate();
        if (isset($this->request->get['payment_letter_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('payment_letter_id' => $this->request->get['payment_letter_id']));
            foreach ($result as $field => $value) {
                if ($field == 'document_date') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }
        }

        $this->data['href_ref_documents'] = $this->url->link($this->getAlias() . '/getRefDocuments', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_ref_document_data'] = $this->url->link($this->getAlias() . '/getRefDocumentData', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation'] = "{
            'rules':{
		        'document_date': {'required':true},
		        'employee_id': {'required':true},
            },
        }";

        $this->response->setOutput($this->render());
    }

    public function getRefDocuments() {
        $employee_registration_id = $this->request->post['employee_registration_id'];

        $this->model['allowance_type'] = $this->load->model('setup/special_allowance_type');
        $allowance_types = $this->model['allowance_type']->getRows(array(), array('special_allowance_type'));
        $source_types = array(
            'payroll' => 'Payroll',
            'sp_enayat' => 'Special Enayat',
        );
        foreach($allowance_types as $allowance_type) {
            $source_types[$allowance_type['special_allowance_type_id']] = $allowance_type['special_allowance_type'];
        }

        $this->model['payment_letter'] = $this->load->model('payroll/payment_letter');
        $docs = $this->model['payment_letter']->getRefDocuments($employee_registration_id);
        $documents = [];
        foreach($docs as $index => $doc) {
            $documents[($index+1)] = $doc;
            $documents[($index+1)]['payment_for'] = $source_types[$doc['payment_for']];
        }

        $json = [
            'success' => true,
            'documents' => $documents
        ];

        echo json_encode($json);
    }

    protected function insertData($data)
    {
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $record = $this->model[$this->getAlias()]->getNextNumber($data['employee_code']);

        $data['company_id'] = $this->session->data['company_id'];
        $data['document_no'] = $record['document_no'];
        $data['document_identity'] = $record['document_identity'];
        $data['document_date'] = MySqlDate($data['document_date']);

        $payment_letter_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);
        return $payment_letter_id;
    }

    protected function updateData($primary_key, $data)
    {
        $data['document_date'] = MySqlDate($data['document_date']);

        $payment_letter_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);
        return $payment_letter_id;
    }

    public function printLetter()
    {
        $payment_letter_id = $this->request->get['payment_letter_id'];
        $lang = $this->load->language('payroll/payment_letter');
        $session = $this->session->data;

        $this->model['payment_letter'] = $this->load->model('payroll/payment_letter');
        $data = $this->model['payment_letter']->getRow(array('payment_letter_id' => $payment_letter_id));
        //d($data, true);
        if($data['transfer_type']=='Cheque') {
            $content = "Huzurala TUS has graciously granted you Enayat of Rs ".number_format($data['amount'],2)."/= for ". $data['reason_for'].". ";
            $content .= "Accordingly, enclosed herewith a cheque no  ". $data['bank_name']. " on ".stdDate($data['cheque_date']);
        } else {
            $content = "Huzurala TUS has graciously granted you Enayat of Rs ".number_format($data['amount'],2)."/= for ". $data['reason_for'].". ";
            $content .= "Accordingly, this amount is transferred directly in your ". $data['bank_name']. " on ".stdDate($data['cheque_date']);
        }
//        $this->model['employee'] = $this->load->model('employee/employee_profile');
//        $employee = $this->model['employee']->getRow(array('employee_id' => $data['employee_id']));

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Payment Letter:' . $data['employee_code'] . '@' . date('YmdHis', strtotime($data['created_at'])));
        $pdf->SetSubject('Payment Letter');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(30, 50, 30);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        $pdf->lang = $lang;
        $pdf->data['document_identity'] = $data['document_identity'];
        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();
        $pdf->SetFont('helvetica', '', 12);
        $pdf->Cell(50, 5, $data['document_identity'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(50, 5, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Cell(50, 5, 'Date: '.stdDate($data['document_date']), 0, false, 'R', 0, '', 0, false, 'T', 'M');
        $pdf->ln(15);
        $pdf->Cell(50, 5, $data['employee_name'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(6);
        $arrAddress = splitString($data['employee_address'], 30);
        foreach($arrAddress as $address) {
            $pdf->Cell(50, 5, $address, 0, false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->ln(6);
        }
        $pdf->ln(10);
        $pdf->Cell(50, 5, 'Al-Akhun Najib', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(15);

        $arrContents = splitString($content, 80);
        foreach($arrContents as $content) {
            $pdf->Cell(50, 5, $content, 0, false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->ln(6);
        }
        $pdf->ln(10);
        $pdf->Cell(50, 5, 'Thank you.', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(10);
        $pdf->Cell(50, 5, 'For Dawat-e-Hadiyah', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $pdf->ln(30);
        $pdf->Cell(40, 5, '('.$data['nominee_name'].')', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->ln(5);
        $pdf->Cell(40, 5, 'Nominee', 'T', false, 'C', 0, '', 0, false, 'T', 'M');
        $pdf->Output('Payment Letter:' . $data['document_identity'] . '@' . date('YmdHis', strtotime($data['created_at'])) . '.pdf', 'I');
    }
}

class PDF extends TCPDF
{
    public $lang;
    public $data;

    //Page header
    public function Header(){

    }

    // Page footer
    public function Footer()
    {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(50, 10, 'Ref: ' . $this->data['document_identity'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(50, 10, 'Page ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(50, 10, 'Date: ' . date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}

?>