<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require DIR_SYSTEM . 'library/PHPMailer/Exception.php';
require DIR_SYSTEM . 'library/PHPMailer/PHPMailer.php';
require DIR_SYSTEM . 'library/PHPMailer/SMTP.php';

class ControllerPayrollPayroll extends HController {

    protected function getAlias() {
        return 'payroll/payroll';
    }

    protected function getPrimaryKey() {
        return 'payroll_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function getList() {
        parent::getList();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']),['department_name']);

        $this->data['href_send_email'] = $this->url->link($this->getAlias() . '/sendEmail', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_get_email'] = $this->url->link($this->getAlias() . '/getEmail', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $this->load->language('payroll/payroll');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'document_date', 'document_title', 'department_name', 'employee_code', 'registration_code', 'employee_name', 'gross_salary', 'tax_deduction', 'payable_salary','exclude_payroll','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "p.`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "p.`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $deposit = $this->model[$this->getAlias()]->getPostedDocument($aRow['payroll_id']);
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            if(empty($deposit)) {
                $actions[] = array(
                    'text' => $this->data['lang']['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            if($aRow['is_email'] !=1) {
                if($aRow['email']=='') {
                    $actions[] = array(
                        'text' => $this->data['lang']['email'],
                        'href' => 'javascript:void(0);',
                        'btn_class' => 'btn btn-warning btn-xs',
                        'class' => 'fa fa-envelope-square'
                    );
                } else {
                    $actions[] = array(
                        'text' => $this->data['lang']['email'],
                        'href' => 'javascript:void(0);',
                        'click' => "sendEmail(this, '" . $aRow[$this->getPrimaryKey()] . "')",
                        'btn_class' => 'btn btn-info btn-xs',
                        'class' => 'fa fa-envelope-square'
                    );
                }
            }


            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'exclude_payroll') {
                    if($aRow['exclude_payroll']) {
                        $row[] = 'Yes';
                    } else {
                        $row[] = 'No';
                    }
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } elseif ($aColumns[$i] == 'check_box') {
                    if($aRow['deposit_slip_id']=='') {
                        $row[] = '<input type="checkbox" name="selected[]" value="' . $aRow[$this->getPrimaryKey()] . '" />';
                    } else {
                        $row[] = '';
                    }
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee_registration']->getRows(array('company_id' => $this->session->data['company_id'], 'status' => 'Active'), array('employee_name'));

        $this->data['date'] = stdDate();
        $this->data['is_edit'] = 0;
        if (isset($this->request->get['payroll_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['is_edit'] = 1;
            $result = $this->model[$this->getAlias()]->getRow(array('payroll_id' => $this->request->get['payroll_id']));
            foreach($result as $field => $value) {
                if(($field=='document_date' || $field=='from_date' || $field=='to_date') && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->model['payroll_allowance'] = $this->load->model('payroll/payroll_allowance');
            $this->model['payroll_deduction'] = $this->load->model('payroll/payroll_deduction');

            $this->data['allowances'] = $this->model['payroll_allowance']->getRows(array('payroll_id' => $result['payroll_id']));
            $this->data['deductions'] = $this->model['payroll_deduction']->getRows(array('payroll_id' => $result['payroll_id']));

            $this->model['employee'] = $this->load->model('employee/employee_registration');
            $employee = $this->model['employee']->getRow(array('employee_registration_id' => $result['employee_registration_id']));

            $arrWhere = array();
            $arrWhere[] = "`employee_registration_id`='" . $result['employee_registration_id'] . "'";
            $arrWhere[] = "`wef_date` <='".$result['document_date']."'";
            $where = implode(' AND ', $arrWhere);
            $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
            $salary = $this->model['employee_salary']->getRow($where, array('wef_date desc, created_at desc'));

            $filter = array(
                'from_date' => $result['from_date'],
                'to_date' => $result['to_date'],
                'company_id' => $result['company_id'],
                'department_id' => $result['department_id'],
                'employee_registration_id' => $result['employee_registration_id'],
                'basic_salary' => $result['basic_salary'],
                'attendance_shift_id' => $employee['attendance_shift_id'],
                'attendance_exempted' => $employee['attendance_exempted'],
                'total_absent' => $result['total_absent'],
            );
            $attendance = $this->getAttendance($filter);
            $this->data['daily_deduction'] = $attendance['daily_deduction'];
            $this->data['taxable'] = $salary['taxable'];
        }

        $this->data['strValidation']="{
            'rules':{
		        'employee_registration_id': {'required':true},
		        'document_date': {'required':true},
		        'document_title': {'required':true},
		        'working_days': {'required':true},
            },
        }";

        $this->data['href_get_installment'] = $this->url->link($this->getAlias() . '/getInstallment', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['href_get_tax_amount'] = $this->url->link('payroll/generate_payroll/getTaxAmount', 'token=' . $this->session->data['token'] . '&employee_id=' . $result['employee_id']);
        $this->response->setOutput($this->render());
    }

    private function getAttendance($data) {
        $company_id = $data['company_id'];
        $department_id = $data['department_id'];
        $employee_registration_id = $data['employee_registration_id'];
        $from_date = $data['from_date'];
        $to_date = $data['to_date'];
        $attendance_shift_id = $data['attendance_shift_id'];
        $attendance_exempted = $data['attendance_exempted'];
        $basic_salary = $data['basic_salary'];

        $this->model['attendance_shift'] = $this->load->model('setup/attendance_shift');
        $this->model['attendance_shift_detail'] = $this->load->model('setup/attendance_shift_detail');
        $this->model['holiday'] = $this->load->model('setup/holiday');
        $this->model['company'] = $this->load->model('setup/company');
        $this->model['department'] = $this->load->model('setup/department');
        $this->model['employee_attendance'] = $this->load->model('employee/employee_attendance');

        $date_diff = strtotime($to_date.' 23:59:59')-strtotime($from_date.' 00:00:00');
        $working_days = round($date_diff / (60 * 60 * 24));

        if($attendance_exempted) {
            $total_absent = 0;
        } else {
            if(isset($data['total_absent']) && $data['total_absent'] !== '') {
                $total_absent = $data['total_absent'];
            } else {
                $shift = $this->model['attendance_shift']->getRow(['attendance_shift_id' => $attendance_shift_id]);
                $shift_status = $this->model['attendance_shift_detail']->getArrays('day',array('day', 'day_status'), array('attendance_shift_id' => $attendance_shift_id));
                //d($shift_status,true);
                $where = " `holiday_date` BETWEEN '". $from_date."' AND '".$to_date."'";
                $where .= " AND company_id=".$this->session->data['company_id'];
                //holidays
                $holidays = $this->model['holiday']->getArrays('holiday_date','holiday_date',$where);
                /*d(array($current_date,$to_date,$holidays),true);*/

                $arrWhere = [];
                $arrWhere[] = "`employee_registration_id` = '$employee_registration_id'";
                $arrWhere[] = "`attendance_date` >= '$from_date' AND `attendance_date` <= '$to_date'";
                $where = implode(" AND ", $arrWhere);
                $arrEmployeeAttendance = $this->model['employee_attendance']->getArrays('attendance_date','status', $where, ['attendance_date']);
                //d($arrEmployeeAttendance, true);
                $current_date = $from_date;
                $total_absent = 0;
                $total_late = 0;
                while($current_date <= $to_date) {
                    if(isset($arrEmployeeAttendance[$current_date])) {
                        if($arrEmployeeAttendance[$current_date]=='A') {
                            $total_absent++;
                        } elseif($arrEmployeeAttendance[$current_date]=='LD') {
                            $total_absent++;
                        } elseif($arrEmployeeAttendance[$current_date]=='LT') {
                            $total_late++;
                        }
                    } else {
                        $day = date('D',strtotime($current_date));
                        if($shift_status[$day]['day_status']=='Working Day') {
                            if(!in_array($current_date, $holidays)) {
                                $total_absent++;
                            }
                        }
                    }

                    $current_date = date('Y-m-d', strtotime($current_date . ' +1 Day'));
                }

                if($shift && $shift['late_deduction'] > 0 && $total_late > 0) {
                    $total_absent += floor($total_late/$shift['late_deduction']);
                }
            }
        }

        $employee = $this->model['employee_registration']->getRecord(array('employee_registration_id' => $employee_registration_id));
        if($employee['override_attendance_policy']) {
            $deduction_days = $employee['deduction_days']===''?0:$employee['deduction_days'];
            $deduction_percent = $employee['deduction_percent']===''?0:$employee['deduction_percent'];
        } else {
            $department = $this->model['department']->getRow(array('department_id' => $department_id));
            if($department['override_attendance_policy']) {
                $deduction_days = $department['deduction_days']===''?0:$department['deduction_days'];
                $deduction_percent = $department['deduction_percent']===''?0:$department['deduction_percent'];
            } else {
                $company_info = $this->model['company']->getRow(array('company_id' => $company_id));
                $deduction_days = $company_info['deduction_days']===''?0:$company_info['deduction_days'];
                $deduction_percent = $company_info['deduction_percent']===''?0:$company_info['deduction_percent'];
            }
        }

        if($deduction_days==0) {
            $daily_deduction=0;
        } else {
            $daily_deduction = round(($basic_salary / $deduction_days)*(1+($deduction_percent/100)));
        }

        $absent_deduction = $daily_deduction * $total_absent;

        return array(
            'working_days' => $working_days,
            'total_absent' => $total_absent,
            'total_present' => $working_days - $total_absent,
            'daily_deduction' => $daily_deduction,
            'absent_deduction' => $absent_deduction,
        );
    }

    public function getEmail() {
        $this->init();
        parent::getForm();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']),['department_name']);

        $this->data['href_get_payroll_data'] = $this->url->link($this->getAlias() . '/getPayrollData', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_send_email'] = $this->url->link($this->getAlias() . '/sendEmail', 'token=' . $this->session->data['token'], 'SSL');
        $this->template = $this->getAlias() . '_email.tpl';
        $this->response->setOutput($this->render());
    }

    public function getPayrollData() {
        $session = $this->session->data;
        $post = $this->request->post;

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $arrWhere = [];
        $arrWhere[] = "`company_id` = '".$session['company_id']."'";
        $arrWhere[] = "`is_email` = 0";
        $arrWhere[] = "`document_date` >= '".MySqlDate($post['date_from'])."'";
        $arrWhere[] = "`document_date` <= '".MySqlDate($post['date_to'])."'";
        if($post['department_id'] != '') {
            $arrWhere[] = "`department_id` = '".$post['department_id']."'";
        }

        $where = implode(' AND ',$arrWhere);
        $rows = $this->model['payroll']->getDistinctRows(['payroll_id','department_name','designation_name','employee_name','email'],$where,['department_name','designation_name','employee_name']);

        $html = '';
        $html = '';
        $html .= '<table class="table table-bordered">';
        $html .= '<thead>';
        $html .= '<tr>';
        $html .= '<td>Sr.</td>';
        $html .= '<td>Department</td>';
        $html .= '<td>Designation</td>';
        $html .= '<td>Emaployy</td>';
        $html .= '<td>Email</td>';
        $html .= '<td>Status</td>';
        $html .= '</tr>';
        $html .= '</thead>';
        $html .= '<tbody>';
        foreach($rows as $id=>$row) {
            $html .= '<tr id="M'.$id.'" data-payroll_id="'.$row['payroll_id'].'" data-email="'.$row['email'].'">';
            $html .= '<td>'.($id+1).'</td>';
            $html .= '<td>'.$row['department_name'].'</td>';
            $html .= '<td>'.$row['designation_name'].'</td>';
            $html .= '<td>'.$row['employee_name'].'</td>';
            $html .= '<td>'.$row['email'].'</td>';
            $html .= '<td class="status">Pending</td>';
            $html .= '</tr>';
        }
        $html .= '</tbody>';
        $html .= '</table>';
        $json = [
            'success' => true,
            'post' => $post,
            'where' => $where,
            'rows' => $rows,
            'html' => $html,
        ];

        echo json_encode($json);
    }

    public function sendEmail() {
        $post = $this->request->post;
        $this->model['core_setting'] = $this->load->model('setup/core_setting');
        $this->model['bank'] = $this->load->model('setup/bank');
        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $this->model['payroll_allowance'] = $this->load->model('payroll/payroll_allowance');
        $this->model['payroll_deduction'] = $this->load->model('payroll/payroll_deduction');
        // d($post);
        $config = $this->model['core_setting']->getArrays('field','value',array('company_id' => $this->session->data['company_id'], 'module'=>'general'));
        $arrBanks = $this->model['bank']->getArrays('bank_id','bank_name',array());

        $payroll = $this->model['payroll']->getRow(['payroll_id' => $post['payroll_id']]);
        $allowances = $this->model['payroll_allowance']->getRows(array('payroll_id' => $payroll['payroll_id']));
        $deductions = $this->model['payroll_deduction']->getRows(array('payroll_id' => $payroll['payroll_id']));
        $html_body = '';
        $html_body .= 'Employee Code: '. $payroll['registration_code'].'<br />';
        $html_body .= 'Employee Name: '. $payroll['employee_name'].'<br />';
        $html_body .= 'Department Name: '. $payroll['department_name'].'<br />';
        $html_body .= 'Email: '. $payroll['email'].'<br />';
        $html_body .= 'Basic Salary: '. number_format($payroll['basic_salary'],2).'<br />';
        $gross_amount = $payroll['basic_salary'];
        if($payroll['house_rent_allowance'] != 0) {
            $html_body .= 'House Rent: '. number_format($payroll['house_rent_allowance'],2).'<br />';
            //$gross_amount += $payroll['house_rent_allowance'];
        }
        foreach($allowances as $allowance) {
            if($allowance['allowance_amount'] != 0 && $allowance['grossable']) {
                $html_body .= $allowance['allowance_name'] . ': '. number_format($allowance['allowance_amount'],2).'<br />';
                $gross_amount += $payroll['allowance_amount'];
            }
        }
        if($payroll['arrears'] != 0) {
            $html_body .= 'Arrears: '. number_format($payroll['arrears'],2).'<br />';
            $gross_amount += $payroll['arrears'];
        }
        if($payroll['manual_addition'] != 0) {
            $html_body .= 'Other Allowance: '. number_format($payroll['manual_addition'],2).'<br />';
            $gross_amount += $payroll['manual_addition'];
        }
        if($payroll['overtime'] != 0) {
            $html_body .= 'Overtime: '. number_format($payroll['overtime'],2).'<br />';
            $gross_amount += $payroll['overtime'];
        }
        $html_body .= '<b>Gross Amount:</b> '. number_format($gross_amount,2).'<br />';
        foreach($deductions as $deduction) {
            if($deduction['deduction_amount'] != 0) {
                $html_body .= $deduction['deduction_name'] . ': '. number_format($deduction['deduction_amount'],2).'<br />';
            }
        }
        if($payroll['manual_deduction'] != 0) {
            $html_body .= 'Other Deduction: '. number_format($payroll['manual_deduction'],2).'<br />';
        }
        if($payroll['attendance_deduction'] != 0) {
            $html_body .= 'Absent Deduction: '. number_format($payroll['attendance_deduction'],2).'<br />';
        }
        if($payroll['tax_deduction'] != 0) {
            $html_body .= 'Tax: '. number_format($payroll['tax_deduction'],2).'<br />';
        }
        $html_body .= '<b>Net Salary: </b>'. number_format($payroll['payable_salary'],2).'<br />';
        $html_body .= 'Credited to A/C No. '. $payroll['bank_account_no'].' in '.$arrBanks[$payroll['bank_id']];

        $log_file = DIR_LOGS . "email_log.".date('Ymd').'.text';
        file_put_contents($log_file, date('Y-m-d H:i:s')." - Sending Email to `".$payroll['email']."`|`".$payroll['employee_name']."`".PHP_EOL,FILE_APPEND);

        //d($config, true);
        try {
            $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
            $mail->SMTPOptions = array(
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                )
            );
            //Server settings
            $mail->SMTPDebug = 0;                                 // Enable verbose debug output
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = $config['config_mail_smtp_hostname'];
            $mail->SMTPAuth = true;
            $mail->Username = $config['config_mail_smtp_username']; //paste one generated by Mailtrap
            $mail->Password = $config['config_mail_smtp_password']; //paste one generated by Mailtrap
            //$mail->SMTPSecure = 'tls';
            $mail->Port = $config['config_mail_smtp_port'];
            $mail->setFrom($config['config_mail_smtp_username'], $post['config_mail_smtp_displayname']);
            $mail->addAddress($payroll['email']);
            $mail->isHTML(true);
            // Set email format to HTML
            $mail->Subject = $payroll['document_title'];
            $mail->Body    = $html_body;
            if(!$mail->Send()) {
                $json = [
                    'success' => false,
                    'error' => $mail->ErrorInfo,
                    'id' => $post['id'],
                    'next_id' => $post['id']+1,
                ];
            } else {
                $this->model['payroll']->edit($this->getAlias(), $payroll['payroll_id'], array('is_email'=>1));
                file_put_contents($log_file, date('Y-m-d H:i:s')." - Email Sent to `".$payroll['email']."`|`".$payroll['employee_name']."`".PHP_EOL,FILE_APPEND);

                $json = [
                    'success' => true,
                    'id' => $post['id'],
                    'next_id' => $post['id']+1,
                ];
            }
        } catch (Exception $e) {
            $json = [
                'success' => false,
                'error' => $e->getCode().'|'.$e->getMessage(),
                'id' => $post['id'],
                'next_id' => $post['id']+1,
            ];
        }


        echo json_encode($json);
    }

    public function getInstallment() {
        $post = $this->request->post;
        $start_date = date('Y-m-01',strtotime(MySqlDate($post['start_date'])));
        $total_amount = $post['total_amount'];
        $total_installment = $post['total_installment'];
        $installment_amount = ceil($total_amount/$total_installment);
        $running_amount=0;

        $html = '';
        for($i=0; $i<$total_installment; $i++) {
            $date = date("Y-m-d", strtotime("+".$i." month", strtotime($start_date)));
            if($i==($total_installment-1)) {
                $installment_amount = ($total_amount - $running_amount);
            }
            $html .= '<tr id="grid_row_installment_'.$i.'" data-grid_row_installment="'.$i.'">';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control dtpDate" id="installment_'.$i.'_date" name="installments['.$i.'][installment_date]" value="'.stdDate($date).'" />';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input onchange="calculateTotal();" type="text" class="form-control text-right fPDecimal" id="installment_'.$i.'_amount" name="installments['.$i.'][installment_amount]" value="'.$installment_amount.'" />';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control" id="installment_'.$i.'_remarks" name="installments['.$i.'][installment_remarks]" value="" />';
            $html .= '</td>';
            $html .= '<td><a title="Remove" class="btnRemoveGrid btn btn-xs btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a></td>';
            $html .= '</tr>';

            $running_amount += $installment_amount;
        }

        $json = array(
            'success' => true,
            'post' => $post,
            'html' => $html,
            'grid_row_installment' => $i
        );

        echo json_encode($json);
    }

    protected function insertData($data) {
        // d($data,true);
        return 0;
        // exit;
        $this->model['payroll_installment'] = $this->load->model('payroll/payroll_installment');
        $data['company_id'] = $this->session->data['company_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['date'] = MySqlDate($data['date']);
        $data['start_date'] = MySqlDate($data['start_date']);

        if($data['cheque_date']=='') {
            $data['cheque_date']=NULL;
        } else {
            $data['cheque_date']=MySqlDate($data['cheque_date']);
        }
        $payroll_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);

        foreach($data['installments'] as $installment) {
            $installment['payroll_id'] = $payroll_id;
            $installment['installment_date'] = MySqlDate($installment['installment_date']);

            $this->model['payroll_installment']->add($this->getAlias(), $installment);
        }
    }

    protected function updateData($primary_key, $data) {
        $data['document_date'] = MySqlDate($data['document_date']);
        $data['from_date'] = MySqlDate($data['from_date']);
        $data['to_date'] = MySqlDate($data['to_date']);
        $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);

        $this->model['payroll_allowance'] = $this->load->model('payroll/payroll_allowance');
        foreach($data['payroll_allowances'] as $allowance) {
            if(!isset($allowance['grossable'])) {
                $allowance['grossable']=0;
            }
            if(!isset($allowance['taxable'])) {
                $allowance['taxable']=0;
            }

            $this->model['payroll_allowance']->edit($this->getAlias(), $allowance['payroll_allowance_id'], $allowance);
        }

        $this->model['payroll_deduction'] = $this->load->model('payroll/payroll_deduction');
        foreach($data['payroll_deductions'] as $deduction) {
            $this->model['payroll_deduction']->edit($this->getAlias(), $deduction['payroll_deduction_id'], $deduction);
        }

        return $primary_key;
    }

    protected function deleteData($primary_key) {
        $this->model['payroll_allowance'] = $this->load->model('payroll/payroll_allowance');
        $this->model['payroll_deduction'] = $this->load->model('payroll/payroll_deduction');
        $this->model['advance'] = $this->load->model('payroll/advance');
        $this->model['loan_installment'] = $this->load->model('payroll/loan_installment');

        $advances = $this->model['advance']->getRows(array('payroll_id' => $primary_key));
        foreach($advances as $advance) {
            $this->model['advance']->edit($this->getAlias(), $advance['advance_id'], array('payroll_id' => '', 'payroll_deduction_id' => ''));
        }

        $loans = $this->model['loan_installment']->getRows(array('payroll_id' => $primary_key));
        foreach($loans as $loan) {
            $this->model['loan_installment']->edit($this->getAlias(), $loan['loan_installment_id'], array('payroll_id' => '', 'payroll_deduction_id' => ''));
        }

        $this->model['payroll_allowance']->deleteBulk($this->getAlias(), array('payroll_id' => $primary_key));
        $this->model['payroll_deduction']->deleteBulk($this->getAlias(), array('payroll_id' => $primary_key));
        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);
    }

}

?>