<?php

class ControllerPayrollSalaryIncrement extends HController {

    protected function getAlias() {
        return 'payroll/salary_increment';
    }

    protected function getPrimaryKey() {
        return 'salary_increment_id';
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $lang = $this->load->language($this->getAlias());
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action','document_identity', 'department_name', 'increment_percent', 'increment_amount','wef_date','increment_status','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );
            /*
            $actions[] = array(
                'text' => $this->data['lang']['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printStatement', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );
            */


            $actions[] = array(
                'text' => $this->data['lang']['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );


            if($aRow['is_post'] != 1) {
                $actions[] = array(
                    'text' => $lang['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['target'])?'target="'.$action['target'].'"':'').' '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']), array('department_name'));

        $this->model['registration'] = $this->load->model('employee/employee_registration');
        $this->data['registrations'] = $this->model['registration']->getRows(array('company_id' => $this->session->data['company_id']), array('employee_name'));

        $this->data['is_edit'] = 0;
        if (isset($this->request->get[$this->getPrimaryKey()]) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['is_edit'] = 1;
            $result = $this->model[$this->getAlias()]->getRow(array($this->getPrimaryKey() => $this->request->get[$this->getPrimaryKey()]));
            // d($result);
            foreach($result as $field => $value) {
                if(($field=='wef_date') && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->model['salary_increment_detail'] = $this->load->model('payroll/salary_increment_detail');
            $this->data['salary_increment_details'] = $this->model['salary_increment_detail']->getRows(array($this->getPrimaryKey() => $this->request->get[$this->getPrimaryKey()]));
            // d($this->request->get[$this->getPrimaryKey()]);
            // d($this->data['salary_increment_details'], true);
        }

        $this->data['href_get_arrears'] = $this->url->link($this->getAlias() . '/getArrears', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_get_emp_data'] = $this->url->link($this->getAlias() . '/getEmpData', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['action_finalize'] = $this->url->link($this->getAlias() . '/finalize', 'token=' . $this->session->data['token'], 'SSL');
        // $this->data['action_save'] = $this->url->link($this->getAlias() . '/insertData', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_get_salary_history'] = $this->url->link($this->getAlias() . '/getEmployeeSalaryHistory', 'token=' . $this->session->data['token'], 'SSL');

        $this->response->setOutput($this->render());
    }

    public function getArrears() {
        $post = $this->request->post;
        $row_id = $post['row_id'];
        $employee_registration_id = $post['employee_registration_id'];
        $wef_date = MySqlDate($post['wef_date']);
        $new_basic = $post['new_basic'];

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $arrWhere = array();
        $arrWhere[] = "`employee_registration_id`='".$employee_registration_id."'";
        $arrWhere[] = "`document_date` >='".$wef_date."'";
        $arrWhere[] = "`exclude_payroll` = 0";
        $payrolls = $this->model['payroll']->getRows(implode(' AND ', $arrWhere));
        //d([$arrWhere, $payrolls], true);
        $arrears = 0;
        foreach($payrolls as $payroll) {
            $arrears += $new_basic-$payroll['basic_salary'];
        }

        $json = array(
            'success' => true,
            'row_id' => $row_id,
            'arrears' => $arrears
        );

        echo json_encode($json);
        exit;
    }

    public function getEmpData()
    {
        ini_set('max_execution_time',0);
        $post = $this->request->post;
        $post['employee_code'] = trim($post['employee_code']);
        $wef_date = MySqlDate($post['wef_date']);
        //d($post, true);

        $this->model['salary_increment_detail'] = $this->load->model('payroll/salary_increment_detail');
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
        $this->model['payroll'] = $this->load->model('payroll/payroll');

        // Get ALL registration IDs whose salary has been defined on particular date to make it ignore in next step.
        $arrRegistrations = $this->model['salary_increment_detail']->getArrays('employee_registration_id','employee_registration_id',['wef_date' => $wef_date]);

        $arrWhere = [];
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`status` = 'Active'";
        // Do not get data of these employees as salary increment has been made.
        $arrWhere[] = "`employee_registration_id` NOT IN ('".implode("','", $arrRegistrations)."')";
        if($post['department_id']) {
            $arrWhere[] = "`department_id` = '".$post['department_id']."'";
        }
        if($post['employee_registration_id']) {
            $arrWhere[] = "`employee_registration_id` = '".$post['employee_registration_id']."'";
        }

        $where = implode(' AND ', $arrWhere);
        $rows = $this->model['employee_registration']->getRows($where,['employee_name']);
        $html = '';
        foreach($rows as $key => $row) {
            $salary = $this->model['employee_salary']->getRow(['employee_registration_id' => $row['employee_registration_id']],['wef_date desc']);

            if($post['total_increment_percent'] > 0) {
                $increment_percent = $post['total_increment_percent'];
                $increment_amount = round($salary['basic_salary'] * $increment_percent / 100,0);
            } else {
                $increment_amount = $post['total_increment_amount'];
                $increment_percent = round($increment_amount / $salary['basic_salary'] * 100, 2);
            }
            $new_salary = round($increment_amount + $salary['basic_salary']);

            $arrWhere = array();
            $arrWhere[] = "`employee_registration_id`='".$row['employee_registration_id']."'";
            $arrWhere[] = "`document_date` >='".$wef_date."'";
            $arrWhere[] = "`exclude_payroll` = 0";
            $payrolls = $this->model['payroll']->getRows(implode(' AND ', $arrWhere));
            //d([$arrWhere, $payrolls], true);
            $arrears = 0;
            foreach($payrolls as $payroll) {
                $arrears += $new_salary-$payroll['basic_salary'];
            }

            if($salary && ($salary['wef_date'] <= $wef_date)) {
                $html .= '<tr>';
                $html .= '<td>';
                if($post['is_selected'] == 1)
                {
                    $html .= '<input type="checkbox" id="is_select_'.$key.'" name="increment_process['.$key.'][is_select]" value="1" checked="true" />';
                } else {
                    $html .= '<input type="checkbox" id="is_select_'.$key.'" name="increment_process['.$key.'][is_select]" value="1" />';
                }
                $html .= '</td>';
                $html .= '<td>';
                $html .= $key + 1;
                $html .= '</td>';
                $html .= '<td>';
                $html .= $row['employee_name'];
                $html .= '<input type="hidden" name="increment_process['.$key.'][employee_registration_id]" id="employee_registration_id_'.$key.'" value="'.$row['employee_registration_id'].'" />';
                $html .= '<input type="hidden" name="increment_process['.$key.'][employee]" id="employee_'.$key.'" value="'.$row['employee_name'].'" />';
                $html .= '<input type="hidden" name="increment_process['.$key.'][employee_salary_id]" id="employee_salary_id_'.$key.'" value="'.$salary['employee_salary_id'].'" />';
                $html .= '<input type="hidden" name="increment_process['.$key.'][employee_id]" id="employee_id_'.$key.'" value="'.$row['employee_id'].'" />';
                $html .= '<input type="hidden" name="increment_process['.$key.'][company_id]" id="company_id_'.$key.'" value="'.$row['company_id'].'" />';
                //$html .= '<input type="hidden" name="increment_process['.$key.'][taxable]" id="taxable_'.$key.'" value="'.$salary['taxable'].'" />';
                //$html .= '<input type="hidden" name="increment_process['.$key.'][taxable_house_rent_percent]" id="taxable_house_rent_percent_'.$key.'" value="'.$salary['taxable_house_rent_percent'].'" />';
                //$html .= '<input type="hidden" name="increment_process['.$key.'][total_allowance]" id="total_allowance_id_'.$key.'" value="'.$salary['total_allowance'].'" />';
                //$html .= '<input type="hidden" name="increment_process['.$key.'][taxable_amount]" id="taxable_amount_'.$key.'" value="'.$salary['taxable_amount'].'" />';
                //$html .= '<input type="hidden" name="increment_process['.$key.'][total_deduction]" id="total_deduction_'.$key.'" value="'.$salary['total_deduction'].'" />';
                $html .= '</td>';
                $html .= '<td>';
                $html .= '<input type="hidden" value="'.$row['joining_date'].'" name="increment_process['.$key.'][joining_date]" />' ;
                $html .= stdDate($row['joining_date']);
                $html .= '</td>';
                $date = Date('Y-m-d');
                $date1 = new DateTime($row['joining_date']);
                $date2 = new DateTime($date);
                $interval = $date1->diff($date2);

                $html .= '<td><input type="hidden" value="'.$interval->y.'" name="increment_process['.$key.'][no_of_years]" />';
                $html .= $interval->y . " years, ";
                $html .= '</td>';

                $html .= '<td><input type="hidden" value="'.$row['designation_name'].'" name="increment_process['.$key.'][designation_name]" />';
                $html .= $row['designation_name'];
                $html .= '</td>';

                $html .= '<td>';
                $html .= '<button class="btn btn-xs btn-info" onclick="getHistory(event,'.$key.');" data-id="'.$row['employee_registration_id'].'"><i class="fa fa-history"></i>&nbsp;History</button>';
                $html .= '</td>';

                $html .= '<td>';
                $html .= stdDate($salary['wef_date']);
                $html .= '<input type="hidden" name="increment_process['.$key.'][last_salary_updated]" id="last_salary_updated_'.$key.'" value="'.$salary['wef_date'].'" />';
                $html .= '</td>';

                $html .= '<td>';
                $html .= $salary['basic_salary'];
                $html .= '<input type="hidden" name="increment_process['.$key.'][basic_salary]" id="basic_salary_'.$key.'" value="'.$salary['basic_salary'].'" />';
                $html .= '</td>';
                $html .= '<td data-id="'.$key.'">';
                $html .= '<input type="text" class="form-control"  onchange="calculateAmount(this);" id="increment_percent_'.$key.'" name="increment_process['.$key.'][increment_percent]" value="'.$increment_percent.'" />';
                $html .= '</td>';
                $html .= '<td data-id="'.$key.'">';
                $html .= '<input type="text" class="form-control" onchange="calculatePercent(this);" id="increment_amount_'.$key.'" name="increment_process['.$key.'][increment_amount]" value="'.$increment_amount.'" />';
                $html .= '</td>';
                $html .= '<td data-id="'.$key.'">';
                $html .= '<input type="text" name="increment_process['.$key.'][new_salary]" class="form-control" onchange="calculateNewSalary(this);" id="new_salary_'.$key.'" value="'.$new_salary.'" />';
                $html .= '</td>';
                $html .= '<td data-id="'.$key.'">';
                $html .= '<input type="text" name="increment_process['.$key.'][arrears]" class="form-control" id="arrears_'.$key.'" value="'.$arrears.'" />';
                $html .= '</td>';
                $html .= '</tr>';
            } else {
                $html .= '<tr>';
                $html .= '<td>';
                $html .= '</td>';
                $html .= '<td>';
                $html .= $key + 1;
                $html .= '</td>';
                $html .= '<td>';
                $html .= $row['employee_name'];
                $html .= '</td>';
                $html .= '<td>';
                $html .= stdDate($row['joining_date']);
                $html .= '</td>';
                $date = Date('Y-m-d');
                $date1 = new DateTime($row['joining_date']);
                $date2 = new DateTime($date);
                $interval = $date1->diff($date2);

                $html .= '<td>';
                $html .= $interval->y . " years, ";
                $html .= '</td>';

                $html .= '<td>';
                $html .= $row['designation_name'];
                $html .= '</td>';

                $html .= '<td>';
                $html .= '<button class="btn btn-xs btn-info" onclick="getHistory(event,'.$key.');" data-id="'.$row['employee_registration_id'].'"><i class="fa fa-history"></i>&nbsp;History</button>';
                $html .= '</td>';

                $html .= '<td>';
                $html .= $salary['wef_date']?stdDate($salary['wef_date']):'';
                $html .= '</td>';

                $html .= '<td>';
                $html .= $salary['basic_salary'];
                $html .= '</td>';
                $html .= '<td data-id="'.$key.'">';
                $html .= '0';
                $html .= '</td>';
                $html .= '<td data-id="'.$key.'">';
                $html .= '0';
                $html .= '</td>';
                $html .= '<td data-id="'.$key.'">';
                $html .= '0';
                $html .= '</td>';
                $html .= '<td data-id="'.$key.'">';
                $html .= '0';
                $html .= '</td>';
                $html .= '</tr>';

            }
        }

        $json['success'] = true;
        $json['html'] = $html;
        echo json_encode($json);
    }

    public function getEmployeeSalaryHistory()
    {
        $post = $this->request->post;
        // d($post);
        $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
        $employee_salaries = $this->model['employee_salary']->getRows(array('employee_registration_id' => $post['employee_registration_id']),['wef_date','department_name']);
        // d($employee_salaries,true);
        $html = '<div class="table-responsive">';
        $html .= '<table class="table table-striped table-bordered">';
        $html .= '<thead>';
        $html .= '<th>S.No</th>';
        $html .= '<th>W.E.F Date</th>';
        $html .= '<th>Department</th>';
        $html .= '<th>Basic Salary</th>';
        $html .= '<th>Allowances</th>';
        $html .= '<th>Deductions</th>';
        $html .= '<th>Net Amount</th>';
        $html .= '</thead>';
        $html .= '<tbody>';
        foreach ($employee_salaries as $key => $value) {
            $html .= '<tr>';
            $html .= '<td>'.($key + 1).'</td>';
            $html .= '<td>'.$value['wef_date'].'</td>';
            $html .= '<td>'.$value['department_name'].'</td>';
            $html .= '<td>'.$value['basic_salary'].'</td>';
            $html .= '<td>'.$value['total_allowance'].'</td>';
            $html .= '<td>'.$value['total_deduction'].'</td>';
            $html .= '<td>'.$value['net_amount'].'</td>';
            $html .= '</tr>';
        }
        $html .= '</tbody>';
        $html .= '</table>';
        $html .= '</div>';

        // d($html,true);

        $json['success'] = true;
        $json['html'] = $html;
        echo json_encode($json);
        exit;

    }

    protected function insertData($data)
    {
        //d($data,true);
        $document_no = $this->model[$this->getAlias()]->getMaxDocumentNo();
        $data['company_id'] = $this->session->data['company_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['increment_amount'] = $data['total_increment_amount'];
        $data['increment_percent'] = $data['total_increment_percent'];
        $data['wef_date'] = MySqlDate($data['wef_date']);
        $data['document_no'] = $document_no;
        $data['document_identity'] = $this->session->data['fy_code'].'-'.str_pad($document_no,5,"0",STR_PAD_LEFT);
        // d($data,true);
        $salary_increment_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);
        $this->model['salary_increment_detail'] = $this->load->model('payroll/salary_increment_detail');
        foreach ($data['increment_process'] as $index => $detail) {
            if($detail['is_select'] == 1)
            {
                $detail['salary_increment_id'] = $salary_increment_id;
                $detail['company_id'] = $this->session->data['company_id'];
                $detail['fiscal_year_id'] = $this->session->data['fiscal_year_id'];

                $this->model['salary_increment_detail']->add($this->getAlias(),$detail);
            }
        }
        return $salary_increment_id;
    }

    protected function updateData($primary_key,$data) {
        // d($primary_key);
        // d($data,true);
        $data['company_id'] = $this->session->data['company_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['increment_amount'] = $data['total_increment_amount'];
        $data['increment_percent'] = $data['total_increment_percent'];
        $data['wef_date'] = MySqlDate($data['wef_date']);
        $salary_increment_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);
        $this->model['salary_increment_detail'] = $this->load->model('payroll/salary_increment_detail');
        $this->model['salary_increment_detail']->deleteBulk($this->getAlias(), array('salary_increment_id' => $primary_key));
        foreach ($data['increment_process'] as $index => $detail) {
            if($detail['is_select'] == 1)
            {
                $detail['salary_increment_id'] = $salary_increment_id;
                $detail['company_id'] = $this->session->data['company_id'];
                $detail['fiscal_year_id'] = $this->session->data['fiscal_year_id'];

                $this->model['salary_increment_detail']->add($this->getAlias(),$detail);
            }
        }
        return $salary_increment_id;
    }

    public function finalize() {
        $this->init();

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateUpdate()) {
            ini_set('max_execution_time',0);
            $this->db->beginTransaction();
            $id = $this->finalizeData($this->request->post);
            $this->db->commit();

            $this->session->data['success'] = $this->language->get('success_update');

            $this->updateRedirect($id, $this->request->post);
        }
        $this->data['isEdit'] = 1;
        $this->getForm();
    }

    public function finalizeData($data)
    {
        $this->model['salary_increment'] = $this->load->model('payroll/salary_increment');
        $this->model['salary_increment_detail'] = $this->load->model('payroll/salary_increment_detail');
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance');
        $this->model['employee_deduction'] = $this->load->model('employee/employee_deduction');
        $this->model['employee_salary'] = $this->load->model('employee/employee_salary');

        $data['company_id'] = $this->session->data['company_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['increment_amount'] = $data['total_increment_amount'];
        $data['increment_percent'] = $data['total_increment_percent'];
        $data['wef_date'] = MySqlDate($data['wef_date']);
        $data['is_post'] = 1;

        //d($data,true);
        $salary_increment_id = $this->model['salary_increment']->edit('salary_increment', $data['salary_increment_id'], $data);
        $this->model['salary_increment_detail']->deleteBulk($this->getAlias(), array('salary_increment_id' => $data['salary_increment_id']));
        foreach ($data['increment_process'] as $index => $detail) {
            if($detail['is_select'] == 1) {
                $detail['salary_increment_id'] = $salary_increment_id;
                $detail['company_id'] = $this->session->data['company_id'];
                $detail['fiscal_year_id'] = $this->session->data['fiscal_year_id'];

                $this->model['salary_increment_detail']->add($this->getAlias(),$detail);
            }
        }

        foreach ($data['increment_process'] as $index => $detail) {
            if($detail['is_select'] == 1) {
                $employee = $this->model['employee_registration']->getRow(['employee_registration_id' => $detail['employee_registration_id']]);
                $salary = $this->model['employee_salary']->getRow(['employee_salary_id' => $detail['employee_salary_id']]);
                $employee_allowances = $this->model['employee_allowance']->getRows(['employee_salary_id' => $detail['employee_salary_id']]);
                $employee_deductions = $this->model['employee_deduction']->getRows(['employee_salary_id' => $detail['employee_salary_id']]);

                //d($salary, true);
                $employee_salary_id = getGUID();
                $total_allowance = 0;
                $taxable_allowance = 0;
                foreach($employee_allowances as $allowance) {
                    if($allowance['grossable']) {
                        $total_allowance += $allowance['allowance_amount'];
                    }
                    if($allowance['taxable']) {
                        $taxable_allowance += $allowance['allowance_amount'];
                    }

                    unset($allowance['employee_allowance_id']);
                    unset($allowance['created_at']);
                    unset($allowance['created_by_id']);
                    unset($allowance['modified_at']);
                    unset($allowance['modified_by_id']);
                    $allowance['employee_salary_id'] = $employee_salary_id;
                    $allowance['employee_registration_id'] = $employee['employee_registration_id'];

                    $employee_allowance_id = $this->model['employee_allowance']->add($this->getAlias(), $allowance);
                }
                $total_deduction = 0;
                foreach($employee_deductions as $deduction) {
                    $total_deduction += $deduction['deduction_amount'];

                    unset($deduction['employee_deduction_id']);
                    unset($deduction['created_at']);
                    unset($deduction['created_by_id']);
                    unset($deduction['modified_at']);
                    unset($deduction['modified_by_id']);
                    $deduction['employee_salary_id'] = $employee_salary_id;
                    $deduction['employee_registration_id'] = $employee['employee_registration_id'];

                    $employee_deduction_id = $this->model['employee_deduction']->add($this->getAlias(), $deduction);
                }

                $salary['employee_salary_id'] = $employee_salary_id;
                $salary['company_id'] = $this->session->data['company_id'];
                $salary['department_id'] = $employee['department_id'];
                $salary['wef_date'] = $data['wef_date'];
                $salary['basic_salary'] = $detail['new_salary'];
                if($salary['taxable_house_rent']=='Yes') {
                    $house_rent_allowance = round($salary['basic_salary'] * $salary['taxable_house_rent_percent'] / 100);
                } else {
                    $house_rent_allowance = 0;
                }
                $salary['gross_amount'] = ($salary['basic_salary']+$total_allowance);
                $salary['taxable_amount'] = ($salary['basic_salary']+$taxable_allowance+$house_rent_allowance);
                $salary['net_amount'] = ($salary['gross_amount']-$total_deduction);
                unset($salary['created_at']);
                unset($salary['created_by_id']);
                unset($salary['modified_at']);
                unset($salary['modified_by_id']);

                //d($salary, true);
                $employee_salary_id = $this->model['employee_salary']->add($this->getAlias(), $salary);

                if($detail['arrears'] != 0) {
                    $this->model['employee_registration']->edit($this->getAlias(),$employee['employee_registration_id'],['arrears' => $detail['arrears']]);
                }
            }
        }
    }

    protected function deleteData($primary_key) {
        $this->model['salary_increment_detail'] = $this->load->model('payroll/salary_increment_detail');
        $this->model['salary_increment_detail']->deleteBulk($this->getAlias(), array('salary_increment_id' => $primary_key));
        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);
    }

    public function printDocument()
    {
        // $get = $this->request->get;
        // d($this->request->post,true);
        ini_set('max_execution_time',0);
        ini_set('memory_limit',-1);

        $lang = $this->load->language($this->getAlias());
        $salary_increment_id = $this->request->get['salary_increment_id'];
        // $post = $this->request->post;
        $session = $this->session->data;
        // d($session,true);
//        $this->model['company'] = $this->load->model('setup/company');
        $this->model['salary_increment'] = $this->load->model('payroll/salary_increment');
        $this->model['salary_increment_detail'] = $this->load->model('payroll/salary_increment_detail');


//        $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));
        $salary_increment = $this->model['salary_increment']->getRow(array('salary_increment_id' => $salary_increment_id));
        $salary_increment_detail = $this->model['salary_increment_detail']->getRows(array('salary_increment_id' => $salary_increment_id));
        // d(array($salary_increment, $salary_increment_detail), true);

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Hira Anwer');
        $pdf->SetTitle('Salary Increment');
        $pdf->SetSubject('Salary Increment');

        //Set Header
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'] ,
            'report_name' => 'Salary Increment',
            'status' => 'Print',
        );


        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(2, 2, 2);
        $pdf->SetHeaderMargin(2);
        $pdf->SetFooterMargin(2);

        // set font
        $pdf->SetFont('times', 'B', 10);

        // add a page
        $pdf->AddPage();

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('times', 'B', 15);
        $pdf->Ln(2);
        $pdf->Cell(207,6, $session['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Ln(7);
        $pdf->SetFont('times', 'B', 14);
        $pdf->Cell(207,6, $pdf->data['report_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');


        $pdf->SetFont('times', '', 10);

        $pdf->Ln(10);
        $pdf->Cell(25,6, 'Document No. : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(22,6, $salary_increment['document_identity'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(107,6, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(22,6, 'Department : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(22,6, $salary_increment['department_name'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Ln(10);
        $pdf->Cell(22,6, 'W.E.F Date : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(22,6, stdDate($salary_increment['wef_date']), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(110,6, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(15,6, 'Status : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(22,6, $salary_increment['increment_status'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');

        $pdf->Ln(10);

        $pdf->SetFont('times', 'B', 8);
        $pdf->Cell(7, 8, 'No.', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(60, 8, 'Employee Name', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(17, 8, 'Joining Date', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(10, 8, 'Years', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25, 8, 'Designation', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(15, 8, 'Allowances', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(15, 8, 'Basic Sal.', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(12, 8, 'Inc %', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(15, 8, 'Inc Amount', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(15, 8, 'New Basic', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(15, 8, 'Arrears', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $sr = 0;
        $pdf->Ln(0);
        $Amount = 0;
        $Arrears = 0;
        $total_basic_sal = 0;
        $total_inc_amount = 0;
        $pdf->SetFont('times', '', 9);
        foreach($salary_increment_detail as $detail) {
            $sr++;
            $pdf->Ln(8);
            $Amount += $detail['new_salary'];
            $Arrears += $detail['arrears'];
            $total_basic_sal += $detail['basic_salary'];
            $total_inc_amount += $detail['increment_amount'];
            $pdf->Cell(7, 8, $sr, 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(60, 8, $detail['employee'], 'LR',false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(17, 8, stdDate($detail['joining_date']), 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(10, 8, $detail['no_of_years'], 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 8, $detail['designation_name'], 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 8, number_format($detail['total_allowance']), 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 8, number_format($detail['basic_salary']), 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(12, 8, $detail['increment_percent'], 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 8, number_format($detail['increment_amount']), 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 8, number_format($detail['new_salary']), 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 8, number_format($detail['arrears']), 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
        }

        $x = $pdf->GetX();
        $y = $pdf->GetY();


        for ($i = $y; $i <= 220; $i++) {

            $pdf->Ln(1);
            $pdf->Cell(7, 7, '', 'L',  false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(60, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(17, 7, '', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(10, 7, '', 'L', false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 7, '', 'L', false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(12, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 7,'', 'L,R', false, 'L', 0, '', 0, false, 'M', 'M');
            $y =$i;
        }
        $pdf->Ln(-1);
        $pdf->Ln(1);
        $pdf->Cell(207, 7, '', 'B', false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->setXY($x,$y);

        $pdf->SetFont('times', 'B', 8);
        $pdf->Ln(8);
        $pdf->Cell(134, 7, '', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(15, 7, number_format($total_basic_sal,2), 1, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(12, 7, '', 1, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(15, 7, number_format($total_inc_amount,2), 1, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(15, 7, number_format($Amount,2), 1, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(15, 7, number_format($Arrears,2), 1, false, 'R', 0, '', 0, false, 'M', 'M');

        //Close and output PDF document
        $pdf->Output('Salary Increment :'.date('YmdHis').'.pdf', 'I');
    }


}

class PDF extends TCPDF {
    public $lang;
    public $header;
    public $footer;
    //Page header
    public function Header() {

    }

    // Page footer
    public function Footer() {
        $data = $this->footer;
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('freesans', 'I', 8);
        // Page number
        $this->Cell(60, 10, $this->lang['ref'].': '.$data['special_enayat_title'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}


?>