<?php

class ControllerPayrollSpecialAllowance extends HController {

    protected function getAlias() {
        return 'payroll/special_allowance';
    }

    protected function getPrimaryKey() {
        return 'special_allowance_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function getList() {
        parent::getList();

        $this->data['href_payment_detail'] = $this->url->link($this->getAlias() . '/getPaymentDetail', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $this->load->language('payroll/advance');

        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        //$this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');

        $data = array();
        $aColumns = array('action','document_date', 'document_identity','special_allowance_type', 'its_no', 'registration_code', 'employee_name',  'total_amount','approved_status','approved_amount','payment','created_at','check_box');
        $aFields = array('action','sa.document_date', 'sa.document_identity','sat.special_allowance_type','e.its_no', 'er.registration_code', 'e.full_name',  'sa.total_amount','sa.approved_status','sa.approved_amount','payment','sa.created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "" . $aFields[intval($_GET['iSortCol_' . $i])] . " " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
            $sort_order = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "sa.`company_id` = '" . $this->session->data['company_id'] . "'";
        //$arrWhere[] = "((sa.`fiscal_year_id` = '" . $this->session->data['fiscal_year_id'] . "' AND sa.`approved_status` IN ('Requested','Approved','Rejected')) OR sa.`approved_status` = 'Requested')";
        $arrWhere[] = "sa.`approved_status` NOT IN('Pending','Pending Verification')";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(" . $aFields[$i] . ") LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(" . $aFields[$i] . ") LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            //$data['filter']['RAW'] = implode(' AND ', $arrWhere);
            $filter = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        //$results = $this->model[$this->getAlias()]->getLists($data);
        $results = $this->model[$this->getAlias()]->getLists($filter, $data['criteria']);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $this->data['lang']['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );

            if($aRow['approved_status'] == 'Pending') {
                $actions[] = array(
                    'text' => $this->data['lang']['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['target'])?'target="'.$action['target'].'"':'').' '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } elseif ($aColumns[$i] == 'payment') {
                    if(($aRow['bl_amount'] + $aRow['ic_amount']) > 0) {
                        $row[] = '<button type="button" class="btn label label-warning" onclick="viewPayments(\''.$aRow['special_allowance_id'].'\');">View</button>';
                    } else {
                        $row[] = '<span class="label label-danger">Pending</span>';
                    }
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }
            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    public function getPaymentDetail() {
        $special_allowance_id = $this->request->post['special_allowance_id'];
        $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
        $rows = $this->model['special_allowance']->getPaymentDetail($special_allowance_id);

        $html = '';
        $html .= '<div class="panel panel-default">';
        $html .= '  <div class="panel-heading">Payment Detail</div>';
        $html .= '  <div class="panel-body">';
        $html .= '      <table class="table table-bordered">';
        $html .= '      <thead>';
        $html .= '          <tr>';
        $html .= '              <th>Doc. No.</th>';
        $html .= '              <th>Doc. Date</th>';
        $html .= '              <th>Doc. Title</th>';
        $html .= '              <th>Chq. Date</th>';
        $html .= '              <th>Chq. No.</th>';
        $html .= '              <th>Amount</th>';
        $html .= '          </tr>';
        $html .= '      </thead>';
        $html .= '      <tbody>';
        foreach($rows as $row) {
            $href = $this->url->link($row['route'], 'token=' . $this->session->data['token'], 'SSL');
            $html .= '          <tr>';
            $html .= '              <td><a href="'.$href.'" target="_blank">'.$row['document_identity'].'</a></td>';
            $html .= '              <td>'.$row['document_date'].'</td>';
            $html .= '              <td>'.$row['document_title'].'</td>';
            $html .= '              <td>'.$row['cheque_date'].'</td>';
            $html .= '              <td>'.$row['cheque_no'].'</td>';
            $html .= '              <td>'.$row['amount'].'</td>';
            $html .= '          </tr>';
        }
        $html .= '      </tbody>';
        $html .= '      </table>';
        $html .= '  </div>';
        $html .= '</div>';


        $json = ['success' => true, 'html' => $html];
        echo json_encode($json);
    }

    protected function getForm() {
        parent::getForm();

        $this->model['employee_family'] = $this->load->model('employee/employee_family');
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');

        //$this->data['employees'] = $this->model['employee_registration']->getRows(array('company_id' => $this->session->data['company_id'], 'status' => 'Active'), array('employee_name'));
        $this->data['employees'] = $this->model['employee_registration']->getRows(array('company_id' => $this->session->data['company_id'], 'status' => 'Active'), array('employee_name'));
        $this->data['document_date'] = stdDate();
        $this->data['document_identity'] = 'Auto';

        if (isset($this->request->get[$this->getPrimaryKey()]) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['isEdit']=1;
            $result = $this->model[$this->getAlias()]->getRow(array($this->getPrimaryKey() => $this->request->get[$this->getPrimaryKey()]));
            // d($result);
            foreach($result as $field => $value) {

                if($field=='document_date') {
                    $this->data[$field] = stdDate($value);
                } elseif($field=='medical_from' && $value != '') {
                    $this->data[$field] = stdDate($value);
                } elseif($field=='medical_to' && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            if($result['file_directory'] != '' && file_exists(DIR_FILES . $result['file_directory'])) {
                $this->data['href_document_file'] = HTTP_FILES . $result['file_directory'];
            } else {
                $this->data['href'] = '';
                $this->data['file_directory'] = '';
                $this->data['file_name'] = '';
            }

            $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
            $employee = $this->model['employee_registration']->getRecord(['employee_registration_id' => $result['employee_registration_id']]);
            $company_id = $employee['company_id'];
            $department_id = $employee['department_id'];

            if($employee['override_allowance_policy']) {
                $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance_policy');
                $policies = $this->model['employee_allowance']->getRows(array('employee_registration_id' => $result['employee_registration_id'], 'allowance_type_id' => $result['special_allowance_type_id']));
            } else {
                $this->model['department'] = $this->load->model('setup/department');
                $department = $this->model['department']->getRow(['department_id' => $department_id]);
                if($department['override_allowance_policy']) {
                    $this->model['policy'] = $this->load->model('setup/department_allowance_policy');
                    $policies = $this->model['policy']->getRecords(array('department_id' => $department_id, 'allowance_type_id' => $result['special_allowance_type_id']));
                } else {
                    $this->model['policy'] = $this->load->model('setup/company_allowance_policy');
                    $policies = $this->model['policy']->getRecords(array('company_id' => $company_id, 'allowance_type_id' => $result['special_allowance_type_id']));
                }
            }

            $arrPolicies = [];
            foreach($policies as $policy) {
                $arrPolicies[$policy['relation']][$policy['allowance_category_id']] = [
                    'allowance_on' => $policy['allowance_on'],
                    'allowance_value' => $policy['allowance_value'],
                ];

            }

            $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');
            $details = $this->model['special_allowance_detail']->getRows(array($this->getPrimaryKey() => $this->request->get[$this->getPrimaryKey()]),array('sort_order'));
            //d($details, true);
            $approved_amount = 0;
            $total_amount = 0;
            foreach($details as $detail) {
                if($detail['receipt_date'] != '') {
                    $detail['receipt_date'] = stdDate($detail['receipt_date']);
                }
                if($detail['file_directory'] && file_exists(DIR_FILES.$detail['file_directory'])) {
                    $detail['href'] = HTTP_FILES . $detail['file_directory'];
                } else {
                    $detail['href'] = '';
                }

                //d($detail, true);
                if($result['approved_status'] != 'Approved' && $detail['approved_amount'] == 0) {
                    $relation = $detail['relation'];
                    $category_id = $detail['special_allowance_category_id'];
                    if(isset($arrPolicies[$relation][$category_id])) {
                        $detail['policy_on'] = $arrPolicies[$relation][$category_id]['allowance_on'];
                        $detail['policy_value'] = $arrPolicies[$relation][$category_id]['allowance_value'];
                    } elseif(isset($arrPolicies[$relation][0])) {
                        $detail['policy_on'] = $arrPolicies[$relation][0]['allowance_on'];
                        $detail['policy_value'] = $arrPolicies[$relation][0]['allowance_value'];
                    } else {
                        $detail['policy_on'] = '';
                        $detail['policy_value'] = 0;
                    }

                    if($detail['policy_on']=='Fixed') {
                        $detail['policy_amount'] = $detail['amount'];
                        $detail['approved_amount'] = $detail['amount'];
                    } else {
                        $detail['policy_amount'] = round($detail['amount'] * $detail['policy_value'] / 100, 2);
                        $detail['approved_amount'] = $detail['policy_amount'];
                    }
                }

                $this->data['allowance_details'][] = $detail;
                $total_amount += $detail['amount'];
                $approved_amount += $detail['approved_amount'];
                /*d($detail['special_allowance_id'],true);*/
            }
            // d($details,true);
            $this->data['total_amount'] = $total_amount;
            $this->data['approved_amount'] = $approved_amount;
            $this->data['employee_policies'] = $policies;
            $this->data['policies'] = $arrPolicies;
            //d($policies, true);

            $this->model['employee_family'] = $this->load->model('employee/employee_family');
            $this->data['employee_families'] = $this->model['employee_family']->getRows(array('employee_id' => $result['employee_id']));

            $this->model['special_allowance_installments'] = $this->load->model('payroll/special_allowance_installments');
            $this->data['installments'] = $this->model['special_allowance_installments']->getRows(array($this->getPrimaryKey() => $this->request->get[$this->getPrimaryKey()]));
            // d($this->data['installments'],true);

            $this->data['total_paid_amount'] = $this->model[$this->getAlias()]->getpaidAmount($result['special_allowance_id']);
        }

        $this->data['strValidation']="{
            'rules':{
                'document_date': {'required':true},
                'registration_code': {'required':true},
                'employee_registration_id': {'required':true},
                'allowance_type': {'required':true},
                'relation': {'required':true},
                'total_amount': {'required':true},
            },
        }";

        $this->data['href_get_allowance_type'] = $this->url->link($this->getAlias() . '/getAllowanceType', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['href_get_policy'] = $this->url->link($this->getAlias() . '/getPolicy', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        // $this->data['href_get_emp_allowance'] = $this->url->link($this->getAlias() . '/getEmployeeAllowance', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['href_get_allowance_category'] = $this->url->link($this->getAlias() . '/getAllowanceCategory', 'token=' . $this->session->data['token']);
        $this->response->setOutput($this->render());
    }

//    public function getEmployeeAllowance(){
//        $post = $this->request->post;
//        $emp_id = $post['employee_registration_id'];
//        $allowance_type_id = $post['special_allowance_type_id'];
//        if($allowance_type_id == 1)
//        {
//            // scholarship types
//            $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
//            $this->data['special_allowance'] = $this->model['special_allowance']->getEmployeeSpecialScholarshipAllowance($emp_id,1);
//            // d($this->data['special_allowance'],true);
//
//        } else if($allowance_type_id == 2) {
//            // medical types
//            $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
//            $this->data['special_allowance'] = $this->model['special_allowance']->getEmployeeSpecialMedicalAllowance($emp_id,2);
//            // d($this->data['special_allowance'],true);
//        }
//        // d($this->data['special_allowance'],true);
//        $json = array(
//            'success' => true,
//            'post' => $post,
//            'emp_allowances' => $this->data['special_allowance']
//        );
//        echo json_encode($json);
//    }

    public function getAllowanceType() {
        $employee_registration_id = $this->request->post['employee_registration_id'];
        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->model['policy'] = $this->load->model('employee/employee_allowance_policy');

        $employee = $this->model['employee']->getRecord(['employee_registration_id' => $employee_registration_id]);
        $company_id = $employee['company_id'];
        $department_id = $employee['department_id'];
        if($employee['override_allowance_policy']) {
            $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance_policy');
            $policies = $this->model['employee_allowance']->getRows(array('employee_registration_id' => $employee_registration_id),['sort_order']);
        } else {
            $this->model['department'] = $this->load->model('setup/department');
            $department = $this->model['department']->getRow(['department_id' => $department_id]);
            if($department['override_allowance_policy']) {
                $this->model['policy'] = $this->load->model('setup/department_allowance_policy');
                $policies = $this->model['policy']->getRecords(array('department_id' => $department_id),['sort_order']);
            } else {
                $this->model['policy'] = $this->load->model('setup/company_allowance_policy');
                $policies = $this->model['policy']->getRecords(array('company_id' => $company_id),['sort_order']);
            }
        }
        $arrAllowanceType = [];
        foreach($policies as $policy) {
            $arrAllowanceType[$policy['allowance_type_id']] = $policy['allowance_type'];
        }

        $html = '<option valie="">&nbsp;</option>';
        foreach($arrAllowanceType as $allowance_type_id=>$allowance_type) {
            $html .= '<option value="'.$allowance_type_id.'">'.$allowance_type.'</option>';
        }

        $json = [
            'success' => true,
            'html' => $html
        ];
        echo json_encode($json);
    }

    public function getAllowanceCategory(){
        $post = $this->request->post;

        //d($post,true);
        $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
        $special_allowance_categories = $this->model['special_allowance']->getAllcategories($post['special_allowance_type_id']);

        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $employee = $this->model['employee_registration']->getRecord(['employee_registration_id' => $post['employee_registration_id']]);
        $company_id = $employee['company_id'];
        $department_id = $employee['department_id'];
        $employee_id = $employee['employee_id'];

        if($employee['override_allowance_policy']) {
            $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance_policy');
            $policies = $this->model['employee_allowance']->getRows(array('employee_registration_id' => $post['employee_registration_id'], 'allowance_type_id' => $post['special_allowance_type_id']));
        } else {
            $this->model['department'] = $this->load->model('setup/department');
            $department = $this->model['department']->getRow(['department_id' => $department_id]);
            if($department['override_allowance_policy']) {
                $this->model['policy'] = $this->load->model('setup/department_allowance_policy');
                $policies = $this->model['policy']->getRecords(array('department_id' => $department_id, 'allowance_type_id' => $post['special_allowance_type_id']));
            } else {
                $this->model['policy'] = $this->load->model('setup/company_allowance_policy');
                $policies = $this->model['policy']->getRecords(array('company_id' => $company_id, 'allowance_type_id' => $post['special_allowance_type_id']));
            }
        }

        $html = '';
        $arrPolicies = [];
        $arrRelaton = [];
        foreach($policies as $policy) {
            $html .= '<tr>';
            $html .= '<td>'.$policy['relation'].'</td>';
            $html .= '<td>'.$policy['allowance_category'].'</td>';
            $html .= '<td>'.$policy['allowance_on'].'</td>';
            $html .= '<td>'.$policy['allowance_value'].'</td>';
            $html .= '</tr>';

            $arrPolicies[$policy['relation']][$policy['allowance_category_id']] = [
                'allowance_on' => $policy['allowance_on'],
                'allowance_value' => $policy['allowance_value'],
            ];

            $arrRelaton[] = $policy['relation'];
        }

        $arrWhere = [];
        $arrWhere[] = "`employee_id` = '$employee_id'";
        $arrWhere[] = "`relation` IN ('".implode("','", $arrRelaton)."')";
        $where = implode(" AND ", $arrWhere);
        $this->model['employee_family'] = $this->load->model('employee/employee_family');
        $families = $this->model['employee_family']->getArrays('employee_family_id',array('employee_family_id','relation','school_id','school_name','class_id','class_name','full_name'),$where,array('sort_order'));

        $json = array(
            'success' => true,
            'employee_policy' => $employee['override_allowance_policy'],
            'department_policy' => $department['override_allowance_policy'],
            'post' => $post,
            'policies' => $arrPolicies,
            'families' => $families,
            'html_policy' => $html,
            'categories' => $special_allowance_categories
        );
        echo json_encode($json);
    }

    public function getPolicy() {
        $post = $this->request->post;
        // d($post,true);
        //$this->model['employee_registration'] = $this->load->model('employee/employee_registration_id');
        //$employees  = $this->model['employee_registration']->getRows();
        $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');
        $allowance_type  = $this->model['special_allowance_detail']->getRows();

        //foreach($employees as $employee){
        $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance_policy');
        $policies = $this->model['employee_allowance']->getRows(array('employee_registration_id' => $post['employee_registration_id']));
        // d($policies,true);

        $html = '';
        foreach($policies as $policy) {
            $html .= '<tr>';
            $html .= '<td>'.$policy['relation'].'</td>';
            $html .= '<td>'.$policy['allowance'].'</td>';
            $html .= '<td>'.$policy['allowance_category'].'</td>';
            $html .= '<td>'.$policy['allowance_on'].'</td>';
            $html .= '<td>'.$policy['allowance_value'].'</td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'post' => $post,
            'html' => $html,
        );
        echo json_encode($json);
    }

    protected function insertData($data) {
        // d($data,true);
        $document_no = $this->model[$this->getAlias()]->getMaxDocumentNo();
        $data['company_id'] = $this->session->data['company_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['document_no'] = $document_no;
        $data['document_identity'] = $this->session->data['fy_code'].'-'.str_pad($document_no,5,"0",STR_PAD_LEFT);
        $data['document_date'] = MySqlDate($data['document_date']);

        if(!isset($data['is_taxable'])) {
            $data['is_taxable'] = 0;
        }

        if($data['medical_from'] != '') {
            $data['medical_from'] = MySqlDate($data['medical_from']);
        } else {
            $data['medical_from'] = NULL;
        }

        if($data['medical_to'] != '') {
            $data['medical_to'] = MySqlDate($data['medical_to']);
        } else {
            $data['medical_to'] = NULL;
        }

        $file = $this->request->files['document'];
        if($file['size'] < 1048576 && $file['size'] > 0) {
            $dir_files = DIR_FILES;
            $uploaded_file = '/'.$data['document_identity'].'-'.basename($file['name']);
            move_uploaded_file($file['tmp_name'], $dir_files . $uploaded_file);

            $data['file_name'] = $file['name'];
            $data['file_directory'] = $uploaded_file;

        }
        $special_allowance_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);

        $arrFiles = array();
        foreach($this->request->files['details'] as $field => $files) {
            foreach($files as $index => $file) {
                $arrFiles[$index][$field] = $file['document'];
            }
        }
        //d(array($this->request->files['details'], $arrFiles),true);
        $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');

        foreach($data['details']  as $index => $detail){
            $detail['special_allowance_id'] = $special_allowance_id;
            $detail['sort_order'] = $index;

            if($detail['receipt_date'] != '') {
                $detail['receipt_date'] = MySqlDate($detail['receipt_date']);
            } else {
                $detail['receipt_date'] = NULL;
            }

            if(isset($arrFiles[$index]) && $arrFiles[$index]['tmp_name'] != '') {
                if($arrFiles[$index]['size'] < 1048576) {
                    $dir_files = DIR_FILES.'E'.$data['employee_code'];
                    if(!file_exists($dir_files)) {
                        mkdir($dir_files);
                    }
                    $upload_file = $dir_files .'/'. basename($arrFiles[$index]['name']);
                    move_uploaded_file($arrFiles[$index]['tmp_name'], $upload_file);

                    $detail['file_name'] = 'E'.$data['employee_code'].'/'.basename($arrFiles[$index]['name']);
                    $detail['file_directory'] = 'E'.$data['employee_code'].'/'.basename($arrFiles[$index]['name']);

                }
            }

            $this->model['special_allowance_detail']->add($this->getAlias(), $detail);
        }

        $this->model['special_allowance_installments'] = $this->load->model('payroll/special_allowance_installments');
        foreach($data['installments'] as $installment_data) {

            $installment_data['special_allowance_id'] = $special_allowance_id;
            $installment_data['installment_date'] = MySqlDate($installment_data['installment_date']);
            $this->model['special_allowance_installments']->add($this->getAlias(), $installment_data);
        }
        /*
        $size = sizeof($data['installment']['installment_date']);
        for($i = 0; $i < $size; $i++)
        {
            $installment_data['installment_date'] = MySqlDate($data['installment']['installment_date'][$i]);
            $installment_data['installment_amount'] = $data['installment']['installment_amount'][$i];
            $installment_data['special_allowance_id'] = $special_allowance_id;
            $installment_data['created_by_id'] = $this->session->data['user_id'];
            $this->model['special_allowance_installments']->add($this->getAlias(), $installment_data);
        }
        */

        return $special_allowance_id;
    }

    protected function updateData($primary_key, $data) {
        // d($data,true);
        $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');
        $this->model['special_allowance_installments'] = $this->load->model('payroll/special_allowance_installments');
        $data['document_date'] = MySqlDate($data['document_date']);
        if(!isset($data['is_taxable'])) {
            $data['is_taxable'] = 0;
        }

        if($data['medical_from'] != '') {
            $data['medical_from'] = MySqlDate($data['medical_from']);
        } else {
            $data['medical_from'] = NULL;
        }

        if($data['medical_to'] != '') {
            $data['medical_to'] = MySqlDate($data['medical_to']);
        } else {
            $data['medical_to'] = NULL;
        }

        $file = $this->request->files['document'];
        if($file['size'] < 1048576 && $file['size'] > 0) {
            $dir_files = DIR_FILES;
            $uploaded_file = '/'.$data['document_identity'].'-'.basename($file['name']);
            move_uploaded_file($file['tmp_name'], $dir_files . $uploaded_file);
            $data['file_name'] = $file['name'];
            $data['file_directory'] = $uploaded_file;
        }
        $special_allowance_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);

        $arrFiles = array();
        foreach($this->request->files['details'] as $field => $files) {
            foreach($files as $index => $file) {
                $arrFiles[$index][$field] = $file['document'];
            }
        }
        $this->model['special_allowance_detail']->deleteBulk($this->getAlias(), array('special_allowance_id' => $primary_key));
        $this->model['special_allowance_installments']->deleteBulk($this->getAlias(), array('special_allowance_id' => $primary_key));
        // exit;
        foreach($data['details'] as $index => $detail){
            $detail['special_allowance_id'] = $special_allowance_id;
            $detail['sort_order'] = $index;

            if($detail['receipt_date'] != '') {
                $detail['receipt_date'] = MySqlDate($detail['receipt_date']);
            } else {
                $detail['receipt_date'] = NULL;
            }

            if(isset($arrFiles[$index]) && $arrFiles[$index]['tmp_name'] != '') {
                if($arrFiles[$index]['size'] < 1048576) {
                    $dir_files = DIR_FILES.'E'.$data['employee_code'];
                    if(!file_exists($dir_files)) {
                        mkdir($dir_files);
                    }
                    $upload_file = $dir_files .'/'. basename($arrFiles[$index]['name']);
                    move_uploaded_file($arrFiles[$index]['tmp_name'], $upload_file);

                    $detail['file_name'] = 'E'.$data['employee_code'].'/'.basename($arrFiles[$index]['name']);
                    $detail['file_directory'] = 'E'.$data['employee_code'].'/'.basename($arrFiles[$index]['name']);

                }
            }
            //d(array($data,$detail), true);
            $this->model['special_allowance_detail']->add($this->getAlias(), $detail);
        }
        // d(sizeof($data['installment']['installment_date']));
        $this->model['special_allowance_installments'] = $this->load->model('payroll/special_allowance_installments');
        foreach($data['installments'] as $installment_data) {

            $installment_data['special_allowance_id'] = $special_allowance_id;
            $installment_data['installment_date'] = MySqlDate($installment_data['installment_date']);
            $this->model['special_allowance_installments']->add($this->getAlias(), $installment_data);
        }

        return $primary_key;
    }

    protected function deleteData($primary_key) {
        $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');
        $this->model['special_allowance_detail']->deleteBulk($this->getAlias(), array('special_allowance_id' => $primary_key));
        $this->model['special_allowance_installments'] = $this->load->model('payroll/special_allowance_installments');
        $this->model['special_allowance_installments']->deleteBulk($this->getAlias(), array('special_allowance_id' => $primary_key));
        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);
    }

    public function printDocument() {
        $special_allowance_id = $this->request->get['special_allowance_id'];
        $lang = $this->load->language($this->getAlias());

        $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
        $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');
        $this->model['employee'] = $this->load->model('employee/employee_profile');
        $this->model['employee_medical'] = $this->load->model('employee/employee_medical');
        $this->model['employee_scholarship'] = $this->load->model('employee/employee_scholarship');
        $this->model['employee_family'] = $this->load->model('employee/employee_family');
        $this->model['employee_policies'] = $this->load->model('employee/employee_allowance_policy');

        $voucher = $this->model['special_allowance']->getRecord(array('sa.special_allowance_id' => $special_allowance_id));
        $details = $this->model['special_allowance_detail']->getRows(array('special_allowance_id' => $special_allowance_id),array('sort_order'));
        $employee = $this->model['employee']->getRow(array('employee_id' => $voucher['employee_id']));
        $families = $this->model['employee_family']->getArrays('employee_family_id','full_name',array('employee_id' => $voucher['employee_id']));

        if($employee['employee_image'] && file_exists(DIR_IMAGE.$employee['employee_image'])) {
            $employee_image = DIR_IMAGE . $employee['employee_image'];
        } else {
            $employee_image = DIR_IMAGE . 'no_user.jpg';
        }
        // d(array($voucher, $details, $families));

        if($voucher['special_allowance_type_id']==1 || $voucher['special_allowance_type_id']==5) {
            //Scholarship
            $arrFamilyData=array();
            foreach($details as $detail) {
                if(!isset($arrFamilyData[$detail['employee_family_id']])) {
                    $policies = $this->model['employee_policies']->getRow(array('employee_registration_id' => $voucher['employee_registration_id'],'allowance_type_id'=>$voucher['special_allowance_type_id'], 'relation' => $detail['relation']),array('relation','allowance_category'));
                    
                    $arrFamilyData[$detail['employee_family_id']] = array(
                        'special_allowance_id' => $detail['special_allowance_id'],
                        'school_id' => $detail['school_id'],
                        'class_id' => $detail['class_id'],
                        'relation' => $detail['relation'],
                        'school_name' => $detail['school_name'],
                        'class_name' => $detail['class_name'],
                        'member_name' => $detail['full_name'],
                        'period' => ($detail['period_start_date']?stdDate($detail['period_start_date']).' - ':'').($detail['period_end_date']?stdDate($detail['period_end_date']):''),
                    );
                }

                $arrFamilyData[$detail['employee_family_id']]['details'][] = array(
                    'special_allowance_detail_id' => $detail['special_allowance_detail_id'],
                    'special_allowance_category_id' => $detail['special_allowance_category_id'],
                    'special_allowance_category' => $detail['special_allowance_category'],
                    'remarks' => $detail['remarks'],
                    'receipt_date' => ($detail['receipt_date']?stdDate($detail['receipt_date']):''),
                    'receipt_no' => $detail['receipt_no'],
                    'amount' => $detail['amount'],
                    'allowance_on' => $policies['allowance_on'],
                    'allowance_value' => $policies['allowance_value'],
                );
            }
            // d($arrFamilyData, true);
            $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
            $pdf->SetAuthor('Huzaifa Khambaty');
            $pdf->SetTitle('Covering Letter:'.$voucher['document_identity'].'@'.date('YmdHis'));
            $pdf->SetSubject('Covering Letter');

            // set margins
            //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
            $pdf->SetMargins(PDF_MARGIN_LEFT, 20, PDF_MARGIN_RIGHT);
            $pdf->SetHeaderMargin(10);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

            $pdf->data = array(
                'company_name' => $voucher['company_name'],
                'document_identity' => $voucher['document_identity']
            );
            $pdf->lang = $lang;
            // set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

            // add a page
            $pdf->AddPage();
            //$pdf->Cell(0,10,'',1,1);
            //$pdf->Cell(180,10,'',1,1);
            $pdf->Image($employee_image, 15, 20, 25, 25);

            $pdf->SetDrawColor(205,205,205);
            $pdf->SetFillColor(255,127,80);
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(25, 6, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(130, 6, $voucher['employee_name'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, $voucher['document_identity'], 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(130, 6, $employee['cnic_address'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, stdDate($voucher['document_date']), 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(130, 6, $employee['cnic_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, $voucher['special_allowance_type'], 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(130, 6, $employee['its_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->ln(20);
            $net_amount = 0;
            $policy_grand_total = 0;
            $grand_total_amount = 0;
            foreach($arrFamilyData as $data) {
                $pdf->SetFillColor(0,255,204);
                $pdf->SetTextColor(0,0,0);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(15, 8, 'Relation:', 'LTB', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 8);
                $pdf->Cell(25, 8, $data['relation'], 'TB', false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(20, 8, 'Name:', 'TB', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 8);
                $pdf->Cell(120, 8, $data['member_name'], 'TBR', false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->ln(8);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(15, 8, 'Class:', 'BL', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 8);
                $pdf->Cell(25, 8, $data['class_name'], 'B', false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(20, 8, 'School:', 'B', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 8);
                $pdf->Cell(50, 8, $data['school_name'], 'B', false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(20, 8, 'Period:', 'B', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 8);
                $pdf->Cell(50, 8, $data['period'], 'BR', false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->ln(8);
                $pdf->SetFillColor(0,206,209);
                $pdf->SetTextColor(255,255,255);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(35, 8, 'Category', 1, false, 'C', 1, '', 0, false, 'T', 'M');
                $pdf->Cell(75, 8, 'Remarks', 1, false, 'C', 1, '', 0, false, 'T', 'M');
                $pdf->Cell(20, 8, 'Receipt Date', 1, false, 'C', 1, '', 0, false, 'T', 'M');
                $pdf->Cell(30, 8, 'Receipt No', 1, false, 'C', 1, '', 0, false, 'T', 'M');
                $pdf->Cell(20, 8, 'Amount', 1, false, 'C', 1, '', 0, false, 'T', 'M');
                $pdf->ln(8);
                $total_amount = 0;
                $total_policy_amount = 0;
                foreach($data['details'] as $detail) {
                    $pdf->SetFillColor(255,255,255);
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont('helvetica', '', 8);
                    $pdf->Cell(35, 8, $detail['special_allowance_category'], 1, false, 'L', 1, '', 0, false, 'T', 'M');
                    $pdf->Cell(75, 8, $detail['remarks'], 1, false, 'L', 1, '', 1, false, 'T', 'M');
                    $pdf->Cell(20, 8, $detail['receipt_date'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
                    $pdf->Cell(30, 8, $detail['receipt_no'], 1, false, 'C', 1, '', 1, false, 'T', 'M');
                    $pdf->Cell(20, 8, number_format($detail['amount'],2), 1, false, 'R', 1, '', 0, false, 'T', 'M');
                    $pdf->ln(8);
                    $total_amount += $detail['amount'];
                }
                $grand_total_amount += $total_amount;


                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(160, 8, 'Amount:', 1, false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 8);
                $pdf->Cell(20, 8, number_format($total_amount,2), 1, false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->ln(8);
                $pdf->ln(4);
            }
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(160, 8, 'Grand Total:', 1, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(20, 8, number_format($grand_total_amount,2), 1, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->ln(8);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(160, 8, 'Approved Amount:', 1, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(20, 8, number_format($voucher['approved_amount'],2), 1, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->ln(32);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(40, 8, 'Applicant Signature', 'T', false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(30, 8, '', 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(40, 8, 'Verified by', 'T', false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(30, 8, '', 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(40, 8, 'Approved By', 'T', false, 'C', 1, '', 0, false, 'T', 'M');
        } elseif($voucher['special_allowance_type_id']==2) {
            //MEDICAL
            $this->model['employee_medical'] = $this->load->model('employee/employee_medical');
            $policies = $this->model['employee_medical']->getRows(array('employee_registration_id' => $voucher['employee_registration_id']), array('relation,medical_type'));
            $arrPolicies = array();
            foreach($policies as $policy) {
                if($policy['relation']=='Children') {
                    $policy['relation']='Child';
                }
                $arrPolicies[$policy['relation']][$policy['medical_type']]=array('medical_on' => $policy['medical_on'],'medical_value' => $policy['medical_value']);
            }
            //d($arrPolicies, true);
            $arrFamilyData = array();
            foreach($details as $detail) {
                if(isset($arrPolicies[$detail['relation']][$detail['special_allowance_category']]) && $arrPolicies[$detail['relation']][$detail['special_allowance_category']]['medical_on']=='Percent') {
                    $desc = $detail['relation'].' ['.$arrPolicies[$detail['relation']][$detail['special_allowance_category']]['medical_value'].'% on '.$detail['special_allowance_category'].']';
                    $percent = $arrPolicies[$detail['relation']][$detail['special_allowance_category']]['medical_value'];
                } else {
                    $desc = $detail['relation'].' ['.$arrPolicies[$detail['relation']]['ALL']['medical_value'].'% on All]';
                    $percent = $arrPolicies[$detail['relation']]['ALL']['medical_value'];
                }
                //d(array($detail['relation'], $detail['special_allowance_category'], $arrPolicies));
                if(!isset($arrFamilyData[$desc])) {
                    $arrFamilyData[$desc] = array(
                        'category' => $detail['special_allowance_category'],
                        'relation' => $detail['relation'],
                        'percent' => $percent
                    );
                }
                $arrFamilyData[$desc]['details'][] = array(
                    'receipt_no' => $detail['receipt_no'],
                    'receipt_date' => $detail['receipt_date'],
                    'remarks' => $detail['remarks'],
                    'amount' => $detail['amount'],
                    'relation' => $detail['relation'],
                    'full_name' => $detail['full_name'],
                    'category' => $detail['special_allowance_category'],
                );
            }

            //d($arrFamilyData, true);
            $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
            $pdf->SetAuthor('Huzaifa Khambaty');
            $pdf->SetTitle('Covering Letter:'.$voucher['document_identity'].'@'.date('YmdHis'));
            $pdf->SetSubject('Covering Letter');

            // set margins
            //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
            $pdf->SetMargins(PDF_MARGIN_LEFT, 20, PDF_MARGIN_RIGHT);
            $pdf->SetHeaderMargin(10);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

            $pdf->data = array(
                'company_name' => $voucher['company_name'],
                'document_identity' => $voucher['document_identity']
            );
            $pdf->lang = $lang;
            // set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

            // add a page
            $pdf->AddPage();
            //$pdf->Cell(0,10,'',1,1);
            //$pdf->Cell(180,10,'',1,1);

            $pdf->Image($employee_image, 15, 20, 25, 25);

            $pdf->SetDrawColor(205,205,205);
            $pdf->SetFillColor(255,127,80);
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(25, 6, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(110, 6, $voucher['employee_name'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(20, 6, 'Doc. No:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, $voucher['document_identity'], 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(110, 6, $employee['cnic_address'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(20, 6, 'Doc. Date:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, stdDate($voucher['document_date']), 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(110, 6, $employee['cnic_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(20, 6, 'Doc. Type:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, $voucher['special_allowance_type'], 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(130, 6, $employee['its_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->ln(20);

            $pdf->SetFont('helvetica', 'B', 8);
            //$pdf->Cell(90, 5, 'Sheikh Kumail Saheb,', 0, false, 'L');
            //$pdf->ln(5);
            $pdf->Cell(90, 5, 'Dawat-e-Hadiyah,', 0, false, 'L');
            $pdf->ln(5);
            $pdf->Cell(90, 5, 'Karachi.', 0, false, 'L');
            $pdf->ln(5);
            $from_date = ($voucher['medical_from']?'From ' . date('M Y',strtotime($voucher['medical_from'])):'');
            $to_date = ($voucher['medical_to']?'To ' . date('M Y', strtotime($voucher['medical_to'])):'');
            $pdf->Cell(0, 8, 'Sub: Medical '.$from_date.' '.$to_date, 0, false, 'C');
            $pdf->ln(10);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(90, 8, 'Dear Sir,', 0, false, 'L');
            $pdf->ln(5);
            $pdf->Cell(90, 8, 'Most respectfully requesting for Medical Expenses as follows:', 0, false, 'L');
            $grand_total = 0;
            foreach($arrFamilyData as $heading => $data) {
                $pdf->ln(10);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(90, 8, $heading, 0, false, 'L');
                $pdf->ln(7);
                $pdf->SetFont('helvetica', '', 8);
                $pdf->SetFillColor(0,206,209);
                $pdf->SetTextColor(255,255,255);
                $pdf->Cell(30, 8, 'Cash Memo / Bill No', 1, false, 'C',1);
                $pdf->Cell(20, 8, 'Date', 1, false, 'C',1);
                $pdf->Cell(100, 8, 'Particulars', 1, false, 'C',1);
                $pdf->Cell(30, 8, 'Amount', 1, false, 'C',1);
                $pdf->SetFont('helvetica', '', 8);

                $total_amount = 0;
                $policy_amount = 0;
                $pdf->SetFillColor(255,127,80);
                $pdf->SetTextColor(0,0,0);
                foreach($data['details'] as $detail) {
                    $pdf->ln(8);
                    $pdf->Cell(30, 8, $detail['receipt_no'], 1, false, 'C');
                    $pdf->Cell(20, 8, stdDate($detail['receipt_date']), 1, false, 'C');
                    $pdf->Cell(100, 8, $detail['remarks'], 1, false, 'L');
                    $pdf->Cell(30, 8, number_format($detail['amount'],2), 1, false, 'R');

                    $total_amount += $detail['amount'];
                    $policy_amount += ($detail['amount'] * $data['percent'] / 100);
                    $grand_total += ($detail['amount'] * $data['percent'] / 100);
                }
                $pdf->ln(8);
                $pdf->Cell(150, 8, 'Total Amount: ', 0, false, 'R');
                $pdf->Cell(30, 8, number_format($total_amount,2), 1, false, 'R');
                $pdf->ln(8);
                $pdf->Cell(150, 8, 'Policy Amount: '.$data['percent'].'% ', 0, false, 'R');
                $pdf->Cell(30, 8, number_format($policy_amount,2), 1, false, 'R');
            }
            $pdf->ln(15);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(130, 8, '', 0, false, 'R');
            $pdf->Cell(20, 8, 'Total Rs: ', 'TB', false, 'R');
            $pdf->Cell(30, 8, number_format($grand_total,2), 'TB', false, 'R');
            $pdf->ln(20);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(40, 8, 'Applicant Signature', 'T', false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(30, 8, '', 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(40, 8, 'Verified by', 'T', false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(30, 8, '', 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(40, 8, 'Approved By', 'T', false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(4);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(40, 8, $employee['full_name'], 0, false, 'C');
        } else {
            // ALL Other
            $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
            $pdf->SetAuthor('Huzaifa Khambaty');
            $pdf->SetTitle('Covering Letter:'.$voucher['document_identity'].'@'.date('YmdHis'));
            $pdf->SetSubject('Covering Letter');

            // set margins
            //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
            $pdf->SetMargins(PDF_MARGIN_LEFT, 20, PDF_MARGIN_RIGHT);
            $pdf->SetHeaderMargin(10);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

            $pdf->data = array(
                'company_name' => $voucher['company_name'],
                'document_identity' => $voucher['document_identity']
            );
            $pdf->lang = $lang;
            // set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

            // add a page
            $pdf->AddPage();
            $pdf->Image($employee_image, 15, 20, 25, 25);

            $pdf->SetDrawColor(205,205,205);
            $pdf->SetFillColor(255,127,80);
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(25, 6, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(110, 6, $voucher['employee_name'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(20, 6, 'Doc. No:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, $voucher['document_identity'], 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(110, 6, $employee['cnic_address'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(20, 6, 'Doc. Date:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, stdDate($voucher['document_date']), 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(110, 6, $employee['cnic_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(20, 6, 'Doc. Type:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, $voucher['special_allowance_type'], 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(130, 6, $employee['its_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->ln(20);

            $pdf->SetFillColor(239,111,108);
            $pdf->SetTextColor(255,255,255);
            $pdf->SetFont('helvetica', 'B', 7);
            $pdf->Cell(0, 8, 'Current Request', 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(8);
            $pdf->SetFillColor(255,255,255);
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont('helvetica', '', 7);
            foreach($details as $detail) {
                $pdf->SetFont('helvetica', 'B', 7);
                $pdf->Cell(20, 6, 'Allowance For:', 'L', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 7);
                $pdf->Cell(70, 6, $families[$detail['employee_family_id']].' ('.$detail['allowance_for'].')', 0, false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', 'B', 7);
                $pdf->Cell(30, 6, 'Allowance Category:', 0, false, 'R', 0, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 7);
                $pdf->Cell(30, 6, $detail['special_allowance_category'], 0, false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', 'B', 7);
                $pdf->Cell(13, 6, 'Amount:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 7);
                $pdf->Cell(17, 6, number_format($detail['amount'],2), 'R', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->ln(6);
                if($detail['remarks']) {
                    $pdf->SetFont('helvetica', 'B', 7);
                    $pdf->Cell(20, 6, 'Remarks:', 'L', false,'R', 1, '', 0, false, 'T', 'M');
                    $pdf->SetFont('helvetica', '', 7);
                    $pdf->Cell(160, 6, $detail['remarks'], 'R', false, 'L', 0, '', 0, false, 'T', 'M');
                    $pdf->ln(6);
                }
                if($detail['receipt_no'] || $detail['receipt_date']) {
                    $pdf->SetFont('helvetica', 'B', 7);
                    $pdf->Cell(20, 6, 'Receipt No:', 'L', false, 'R', 1, '', 0, false, 'T', 'M');
                    $pdf->SetFont('helvetica', '', 7);
                    $pdf->Cell(120, 6, $detail['receipt_no'], 0, false, 'L', 1, '', 0, false, 'T', 'M');
                    $pdf->SetFont('helvetica', 'B', 7);
                    $pdf->Cell(20, 6, 'Receipt Date', 0, false, 'L', 1, '', 0, false, 'T', 'M');
                    $pdf->SetFont('helvetica', '', 7);
                    $pdf->Cell(20, 6, ($detail['receipt_date']!=''?stdDate($detail['receipt_date']):''), 'R', false, 'L', 1, '', 0, false, 'T', 'M');
                    $pdf->ln(6);
                }
                $pdf->Cell(0, 1, '', 'T');
                $pdf->ln(1);
            }
            $pdf->ln(4);
            $pdf->SetFont('helvetica', 'B', 7);
            $pdf->Cell(20, 8, 'Total Amount:', 0, false, 'L', 1, '', 0, false, 'T', 'M');
            $pdf->SetFont('helvetica', '', 7);
            $pdf->Cell(160, 8, number_format($voucher['total_amount'],2).' ('.Number2Words(round($voucher['total_amount'],0)).')', 0, false, 'L', 1, '', 0, false, 'T', 'M');
            $pdf->ln(16);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(40, 8, 'Applicant Signature', 'T', false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(30, 8, '', 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(40, 8, 'Verified by', 'T', false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(30, 8, '', 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(40, 8, 'Approved By', 'T', false, 'C', 1, '', 0, false, 'T', 'M');
        }

        $pdf->Output('Covering Letter:'.$voucher['document_identity'].'@'.date('YmdHis').'.pdf', 'I');
    }
}

class PDF extends TCPDF {
    public $lang;
    public $data;

    //Page header
    public function Header() {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        // Title
        $this->Cell(0, 10, 'Dawat e Hadiyah', 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('helvetica', 'B', 14);
//        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('helvetica', '', 14);
//        $this->Cell(0, 10, $this->data['subtitle'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(60, 10, 'Ref: '.$this->data['document_identity'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>