<?php

class ControllerPayrollSpecialEnayat extends HController {

    protected function getAlias() {
        return 'payroll/special_enayat';
    }

    protected function getPrimaryKey() {
        return 'special_enayat_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function getList() {
        parent::getList();
        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_emp_data'] = $this->url->link($this->getAlias() . '/getDocNo', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $lang = $this->load->language($this->getAlias());
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'document_date', 'document_identity', 'document_title','total_amount','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $total_records = $this->model[$this->getAlias()]->getChequeCount($aRow['special_enayat_id']);
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $this->data['lang']['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );

            if($aRow['is_post'] != 1 && $total_records == 0) {
                $actions[] = array(
                    'text' => $lang['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['target'])?'target="'.$action['target'].'"':'').' '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $company_id = $this->session->data['company_id'];

        $this->model['department'] = $this->load->model('setup/department');
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['enayat_event'] = $this->load->model('payroll/enayat_event');

        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $company_id),['department_name']);
        $this->data['employees'] = $this->model['employee_registration']->getRows(array('company_id' => $company_id),['employee_name']);
        $this->data['events'] = $this->model['enayat_event']->getRows(array('company_id' => $company_id),['name']);

        $this->data['document_date'] = stdDate();

        if (isset($this->request->get['special_enayat_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['isEdit'] = 1;
            $result = $this->model[$this->getAlias()]->getRow(array('special_enayat_id' => $this->request->get['special_enayat_id']));
            // d($result,true);
            foreach($result as $field => $value) {
                if(($field=='document_date') && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->model['special_enayat_detail'] = $this->load->model('payroll/special_enayat_detail');
            $details = $this->model['special_enayat_detail']->getRows(array('special_enayat_id' => $this->request->get['special_enayat_id']),array('sort_order'));

            $employees = array();
            // d($details,true);
            $this->model['individual_cheque_detail'] = $this->load->model('payroll/individual_cheque_detail');
            $this->model['bank_letter_detail'] = $this->load->model('payroll/bank_letter_detail');
            foreach($details as $row_no => $detail) {
                $ic = $this->model['individual_cheque_detail']->getRows(['source_table_id' => $detail['special_enayat_detail_id']]);
                $bl = $this->model['bank_letter_detail']->getRows(['source_table_id' => $detail['special_enayat_detail_id']]);
                if($ic || $bl) {
                    $detail['isPost'] = true;
                }
                $detail['full_name'] = $detail['employee_name'];
                if($detail['cheque_date'] != '' && $detail['cheque_date'] != '0000-00-00') {
                    $detail['cheque_date'] = stdDate($detail['cheque_date']);
                } else {
                    $detail['cheque_date'] = '';
                }
                $employees[] = $detail;
            }
        }

        $this->data['special_enayat_details'] = $employees;

        $this->data['strValidation']="{
            'rules':{
              'document_date': {'required':true},
              'document_title': {'required':true},
              'enayat_event_id': {'required':true},
              'total_amount': {'required':true,'min':1},
            },
        }";

        $this->data['href_get_employees'] = $this->url->link($this->getAlias() . '/getEmployees', 'token=' . $this->session->data['token']);
        $this->response->setOutput($this->render());
    }

    public function getEmployees()
    {
        $session = $this->session->data;
        $post = $this->request->post;

        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['special_enayat_detail'] = $this->load->model('payroll/special_enayat_detail');
        $this->model['special_enayat'] = $this->load->model('payroll/special_enayat');

        $arrMembers = $this->model['special_enayat_detail']->getEmployees($session['company_id'], MySqlDate($post['document_date']), $post['enayat_event_id']);
        $arrFilter = [];
        $arrFilter[] = "`company_id` = '".$session['company_id']."'";
        $arrFilter[] = "`employee_registration_id` NOT IN ('".implode("','", $arrMembers)."')";
        if($post['department_id']) {
            $arrFilter[] = "`department_id` IN ('".implode("','", $post['department_id'])."')";
        }
        if($post['employee_registration_id']) {
            $arrFilter[] = "`employee_registration_id` IN ('".implode("','", $post['employee_registration_id'])."')";
        }

        $where = implode(' AND ', $arrFilter);
        $employees = $this->model['employee_registration']->getDistinctRows(['employee_registration_id','employee_id','registration_code','employee_name'],$where,['employee_name']);

        $json = array(
            'success' => true,
            'employees' => $employees,
        );

        echo json_encode($json);
        exit;
    }

    protected function insertData($data) {
        //d($data,true);
        //d(array($data, $this->session->data), true);
        $this->model['special_enayat'] = $this->load->model('payroll/special_enayat');
        $this->model['special_enayat_detail'] = $this->load->model('payroll/special_enayat_detail');

        $data['document_no'] = $this->model[$this->getAlias()]->getNextNumber();
        $data['document_identity'] = $this->session->data['fy_code'].$this->session->data['company_id'].'-SE'.str_pad($data['document_no'],4,"0",STR_PAD_LEFT);
        $data['company_id'] = $this->session->data['company_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['document_date'] = MySqlDate($data['document_date']);
        $special_enayat_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);

        foreach ($data['employees'] as $sort_order => $detail) {
            $detail['special_enayat_id'] = $special_enayat_id;
            $detail['sort_order'] = $sort_order;

            $special_enayat_detail_id = $this->model['special_enayat_detail']->add($this->getAlias(), $detail);
        }

        return $special_enayat_id;
    }

    protected function updateData($primary_key, $data) {
        // d($data,true);
        $this->model['special_enayat'] = $this->load->model('payroll/special_enayat');
        $this->model['special_enayat_detail'] = $this->load->model('payroll/special_enayat_detail');

        $this->model['special_enayat_detail']->deleteBulk($this->getAlias(), array('special_enayat_id' => $primary_key));
        $data['document_date'] = MySqlDate($data['document_date']);
        $special_enayat_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);

        foreach ($data['employees'] as $sort_order => $detail) {
            $detail['special_enayat_id'] = $special_enayat_id;
            $detail['sort_order'] = $sort_order;
            if(!empty($detail['cheque_date']))
            {
                $detail['cheque_date'] = MySqlDate($detail['cheque_date']);
            }

            $special_enayat_detail_id = $this->model['special_enayat_detail']->add($this->getAlias(), $detail);
        }

        return $special_enayat_id;
    }

    protected function deleteData($primary_key) {
        //d($primary_key, true);
        $this->model['special_enayat_detail'] = $this->load->model('payroll/special_enayat_detail');
        $this->model['special_enayat_detail']->deleteBulk($this->getAlias(), array('special_enayat_id' => $primary_key));

        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);
    }

    public function printDocument() {
        ini_set('max_execution_time',0);
        ini_set('memory_limit',-1);

        $lang = $this->load->language($this->getAlias());
        $special_enayat_id = $this->request->get['special_enayat_id'];
        $post = $this->request->post;
        $session = $this->session->data;

        $this->model['special_enayat'] = $this->load->model('payroll/special_enayat');
        $this->model['special_enayat_detail'] = $this->load->model('payroll/special_enayat_detail');


        $special_enayat = $this->model['special_enayat']->getRow(array('special_enayat_id' => $special_enayat_id));
        $special_enayat_detail = $this->model['special_enayat_detail']->getRows(array('special_enayat_id' => $special_enayat_id),array('sort_order asc'));
        //d(array($special_enayat, $special_enayat_detail), true);

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Saif Zakir');
        $pdf->SetTitle('Enayat');
        $pdf->SetSubject('Enayat');

        //Set Header
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'] ,
            'report_name' => 'Enayat',
//            'company_logo' => $session['company_image'],
            'status' => 'Print',
        );


        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(10, 2, 10);
        $pdf->SetHeaderMargin(2);
        $pdf->SetFooterMargin(2);

        // set auto page breaks
        //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set font
        $pdf->SetFont('times', 'B', 10);

        // add a page
        $pdf->AddPage();

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('times', 'B', 15);
        $pdf->Ln(2);
        $pdf->Cell(207,6, 'DAWAT-E-HADIYAH', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Ln(7);
        $pdf->SetFont('times', 'B', 14);
        $pdf->Cell(207,6, $pdf->data['report_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');


        $pdf->SetFont('times', '', 10);
        $pdf->Ln(10);
        $pdf->Cell(26,6, 'Document Title : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(151,6, $special_enayat['document_title'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');

        $pdf->Ln(10);
        $pdf->Cell(25,6, 'Document No. : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(26,6, $special_enayat['document_identity'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(10,6, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(26,6, 'Document Date : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25,6, stdDate($special_enayat['document_date']), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(10,6, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25,6, 'Enayat Event : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(26,6, $special_enayat['enayat_event_name'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');

        $pdf->Ln(10);
        $pdf->SetFont('times', 'B', 8);
        $pdf->Cell(10, 8, 'No.', 1, false, 'C', 0, '', 0, false, 'M', 'M');

        $pdf->Cell(147, 8, 'Employee Name', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25, 8, 'Amount', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $sr = 0;
        $pdf->Ln(7);
        $Amount = 0;
        $pdf->SetFont('times', '', 9);
        foreach($special_enayat_detail as $detail) {
            if($detail['amount'] > 0)
            {
                $sr++;
                $pdf->Cell(10, 5, $sr, 'LR', false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(147, 5, $detail['employee_name'], 'LR',false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(25, 5, number_format($detail['amount'],2), 'LR', false, 'R', 0, '', 0, false, 'M', 'M');
                $pdf->Ln(5);
            }
        }

        $x = $pdf->GetX();
        $y = $pdf->GetY();

        for ($i = $y; $i <= 260; $i++) {

            $pdf->Ln(1);
            $pdf->Cell(10, 7, '', 'L',  false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(147, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 7, '', 'LR', false, 'L', 0, '', 0, false, 'M', 'M');
            $y =$i;
        }
        $pdf->Ln(-1);
        $pdf->Ln(1);
        $pdf->Cell(182, 7, '', 'B', false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->setXY($x,$y);

        $pdf->SetFont('times', 'B', 8);
        $pdf->Ln(8);
        $pdf->Cell(157, 7, '', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25, 7, number_format($special_enayat['total_amount'],2), 1, false, 'R', 0, '', 0, false, 'M', 'M');

        $data= $special_enayat;
        //Close and output PDF document
        $pdf->Output('Enayat :'.date('YmdHis').'.pdf', 'I');
    }

}

class PDF extends TCPDF {
    public $lang;
    public $header;
    public $footer;
    //Page header
    public function Header() {

    }

    // Page footer
    public function Footer() {
        $data = $this->footer;
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('freesans', 'I', 8);
        // Page number
        $this->Cell(60, 10, $this->lang['ref'].': '.$data['special_enayat_title'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>
