<?php
class ControllerPayrollTaxChallan extends HController {

    protected function getAlias() {
        return 'payroll/tax_challan';
    }

    protected function getPrimaryKey() {
        return 'payroll_id';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    public function index() {
        $this->redirect($this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'], 'SSL'));
    }

    protected function getForm() {
        parent::getForm();
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee_registration']->getArrays('registration_code',array('employee_registration_id', 'registration_code', 'employee_id', 'employee_code', 'employee_name'),array('company_id' => $this->session->data['company_id'], 'status' => 'Active'), array('employee_name'));

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']), array('department_name'));

        $this->data['payroll_from_date'] = stdDate($this->session->data['fiscal_date_from']);
        $this->data['payroll_to_date'] = stdDate();

        $this->data['strValidation']="{
            'rules':{
		        'payroll_from_date': {'required':true},
		        'payroll_to_date': {'required':true},
            },
        }";

        $this->data['href_get_tax_data'] = $this->url->link($this->getAlias() . '/getTaxData', 'token=' . $this->session->data['token'] . '&employee_id=' . $this->request->get['employee_id']);
        $this->data['action_update'] = $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getTaxData() {
        ini_set('max_execution_time','400');
        $lang = $this->load->language($this->getAlias());
        $post = $this->request->post;

        $this->model['bank'] = $this->load->model('setup/bank');
        $this->model['payroll'] = $this->load->model('payroll/payroll');

        $banks = $this->model['bank']->getRows(array(), array('bank_name'));

        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`tax_deduction` > 0";
        //$arrWhere[] = "`deposit_slip_id` != ''";
        if($post['payroll_from_date']) {
            $arrWhere[] = "`document_date` >= '".MySqlDate($post['payroll_from_date'])."'";
        }
        if($post['payroll_to_date']) {
            $arrWhere[] = "`document_date` <= '".MySqlDate($post['payroll_to_date'])."'";
        }
        if($post['department_id']) {
            $arrWhere[] = "`department_id` IN ('".implode("','",array_values($post['department_id']))."') ";
            //$arrWhere[] = "`department_id` = '".$post['department_id']."'";
        }
        if($post['registration_code']) {
            $arrWhere[] = "`registration_code` = '".$post['registration_code']."'";
        }

        $where = implode(' AND ', $arrWhere);
        $payrolls = $this->model['payroll']->getRows($where, array('document_date', 'registration_code'));

        //d(array($where, $payrolls,$post['department_id']), true);
        $html = '';
        $html .= '<table id="tblPayroll" class="table table-striped" style="max-height: 500px;">';
        $html .= '<thead>';
        $html .= '<tr>';
        $html .= '<th class="freeze">Sr.</th>';
        $html .= '<th class="freeze">'.$lang['payroll_date'].'</th>';
        $html .= '<th class="freeze">'.$lang['registration_code'].'</th>';
        $html .= '<th class="freeze">'.$lang['employee'].'</th>';
        $html .= '<th>'.$lang['gross_salary'].'</th>';
        $html .= '<th>'.$lang['taxable_salary'].'</th>';
        $html .= '<th>'.$lang['tax_amount'].'</th>';
        $html .= '<th>'.$lang['tax_challan_no'].'</th>';
        $html .= '<th>'.$lang['tax_challan_date'].'</th>';
        $html .= '<th>'.$lang['tax_challan_bank'].'</th>';
        $html .= '<th>'.$lang['tax_challan_branch'].'</th>';
        $html .= '</tr>';
        $html .= '</thead>';
        $html .= '<tbody>';

        $total_gross_salary = 0;
        $total_taxable_salary = 0;
        $total_tax_deduction = 0;
        $id= 0;
        foreach($payrolls as $payroll) {
            $html .= '<tr data-id="'.$id.'" data-registration_id="'.$payroll['registration_id'].'">';
            $html .= '<td class="text-center">'.($id+1).'</td>';
            $html .= '<td class="text-center">'.stdDate($payroll['document_date']).'</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" class="form-control" id="payroll_'.$id.'_id" name="payrolls['.$id.'][payroll_id]" value="'.$payroll['payroll_id'].'" />';
            $html .= $payroll['registration_code'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= $payroll['employee_name'];
            $html .= '</td>';
            $html .= '<td class="text-right">';
            $html .= number_format($payroll['gross_salary'],2);
            $html .= '</td>';
            $html .= '<td class="text-right">';
            $html .= number_format($payroll['taxable_salary'],2);
            $html .= '</td>';
            $html .= '<td class="text-right">';
            $html .= number_format($payroll['tax_deduction'],2);
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control text-right" style="width:105px;" id="payroll_'.$id.'_tax_challan_no" name="payrolls['.$id.'][tax_challan_no]" value="'.$payroll['tax_challan_no'].'" />';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="text" class="form-control dtpDate" style="width:105px;" id="payroll_'.$id.'_tax_challan_date" name="payrolls['.$id.'][tax_challan_date]" value="'.stdDate($payroll['tax_challan_date']).'"/>';
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<select class="form-control text-right" id="payroll_'.$id.'_tax_challan_bank_id" name="payrolls['.$id.'][tax_challan_bank_id]">';
            $html .= '<option value="">&nbsp;</option>';

            foreach($banks as $bank) {
                //d($payroll['tax_challan_bank_id'],true);
                if($payroll['tax_challan_bank_id'] == '0'){
                    $html .= '<option value="'.$bank['bank_id'].'" '. ('1' ==$bank["bank_id"]?'selected="true"':''). '>'.$bank['bank_name'].'</option>';
                } else {
                    $html .= '<option value="'.$bank['bank_id'].'" '. ($payroll["tax_challan_bank_id"]==$bank["bank_id"]?'selected="true"':''). '>'.$bank['bank_name'].'</option>';
                }
            }
            $html .= '</select>';
            $html .= '</td>';
            $html .= '<td>';
            if($payroll['tax_challan_branch'] == '') {
            $html .= '<input type="text" class="form-control text-right" style="width:105px;" id="payroll_'.$id.'_tax_challan_branch" name="payrolls['.$id.'][tax_challan_branch]" value="Shaheen Commercial Complex, Karachi" />';
            } else {
                $html .= '<input type="text" class="form-control text-right" style="width:105px;" id="payroll_'.$id.'_tax_challan_branch" name="payrolls['.$id.'][tax_challan_branch]" value="'.$payroll['tax_challan_branch'].'" />';
            }
            $html .= '</td>';
            $html .= '</tr>';

            $id++;
            $total_gross_salary += $payroll['gross_salary'];
            $total_taxable_salary += $payroll['taxable_salary'];
            $total_tax_deduction += $payroll['tax_deduction'];
        }
        $html .= '</tbody>';
        $html .= '<tfoot>';
        $html .= '<tr>';
        $html .= '<td>&nbsp;</td>';
        $html .= '<td>&nbsp;</td>';
        $html .= '<td>&nbsp;</td>';
        $html .= '<td class="text-right">Total:</td>';
        $html .= '<td class="text-right"><span id="total_gross_salary">'.number_format($total_gross_salary,2).'</span></td>';
        $html .= '<td class="text-right"><span id="total_taxable_salary">'.number_format($total_taxable_salary,2).'</span></td>';
        $html .= '<td class="text-right"><span id="total_tax_deduction">'.number_format($total_tax_deduction,2).'</span></td>';
        $html .= '<td class="text-right">&nbsp;</td>';
        $html .= '<td class="text-right">&nbsp;</td>';
        $html .= '<td class="text-right">&nbsp;</td>';
        $html .= '<td class="text-right">&nbsp;</td>';
        $html .= '</tr>';
        $html .= '</tfoot>';
        $html .= '</table>';
        //d(array($payrolls, $html), true);
        $json = array(
            'success' => true,
            'post' => $post,
            'html' => $html
        );

        echo json_encode($json);
        exit;
    }

    protected function updateData($primary_key, $data) {
        //d(array($primary_key,$data),true);
        foreach($data['payrolls'] as $payroll) {
           // d($payroll,true);
            $payroll_data = array(
                'tax_challan_no'=>$payroll['tax_challan_no'],
                'tax_challan_date'=>MySqlDate($payroll['tax_challan_date']),
                'tax_challan_bank_id'=>$payroll['tax_challan_bank_id'],
                'tax_challan_branch'=>$payroll['tax_challan_branch']
            );
            //return $this->model[$this->getAlias()]->edit($this->getAlias(), $data['student_id'], $delete_request);
            $this->model[$this->getAlias()]->edit($this->getAlias(), $payroll['payroll_id'],$payroll_data);
        }
    }

    /*protected function insertData($data) {
        d($data, true);
        ini_set('max_execution_time','400');
        $this->model['loan_installment'] = $this->load->model('payroll/loan_installment');
        $this->model['advance'] = $this->load->model('payroll/advance');
        $this->model['payroll_allowance'] = $this->load->model('payroll/payroll_allowance');
        $this->model['payroll_deduction'] = $this->load->model('payroll/payroll_deduction');
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        //d($data, true);
        foreach($data['payrolls'] as $payroll) {
            if($payroll['selected']==1) {
                $payroll['company_id'] = $this->session->data['company_id'];
                $payroll['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
                $payroll['document_date'] = MySqlDate($data['document_date']);
                $payroll['document_title'] = $data['document_title'];
                $payroll['from_date'] = MySqlDate($data['from_date']);
                $payroll['to_date'] = MySqlDate($data['to_date']);
                $payroll['remaining_payroll'] = $data['remaining_payroll'];
                $payroll_id = $this->model[$this->getAlias()]->add($this->getAlias(), $payroll);

                foreach($payroll['other_allowances'] as $allowance) {
                    $allowance['payroll_id'] = $payroll_id;

                    $this->model['payroll_allowance']->add($this->getAlias(), $allowance);
                }

                //d($payroll['other_deductions'], true);
                foreach($payroll['other_deductions'] as $deduction) {
                    $deduction['payroll_id'] = $payroll_id;

                    $payroll_deduction_id = $this->model['payroll_deduction']->add($this->getAlias(), $deduction);

                    if($deduction['ref_document_type']=='Qarzan Hasana') {
                        $this->model['loan_installment']->edit($this->getAlias(), $deduction['ref_document_id'], array('payroll_id' => $payroll_id, 'payroll_deduction_id' => $payroll_deduction_id));
                    } elseif($deduction['ref_document_type']=='Advance') {
                        $this->model['advance']->edit($this->getAlias(), $deduction['ref_document_id'], array('payroll_id' => $payroll_id, 'payroll_deduction_id' => $payroll_deduction_id));
                    }
                }
                $this->model['employee_registration']->edit($this->getAlias(), $payroll['employee_registration_id'], array('arrears' => 0));
            }
        }
    }*/
}

?>