<?php

class ControllerReportAllowanceCoveringList extends HController {

    protected function getAlias() {
        return 'report/allowance_covering_list';
    }

    protected function getList() {
        parent::getList();

        $this->model['allowance_type'] = $this->load->model('setup/special_allowance_type');
        $this->data['allowance_types'] = $this->model['allowance_type']->getRows();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['document_date'] = stdDate();
        $this->data['href_print_report'] = $this->url->link($this->getAlias() . '/printReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation']="{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function printReport()
    {
        ini_set('max_execution_time', 400);
        $session = $this->session->data;
        $post = $this->request->post;

        $this->model['department'] = $this->load->model('setup/department');
        $this->model['allowance_type'] = $this->load->model('setup/special_allowance_type');
        $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');

        $arrAllowances = $this->model['allowance_type']->getArrays('special_allowance_type_id','special_allowance_type');
        $arrDepartments = $this->model['department']->getArrays('department_id','department_name',['company_id' => $session['company_id']]);

        //d([$arrAllowances, $arrDepartments], true);
        $arrFilter = [];
        $arrWhere = [];
        $arrWhere[] = "sa.`company_id` = '".$session['company_id']."'";
        //$arrWhere[] = "sa.`approved_status` != 'Approved'";
        if(isset($post['approved_status']) && $post['approved_status'] != '') {
            $arrWhere[] = "sa.`approved_status` = '".$post['approved_status']."'";
            $arrFilter['Status'] = $post['approved_status'];
        }
        if(isset($post['allowance_type_id']) && $post['allowance_type_id'] != '') {
            $arrWhere[] = "sa.`special_allowance_type_id` = '".$post['allowance_type_id']."'";
            $arrFilter['Allowance'] = $arrAllowances[$post['allowance_type_id']];
        }
        $arrWhere[] = "sa.`document_date` >= '".MySqlDate($post['from_date'])."'";
        $arrWhere[] = "sa.`document_date` <= '".MySqlDate($post['to_date'])."'";
        $arrFilter['Date'] = $post['from_date'] . ' to '.$post['to_date'];
        if($post['department_id']) {
            $arrWhere[] = "er.department_id IN (".implode(",", $post['department_id']).")";
            if(count($post['department_id']) > 3) {
                $arrFilter['Department'] = count($post['department_id']). ' Departments Selected ';
            } else {
                $aDepartments= [];
                foreach($post['department_id'] as $department_id) {
                    $aDepartments[] = $arrDepartments[$department_id];
                }

                $arrFilter['Department'] = implode(", ", $aDepartments);
            }
        } else {
            $arrFilter['Department'] = 'ALL';
        }
        $where = implode(" AND ", $arrWhere);
        $rows = $this->model['special_allowance']->getRecords($where);

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Covering Letter:'.date('YmdHis'));
        $pdf->SetSubject('Covering Letter');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(10, 40, 5);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        $pdf->data = array(
            'company_name' => $session['company_name'],
            'filter' => $arrFilter
        );
        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(7, 6, 'Sr.', '1', false, 'C');
        $pdf->Cell(15, 6, 'Doc. Date', '1', false, 'C');
        $pdf->Cell(15, 6, 'Doc. No.', '1', false, 'C');
        $pdf->Cell(25, 6, 'Allowance', '1', false, 'C');
        $pdf->Cell(15, 6, 'ITS No.', '1', false, 'C');
        $pdf->Cell(75, 6, 'Full Name', '1', false, 'C');
        $pdf->Cell(15, 6, 'Status', '1', false, 'C');
        $pdf->Cell(15, 6, 'Req. Amt.', '1', false, 'C');
        $pdf->Cell(15, 6, 'App. Amt.', '1', false, 'C');
        $sr =0;
        $pdf->SetFont('helvetica', '', 7);
        foreach($rows as $row) {
            $sr++;
            $pdf->ln(6);
            $pdf->Cell(7, 6, $sr, '1', false, 'R');
            $pdf->Cell(15, 6, stdDate($row['document_date']), '1', false, 'C');
            $pdf->Cell(15, 6, $row['document_identity'], '1', false, 'C');
            $pdf->Cell(25, 6, $row['special_allowance_type'], '1', false, 'L');
            $pdf->Cell(15, 6, $row['its_no'], '1', false, 'C');
            $pdf->Cell(75, 6, $row['employee_name'].' ['.$row['registration_code'].']', '1', false, 'L');
            $pdf->Cell(15, 6, ($row['approved_status']=='Pending Verification'?'P. Verify':$row['approved_status']), '1', false, 'L');
            $pdf->Cell(15, 6, number_format($row['total_amount'],0), '1', false, 'R');
            $pdf->Cell(15, 6, number_format($row['approved_amount'],0), '1', false, 'R');

        }

        $pdf->Output('Allowances Covering Letter:'.date('YmdHis').'.pdf', 'I');
    }
}

class PDF extends TCPDF {
    public $lang;
    public $data;

    //Page header
    public function Header() {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        // Title
        $this->Cell(0, 10, 'Dawat e Hadiyah', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', '', 7);
        foreach($this->data['filter'] as $key => $value) {
            $this->Ln(5);
            $this->Cell(15, 5, $key.':');
            $this->Cell(60, 5, $value);
        }
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(60, 10, 'Allowances Cover Letter', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>