<?php

class ControllerReportEmployeeAttendance extends HController {

    protected function getAlias() {
        return 'report/employee_attendance';
    }

    protected function getList() {
        parent::getList();

        $this->model['company'] = $this->load->model('user/user_access');
        $this->data['companies'] = $this->model['company']->getRows(array('user_id' => $this->session->data['user_id']));

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['document_date'] = stdDate();
        $this->data['href_print_report'] = $this->url->link($this->getAlias() . '/printReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_excel_report'] = $this->url->link($this->getAlias() . '/excelReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation']="{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function printReport() {
        $post = $this->request->post;
        $session = $this->session->data;
        //d([$post, $session], true);
        $from_document_date = MySqlDate($post['from_document_date']);
        $to_document_date = MySqlDate($post['to_document_date']);
        $employee_registration_id = $post['employee_registration_id'];
        $department_id = $post['department_id'];
        $company_id = $this->session->data['company_id'];

        $this->model['filter_data'] = $this->load->model('employee/employee_registration');
        $filter_employee = $this->model['filter_data']->getRow(array('employee_registration_id' => $employee_registration_id));
        $filter_employee_name = $filter_employee['employee_name'];

        $this->model['filter_data'] = $this->load->model('setup/department');
        $where = " department_id IN ('".implode("','",$department_id)."')";
        $filter_department = $this->model['filter_data']->getRows($where);
        // $filter_employee_name = $filter_employee['employee_name'];
        foreach ($filter_department as $key => $value) {
            $filter_department_name[] = $value['department_name'];
        }
        // d($filter_department_name,true);

        $this->model['employee_attendance'] = $this->load->model('employee/employee_attendance');
        if($post['reportType']=='YearlySummary') {

            $filter = array(
                'company_id' => $company_id,
                'from_date' => $session['fiscal_date_from'],
                'to_date' => $session['fiscal_date_to'],
                'employee_registration_id' => $employee_registration_id,
                'department_id' => $department_id,
            );
            $rows = $this->model['employee_attendance']->getAttendanceSummary($filter);

            $pdf = new PDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);
            $pdf->data = array(
                'company_name' => $this->session->data['company_name'],
                'report_title' => 'Employee Attendance',
                'report_type' => 'EmployeeAttendance',
                'emp_name' => $filter_employee_name,
                'dept_name' => $filter_department_name,
            );
            // set document information
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Huzaifa Khambaty');
            $pdf->SetTitle('Employee Leave Summary');
            $pdf->SetSubject('Employee Leave Summary');
            // set margins
            $pdf->SetMargins(15, 55, 5);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(5);

            // set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, 5);

            // add a page
            $pdf->AddPage();
            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(10, 10, 'Sr.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Reg. Code', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Emp. Code', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(75, 10, 'Emp. Name', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(60, 10, 'Department', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 10, 'No. of Leaves', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'LP', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Balance', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'LD', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'WV', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'UA', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'LT', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->ln(10);
            // d($rows,TRUE);
            $pdf->SetFont('freesans', '', 8);
            foreach($rows as $sr_no => $row) {
                $late = $row['total_late']==0 ? 0 : round($row['total_late']/$row['late_deduction']);
                $pdf->Cell(10, 7, ($sr_no+1), 'B', false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['registration_code'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['employee_code'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(75, 7, $row['employee_name'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(60, 7, $row['department_name'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, $row['yearly_leave'], 'B', false, 'C', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $row['total_pay_leave'], 'B', false, 'C', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(15, 7, ($row['yearly_leave']-$row['total_pay_leave']), 'B', false, 'C', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $row['total_deduction_leave'], 'B', false, 'C', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $row['total_waived'], 'B', false, 'C', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $row['total_un_availed'], 'B', false, 'C', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $late, 'B', false, 'C', 0, '', 1, false, 'M', 'M');
                $pdf->ln(7);
            }
            //Close and output PDF document
            $pdf->Output('Employee Attendance - Leave Summary:'.date('YmdHis').'.pdf', 'I');
            exit;
        } elseif($post['reportType']=='Summary') {
            $date_from = new DateTime($from_document_date);
            $date_to = new DateTime($to_document_date);
            $difference = $date_from->diff($date_to);
            $working_days = $difference->days + 1;
            //d([$date_from, $date_to, $difference, $working_days], true);
            $where = '';
            $where .= "ea.`company_id`='".$company_id."'";
            $where .= " AND ea.`attendance_date`>='".$from_document_date."'";
            $where .= " AND ea.`attendance_date`<='".$to_document_date."'";
            if($employee_registration_id) {
                $where .= " AND ea.`employee_registration_id` = '".$employee_registration_id."'";
            }
            if($department_id) {
                $where .= " AND ea.`department_id` IN ('".implode("','",$department_id)."')";
            }

            $filter = array(
                'company_id' => $company_id,
                'from_date' => $from_document_date,
                'to_date' => $to_document_date,
                'employee_registration_id' => $employee_registration_id,
                'department_id' => $department_id,
            );
            $rows = $this->model['employee_attendance']->getAttendanceSummary($filter);
            
            $pdf = new PDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);
            $pdf->data = array(
                'company_name' => $this->session->data['company_name'],
                'report_title' => 'Employee Attendance',
                'report_type' => 'EmployeeAttendance',
                'from_date' => $from_document_date,
                'to_date' => $to_document_date,
                'emp_name' => $filter_employee_name,
                'dept_name' => $filter_department_name,
            );
            // set document information
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Hira Anwer');
            $pdf->SetTitle('Employee Attendance');
            $pdf->SetSubject('Employee Attendance');
            // set margins
            $pdf->SetMargins(5, 55, 5);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(5);

            // set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, 5);

            // add a page
            $pdf->AddPage();
            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(10, 10, 'Sr.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Reg. Code', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Emp. Code', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Machine Code', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(55, 10, 'Emp. Name', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(50, 10, 'Department', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 10, 'Working Days', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'P', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'A', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'LT', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'LP', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'LD', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'WV', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'UA', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'HD', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->ln(10);
            // d($rows,TRUE);
            $pdf->SetFont('freesans', '', 8);
            foreach($rows as $sr_no => $row) {
                $total_absent = $working_days - $row['total_late'] - $row['total_pay_leave'] - $row['total_deduction_leave'] - $row['total_waived'] - $row['total_un_availed'] - $row['total_present'] - $row['total_holiday'];

                $pdf->Cell(10, 7, ($sr_no+1), 'B', false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['registration_code'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['employee_code'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['attendance_code'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(55, 7, $row['employee_name'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(50, 7, $row['department_name'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, $working_days, 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $row['total_present'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $total_absent, 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $row['total_late'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $row['total_pay_leave'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $row['total_deduction_leave'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $row['total_waived'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $row['total_un_availed'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $row['total_holiday'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->ln(7);
            }
            //Close and output PDF document
            $pdf->Output('Summary-Employee Attendance:'.date('YmdHis').'.pdf', 'I');
            exit;
        } else {
            $where = '';
            $where .= "`company_id`='".$company_id."'";
            $where .= " AND `attendance_date`>='".$from_document_date."'";
            $where .= " AND `attendance_date`<='".$to_document_date."'";
            if($employee_registration_id) {
                $where .= " AND `employee_registration_id` = '".$employee_registration_id."'";
            }
            if($department_id) {
                $where .= " AND `department_id` IN ('".implode("','",$department_id)."')";
            }
            $rows = $this->model['employee_attendance']->getRows($where, array('employee_name','attendance_date'));
            // d([$where, $rows], true);
            // d($rows,true);
            $pdf = new PDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);
            $pdf->data = array(
                'company_name' => $this->session->data['company_name'],
                'report_title' => 'Employee Attendance',
                'report_type' => 'EmployeeAttendance',
                'from_date' => $from_document_date,
                'to_date' => $to_document_date,
                'emp_name' => $filter_employee_name,
                'dept_name' => $filter_department_name,
            );
            // set document information
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Hira Anwer');
            $pdf->SetTitle('Employee Attendance');
            $pdf->SetSubject('Employee Attendance');

            // set margins
            $pdf->SetMargins(5, 55, 5);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(5);

            // set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, 5);

            // add a page
            $pdf->AddPage();
            $pdf->SetFont('freesans', '', 8);
            $pdf->Cell(10, 10, 'Sr.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Reg. Code', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Emp. Code', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Machine Code', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(55, 10, 'Emp. Name', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(30, 10, 'Department', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 10, 'Shift Title', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Shift In', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Shift Out', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Date', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Time In', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 10, 'Time Out', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 10, 'Status', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(30, 10, 'Remarks', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->ln(10);
            // d($rows,TRUE);
            $pdf->SetFont('freesans', '', 8);
            foreach($rows as $sr_no => $row) {
                $pdf->Cell(10, 7, ($sr_no+1), 'B', false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['registration_code'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['employee_code'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['attendance_code'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(55, 7, $row['employee_name'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, $row['department_name'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, $row['shift_title'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['shift_in'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['shift_out'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['attendance_date'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['time_in'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(15, 7, $row['time_out'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(10, 7, $row['status'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, $row['remarks'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->ln(7);
            }
            //Close and output PDF document
            $pdf->Output('Detail-Employee Attendance:'.date('YmdHis').'.pdf', 'I');
            exit;
        }
    }

    public function excelReport() {
        include_once(DIR_SYSTEM.'library/PHPExcel.php');
        include_once(DIR_SYSTEM.'library/PHPExcel/Classes/PHPExcel/Writer/Excel5.php');
        $post = $this->request->post;
        $session = $this->session->data;
        // d($post,true);
        $from_document_date = MySqlDate($post['from_document_date']);
        $to_document_date = MySqlDate($post['to_document_date']);
        $employee_registration_id = $post['employee_registration_id'];
        $department_id = $post['department_id'];
        $company_id = $session['company_id'];

        $this->model['employee_attendance'] = $this->load->model('employee/employee_attendance');
        if($post['reportType']=='YearlySummary') {
            $filter = array(
                'company_id' => $company_id,
                'from_date' => $session['fiscal_date_from'],
                'to_date' => $session['fiscal_date_to'],
                'employee_registration_id' => $employee_registration_id,
                'department_id' => $department_id,
            );
            $rows = $this->model['employee_attendance']->getAttendanceSummary($filter);
            $columns = array(
                'sr' => 'Sr.',
                'registration_code' => 'Reg. Code',
                'employee_code' => 'Emp. Code',
                'employee_name' => 'Emp. Name',
                'department_name' => 'Department',
                'yearly_leave' => 'No. of Leaves',
                'total_deduction_leave' => 'Leave With Deduction',
                'total_balance' => 'Balance',
                'total_pay_leave' => 'Leave With Pay',
                'total_waived' => 'Leave Waved',
                'total_un_availed' => 'Leave UN Availed',
                'total_late' => 'Late',
            );

            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Huzaifa Khambaty")
                ->setLastModifiedBy("Huzaifa Khambaty")
                ->setTitle('Attendance Summary Report')
                ->setSubject('Attendance Summary Report');
            $row_no = 1;
            $no_of_columns = count($columns);
            $start_column_idx = 0;
            $end_column_idx = $start_column_idx + $no_of_columns - 1;

            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);

            $objPHPExcel->data = array(
                'company_name' => $this->session->data['company_name'],
                'report_name' => 'Attendance Summary Report'
            );
            $rowCount = 1;
            $objPHPExcel->getActiveSheet()->mergeCells('A'.($rowCount).":N".($rowCount));
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $this->session->data['company_name']);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->applyFromArray(
                array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                    'font' => array(
                        'size' => 25
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'ebebeb')
                    )
                )
            );
            $rowCount ++;
            $objPHPExcel->getActiveSheet()->mergeCells('A'.($rowCount).":N".($rowCount));
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Attendance Summary Report');
            $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->applyFromArray(
                array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                    'font' => array(
                        'size' => 20
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'ebebeb')
                    )
                )
            );
            $rowCount ++;

            $objPHPExcel->getActiveSheet()->mergeCells('A'.($rowCount).":N".($rowCount));
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'From:'.$from_document_date.' - To:'.$to_document_date);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->applyFromArray(
                array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                    'font' => array(
                        'size' => 20
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'ebebeb')
                    )
                )
            );
            $rowCount ++;
            $rowCount ++;

            $objPHPExcel->getActiveSheet()->mergeCells('A'.($rowCount).":N".($rowCount));
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, '');
            $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->getFill('ebebeb');
            $rowCount ++;

            $row_no++;
            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            // d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells));
            $style = array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            );
            $objPHPExcel->getActiveSheet()
                ->mergeCells($merge_cells)
                ->setCellValue('A' . $row_no, 'Attendance Summary Report')
                ->getStyle($merge_cells)
                ->getAlignment()
                ->applyFromArray($style);


            $row_no++;
            $row_no++;
            $column_no = 0;
            foreach ($columns as $key => $column) {
                // d(array($column_no,$row_no,$column),true);
                $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($column_no, $row_no, $column)
                    ->getStyleByColumnAndRow($column_no, $row_no)
                    ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => '000000')
                            ),
                            'font' => array(
                                'color' => array('rgb' => 'ffffff')
                            )
                        )
                    );
                $column_no++;
            }
            $row_no++;
            $sr=0;
            $column_no = 0;
            foreach($rows as $row) {
                $row_no++;
                $column_no = 0;
                foreach ($columns as $key => $column) {
                    if($key=='sr') {
                        $sr++;
                        $value = $sr;
                    } elseif ($key=='total_late') {
                        $value = round($row['total_late']/$row['late_deduction']);
                    } elseif ($key=='total_balance') {
                        $value = $row['yearly_leave'] - ($row['total_pay_leave'] + $row['total_deduction_leave']+round($row['total_late']/$row['late_deduction']));
                    } else {
                        $value = $row[$key];
                    }
                    // d($column_no);
                    // d($row_no);
                    // d($value);
                    $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($column_no, $row_no, $value);
                    $column_no++;
                }
            }
            // exit;
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="AttendanceSummary.xlsx"');
            header('Cache-Control: max-age=0');
            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
            $objWriter->save('php://output');
            exit;
        } elseif($post['reportType']=='Summary') {
            $date_from = new DateTime($from_document_date);
            $date_to = new DateTime($to_document_date);
            $difference = $date_from->diff($date_to);
            $working_days = $difference->days + 1;

            $where = '';
            $where .= "ea.`company_id`='".$company_id."'";
            $where .= " AND ea.`attendance_date`>='".$from_document_date."'";
            $where .= " AND ea.`attendance_date`<='".$to_document_date."'";
            if($employee_registration_id) {
                $where .= " AND ea.`employee_registration_id` = '".$employee_registration_id."'";
            }
            if($department_id) {
                $where .= " AND ea.`department_id` IN ('".implode("','",$department_id)."')";
            }

            $columns = array(
                'sr' => 'Sr.',
                'registration_code' => 'Reg. Code',
                'employee_code' => 'Emp. Code',
                'attendance_code' => 'Machine Code',
                'employee_name' => 'Emp. Name',
                'department_name' => 'Department',
                'working_days' => 'Working Days',
                'total_absent' => 'Absent',
                'total_late' => 'Late',
                'total_pay_leave' => 'Leave Without Deduction',
                'total_deduction_leave' => 'Leave With Deduction',
                'total_present' => 'Present',
                'total_holiday' => 'Holiday',
                'note' => 'Note'
            );
            $rows = $this->model['employee_attendance']->getAttendanceSummary($where);
            // d([$where, $rows], true);   
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Huzaifa Khambaty")
                ->setLastModifiedBy("Huzaifa Khambaty")
                ->setTitle('Attendance Summary Report')
                ->setSubject('Attendance Summary Report');
            $row_no = 1;
            $no_of_columns = count($columns);
            $start_column_idx = 0;
            $end_column_idx = $start_column_idx + $no_of_columns - 1;

            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);

            $objPHPExcel->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_name' => 'Attendance Summary Report'
            );
            $rowCount = 1;
            $objPHPExcel->getActiveSheet()->mergeCells('A'.($rowCount).":N".($rowCount));
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $this->session->data['company_name']);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->applyFromArray(
                array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                    'font' => array(
                        'size' => 25
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'ebebeb')
                    )
                )
            );
            $rowCount ++;
            $objPHPExcel->getActiveSheet()->mergeCells('A'.($rowCount).":N".($rowCount));
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Attendance Summary Report');
            $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->applyFromArray(
                array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                    'font' => array(
                        'size' => 20
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'ebebeb')
                    )
                )
            );
            $rowCount ++;
            
            $objPHPExcel->getActiveSheet()->mergeCells('A'.($rowCount).":N".($rowCount));
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'From:'.$from_document_date.' - To:'.$to_document_date);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->applyFromArray(
                array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                    'font' => array(
                        'size' => 20
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'ebebeb')
                    )
                )
            );
            $rowCount ++;
            $rowCount ++;

            $objPHPExcel->getActiveSheet()->mergeCells('A'.($rowCount).":N".($rowCount));
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, '');
            $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->getFill('ebebeb');
            $rowCount ++;

            $row_no++;
            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            // d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells));
            $style = array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            );
            $objPHPExcel->getActiveSheet()
                ->mergeCells($merge_cells)
                ->setCellValue('A' . $row_no, 'Attendance Summary Report')
                ->getStyle($merge_cells)
                ->getAlignment()
                ->applyFromArray($style);


            $row_no++;
            $row_no++;
            $column_no = 0;
            foreach ($columns as $key => $column) {
                // d(array($column_no,$row_no,$column),true);
                $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($column_no, $row_no, $column)
                    ->getStyleByColumnAndRow($column_no, $row_no)
                    ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => '000000')
                            ),
                            'font' => array(
                                'color' => array('rgb' => 'ffffff')
                            )
                        )
                    );
                $column_no++;
            }
            $row_no++;
            $sr=0;
            $column_no = 0;
            foreach($rows as $row) {
                $row_no++;
                $column_no = 0;
                foreach ($columns as $key => $column) {
                    if($key=='sr') {
                        $sr++;
                        $value = $sr;
                    } elseif ($key=='working_days') {
                        $value = $working_days;
                    } elseif ($key=='note') {
                        $value = round($row['late_deduction']).' late = 1 Absent';
                    } elseif ($key=='total_absent') {
                        $total_absent = $working_days - $row['total_present'] - $row['total_late'] - $row['total_pay_leave'] - $row['total_deduction_leave'] - $row['total_holiday'];
                        if($total_absent < 0) {
                            $row['total_present'] += $total_absent;
                            $value = 0;
                        } else {
                            $value = $total_absent;
                        }
                    } else {
                        $value = $row[$key];
                    }
                    // d($column_no);
                    // d($row_no);
                    // d($value);
                    $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($column_no, $row_no, $value);
                    $column_no++;
                }
            }
            // exit;
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="AttendanceSummary.xlsx"');
            header('Cache-Control: max-age=0');
            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
            $objWriter->save('php://output');
            exit;
        } else {
            $where = '';
            $where .= "`company_id`='".$company_id."'";
            $where .= " AND `attendance_date`>='".$from_document_date."'";
            $where .= " AND `attendance_date`<='".$to_document_date."'";
            if($employee_registration_id) {
                $where .= " AND `employee_registration_id` = '".$employee_registration_id."'";
            }
            if($department_id) {
                $where .= " AND `department_id` IN ('".implode("','",$department_id)."')";
            }

            $columns = array(
                'sr' => 'Sr.',
                'registration_code' => 'Reg. Code',
                'employee_code' => 'Emp. Code',
                'attendance_code' => 'Machine Code',
                'employee_name' => 'Emp. Name',
                'department_name' => 'Department',
                'shift_title' => 'Shift Title',
                'shift_in' => 'Shift IN',
                'shift_out' => 'Shift OUT',
                'attendance_date' => 'Date',
                'time_in' => 'Time IN',
                'time_out' => 'Time OUT',
                'status' => 'Status',
                'remarks' => 'Remarks',
            );
            $rows = $this->model['employee_attendance']->getRows($where, array('employee_name','attendance_date'));
            // d([$where, $rows], true);

            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Huzaifa Khambaty")
                ->setLastModifiedBy("Huzaifa Khambaty")
                ->setTitle('Attendance Detailed Report')
                ->setSubject('Attendance Detailed Report');
            $row_no = 2;
            $no_of_columns = count($columns);
            $start_column_idx = 0;
            $end_column_idx = $start_column_idx + $no_of_columns - 1;

            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
            $objPHPExcel->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_name' => 'Attendance Detailed Report'
            );
                $rowCount = 1;
                $objPHPExcel->getActiveSheet()->mergeCells('A'.($rowCount).":N".($rowCount));
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $this->session->data['company_name']);
                $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->applyFromArray(
                    array(
                        'alignment' => array(
                            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                        ),
                        'font' => array(
                            'size' => 25
                        ),
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => 'ebebeb')
                        )
                    )
                );
                $rowCount ++;
                $objPHPExcel->getActiveSheet()->mergeCells('A'.($rowCount).":N".($rowCount));
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Attendance Summary Report');
                $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->applyFromArray(
                    array(
                        'alignment' => array(
                            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                        ),
                        'font' => array(
                            'size' => 20
                        ),
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => 'ebebeb')
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->mergeCells('A'.($rowCount).":N".($rowCount));
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'From:'.$from_document_date.' - To:'.$to_document_date);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->applyFromArray(
                array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                    'font' => array(
                        'size' => 20
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'ebebeb')
                    )
                )
            );
            $rowCount ++;
            $rowCount ++;
                $rowCount ++;
                $objPHPExcel->getActiveSheet()->mergeCells('A'.($rowCount).":N".($rowCount));
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, '');
                $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->getFill('ebebeb');
                $rowCount ++;
            // $style = array(
            //     'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            // );
            // $objPHPExcel->getActiveSheet()
            //     ->mergeCells($merge_cells)
            //     ->setCellValue('A' . $row_no, '')
            //     ->getStyle($merge_cells)
            //     ->getAlignment()
            //     ->applyFromArray($style);

            $row_no++;
            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
            $style = array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            );
            $objPHPExcel->getActiveSheet()
                ->mergeCells($merge_cells)
                ->setCellValue('A' . $row_no, 'Attendance Detail Report')
                ->getStyle($merge_cells)
                ->getAlignment()
                ->applyFromArray($style);


            $row_no++;
            $text = "P=Present, LT=Late, LP=Leave without Deduction, LD=Leave with Deduction, H=Holiday";
            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
            $style = array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            );
            $objPHPExcel->getActiveSheet()
                ->mergeCells($merge_cells)
                ->setCellValue('A' . $row_no, $text)
                ->getStyle($merge_cells)
                ->getAlignment()
                ->applyFromArray($style);
            $row_no++;
            $row_no++;
            $column_no = 0;
            foreach ($columns as $key => $column) {
                $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($column_no, $row_no, $column)
                    ->getStyleByColumnAndRow($column_no, $row_no)
                    ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => '000000')
                            )
                        ,
                            'font' => array(
                                'color' => array('rgb' => 'ffffff')
                            )
                        )
                    );
                $column_no++;
            }

            $sr=0;
            foreach($rows as $row) {
                $row_no++;
                $column_no = 0;
                foreach ($columns as $key => $column) {
                    if($key=='sr') {
                        $sr++;
                        $value = $sr;
                    } else {
                        $value = $row[$key];
                    }
                    $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($column_no, $row_no, $value);
                    $column_no++;
                }
            }

            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="AttendanceDetail.xlsx"');
            header('Cache-Control: max-age=0');
            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
            $objWriter->save('php://output');
            exit;
        }
    }

    private function cellsToMergeByColsRow($start = -1, $end = -1, $row = -1)
    {
        $merge = 'A1:A1';
        if ($start >= 0 && $end >= 0 && $row >= 0) {
            $start = PHPExcel_Cell::stringFromColumnIndex($start);
            $end = PHPExcel_Cell::stringFromColumnIndex($end);
            $merge = "$start{$row}:$end{$row}";
        }
        return $merge;
    }
}

class PDF extends TCPDF {
    public $data;
    //Page header
    public function Header() {
       
        // Set font
        $this->SetFont('freesans', 'B', 20);
        // Title
        $this->SetFont('freesans', 'B', 14);
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('freesans', 'B', 9);
        $this->Ln(10);
        $this->Cell(0, 7, 'From: '.$this->data['from_date'].' - To: '.$this->data['to_date'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(5);
        if(!empty($this->data['emp_name']))
        {
             $this->Cell(0, 7, 'Employee: '.$this->data['emp_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
             $this->Ln(5);     
        }

        if(!empty($this->data['dept_name']))
        {
            $this->Cell(0, 7, 'Department: '.implode(",",$this->data['dept_name']), 0, false, 'C', 0, '', 0, false, 'M', 'M');  
             $this->Ln(5);  
        }

        $this->Cell(0, 7,'P=Present, LT=Late, LP=Leave without Deduction, LD=Leave with Deduction, WV=Leave Waved, UA=Leave Un-availed, H=Holiday', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(5);
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-10);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(90, 10, 'Employee Attendance', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(90, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(90, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>