<?php

class ControllerReportEmployeeData extends HController {

    protected function getAlias() {
        return 'report/employee_data';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->model['company'] = $this->load->model('setup/company');
        $this->data['companies'] = $this->model['company']->getRows();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['employee_profile'] = $this->load->model('employee/employee_profile');
        $this->data['employees'] = $this->model['employee_profile']->getRows(array('company_id' => $this->session->data['company_id']));
        // d($this->data['employees'], true);

        $this->data['company_id'] = $this->session->data['company_id'];
        $this->data['document_date'] = stdDate();
        $this->data['href_get_departments'] = $this->url->link($this->getAlias() . '/getDepartments', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_get_report'] = $this->url->link($this->getAlias() . '/getReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_report'] = $this->url->link($this->getAlias() . '/printReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_excel'] = $this->url->link($this->getAlias() . '/printExcel', 'token=' . $this->session->data['token'], 'SSL');


        $columns = array();
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 's_no',
            'display_name' => 'Sr.'
        );
        $columns[] = array(
            'column_ratio' => 4,
            'column_name' => 'company_name',
            'display_name' => 'Company'
        );
        $columns[] = array(
            'column_ratio' => 4,
            'column_name' => 'department_name',
            'display_name' => 'Department'
        );
        $columns[] = array(
            'column_ratio' => 4,
            'column_name' => 'designation_name',
            'display_name' => 'Designation'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'employee_code',
            'display_name' => 'Emp. Code'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'registration_code',
            'display_name' => 'Reg. Code'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'attendance_code',
            'display_name' => 'Att. Code'
        );
        $columns[] = array(
            'column_ratio' => 4,
            'column_name' => 'employee_name',
            'display_name' => 'Full Name'
        );
        $columns[] = array(
            'column_ratio' => 4,
            'column_name' => 'employee_arabic_name',
            'display_name' => 'Name in Arabic'
        );
        $columns[] = array(
            'column_ratio' => 3,
            'column_name' => 'surname',
            'display_name' => 'Surname'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'profile_joining_date',
            'display_name' => 'Joining Date'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'profile_joining_date_hijri',
            'display_name' => 'Joining Date Hijri'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'its_no',
            'display_name' => 'ITS No.'
        );
        $columns[] = array(
            'column_ratio' => 3,
            'column_name' => 'shift_title',
            'display_name' => 'Shift'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'total_payroll',
            'display_name' => 'Total Payroll'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'arrears',
            'display_name' => 'Arrears'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'late_deduction',
            'display_name' => 'Late Deductiontion'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'dob',
            'display_name' => 'DOB'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'gender',
            'display_name' => 'Gender'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'marital_status',
            'display_name' => 'Marital Status'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'mobile_no',
            'display_name' => 'Mobile No.'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'phone_no',
            'display_name' => 'Phone No.'
        );
        $columns[] = array(
            'column_ratio' => 3,
            'column_name' => 'email',
            'display_name' => 'Email'
        );
        $columns[] = array(
            'column_ratio' => 3,
            'column_name' => 'city',
            'display_name' => 'City'
        );
        $columns[] = array(
            'column_ratio' => 3,
            'column_name' => 'area',
            'display_name' => 'Area'
        );
        $columns[] = array(
            'column_ratio' => 3,
            'column_name' => 'nationality',
            'display_name' => 'Nationality'
        );
        $columns[] = array(
            'column_ratio' => 3,
            'column_name' => 'cnic_no',
            'display_name' => 'CNIC NO.'
        );
        $columns[] = array(
            'column_ratio' => 4,
            'column_name' => 'cnic_name',
            'display_name' => 'CNIC Name'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'cnic_expiry',
            'display_name' => 'CNIC Expiry'
        );
        $columns[] = array(
            'column_ratio' => 6,
            'column_name' => 'cnic_address',
            'display_name' => 'CNIC Address'
        );
        $columns[] = array(
            'column_ratio' => 4,
            'column_name' => 'bank_name',
            'display_name' => 'Bank Name'
        );
        $columns[] = array(
            'column_ratio' => 4,
            'column_name' => 'bank_title',
            'display_name' => 'Bank Title'
        );
        $columns[] = array(
            'column_ratio' => 4,
            'column_name' => 'bank_account',
            'display_name' => 'Bank Account'
        );
         $columns[] = array(
            'column_ratio' => 4,
            'column_name' => 'bank_iban',
            'display_name' => 'Bank IBAN'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'eobi_no',
            'display_name' => 'EOBI No.'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'eobi_date',
            'display_name' => 'EOBI Date'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'eobi_sno',
            'display_name' => 'EOBI SNo.'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'probation_from',
            'display_name' => 'Probation From'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'probation_to',
            'display_name' => 'Probation To'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'ramzan_enayat',
            'display_name' => 'Ramazan Enayat'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'nicop_no',
            'display_name' => 'NICOP No.'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'nicop_name',
            'display_name' => 'NICOP Name'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'nicop_expiry',
            'display_name' => 'NICOP Expiry'
        );
        $columns[] = array(
            'column_ratio' => 4,
            'column_name' => 'nicop_address',
            'display_name' => 'NICOP Address'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'passport_no',
            'display_name' => 'Passport No.'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'passport_name',
            'display_name' => 'Passport Name'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'passport_expiry',
            'display_name' => 'Passport Expiry'
        );
        $columns[] = array(
            'column_ratio' => 3,
            'column_name' => 'passport_address',
            'display_name' => 'Passport Address'
        );
        $this->data['columns'] = $columns;

        $this->data['strValidation']="{
            'rules':{
                'from_document_date': {'required':true},
                'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function getDepartments() {
        $post = $this->request->post;
        $company_id = $post['company_id'];

        $this->model['department'] = $this->load->model('setup/department');
        $departments = $this->model['department']->getRows(['company_id' => $company_id]);
        $html = '<option value="">&nbsp;</option>';
        foreach($departments as $department) {
            $html .= '<option value="'.$department['department_id'].'">'.$department['department_name'].'</option>';
        }

        $json = [
            'success' => true,
            'departments' => $html
        ];

        echo json_encode($json);
        exit;
    }

    public function printReport() {
        ini_set('max_execution_time',400);
        $post = $this->request->get;
        // d($post,true);
        $lang = $this->load->language($this->getAlias());
        $from_joining_date = $post['from_joining_date'];
        $to_joining_date = $post['to_joining_date'];
        $from_leaving_date = $post['from_leaving_date'];
        $to_leaving_date = $post['to_leaving_date'];
        $company_id = $post['company_id'];
        $department_id = $post['department_id'];
        $status_id = $post['status_id'];
        $eobi_status = $post['eobi_status'];
        $display_columns = $post['display_columns'];
        //d($post, true);
        $arrSortOrder = [];
        foreach($display_columns as $column) {
            if($column['column_name'] != 's_no') {
                $arrSortOrder[] = $column['column_name'];
            }
        }
        $arrSortOrder = array_splice($arrSortOrder,0,4);

        $arrWhere = array();
        $arrFilter = array();
        if(!empty($company_id))
        {
            $arrWhere[] = " `company_id` = ".$company_id."";

            $this->model['company'] = $this->load->model('setup/company');
            $row = $this->model['company']->getRow(['company_id' => $company_id]);
            $arrFilter[] = " `Company`: ".$row['company_name']."";
        }
        if(!empty($department_id))
        {
            $arrWhere[] = " `department_id` = ".$department_id."";

            $this->model['department'] = $this->load->model('setup/department');
            $row = $this->model['department']->getRow(['department_id' => $department_id]);
            $arrFilter[] = " `Department`: ".$row['name']."";
        }
        if(!empty($from_joining_date))
        {
            $arrWhere[] = " `joining_date` >= '".MySqlDate($from_joining_date)."'";
            $arrFilter[] = " `Joining From Dt.`: ".$from_joining_date."";
        }
        if(!empty($to_joining_date))
        {
            $arrWhere[] = " `joining_date` <= '".MySqlDate($to_joining_date)."'";
            $arrFilter[] = " `Joining To Dt.`: ".$to_joining_date."";
        }
        if(!empty($from_leaving_date))
        {
            $arrWhere[] = " `leaving_date` >= '".MySqlDate($from_leaving_date)."'";
            $arrFilter[] = " `Leaving From Dt.`: ".$from_leaving_date."";
        }
        if(!empty($to_leaving_date))
        {
            $arrWhere[] = " `leaving_date` <= '".MySqlDate($to_leaving_date)."'";
            $arrFilter[] = " `Leaving To Dt.`: ".$to_joining_date."";
        }
        if(!empty($status_id))
        {
            $arrWhere[] = " `status` = '".$status_id."'";
            $arrFilter[] = " `Status`: ".$status_id."";
        }
        if(!empty($eobi_status))
        {
            if($eobi_status == 'Registered')
            {
                $arrWhere[] = " `eobi_no` IS NOT NULL";
                $arrFilter[] = " `eobi_no` IS NOT NULL";
            }
            else if($eobi_status == 'Not-Registered')
            {
                $arrWhere[] = " `eobi_no` IS NULL";
                $arrFilter[] = " `eobi_no` IS NULL";
            }
        }
        // d($arrWhere);
        $where = implode(' AND ', $arrWhere);
        $display_filter = 'FILTER :: '.implode('; ', $arrFilter);
        //d($where);
        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $rows = $this->model['employee']->getRows($where, $arrSortOrder);
        //d($rows,true);
        // $post['page_size'] = 'A4';
        // $post['page_orientation'] = 'L';
        $page_width = array();
        $page_width['A4']['P'] = 190;
        $page_width['A4']['L'] = 277;
        $page_width['A3']['P'] = 277;
        $page_width['A3']['L'] = 400;

        $pdf = new PDF($post['page_orientation'], PDF_UNIT, $post['page_size'], true, 'UTF-8', false);
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Hira Anwer');
        $pdf->SetTitle('Employee Data');
        $pdf->SetSubject('Employee Data');
        $pdf->SetMargins(15, 30, 5);
        $pdf->SetHeaderMargin(5);
        $pdf->SetFooterMargin(2);

        $report_width = $page_width[$post['page_size']][$post['page_orientation']];
        $total_ratio = 0;
        foreach($display_columns as $column) {
            $total_ratio += $column['column_ratio'];
        }
        //d($display_columns, true);
        //$width = floor($report_width/$total_ratio);
        $width = $report_width/$total_ratio;
        if($width < 5) {
            $this->session->data['error_warning'] = 'Too many columns ' . $report_width . ' / '.$total_ratio;
            $this->redirect($this->url->link('report/employee_data', 'token=' . $this->session->data['token'], 'SSL'));
        }
        foreach($display_columns as $row_id => $column) {
            $display_columns[$row_id]['column_width']=($width * $column['column_ratio']);
        }
        //Set Header
        $pdf->data = array(
            'report_title' => 'Employee Data',
            'report_width' => $report_width,
            'display_filter' => $display_filter,
            'display_columns' => $display_columns,
            'page_size' => $post['page_size'],
            'page_orientation' => $post['page_orientation'],
        );

        $pdf->SetFont('times', 'B', 8);
        $pdf->AddPage();
        $sr = 0;
        // d($display_columns,true);
        foreach($rows as $key => $row) {
            $sr++;
            foreach($display_columns as $column) {
                // d($column);
                if($column['column_name'] == 's_no') {
                    $pdf->Cell($column['column_width'], 8, $sr, 1, 0, 'L', 0, '', 1);
                } elseif($column['column_name'] == 'employee_arabic_name') {
                    $pdf->SetFont('fatimi5', 'B', 10);
                    $pdf->Cell($column['column_width'],8,$row[$column['column_name']],1,0,'L',0,'',1);
                    $pdf->SetFont('times', 'B', 8);
                } else {
                    // d($column['display_name']);
                    // d($column['column_name']);
                    // d($row);
                    $pdf->Cell($column['column_width'],8,$row[$column['column_name']],1,0,'L',0,'',1);
                }
            }
            $pdf->ln(8);
        }
        
        $pdf->Output('Payment Report:'.date('YmdHis').'.pdf', 'I');       
    }

    public function printExcel()
    {
        ini_set('max_execution_time',400);
        $post = $this->request->get;
        $lang = $this->load->language($this->getAlias());
        $from_joining_date = $post['from_joining_date'];
        $to_joining_date = $post['to_joining_date'];
        $from_leaving_date = $post['from_leaving_date'];
        $to_leaving_date = $post['to_leaving_date'];
        $company_id = $post['company_id'];
        $department_id = $post['department_id'];
        $status_id = $post['status_id'];
        $eobi_status = $post['eobi_status'];
        $display_columns = $post['display_columns'];

        $arrSortOrder = [];
        foreach($display_columns as $column) {
            if($column['column_name'] != 's_no') {
                $arrSortOrder[] = $column['column_name'];
            }
        }
        $arrSortOrder = array_splice($arrSortOrder,0,4);
        $arrWhere = array();
        $arrFilter = array();
        if(!empty($company_id))
        {
            $arrWhere[] = " `company_id` = ".$company_id."";

            $this->model['company'] = $this->load->model('setup/company');
            $row = $this->model['company']->getRow(['company_id' => $company_id]);
            $arrFilter[] = " `Company`: ".$row['company_name']."";
        }
        if(!empty($department_id))
        {
            $arrWhere[] = " `department_id` = ".$department_id."";

            $this->model['department'] = $this->load->model('setup/department');
            $row = $this->model['department']->getRow(['department_id' => $department_id]);
            $arrFilter[] = " `Department`: ".$row['name']."";
        }
        if(!empty($from_joining_date))
        {
            $arrWhere[] = " `joining_date` >= '".MySqlDate($from_joining_date)."'";
            $arrFilter[] = " `Joining From Dt.`: ".$from_joining_date."";
        }
        if(!empty($to_joining_date))
        {
            $arrWhere[] = " `joining_date` <= '".MySqlDate($to_joining_date)."'";
            $arrFilter[] = " `Joining To Dt.`: ".$to_joining_date."";
        }
        if(!empty($from_leaving_date))
        {
            $arrWhere[] = " `leaving_date` >= '".MySqlDate($from_leaving_date)."'";
            $arrFilter[] = " `Leaving From Dt.`: ".$from_leaving_date."";
        }
        if(!empty($to_leaving_date))
        {
            $arrWhere[] = " `leaving_date` <= '".MySqlDate($to_leaving_date)."'";
            $arrFilter[] = " `Leaving To Dt.`: ".$to_joining_date."";
        }
        if(!empty($status_id))
        {
            $arrWhere[] = " `status` = '".$status_id."'";
            $arrFilter[] = " `Status`: ".$status_id."";
        }
        if(!empty($eobi_status))
        {
            if($eobi_status == 'Registered')
            {
                $arrWhere[] = " `eobi_no` IS NOT NULL";
                $arrFilter[] = " `eobi_no` IS NOT NULL";
            }
            else if($eobi_status == 'Not-Registered')
            {
                $arrWhere[] = " `eobi_no` IS NULL";
                $arrFilter[] = " `eobi_no` IS NULL";
            }
        }
        // d($arrWhere);
        $where = implode(' AND ', $arrWhere);
        $display_filter = 'FILTER :: '.implode('; ', $arrFilter);
        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $rows = $this->model['employee']->getRows($where, $arrSortOrder);
        //d([$where, $arrSortOrder], true);
        $columns = array_keys($rows[0]);
        $no_of_columns = count($display_columns);
        $start_column_idx = 0;
        $end_column_idx = $start_column_idx + $no_of_columns -1;

        try {
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Huzaifa Khambaty")
                ->setLastModifiedBy("Huzaifa Khambaty")
                ->setTitle('Employee Data')
                ->setSubject('Employee Data');

            $row_no = 0;
            $objPHPExcel->setActiveSheetIndex(0);

            $row_no++;
            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            // d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
            $objPHPExcel->getActiveSheet()
                ->mergeCells($merge_cells)
                ->setCellValue('A'.$row_no,'Employee Data');
            $objPHPExcel->getActiveSheet()->getStyle('A'.$row_no)->applyFromArray(
                array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                    'font' => array(
                        'size' => 25
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'ebebeb')
                    )
                )
            );

            // Set the Report Title
            $row_no++;
            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
            $style = array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            );
            $objPHPExcel->getActiveSheet()
                ->mergeCells($merge_cells)
                ->setCellValue('A'.$row_no,$display_filter)
                ->getStyle($merge_cells)
                ->getAlignment()
                ->applyFromArray($style);

            // Set The Header Column
            $column_no = 0;
            $row_no++;
            foreach($display_columns as $column) {
                $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($column_no, $row_no, $column['display_name'])
                    ->getStyleByColumnAndRow($column_no, $row_no)
                    ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => '000000')
                            )
                        ,
                            'font'  => array(
                                'color' => array('rgb' => 'ffffff')
                            )
                        )
                    )
                ;
                $column_no++;
            }

            // Set The Rows
            $s_no = 1;
            foreach($rows as $variable_name => $row) {
                $column_no = 0;
                $row_no++;
                foreach($display_columns as $column) {
                    if($column['column_name'] == 's_no')
                    {
                        $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($column_no, $row_no, $s_no)
                        ->getStyleByColumnAndRow($column_no, $row_no)
                        ->applyFromArray(array(
                                    'font'  => array(
                                    'color' => array('rgb' => '000000'))));
                        $column_no++;
                        $s_no++;    
                    }
                    else
                    {
                       $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($column_no, $row_no, $row[$column['column_name']])
                        ->getStyleByColumnAndRow($column_no, $row_no)
                        ->applyFromArray(array(
                                    'font'  => array(
                                    'color' => array('rgb' => '000000'))));
                        $column_no++; 
                    }
                }
            }

            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            ob_end_clean();
            $file_name = 'Employee Data' .'_' . date('YmdHis');
            //header('Content-type: application/vnd.ms-excel');
            header('Content-type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');

            // It will be called file.xls
            header('Content-Disposition: attachment; filename="'.$file_name.'.xlsx"');

            // Write file to the browser
            $objWriter->save('php://output');
            //$objWriter->save($file_name);
        } catch(Exception $e) {
            d($e, true);
        }
    }

    private function cellsToMergeByColsRow($start = -1, $end = -1, $row = -1){
        $merge = 'A1:A1';
        if($start>=0 && $end>=0 && $row>=0){
            $start = PHPExcel_Cell::stringFromColumnIndex($start);
            $end = PHPExcel_Cell::stringFromColumnIndex($end);
            $merge = "$start{$row}:$end{$row}";
        }
        return $merge;
    }

}

class PDF extends TCPDF {
    var $data = array();
    //Page header
    public function Header() {
        $data = $this->data;
        $report_width = $data['report_width'];
        $width = floor($report_width/3);

        $this->SetFont('freesans', 'B', 10);
        // $this->Cell($width,8,'Filter:',0,0,'L');
        // $report_width-($width*2)
        $this->Cell(0,8,'Employee Data Report',0,0,'C');
        $this->ln(8);
        $this->SetFont('freesans', 'B', 8);
        $this->Cell(0,8,$data['display_filter'],0,0,'C');
        $this->ln(8);

        // $filter = implode(PHP_EOL, $data['display_filter']);
        // $this->SetFont('freesans', '', 8);
        // $this->MultiCell($width,35,$filter,1,'L',0,0,15,11);
        // $this->ln(35);

        foreach($data['display_columns'] as $column) {
            $this->Cell($column['column_width'],8,$column['display_name'],1,0,'C',0,'',1);
        }
        $this->ln(8);
    }
    // Page header
    // Page footer
    public function Footer() {
        $data = $this->data;
        $report_width = $data['report_width'];
        $width = $report_width/3;
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('freesans', 'I', 8);
        // Page number
        $this->Cell($width, 10, 'Employee Data '.$data['page_size'].' - '.$data['page_orientation'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell($width, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell($width, 10, 'Date: '.date(STD_DATETIME), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>