<?php
class ControllerReportEmployeeData extends HController {
    protected function getAlias() {
        return 'report/employee_data';
    }
    protected function getPrimaryKey() {
        return 'employee_id';
    }
    public function index() {
        $this->model[$this->getAlias()] = $this->load->model('report/employee_data');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } elseif (isset($this->session->data['error'])) {
            $this->data['error_warning'] = $this->session->data['error'];
            unset($this->session->data['error']);
        } elseif (isset($this->session->data['warning'])) {
            $this->data['error_warning'] = $this->session->data['warning'];
            unset($this->session->data['warning']);
        } elseif (isset($this->session->data['error_warning'])) {
            $this->data['error_warning'] = $this->session->data['error_warning'];
            unset($this->session->data['error_warning']);
        } else {
            $this->data['error_warning'] = '';
        }
        if (isset($this->session->data['success'])) {
            $this->data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $this->data['success'] = '';
        }
        if (isset($this->error)) {
            $this->data['error'] = $this->error;
        }
        $this->data['breadcrumbs'] = array();
        $this->data['breadcrumbs'][] = array(
            'text' => $this->data['lang']['text_home'],
            'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
            'class' => 'fa fa-dashboard',
            'separator' => false
        );
        $this->data['breadcrumbs'][] = array(
            'text' => $this->data['lang']['heading_title'],
            'href' => $this->url->link('report/employee_data', 'token=' . $this->session->data['token'], 'SSL'),
            'class' => 'fa fa-tasks',
            'separator' => false
        );

        $this->model['report_criteria'] = $this->load->model('setup/report_criteria');
        $rows = $this->model['report_criteria']->getRows(array('user_id' => $this->session->data['user_id']),array('created_at DESC'));
        $reports = array();
        foreach($rows as $row) {
            $reports[] = array(
                'report_criteria_id' => $row['report_criteria_id'],
                'report_id' => $row['report_id'],
                'report_title' => $row['report_title']
            );
        }

        $this->data['reports'] = $reports;

        $this->model['mohallah'] = $this->load->model('setup/mohallah');
        $this->data['mohallahs'] = $this->model['mohallah']->getUserMohallah();

        $this->model['age_group'] = $this->load->model('setup/age_limit');
        $this->data['age_groups'] = $this->model['age_group']->getRows(array(),array('title'));

        $this->model['institute_category'] = $this->load->model('setup/institute_category');
        $this->data['categories'] = $this->model['institute_category']->getRows(array(),array('institute_category'));

        $this->model['school'] = $this->load->model('setup/school');
        $this->data['schools'] = $this->model['school']->getRows(array(),array('school_name'));

        $this->model['class'] = $this->load->model('setup/class');
        $this->data['classes'] = $this->model['class']->getRows(array(),array('class_name'));

        $this->model['madrassa'] = $this->load->model('setup/madrassa');
        $this->data['madrassas'] = $this->model['madrassa']->getRows(array(),array('madrassa_name'));

        $columns = array();
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => '(@sr:=@sr+1)',
            'display_name' => 'Sr.'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'mohallah_name',
            'display_name' => 'Mohallah'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'employee_no',
            'display_name' => 'Employee No.'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'sf_no',
            'display_name' => 'SF#'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'its_no',
            'display_name' => 'ITS No.'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'employee_name',
            'display_name' => 'Employee Name'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'surname',
            'display_name' => 'Surname'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'dob',
            'display_name' => 'D.O.B'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'father_its_no',
            'display_name' => 'F. ITS No.'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'father_name',
            'display_name' => 'Father'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'father_mobile_no',
            'display_name' => 'F. Mobile No.'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'father_occupation',
            'display_name' => 'F. Occupation'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'father_cnic',
            'display_name' => 'F. CNIC'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'mother_its_no',
            'display_name' => 'M. ITS No.'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'mother_name',
            'display_name' => 'Mother'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'mother_mobile_no',
            'display_name' => 'M. Mobile No.'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'mother_occupation',
            'display_name' => 'M. Occupation'
        );
        $columns[] = array(
            'column_ratio' => 4,
            'column_name' => 'residential_address',
            'display_name' => 'Address'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'residential_phone_no',
            'display_name' => 'Res. Phone'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'gender',
            'display_name' => 'Gender'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'status',
            'display_name' => 'Status'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'madrassa_going',
            'display_name' => 'Madrassa Going'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'madrassa_name',
            'display_name' => 'Madrassa'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'finance_support',
            'display_name' => 'FA'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'monthly_income',
            'display_name' => 'Monthly Income'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'earning_members',
            'display_name' => 'Earning Members'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'dependents',
            'display_name' => 'Dependents'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'flat_area',
            'display_name' => 'Flat Area'
        );
        $columns[] = array(
            'column_ratio' => 1,
            'column_name' => 'age',
            'display_name' => 'Age'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'age_group',
            'display_name' => 'Age Group'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'institute_category',
            'display_name' => 'Category'
        );
        $columns[] = array(
            'column_ratio' => 3,
            'column_name' => 'school_name',
            'display_name' => 'School'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'class_name',
            'display_name' => 'Class'
        );
        $columns[] = array(
            'column_ratio' => 2,
            'column_name' => 'section_name',
            'display_name' => 'Section'
        );
        $this->data['columns'] = $columns;
        $this->data['age_at'] = stdDate();

        $this->data['href_get_section'] = $this->url->link('report/employee_data/getSection', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_get_floor'] = $this->url->link('report/employee_data/getFloor', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['action_cancel'] = $this->url->link('report/employee_data', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['action_filter_employee_data'] = $this->url->link('report/employee_data/filterReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['action_pdf_employee_data'] = $this->url->link('report/employee_data/pdfReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['action_excel_employee_data'] = $this->url->link('report/employee_data/excelReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['action_save_employee_data'] = $this->url->link('report/employee_data/saveReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['action_remove_employee_data'] = $this->url->link('report/employee_data/removeReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['action_load_employee_data'] = $this->url->link('report/employee_data/loadReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->template = $this->getAlias() . '.tpl';
        $this->children = array(
            'common/header',
            'common/page_header',
            'common/column_left',
            'common/page_footer',
            'common/footer',

        );
        $this->response->setOutput($this->render());
    }

    public function getSection() {
        $class_id = $this->request->post['class_id'];
        $this->model['section'] = $this->load->model('setup/section');
        $sections = $this->model['section']->getRows(array('class_id' => $class_id),array('section_name'));
        $html = '<option value="">&nbsp;</option>';
        foreach($sections as $section) {
            $html .= '<option value="'.$section['section_id'].'">'.$section['section_name'].'</option>';
        }

        $json = array(
            'success' => true,
            'html' => $html,
            'post' => $this->request->post
        );

        echo json_encode($json);
        exit;
    }

    public function pdfReport() {
        ini_set('max_execution_time',0);
        $post = $this->request->get;
        //d($post, true);
        $display_columns = $post['display_columns'];
        $lang = $this->load->language('report/employee_data');
        $this->model['employee_data'] = $this->load->model('report/employee_data');
        $this->model['mohallah'] = $this->load->model('setup/mohallah');
        $this->model['age_limit'] = $this->load->model('setup/age_limit');
        $this->model['institute_category'] = $this->load->model('setup/institute_category');
        $this->model['school'] = $this->load->model('setup/school');
        $this->model['class'] = $this->load->model('setup/class');
        $this->model['section'] = $this->load->model('setup/section');
        $this->model['madrassa'] = $this->load->model('setup/madrassa');

        $arrMohallahs = $this->model['mohallah']->getArrays('mohallah_id','mohallah_name');
        $arrAgeGroups = $this->model['age_limit']->getArrays('age_limit_id','title');
        $arrCategories = $this->model['institute_category']->getArrays('institute_category_id','institute_category');
        $arrSchools = $this->model['school']->getArrays('school_id','school_name');
        $arrClasses = $this->model['class']->getArrays('class_id','class_name');
        $arrSections = $this->model['section']->getArrays('section_id','section_name');
        $arrMadrassas = $this->model['madrassa']->getArrays('madrassa_id','madrassa_name');
        //d($arrAgeGroups, true);

        $filter = array();
        $display_filter = array();
        if(isset($post['age_at']) && $post['age_at'] != '') {
            $filter['age_at'] = MySqlDate($post['age_at']);
            $display_filter[] = "`Age At` = '".$post['age_at']."'";
        }
        if(isset($post['mohallah_id']) && $post['mohallah_id'] != '') {
            $filter[] = "`mohallah_id` IN (".implode(",",$post['mohallah_id']).")";
            $strArray = array();
            foreach($post['mohallah_id'] as $index_id) {
                $strArray[] = $arrMohallahs[$index_id];
            }
            $display_filter[] = "`Mohallah` IN (".implode(',',$strArray).")";
        }
        if(isset($post['age_limit_id']) && $post['age_limit_id'] != '') {
            $filter[] = "`age_limit_id` IN (".implode(",",$post['age_limit_id']).")";
            $strArray = array();
            foreach($post['age_limit_id'] as $index_id) {
                $strArray[] = $arrAgeGroups[$index_id];
            }
            $display_filter[] = "`Age Group` IN (".implode(',',$strArray).")";
        }
        if(isset($post['gender']) && $post['gender'] != '') {
            $filter[] = "`age` = '" . $post['gender'] . "'";
            $display_filter[] = "`Gender` = '".$post['gender']."'";
        }
        if(isset($post['institute_category_id']) && $post['institute_category_id'] != '') {
            //$filter['institute_category_id'] = $post['institute_category_id'];
            $filter[] = "`institute_category_id` IN (".implode(",",$post['institute_category_id']).")";
            $strArray = array();
            foreach($post['institute_category_id'] as $index_id) {
                $strArray[] = $arrCategories[$index_id];
            }
            $display_filter[] = "`Category` IN (".implode(',',$strArray).")";
        }
        if(isset($post['school_id']) && $post['school_id'] != '') {
            //$filter['school_id'] = $post['school_id'];
            $filter[] = "`school_id` IN (".implode(",",$post['school_id']).")";
            $strArray = array();
            foreach($post['school_id'] as $index_id) {
                $strArray[] = $arrSchools[$index_id];
            }
            $display_filter[] = "`School` IN (".implode(',',$strArray).")";
        }
        if(isset($post['class_id']) && $post['class_id'] != '') {
            //$filter['class_id'] = $post['class_id'];
            $filter[] = "`class_id` IN (".implode(",",$post['class_id']).")";
            $strArray = array();
            foreach($post['class_id'] as $index_id) {
                $strArray[] = $arrClasses[$index_id];
            }
            $display_filter[] = "`Class` IN (".implode(',',$strArray).")";
        }
        if(isset($post['section_id']) && $post['section_id'] != '') {
            //$filter['section_id'] = $post['section_id'];
            $filter[] = "`section_id` IN (".implode(",",$post['section_id']).")";
            $strArray = array();
            foreach($post['section_id'] as $index_id) {
                $strArray[] = $arrSections[$index_id];
            }
            $display_filter[] = "`Section` IN (".implode(',',$strArray).")";
        }
        if(isset($post['madrassa_going']) && $post['madrassa_going'] != '') {
            //$filter['madrassa_going'] = $post['madrassa_going'];
            $filter[] = "`madrassa_going` = '".$post['modrassa_going']."'";
            $display_filter[] = "`Madrassa Going` = '".$post['madrassa_going']."'";
        }
        if(isset($post['madrassa_id']) && $post['madrassa_id'] != '') {
            //$filter['madrassa_id'] = $post['madrassa_id'];
            $filter[] = "`madrassa_id` IN (".implode(",",$post['madrassa_id']).")";
            $strArray = array();
            foreach($post['madrassa_id'] as $index_id) {
                $strArray[] = $arrMadrassas[$index_id];
            }
            $display_filter[] = "`Madrassa` IN (".implode(',',$strArray).")";
            //$display_filter[] = "`Madrassa` = '".$arrMadrassas[$post['madrassa_id']]."'";
        }
        if(isset($post['status']) && $post['status'] != '') {
            //$filter['status'] = $post['status'];
            $filter[] = "`status` = '".$post['status']."'";
            $display_filter[] = "`Status` = '".$post['status']."'";
        }
        if(isset($post['finance_support']) && $post['finance_support'] != '') {
            //$filter['finance_support'] = $post['finance_support'];
            $filter[] = "`finance_support` IN ('".implode("','",$post['finance_support'])."')";
            $strArray = array();
            foreach($post['finance_support'] as $index_id) {
                $strArray[] = $index_id;
            }
            $display_filter[] = "`Finance Support` IN (".implode(',',$strArray).")";
        }

        $page_width = array();
        $page_width['A4']['P'] = 190;
        $page_width['A4']['L'] = 277;
        $page_width['A3']['P'] = 277;
        $page_width['A3']['L'] = 400;

        $pdf = new PDF($post['page_orientation'], PDF_UNIT, $post['page_size'], true, 'UTF-8', false);
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Employee Data');
        $pdf->SetSubject('Employee Data');
        $pdf->SetMargins(15, 40, 5);
        $pdf->SetHeaderMargin(5);
        $pdf->SetFooterMargin(2);

        $report_width = $page_width[$post['page_size']][$post['page_orientation']];
        $total_ratio = 0;
        foreach($display_columns as $column) {
            $total_ratio += $column['column_ratio'];
        }
        //d($display_columns, true);
        //$width = floor($report_width/$total_ratio);
        $width = $report_width/$total_ratio;
        if($width < 5) {
            $this->session->data['error_warning'] = 'Too many columns ' . $report_width . ' / '.$total_ratio;
            $this->redirect($this->url->link('report/employee_data', 'token=' . $this->session->data['token'], 'SSL'));
        }
        foreach($display_columns as $row_id => $column) {
            $display_columns[$row_id]['column_width']=($width * $column['column_ratio']);
        }

        $rows = $this->model['employee_data']->getRecords($display_columns,$filter, $post['show_empty']);

        //Set Header
        $pdf->data = array(
            'report_title' => $post['report_title'],
            'report_width' => $report_width,
            'display_filter' => $display_filter,
            'display_columns' => $display_columns,
            'page_size' => $post['page_size'],
            'page_orientation' => $post['page_orientation'],
        );
        $pdf->SetFont('times', 'B', 8);
        $pdf->AddPage();
        $sr =0;
        foreach($rows as $row) {
            $sr++;
            foreach($display_columns as $column) {
                if(in_array($column['column_name'],array('dob','fa_date'))) {
                    if($row[$column['display_name']] != '') {
                        $pdf->Cell($column['column_width'],8,stdDate($row[$column['display_name']]),1,0,'C',0,'',1);
                    } else {
                        $pdf->Cell($column['column_width'],8,$row[$column['display_name']],1,0,'C',0,'',1);
                    }
                } elseif(in_array($column['column_name'],array('employee_no','age'))) {
                    $pdf->Cell($column['column_width'],8,$row[$column['display_name']],1,0,'R',0,'',1);
                } elseif(in_array($column['display_name'],array('Sr.'))) {
                    $pdf->Cell($column['column_width'],8,$sr,1,0,'C',0,'',1);
                } else {
                    $pdf->Cell($column['column_width'],8,$row[$column['display_name']],1,0,'L',0,'',1);
                }
            }
            $pdf->ln(8);
        }
        //$pdf->Cell(0,10,"Full Width",1,1,'C');
        //$pdf->Cell(400,10,"Width of ".$post['page_size']." - ".$post['page_orientation'],1,0,'C');
        //$pdf->writeHTML($body);
        $pdf->Output('Employee Data:'.date('YmdHis').'.pdf', 'I');
    }

    public function excelReport() {
        ini_set('max_execution_time',0);
        $post = $this->request->get;
        //d($post, true);
        $display_columns = $post['display_columns'];
        $lang = $this->load->language('report/employee_data');
        $this->model['employee_data'] = $this->load->model('report/employee_data');
        $this->model['mohallah'] = $this->load->model('setup/mohallah');
        $this->model['age_limit'] = $this->load->model('setup/age_limit');
        $this->model['institute_category'] = $this->load->model('setup/institute_category');
        $this->model['school'] = $this->load->model('setup/school');
        $this->model['class'] = $this->load->model('setup/class');
        $this->model['section'] = $this->load->model('setup/section');
        $this->model['madrassa'] = $this->load->model('setup/madrassa');

        $arrMohallahs = $this->model['mohallah']->getArrays('mohallah_id','mohallah_name');
        $arrAgeGroups = $this->model['age_limit']->getArrays('age_limit_id','title');
        $arrCategories = $this->model['institute_category']->getArrays('institute_category_id','institute_category');
        $arrSchools = $this->model['school']->getArrays('school_id','school_name');
        $arrClasses = $this->model['class']->getArrays('class_id','class_name');
        $arrSections = $this->model['section']->getArrays('section_id','section_name');
        $arrMadrassas = $this->model['madrassa']->getArrays('madrassa_id','madrassa_name');
        //d($arrAgeGroups, true);

        $filter = array();
        $display_filter = array();
        if(isset($post['age_at']) && $post['age_at'] != '') {
            $filter['age_at'] = MySqlDate($post['age_at']);
            $display_filter[] = "`Age At` = '".$post['age_at']."'";
        }
        if(isset($post['mohallah_id']) && $post['mohallah_id'] != '') {
            $filter[] = "`mohallah_id` IN (".implode(",",$post['mohallah_id']).")";
            $strArray = array();
            foreach($post['mohallah_id'] as $index_id) {
                $strArray[] = $arrMohallahs[$index_id];
            }
            $display_filter[] = "`Mohallah` IN (".implode(',',$strArray).")";
        }
        if(isset($post['age_limit_id']) && $post['age_limit_id'] != '') {
            $filter[] = "`age_limit_id` IN (".implode(",",$post['age_limit_id']).")";
            $strArray = array();
            foreach($post['age_limit_id'] as $index_id) {
                $strArray[] = $arrAgeGroups[$index_id];
            }
            $display_filter[] = "`Age Group` IN (".implode(',',$strArray).")";
        }
        if(isset($post['gender']) && $post['gender'] != '') {
            $filter[] = "`age` = '" . $post['gender'] . "'";
            $display_filter[] = "`Gender` = '".$post['gender']."'";
        }
        if(isset($post['institute_category_id']) && $post['institute_category_id'] != '') {
            //$filter['institute_category_id'] = $post['institute_category_id'];
            $filter[] = "`institute_category_id` IN (".implode(",",$post['institute_category_id']).")";
            $strArray = array();
            foreach($post['institute_category_id'] as $index_id) {
                $strArray[] = $arrCategories[$index_id];
            }
            $display_filter[] = "`Category` IN (".implode(',',$strArray).")";
        }
        if(isset($post['school_id']) && $post['school_id'] != '') {
            //$filter['school_id'] = $post['school_id'];
            $filter[] = "`school_id` IN (".implode(",",$post['school_id']).")";
            $strArray = array();
            foreach($post['school_id'] as $index_id) {
                $strArray[] = $arrSchools[$index_id];
            }
            $display_filter[] = "`School` IN (".implode(',',$strArray).")";
        }
        if(isset($post['class_id']) && $post['class_id'] != '') {
            //$filter['class_id'] = $post['class_id'];
            $filter[] = "`class_id` IN (".implode(",",$post['class_id']).")";
            $strArray = array();
            foreach($post['class_id'] as $index_id) {
                $strArray[] = $arrClasses[$index_id];
            }
            $display_filter[] = "`Class` IN (".implode(',',$strArray).")";
        }
        if(isset($post['section_id']) && $post['section_id'] != '') {
            //$filter['section_id'] = $post['section_id'];
            $filter[] = "`section_id` IN (".implode(",",$post['section_id']).")";
            $strArray = array();
            foreach($post['section_id'] as $index_id) {
                $strArray[] = $arrSections[$index_id];
            }
            $display_filter[] = "`Section` IN (".implode(',',$strArray).")";
        }
        if(isset($post['madrassa_going']) && $post['madrassa_going'] != '') {
            //$filter['madrassa_going'] = $post['madrassa_going'];
            $filter[] = "`madrassa_going` = '".$post['modrassa_going']."'";
            $display_filter[] = "`Madrassa Going` = '".$post['madrassa_going']."'";
        }
        if(isset($post['madrassa_id']) && $post['madrassa_id'] != '') {
            //$filter['madrassa_id'] = $post['madrassa_id'];
            $filter[] = "`madrassa_id` IN (".implode(",",$post['madrassa_id']).")";
            $strArray = array();
            foreach($post['madrassa_id'] as $index_id) {
                $strArray[] = $arrMadrassas[$index_id];
            }
            $display_filter[] = "`Madrassa` IN (".implode(',',$strArray).")";
            //$display_filter[] = "`Madrassa` = '".$arrMadrassas[$post['madrassa_id']]."'";
        }
        if(isset($post['status']) && $post['status'] != '') {
            //$filter['status'] = $post['status'];
            $filter[] = "`status` = '".$post['status']."'";
            $display_filter[] = "`Status` = '".$post['status']."'";
        }
        if(isset($post['finance_support']) && $post['finance_support'] != '') {
            //$filter['finance_support'] = $post['finance_support'];
            $filter[] = "`finance_support` IN ('".implode("','",$post['finance_support'])."')";
            $strArray = array();
            foreach($post['finance_support'] as $index_id) {
                $strArray[] = $index_id;
            }
            $display_filter[] = "`Finance Support` IN (".implode(',',$strArray).")";
        }

        $rows = $this->model['employee_data']->getRecords($display_columns,$filter, $post['show_empty']);

        //d(array($post, $records, $rows), true);
        $columns = array_keys($rows[0]);
        $no_of_columns = count($columns);
        $start_column_idx = 0;
        $end_column_idx = $start_column_idx + $no_of_columns -1;

        try {
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Huzaifa Khambaty")
                ->setLastModifiedBy("Huzaifa Khambaty")
                //->setDescription("Test document for PHPExcel, generated using PHP classes.")
                //->setKeywords("office PHPExcel php")
                //->setCategory("Test result file")
                ->setTitle($post['report_title'])
                ->setSubject($post['report_title']);

            $row_no = 0;
            $objPHPExcel->setActiveSheetIndex(0);

            // Set the Report Title
            $row_no++;
            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
            $style = array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            );
            $objPHPExcel->getActiveSheet()
                ->mergeCells($merge_cells)
                ->setCellValue('A'.$row_no,$post['report_title'])
                ->getStyle($merge_cells)
                ->getAlignment()
                ->applyFromArray($style)
            ;


            // Set the Filter in Excell
            $strFilter = implode(' AND ', $display_filter);
            $strFilter = $strFilter != ''?$strFilter:$lang['no_filter'];
            //d(array($lang['no_filter'], $strFilter, $lang));
            $row_no++;
            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
            $objPHPExcel->getActiveSheet()
                ->mergeCells($merge_cells)
                ->setCellValue('A'.$row_no,'Filter: ' . $strFilter)
            ;


            // Set The Header Column
            $column_no = 0;
            $row_no++;
            foreach($columns as $column) {
                $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($column_no, $row_no, $column)
                    ->getStyleByColumnAndRow($column_no, $row_no)
                    ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => '000000')
                            )
                        ,
                            'font'  => array(
                                'color' => array('rgb' => 'ffffff')
                            )
                        )
                    )
                ;
                $column_no++;
            }

            // Set The Rows
            foreach($rows as $variable_name => $row) {
                $column_no = 0;
                $row_no++;
                foreach($row as $header_row => $value) {
                    $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($column_no, $row_no, $value)
                        ->getStyleByColumnAndRow($column_no, $row_no)
                        ->applyFromArray(
                            array(
//                                'fill' => array(
//                                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
//                                    'color' => array('rgb' => 'D8D8D8')
//                                )
//                            ,
                                'font'  => array(
                                    'color' => array('rgb' => '000000')
                                )
                            )
                        )
                    ;

                    $column_no++;
                }
            }

            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            ob_end_clean();
            $file_name = $post['report_title'] .'_' . date('YmdHis');
            //header('Content-type: application/vnd.ms-excel');
            header('Content-type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');

            // It will be called file.xls
            header('Content-Disposition: attachment; filename="'.$file_name.'.xlsx"');

            // Write file to the browser
            $objWriter->save('php://output');
            //$objWriter->save($file_name);
        } catch(Exception $e) {
            d($e, true);
        }

    }

    private function cellsToMergeByColsRow($start = -1, $end = -1, $row = -1){
        $merge = 'A1:A1';
        if($start>=0 && $end>=0 && $row>=0){
            $start = PHPExcel_Cell::stringFromColumnIndex($start);
            $end = PHPExcel_Cell::stringFromColumnIndex($end);
            $merge = "$start{$row}:$end{$row}";
        }
        return $merge;
    }

    public function saveReport() {
        $post = $this->request->post;
        $this->model['report_criteria'] = $this->load->model('setup/report_criteria');
        $user_id = $this->session->data['user_id'];
        $report_id = strtolower($post['report_title']);
        $report_title = $post['report_title'];


        $report = $this->model['report_criteria']->getRow(array('user_id' => $user_id, 'report_id' => $report_id));
        if(empty($report)) {
            $insertData = array(
                'user_id' => $user_id,
                'report_id' => $report_id,
                'report_title' => $report_title,
                'data' => serialize($post)
            );

            $report_criteria_id = $this->model['report_criteria']->add($this->getAlias(), $insertData);
        } else {
            $report_criteria_id = $report['report_criteria_id'];
            $updateData = array(
                'user_id' => $user_id,
                'report_id' => $report_id,
                'report_title' => $report_title,
                'data' => serialize($post)
            );

            $this->model['report_criteria']->edit($this->getAlias(), $report_criteria_id, $updateData);
        }


        $reports = array();
        $rows = $this->model['report_criteria']->getRows(array('user_id' => $user_id),array('created_at DESC'));
        foreach($rows as $row) {
            $reports[] = array(
                'report_criteria_id' => $row['report_criteria_id'],
                'report_id' => $row['report_id'],
                'report_title' => $row['report_title']
            );
        }
        $json = array(
            'success' => true,
            //'post' => $post,
            'report_criteria_id' => $report_criteria_id,
            'reports' => $reports
        );

        echo json_encode($json);
        exit;
    }

    public function removeReport() {
        $post = $this->request->post;
        $report_criteria_id = $post['report_criteria_id'];
        $this->model['report_criteria'] = $this->load->model('setup/report_criteria');
        $this->model['report_criteria']->delete($this->getAlias(), $report_criteria_id);

        $reports = array();
        $rows = $this->model['report_criteria']->getRows(array('user_id' => $this->session->data['user_id']),array('created_at DESC'));
        foreach($rows as $row) {
            $reports[] = array(
                'report_criteria_id' => $row['report_criteria_id'],
                'report_id' => $row['report_id'],
                'report_title' => $row['report_title']
            );
        }
        $json = array(
            'success' => true,
            //'post' => $post,
            'report_criteria_id' => $report_criteria_id,
            'reports' => $reports
        );

        echo json_encode($json);
        exit;
    }

    public function loadReport() {
        $post = $this->request->post;
        $this->model['report_criteria'] = $this->load->model('setup/report_criteria');
        $report = $this->model['report_criteria']->getRow(array('report_criteria_id' => $post['report_criteria_id']));
        $data = unserialize($report['data']);

        $json = array(
            'success' => true,
            'post' => $post,
            'report' => $report,
            'data' => $data
        );

        echo json_encode($json);
        exit;
    }

}

class PDF extends TCPDF {
    var $data = array();
    //Page header
    public function Header() {
        $data = $this->data;
        $report_width = $data['report_width'];
        $width = floor($report_width/3);

        $this->SetFont('freesans', 'B', 10);
        $this->Cell($width,8,'Filter:',0,0,'L');
        $this->Cell($report_width-($width*2),8,'Educational Committee',0,0,'C');
        $this->ln(8);
        $this->SetFont('freesans', 'B', 8);
        $this->Cell($width,8,'',0,0,'L');
        $this->Cell($report_width-($width*2),8,$data['report_title'],0,0,'C');
        $this->ln(8);

        $filter = implode(PHP_EOL, $data['display_filter']);
        $this->SetFont('freesans', '', 8);
        $this->MultiCell($width,20,$filter,1,'L',0,0,15,11);
        $this->ln(20);

        foreach($data['display_columns'] as $column) {
            $this->Cell($column['column_width'],8,$column['display_name'],1,0,'C',0,'',1);
        }
        $this->ln(8);
    }
    // Page header
    // Page footer
    public function Footer() {
        $data = $this->data;
        $report_width = $data['report_width'];
        $width = $report_width/3;
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('freesans', 'I', 8);
        // Page number
        $this->Cell($width, 10, 'Employee Data '.$data['page_size'].' - '.$data['page_orientation'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell($width, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell($width, 10, 'Date: '.stdDateTime(), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}

?>