<?php

class ControllerReportEmployeeLeave extends HController
{

    protected function getAlias()
    {
        return 'report/employee_leave';
    }

    protected function init()
    {
        $this->model[$this->getAlias()] = $this->load->model('employee/employee_leave');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList()
    {
        parent::getList();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['document_date'] = stdDate();
        $this->data['href_get_report'] = $this->url->link($this->getAlias() . '/getReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_excel_report'] = $this->url->link($this->getAlias() . '/downloadExcel', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_report'] = $this->url->link($this->getAlias() . '/printReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation'] = "{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function getReport()
    {
        $post = $this->request->post;
        $from_date = MySqlDate($post['from_date']);
        $to_date = MySqlDate($post['to_date']);
        $status=$post['leave_status'];
        if (isset($post['department_id']) && is_array($post['department_id'])) {
            $department_id = $post['department_id'];
        } else {
            $department_id = array();
        }


        $this->model['leave'] = $this->load->model('report/employee_leave');
        $rows = $this->model['leave']->getLeaveReport($from_date, $to_date, $department_id,$status);
        //d(array($where, $payrolls), true);
        $html = '';
        foreach ($rows as $row_id => $row) {
            $html .= '<tr>';
            $html .= '<td class="text-left">' . ($row_id + 1) . '</td>';
            $html .= '<td class="text-left">' . stdDate($row['request_date'] ). '</td>';
            $html .= '<td class="text-left">' . $row['employee_name'] . '</td>';
            $html .= '<td class="text-left">' . '<label class="help-content">From:&nbsp;</label>' . stdDate($row['leave_from']) . '<br /><label class="help-content">To:&nbsp;</label>' . stdDate($row['leave_to']) . '</td>';
            $html .= '<td class="text-left"><b>' . $row['reason'] ."</b><br>".$row['description'] . '</td>';
            $html .= '<td class="text-left">' . $row['status'] . '</td>';
            $html .= '<td class="text-right">';
            if ($row['status'] == 'Approved') {
                $html .= $row['approved_type'] == 'LP' ? 'Leave with Pay' : 'Leave with Deduction';
            } else {
                $html .= "";
            }
            $html .= '</td>';
            $html .= '<td class="text-right">';
            if($row['status'] == 'Approved') {
                $html .= '<label class="help-content">From:&nbsp;</label>' . stdDate($row['approved_from']) . '<br />
                        <label class="help-content">To:&nbsp;</label>' . stdDate($row['approved_to']);
            }else{
                $html.='';

            }

                       $html.='</td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'rows' => $rows,
            'html' => $html
        );

        echo json_encode($json);
    }

    public function downloadExcel()
    {
        include_once(DIR_SYSTEM . 'library/PHPExcel.php');
        include_once(DIR_SYSTEM . 'library/PHPExcel/Classes/PHPExcel/Writer/Excel5.php');
        $post = $this->request->post;
        $from_date = MySqlDate($post['from_transaction_date']);
        $to_date = MySqlDate($post['to_transaction_date']);
        if (isset($post['department_id'])) {
            $department_id = $post['department_id'];
        } else {
            $department_id = array();
        }

        $this->model['tax'] = $this->load->model('report/tax_deduction');
        $rows = $this->model['tax']->getTaxDeduction($from_date, $to_date, $department_id);
        //d($rows, true);
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $rowCount = 1;
        $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, 'employee_code');
        $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, 'Payment Section');
        $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, 'TaxPayer_NTN');
        $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, 'TaxPayer_CNIC');
        $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, 'TaxPayer_Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, 'TaxPayer_City');
        $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, 'TaxPayer_Address');
        $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'TaxPayer_Status');
        $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'TaxPayer_Business_Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, 'Taxable_Amount');
        $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, 'Tax_Amount');
        $rowCount++;
        $total_taxable_amount = 0;
        $total_tax_amount = 0;
        foreach ($rows as $row) {
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $row['employee_code']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $row['Payment Section']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $row['TaxPayer_NTN']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $row['TaxPayer_CNIC']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $row['TaxPayer_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $row['TaxPayer_City']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $row['TaxPayer_Address']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $row['TaxPayer_Status']);
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $row['TaxPayer_Business_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $row['Taxable_Amount']);
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $row['Tax_Amount']);
            $rowCount++;
            $total_taxable_amount += $row['Taxable_Amount'];
            $total_tax_amount += $row['Tax_Amount'];
        }
        $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'Total');
        $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $total_taxable_amount);
        $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $total_tax_amount);

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="Tax.xls"');
        header('Cache-Control: max-age=0');
        //$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        //$objWriter->save('some_excel_file.xlsx');
        $objWriter->save('php://output');
        exit;
    }

    public function printReport()
    {
        ini_set('max_execution_time', 400);
        $lang = $this->load->language($this->getAlias());
        $post = $this->request->post;
        $from_date = MySqlDate($post['from_date']);
        $to_date = MySqlDate($post['to_date']);
        $status=$post['leave_status'];
        if (isset($post['department_id']) && is_array($post['department_id'])) {
            $department_id = $post['department_id'];
        } else {
            $department_id = array();
        }
        $this->model['leave'] = $this->load->model('report/employee_leave');
        $rows = $this->model['leave']->getLeaveReport($from_date, $to_date, $department_id,$status);
        $html = '';
        $columns = array_keys($rows[0]);

        $pdf = new PDF('L', PDF_UNIT, 'A3', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => 'Employee Leave Report',
        );

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Employee Leave Report');
        $pdf->SetSubject('Employee Leave Report');
        $pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->AddPage();
        $pdf->ln(10);
        $pdf->SetFont('freesans', 'B', 10);
        $pdf->Cell(10, 10, 'Sr.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(30, 10, 'Request On', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(70, 10, 'Employee Name', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(70, 10, 'Leave Date', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        // $pdf->Cell(65, 10, 'Reason', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(30, 10, 'Status', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(30, 10, 'Approved Type', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(100, 10, 'Approved Date', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->ln(10);
        $pdf->SetFont('freesans', '', 10);

        foreach ($rows as $row_no => $row) {
            if ($row['status'] == 'Approved') {
               $approved_type= $row['approved_type'] == 'LP' ? 'Leave with Pay' : 'Leave with Deduction';
                $approved_date = 'From: ' . stdDate($row['approved_from']) . 'To ' . stdDate($row['approved_to']);
            } else{
                $approved_type="";
                $approved_date="";
            }

            $pdf->Cell(10, 10, ($row_no + 1), 'T', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(30, 10,stdDate($row['request_date']), 'T', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(70, 10, $row['employee_name'], 'T', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(70, 10, 'From '. stdDate($row['leave_from']) .'To: ' . stdDate($row['leave_to']), 'T', false, 'M', 0, '', 1, false, 'M', 'M');
            
            $pdf->Cell(30, 10, $row['status'], 'T', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(30, 10,$approved_type , 'T', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(100, 10, $approved_date, 'T', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(8);
            $pdf->Cell(500, 15, 'Description : '.$row['description'], '', false, 'L', 0, '', 1, true, 'M', 'M');
            $pdf->ln(6);
            $pdf->Cell(500, 10, 'Reason : '.$row['reason'] , '', false, 'L', 0, '', 1,
                false, 'M', 'M');
            $pdf->ln(12);
        }
        $pdf->ln(10);
        $pdf->SetFont('freesans', 'B', 10);
        $pdf->Cell(320, 10, '', '', false, 'L', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(10, 10, 'Total:', 'TB', false, 'R', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(30, 10, number_format(0, 0), 'TB', false, 'R', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(30, 10, number_format(0, 0), 'TB', false, 'R', 0, '', 1, false, 'M', 'M');
        $pdf->Output('Employee Leave Report:' . date('YmdHis') . '.pdf', 'I');
    }

}

class PDF extends TCPDF
{
    public $data;

    //Page header
    public function Header()
    {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('freesans', 'B', 20);
        // Title
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->SetFont('freesans', 'B', 14);
        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer()
    {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(130, 10, 'Tax Report', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(130, 10, 'Page ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(130, 10, 'Date: ' . date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}

?>