<?php

class ControllerReportEmployeeProfile extends HController
{

    protected function getAlias()
    {
        return 'report/employee_profile';
    }

    protected function init()
    {
        $this->model[$this->getAlias()] = $this->load->model('employee/employee_leave');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList()
    {
        parent::getList();

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['href_get_report'] = $this->url->link($this->getAlias() . '/getReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_excel_report'] = $this->url->link($this->getAlias() . '/downloadExcel', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_report'] = $this->url->link($this->getAlias() . '/printReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation'] = "{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function downloadExcel()
    {
        include_once(DIR_SYSTEM . 'library/PHPExcel.php');
        include_once(DIR_SYSTEM . 'library/PHPExcel/Classes/PHPExcel/Writer/Excel5.php');
        $post = $this->request->post;
        $from_date = MySqlDate($post['from_transaction_date']);
        $to_date = MySqlDate($post['to_transaction_date']);
        if (isset($post['department_id'])) {
            $department_id = $post['department_id'];
        } else {
            $department_id = array();
        }

        $this->model['tax'] = $this->load->model('report/tax_deduction');
        $rows = $this->model['tax']->getTaxDeduction($from_date, $to_date, $department_id);
        //d($rows, true);
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $rowCount = 1;
        $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, 'employee_code');
        $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, 'Payment Section');
        $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, 'TaxPayer_NTN');
        $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, 'TaxPayer_CNIC');
        $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, 'TaxPayer_Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, 'TaxPayer_City');
        $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, 'TaxPayer_Address');
        $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'TaxPayer_Status');
        $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'TaxPayer_Business_Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, 'Taxable_Amount');
        $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, 'Tax_Amount');
        $rowCount++;
        $total_taxable_amount = 0;
        $total_tax_amount = 0;
        foreach ($rows as $row) {
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $row['employee_code']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $row['Payment Section']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $row['TaxPayer_NTN']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $row['TaxPayer_CNIC']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $row['TaxPayer_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $row['TaxPayer_City']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $row['TaxPayer_Address']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $row['TaxPayer_Status']);
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $row['TaxPayer_Business_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $row['Taxable_Amount']);
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $row['Tax_Amount']);
            $rowCount++;
            $total_taxable_amount += $row['Taxable_Amount'];
            $total_tax_amount += $row['Tax_Amount'];
        }
        $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'Total');
        $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $total_taxable_amount);
        $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $total_tax_amount);

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="Tax.xls"');
        header('Cache-Control: max-age=0');
        //$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        //$objWriter->save('some_excel_file.xlsx');
        $objWriter->save('php://output');
        exit;
    }

    public function printReport()
    {
        ini_set('max_execution_time', 400);
        $lang = $this->load->language($this->getAlias());
        $post = $this->request->post;

        $arrWhere=array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        if (isset($post['department_id']) && is_array($post['department_id'])) {
            $arrWhere[] = "`department_id` IN (".implode(',',$post['department_id']).")";
        }
        if (isset($post['employee_id']) && $post['employee_id'] != '') {
            $arrWhere[] = "`employee_id` = '".$post['employee_id']."'";
        }
        $where = implode(' AND ', $arrWhere);
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['employee_family'] = $this->load->model('employee/employee_family');
        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $this->model['allowance'] = $this->load->model('payroll/special_allowance');
        $this->model['loan'] = $this->load->model('payroll/loan');
        $employees = $this->model['employee_registration']->getDistinctRows(array('employee_id','employee_code', 'employee_name', 'employee_image','dob','its_no','mobile_no','email','cnic_no','cnic_name'), $where, array('employee_name'));
        //d([$where, $employees], true);
        $pdf = new PDF('L', PDF_UNIT, 'A3', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => 'Employee Profile',
        );
        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Employee Profile');
        $pdf->SetSubject('Employee Profile');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        foreach($employees as $employee) {
            // add a page
            $pdf->AddPage();
            $pdf->data['employee_name'] = $employee['employee_name'];
            if ($employee['employee_image'] != '' && file_exists(DIR_IMAGE . $employee['employee_image'])) {
                $employee_image = DIR_IMAGE . $employee['employee_image'];
            } else {
                $employee_image = DIR_IMAGE . 'no_user.jpg';
            }
            $pdf->Image($employee_image, 15, 30, 30, 30);

            $pdf->ln(5);
            $pdf->Cell(30, 7, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(25, 7, 'Emp. Code:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(70, 7, $employee['employee_code'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(25, 7, 'CNIC. No.:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(70, 7, $employee['cnic_no'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(7);
            $pdf->Cell(30, 7, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(25, 7, 'Name:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(70, 7, $employee['employee_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(25, 7, 'CNIC. Name:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(70, 7, $employee['cnic_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(7);
            $pdf->Cell(30, 7, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(25, 7, 'ITS No:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(70, 7, $employee['its_no'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(25, 7, 'DOB:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(70, 7, ($employee['dob']==''?'':stdDate($employee['dob'])), 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(7);
            $pdf->Cell(30, 7, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(25, 7, 'Phone No:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(70, 7, $employee['mobile_no'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(25, 7, 'Email:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(70, 7, $employee['email'], 0, false, 'L', 0, '', 1, false, 'M', 'M');

            // Width 390.
            // Print Registration
            $registrations = $this->model['employee_registration']->getRows(array('employee_id' => $employee['employee_id']));
            $pdf->ln(15);
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(0, 7, 'Registration:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(7);
            $pdf->Cell(20, 7, 'Comp. Code', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(90, 7, 'Comp. Name', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(30, 7, 'Reg. Code', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(90, 7, 'Department', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(30, 7, 'Joining Date', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(30, 7, 'Status', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            //d($registrations, true);
            $pdf->SetFont('freesans', '', 10);
            foreach($registrations as $registration) {
                $pdf->ln(7);
                $pdf->Cell(20, 7, $registration['company_id'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(90, 7, $registration['company_name'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, $registration['registration_code'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(90, 7, $registration['department_name'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, stdDate($registration['joining_date']), 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, $registration['status'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
            }

            // Print Family Data
            $arrWhere = [];
            $arrWhere[] = "`employee_id` = '".$employee['employee_id']."'";
            $arrWhere[] = "`relation` != 'Self'";
            $where = implode(' AND ', $arrWhere);
            $families = $this->model['employee_family']->getRows($where, array('FIELD(relation,"Parent","Spouse","Child")','sort_order'));
            //d($families, true);
            $pdf->ln(15);
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(0, 7, 'Family Data:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(7);
            $pdf->Cell(25, 7, 'Relation', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(90, 7, 'Full Name', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(40, 7, 'Qualification', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(90, 7, 'School', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(25, 7, 'Class', 1, false, 'L', 0, '', 1, false, 'M', 'M');

            $pdf->SetFont('freesans', '', 10);
            foreach($families as $family) {
                $pdf->ln(7);
                $pdf->Cell(25, 7, $family['relation'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(90, 7, $family['full_name'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(40, 7, $family['qualification'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(90, 7, $family['school_name'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(25, 7, $family['class_name'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
            }

            // Print Payrolls
            $arrWhere = [];
            $arrWhere[] = "p.`employee_id` = '".$employee['employee_id']."'";
            $arrWhere[] = "p.`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
            $where = implode(' AND ', $arrWhere);
            $payrolls = $this->model['payroll']->getRegister($where, array('document_date', 'company_id'));
            //d($payrolls, true);
            $pdf->ln(15);
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(0, 7, 'Payroll Register:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(7);
            $pdf->Cell(25, 7, 'Doc. Date', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, 'Comp Code', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(100, 7, 'Particulars', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, 'S&A', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, 'Salary', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, 'Arrears', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, 'Allowance', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, 'Gross', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, 'Tax', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, 'EOBI', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, 'Deductions', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, 'Payable', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(25, 7, 'CHQ', 1, false, 'L', 0, '', 1, false, 'M', 'M');

            $total_sa=0;
            $total_salary=0;
            $total_arrears=0;
            $total_allowances=0;
            $total_gross=0;
            $total_tax=0;
            $total_eobi=0;
            $total_deductions=0;
            $total_payable=0;
            $pdf->SetFont('freesans', '', 10);
            foreach($payrolls as $payroll) {
                $pdf->ln(7);
                $pdf->Cell(25, 7, $payroll['document_date'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, $payroll['company_id'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(100, 7, $payroll['document_title'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($payroll['S&A']), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($payroll['Salary']), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($payroll['Arrears']), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($payroll['Gross']-$payroll['Salary']-$payroll['Arrears']), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($payroll['Gross']), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($payroll['TAX']), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($payroll['EOBI']), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($payroll['Gross']-$payroll['Payable']-$payroll['TAX']-$payroll['EOBI']), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($payroll['Payable']), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(25, 7, $payroll['CHQ'], 1, false, 'R', 0, '', 1, false, 'M', 'M');

                $total_sa += $payroll['S&A'];
                $total_salary += $payroll['Salary'];
                $total_arrears += $payroll['Arrears'];
                $total_allowances += $payroll['Gross']-$payroll['Salary']-$payroll['Arrears'];
                $total_gross += $payroll['Gross'];
                $total_tax += $payroll['TAX'];
                $total_eobi += $payroll['EOBI'];
                $total_deductions += $payroll['Gross']-$payroll['Payable']-$payroll['TAX']-$payroll['EOBI'];
                $total_payable += $payroll['Payable'];
            }
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->ln(7);
            $pdf->Cell(25, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(100, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, number_format($total_sa), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, number_format($total_salary), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, number_format($total_arrears), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, number_format($total_allowances), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, number_format($total_gross), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, number_format($total_tax), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, number_format($total_eobi), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, number_format($total_deductions), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, number_format($total_payable), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(25, 7, '', 1, false, 'R', 0, '', 1, false, 'M', 'M');

            // Print Allowances
            $arrWhere = [];
            $arrWhere[] = "`employee_id` = '".$employee['employee_id']."'";
            //$arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
            $where = implode(' AND ', $arrWhere);
            $allowances = $this->model['allowance']->getRows($where, array('document_date', 'company_id'));
            //d($allowances, true);
            if($allowances) {
                $pdf->ln(15);
                $pdf->SetFont('freesans', 'B', 10);
                $pdf->Cell(0, 7, 'Alowances:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->ln(7);
                $pdf->Cell(30, 7, 'Doc. Date', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, 'Doc. No.', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, 'Comp. Code', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, 'Allowance For', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, 'Doc. Amount', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, 'Approved Amount', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, 'Status', 1, false, 'L', 0, '', 1, false, 'M', 'M');

                $pdf->SetFont('freesans', '', 10);
                $total_amount = 0;
                $approved_amount=0;
                foreach($allowances as $allowance) {
                    $pdf->ln(7);
                    $pdf->Cell(30, 7, $allowance['document_date'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, $allowance['document_identity'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, $allowance['company_id'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, $allowance['special_allowance_type'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, $allowance['total_amount'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, $allowance['approved_amount'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, $allowance['approved_status'], 1, false, 'L', 0, '', 1, false, 'M', 'M');

                    $total_amount += $allowance['total_amount'];
                    $approved_amount += $allowance['approved_amount'];
                }
                $pdf->SetFont('freesans', 'B', 10);
                $pdf->ln(7);
                $pdf->Cell(30, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, $total_amount, 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, $approved_amount, 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            }

            // Print Qarzan Hasana
            $arrWhere = [];
            $arrWhere[] = "`employee_id` = '".$employee['employee_id']."'";
            //$arrWhere[] = "(`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."' OR `balance_installment` > 0)";
            $where = implode(' AND ', $arrWhere);
            $loans = $this->model['loan']->getRows($where, array('company_id', 'date'));
            //d($allowances, true);
            if($loans) {
                $pdf->ln(15);
                $pdf->SetFont('freesans', 'B', 10);
                $pdf->Cell(0, 7, 'Qarzan Hasana:', 0, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->ln(7);
                $pdf->Cell(20, 7, 'Comp. Code', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, 'Doc. Date', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, 'Description', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, 'T. Amount', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, 'T. Installment', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, 'Amt. Paid', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, 'Amt. Transferred', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, 'Bal. Installment', 1, false, 'L', 0, '', 1, false, 'M', 'M');

                $pdf->SetFont('freesans', '', 10);
                $total_amount = 0;
                $returned_amount = 0;
                foreach($loans as $loan) {
                    $pdf->ln(7);
                    $pdf->Cell(20, 7, $loan['company_id'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(20, 7, $loan['document_date'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, $loan['description'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, number_format($loan['total_amount'],0), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, $loan['total_installment'], 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, number_format($loan['amount_returned'],0), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, number_format($loan['amount_transfer'],0), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, $loan['balance_installment'], 1, false, 'R', 0, '', 1, false, 'M', 'M');

                    $total_amount += $loan['total_amount'];
                    $returned_amount += $loan['amount_returned'];
                }
                $pdf->SetFont('freesans', 'B', 10);
                $pdf->ln(7);
                $pdf->Cell(20, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, number_format($total_amount,0), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, number_format($returned_amount,0), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            }
        }

        //Close and output PDF document
        $pdf->Output('Employee Profile:' . date('YmdHis') . '.pdf', 'I');
    }

}

class PDF extends TCPDF
{
    public $data;

    //Page header
    public function Header()
    {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('freesans', 'B', 20);
        // Title
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->SetFont('freesans', 'B', 14);
        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer()
    {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(130, 10, 'Employee Profile:'.$this->data['employee_name'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(130, 10, 'Page ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(130, 10, 'Date: ' . date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}

?>