<?php

class ControllerReportEOBI extends HController {

    protected function getAlias() {
        return 'report/eobi';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']),['department_name']);

        $this->data['document_date'] = stdDate();
        $this->data['href_full_employee'] = $this->url->link($this->getAlias() . '/reportFullEmployee', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_active_employee'] = $this->url->link($this->getAlias() . '/reportActiveEmployee', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_inactive_employee'] = $this->url->link($this->getAlias() . '/reportInactiveEmployee', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_eobi_deducted'] = $this->url->link($this->getAlias() . '/reportEOBIDeducted', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_eobi_not_deducted'] = $this->url->link($this->getAlias() . '/reportEOBINotDeducted', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_eobi_statement'] = $this->url->link($this->getAlias() . '/reportEOBIStatement', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_eobi_no_salary'] = $this->url->link($this->getAlias() . '/reportEOBINoSalary', 'token=' . $this->session->data['token'], 'SSL');

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function reportEOBIStatement() {
        $post = $this->request->post;
        $output = $this->request->get['output'];
        $session = $this->session->data;

        $this->model['eobi_report'] = $this->load->model('report/eobi');
        $arrWhere = [];
        $arrWhere[] = "p.`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        $arrWhere[] = "er.`company_id` = '".$this->session->data['company_id']."'";
        if(isset($post['department_id'])) {
            $arrWhere[] = "er.`department_id` IN ('".implode("','", $post['department_id'])."')";
        }
        $where = implode(" AND ", $arrWhere);
        $employees = $this->model['eobi_report']->getEOBIStatement($where);
        if($output=='pdf') {
            $this->printStatement('EOBI Statement', $employees);
        } else {
            $this->excelStatement('EOBI Statement', $employees);
        }
    }

    public function reportFullEmployee() {
        $post = $this->request->post;
        $output = $this->request->get['output'];
        $session = $this->session->data;

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $arrWhere = [];
//        if($session['parent_company_id'] != 0) {
//            $arrWhere[] = "`parent_company_id` = '".$session['parent_company_id']."'";
//        } else {
//            $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
//        }
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`status` = 'Active'";
        if(isset($post['department_id'])) {
            $arrWhere[] = "`department_id` IN ('".implode("','", $post['department_id'])."')";
        }
        $where = implode(" AND ", $arrWhere);
        $employees = $this->model['employee']->getRows($where, ['employee_name']);
        if($output=='pdf') {
            $this->printReport('Full Active Employee', $employees);
        } else {
            $this->excelReport('Full Active Employee', $employees);
        }
    }

    public function reportActiveEmployee() {
        $post = $this->request->post;
        $output = $this->request->get['output'];
        $session = $this->session->data;

        $this->model['eobi_report'] = $this->load->model('report/eobi');
        $arrWhere = [];
//        if($session['parent_company_id'] != 0) {
//            $arrWhere[] = "er.`parent_company_id` = '".$session['parent_company_id']."'";
//        } else {
//            $arrWhere[] = "er.`company_id` = '".$this->session->data['company_id']."'";
//        }
        $arrWhere[] = "er.`company_id` = '".$this->session->data['company_id']."'";
        if(isset($post['department_id'])) {
            $arrWhere[] = "er.`department_id` IN ('".implode("','", $post['department_id'])."')";
        }
        $arrWhere[] = "er.`joining_date` >= '".MySqlDate($post['from_date'])."'";
        $arrWhere[] = "er.`joining_date` <= '".MySqlDate($post['to_date'])."'";
        $arrWhere[] = "p.`document_date` >= '".MySqlDate($post['from_date'])."'";
        $arrWhere[] = "p.`document_date` <= '".MySqlDate($post['to_date'])."'";
        $where = implode(" AND ", $arrWhere);
        $employees = $this->model['eobi_report']->getActiveEmployee($where);
        if($output=='pdf') {
            $this->printReport('New Active Employee', $employees);
        } else {
            $this->excelReport('New Active Employee', $employees);
        }
    }

    public function reportInactiveEmployee() {
        $post = $this->request->post;
        $output = $this->request->get['output'];
        $session = $this->session->data;

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $arrWhere = [];
//        if($session['parent_company_id'] != 0) {
//            $arrWhere[] = "`parent_company_id` = '".$session['parent_company_id']."'";
//        } else {
//            $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
//        }
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        if(isset($post['department_id'])) {
            $arrWhere[] = "`department_id` IN ('".implode("','", $post['department_id'])."')";
        }
        $arrWhere[] = "`leaving_date` >= '".MySqlDate($post['from_date'])."'";
        $arrWhere[] = "`leaving_date` <= '".MySqlDate($post['to_date'])."'";
        $where = implode(" AND ", $arrWhere);
        $employees = $this->model['employee']->getRows($where, ['employee_name']);
        //$this->printReport('Inactive Employee', $employees);
        if($output=='pdf') {
            $this->printReport('Inactive Employee', $employees);
        } else {
            $this->excelReport('Inactive Employee', $employees);
        }
    }

    public function reportEOBIDeducted() {
        $post = $this->request->post;
        $output = $this->request->get['output'];
        $session = $this->session->data;

        $this->model['eobi_report'] = $this->load->model('report/eobi');
        $arrWhere = [];
//        if($session['parent_company_id'] != 0) {
//            $arrWhere[] = "er.`parent_company_id` = '".$session['parent_company_id']."'";
//        } else {
//            $arrWhere[] = "er.`company_id` = '".$this->session->data['company_id']."'";
//        }
        $arrWhere[] = "er.`company_id` = '".$this->session->data['company_id']."'";
        if(isset($post['department_id'])) {
            $arrWhere[] = "er.`department_id` IN ('".implode("','", $post['department_id'])."')";
        }
        $arrWhere[] = "p.`document_date` >= '".MySqlDate($post['from_date'])."'";
        $arrWhere[] = "p.`document_date` <= '".MySqlDate($post['to_date'])."'";
        $where = implode(" AND ", $arrWhere);
        $employees = $this->model['eobi_report']->getReport('deducted', $where);
        //$this->printReport('EOBI Deducted', $employees);
        if($output=='pdf') {
            $this->printReport('EOBI Deducted', $employees);
        } else {
            $this->excelReport('EOBI Deducted', $employees);
        }
    }

    public function reportEOBINotDeducted() {
        $post = $this->request->post;
        $output = $this->request->get['output'];
        $session = $this->session->data;

        $this->model['eobi_report'] = $this->load->model('report/eobi');
        $arrWhere = [];
//        if($session['parent_company_id'] != 0) {
//            $arrWhere[] = "er.`parent_company_id` = '".$session['parent_company_id']."'";
//        } else {
//            $arrWhere[] = "er.`company_id` = '".$this->session->data['company_id']."'";
//        }
        $arrWhere[] = "er.`company_id` = '".$this->session->data['company_id']."'";
        if(isset($post['department_id'])) {
            $arrWhere[] = "er.`department_id` IN ('".implode("','", $post['department_id'])."')";
        }
        $arrWhere[] = "p.`document_date` >= '".MySqlDate($post['from_date'])."'";
        $arrWhere[] = "p.`document_date` <= '".MySqlDate($post['to_date'])."'";
        $where = implode(" AND ", $arrWhere);
        $employees = $this->model['eobi_report']->getReport('not_deducted', $where);
        //$this->printReport('EOBI Not Deducted', $employees);
        if($output=='pdf') {
            $this->printReport('EOBI Not Deducted', $employees);
        } else {
            $this->excelReport('EOBI Not Deducted', $employees);
        }
    }

    public function reportEOBINoSalary() {
        $post = $this->request->post;
        $output = $this->request->get['output'];
        $session = $this->session->data;

        $company_id = $session['company_id'];
        $department_id = $post['department_id'];
        $from_date = MySqlDate($post['from_date']);
        $to_date = MySqlDate($post['to_date']);

        $this->model['eobi_report'] = $this->load->model('report/eobi');
        $employees = $this->model['eobi_report']->getEOBINoSalary($company_id, $department_id, $from_date, $to_date);
        //$this->printReport('EOBI Not Deducted', $employees);
        if($output=='pdf') {
            $this->printReport('EOBI Active Employee for Pending Salary', $employees);
        } else {
            $this->excelReport('EOBI Active Employee for Pending Salary', $employees);
        }
    }

    private function printReport($report_title, $employees) {
        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => $report_title,
        );
        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle($report_title);
        $pdf->SetSubject($report_title);

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(10, 30, 5);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->AddPage();

        $sr = 1;
        foreach($employees as $employee) {
            $pdf->SetFont('freesans', '', 7);
            $pdf->Cell(10, 7, $sr, 1, false, 'R');
            $pdf->Cell(12, 7, $employee['employee_code'], 1, false, 'R');
            $pdf->Cell(12, 7, $employee['registration_code'], 1, false, 'R');
            $pdf->Cell(72, 7, $employee['employee_name'], 1, false, 'L');
            $pdf->Cell(15, 7, ($employee['dob']==""?"":stdDate($employee['dob'])), 1, false, 'L');
            $pdf->Cell(15, 7, ($employee['joining_date']==""?"":stdDate($employee['joining_date'])), 1, false, 'L');
            $pdf->Cell(22, 7, $employee['eobi_no'], 1, false, 'L');
            $pdf->Cell(22, 7, $employee['cnic_no'], 1, false, 'L');
            $pdf->Cell(15, 7, ($employee['leaving_date']==""?"":stdDate($employee['leaving_date'])), 1, false, 'L');

            $pdf->ln(7);
            $sr++;
        }

        //Close and output PDF document
        $pdf->Output($report_title.'-' . date('YmdHis') . '.pdf', 'I');
    }

    private function excelReport($report_title, $employees) {

        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $rowCount = 1;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Sr.');
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, 'Emp. No.');
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, 'Reg. No.');
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, 'Emp. Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, 'DOB');
        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, 'Joining Dt.');
        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, 'EOBI No.');
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, 'CNIC No.');
        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, 'Leaving Dt.');
        $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, 'Company');
        $rowCount++;
        $sr=0;
        foreach($employees as $employee){
            $sr++;
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $sr);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $employee['employee_code']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $employee['registration_code']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $employee['employee_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $employee['dob']?stdDate($employee['dob']):'');
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $employee['joining_date']?stdDate($employee['joining_date']):'');
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $employee['eobi_no']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $employee['cnic_no']);
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, $employee['leaving_date']?stdDate($employee['leaving_date']):'');
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, $employee['company_name']);
            $rowCount++;
        }

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'.$report_title.'.xlsx"');
        header('Cache-Control: max-age=0');
        //$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        //$objWriter->save('some_excel_file.xlsx');
        $objWriter->save('php://output');
        exit;
    }

    private function printStatement($report_title, $employees) {
        $pdf = new Statement('L', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => $report_title,
        );
        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle($report_title);
        $pdf->SetSubject($report_title);

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(10, 36, 5);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);
        $pdf->AddPage();

        $total_employers_contribution = 0;
        $total_employees_contribution = 0;
        $total_contribution = 0;
        $sr = 1;
        foreach($employees as $employee) {
            $pdf->SetFont('freesans', '', 7);
            $pdf->Cell(10, 7, $sr, 1, false, 'R');
            $pdf->Cell(20, 7, $employee['eobi_no'], 1, false, 'R');
            $pdf->Cell(20, 7, $employee['old_cnic_no'], 1, false, 'R');
            $pdf->Cell(25, 7, $employee['cnic_no'], 1, false, 'R');
            $pdf->Cell(70, 7, $employee['full_name'], 1, false, 'L');
            $pdf->Cell(10, 7, $employee['gender'], 1, false, 'L');
            $pdf->Cell(15, 7, ($employee['dob']==""?"":stdDate($employee['dob'])), 1, false, 'L');
            $pdf->Cell(15, 7, ($employee['joining_date']==""?"":stdDate($employee['joining_date'])), 1, false, 'L');
            $pdf->Cell(15, 7, ($employee['leaving_date']==""?"":stdDate($employee['leaving_date'])), 1, false, 'L');
            $pdf->Cell(12, 7, $employee['no_of_days'], 1, false, 'R');
            $pdf->Cell(17, 7, number_format($employee['gross_salary'],0), 1, false, 'R');
            $pdf->Cell(17, 7, number_format($employee['employers_contribution'],0), 1, false, 'R');
            $pdf->Cell(17, 7, number_format($employee['employee_contribution'],0), 1, false, 'R');
            $pdf->Cell(17, 7, number_format($employee['total_contribution'],0), 1, false, 'R');

            $pdf->ln(7);
            $sr++;
            $total_employers_contribution +=$employee['employers_contribution'];
            $total_employees_contribution +=$employee['employee_contribution'];
            $total_contribution +=$employee['total_contribution'];
        }
        $pdf->ln(7);

        $pdf->SetFont('freesans', 'B', 7);
        $pdf->Cell(35, 7, "Employer's Contribution" , 0, false, 'L');
        $pdf->SetFont('freesans', 'B', 7);
        $pdf->Cell(20, 7, number_format($total_employers_contribution,0) , 'B', false, 'R');
        $pdf->ln(7);

        $pdf->SetFont('freesans', 'B', 7);
        $pdf->Cell(35, 7, "Employee's Contribution" , 0, false, 'L');
        $pdf->SetFont('freesans', 'B', 7);
        $pdf->Cell(20, 7, number_format($total_employees_contribution,0) , 'B', false, 'R');
        $pdf->ln(7);

        $pdf->SetFont('freesans', 'B', 7);
        $pdf->Cell(35, 7, "Total Contribution" , 0, false, 'L');
        $pdf->SetFont('freesans', 'B', 7);
        $pdf->Cell(20, 7, number_format($total_contribution,0) , 'B', false, 'R');
        //Close and output PDF document
        $pdf->Output($report_title.'-' . date('YmdHis') . '.pdf', 'I');
    }

    private function excelStatement($report_title, $employees) {

        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $rowCount = 1;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'EMPLOYEES OLD AGE BENEFITS INSTITUTION');
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Ministry Of Human Resource Development');
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Government of Pakistan');
        $rowCount++;
        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Employer`s Name: ');
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $this->session->data['company_name']);
        $rowCount++;

        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Sr #');
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, 'Insured Person Registration No.');
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, 'OLD NIC');
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, 'CNIC');
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, 'Name of Insured Person F/Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, 'Sex');
        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, 'Date of Birth');
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, 'Date of Into Employment');
        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, 'Date of Exit if Application');
        $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, 'No. of Days for which salary Paid (Full Year)');
        $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, 'Amount of (Full Year)');
        $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, 'Employer`s Contribution (Full Year)');
        $objPHPExcel->getActiveSheet()->SetCellValue('M'.$rowCount, 'Insured Contribution (Full Year)');
        $objPHPExcel->getActiveSheet()->SetCellValue('N'.$rowCount, 'Total Contribution (Full Year)');
        $rowCount++;
        $sr=0;
        $total_employers_contribution=0;
        $total_employees_contribution=0;
        $total_contribution=0;
        foreach($employees as $employee){
            $sr++;
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $sr);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $employee['eobi_no']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $employee['old_cnic_no']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $employee['cnic_no']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $employee['full_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $employee['gender']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $employee['dob']?stdDate($employee['dob']):'');
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $employee['joining_date']?stdDate($employee['joining_date']):'');
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, $employee['leaving_date']?stdDate($employee['leaving_date']):'');
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, $employee['no_of_days']);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, $employee['gross_salary']);
            $objPHPExcel->getActiveSheet()->SetCellValue('l'.$rowCount, $employee['employers_contribution']);
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$rowCount, $employee['employee_contribution']);
            $objPHPExcel->getActiveSheet()->SetCellValue('N'.$rowCount, $employee['total_contribution']);
            $rowCount++;

            $total_employers_contribution += $employee['employers_contribution'];
            $total_employees_contribution += $employee['employee_contribution'];
            $total_contribution += $employee['total_contribution'];
        }

        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Employer`s Contribution');
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $total_employers_contribution);

        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Employee`s Contribution');
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $total_employees_contribution);

        $rowCount++;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Total Contribution');
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $total_contribution);
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, 'Signature of Employer with Seal');

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'.$report_title.'.xlsx"');
        header('Cache-Control: max-age=0');
        //$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        //$objWriter->save('some_excel_file.xlsx');
        $objWriter->save('php://output');
        exit;
    }
}

class PDF extends TCPDF {
    public $data;
    //Page header
    public function Header() {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Title
        $this->SetFont('freesans', 'B', 14);
        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C');
        $this->Ln(10);
        if($this->data['subtitle']) {
            $this->SetFont('freesans', '', 14);
            $this->Cell(0, 10, $this->data['subtitle'], 0, false, 'C');
            $this->Ln(10);
        }
        $this->SetFont('freesans', 'B', 7);
        $this->Cell(10, 7, 'Sr.', 1, false, 'C');
        $this->Cell(12, 7, 'Emp. No.', 1, false, 'C');
        $this->Cell(12, 7, 'Reg. No.', 1, false, 'C');
        $this->Cell(72, 7, 'Emp. Name', 1, false, 'C');
        $this->Cell(15, 7, 'DOB', 1, false, 'C');
        $this->Cell(15, 7, 'Joining Dt.', 1, false, 'C');
        $this->Cell(22, 7, 'EOBI No.', 1, false, 'C');
        $this->Cell(22, 7, 'CNIC No.', 1, false, 'C');
        $this->Cell(15, 7, 'Leaving Dt.', 1, false, 'C');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-10);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(95, 10, $this->data['report_title'].'|'.$this->request->post['from_date'].'|'.$this->request->post['to_date'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(95, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(95, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}

class Statement extends TCPDF {
    public $data;
    //Page header
    public function Header() {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Title
        $this->SetFont('freesans', 'B', 14);
        $this->Cell(0, 5, $this->data['company_name'], 0, true, 'C');
        $this->SetFont('freesans', 'B', 10);
        $this->Cell(0, 5, 'EMPLOYEES OLD AGE BENEFITS INSTITUTION', 0, true, 'L');
        $this->Cell(0, 5, 'Ministry of Human Resource Development', 0, true, 'L');
        $this->Cell(0, 5, 'Government of Pakistan', 0, true, 'L');
        $this->SetFont('freesans', 'B', 6);
        $this->Cell(10, 5, 'Sr #', 1, false, 'C');
        $this->Cell(20, 5, 'EOBI No.', 1, false, 'C');
        $this->Cell(20, 5, 'OLD CNIC', 1, false, 'C');
        $this->Cell(25, 5, 'CNIC', 1, false, 'C');
        $this->Cell(70, 5, 'Emp. Name', 1, false, 'C');
        $this->Cell(10, 5, 'Sex', 1, false, 'C');
        $this->Cell(15, 5, 'DOB', 1, false, 'C');
        $this->Cell(15, 5, 'Joining Dt.', 1, false, 'C');
        $this->Cell(15, 5, 'Leaving Dt.', 1, false, 'C');
        $this->Cell(12, 5, 'No. of Days', 1, false, 'C');
        $this->Cell(17, 5, 'Amount', 1, false, 'C');
        $this->Cell(17, 5, 'Employer Cont.', 1, false, 'C');
        $this->Cell(17, 5, 'Employee Cont.', 1, false, 'C');
        $this->Cell(17, 5, 'Total Cont.', 1, false, 'C');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-10);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(95, 10, $this->data['report_title'].'|'.$this->request->post['from_date'].'|'.$this->request->post['to_date'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(95, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(95, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>