<?php
class ControllerReportIncomeTaxCertificate extends HController {

    protected function getAlias() {
        return 'report/income_tax_certificate';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['href_generate_certificate'] = $this->url->link($this->getAlias() . '/generateCertificate', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_report'] = $this->url->link($this->getAlias() . '/printReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_detail_report'] = $this->url->link($this->getAlias() . '/printDetailReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation']="{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function GenerateCertificate() {



        ini_set('max_execution_time',0);
        try {
            $post = $this->request->post;
            //d($post,true);
            $ReportType = $post['report_type'];
            $employee_code = $post['employee_code'];
            $registration_code = $post['registration_code'];
            $department_id = $post['department_id'];
            $hijri_period = $post['hijri_period'];
            $issue_date = $post['issue_date'];
            $issuer_name = $post['name'];
            $issuer_designation = $post['designation'];

            $parent_company_id = $this->session->data['parent_company_id'];
            $company_id = $this->session->data['company_id'];
            //d($session,true);

            $this->model['payroll'] = $this->load->model('payroll/payroll');
            $this->model['certificate'] = $this->load->model('report/certificate_serial_no');
            $max_no = $this->model['certificate']->getNextNumber();

            $this->model['tax_report'] = $this->load->model('report/income_tax_certificate');
            if($post['select']=='employee_code') {
                $filter_type = 'employee_code';
                $filter_value = $employee_code;
            } elseif($post['select']=='registration_code') {
                $filter_type = 'registration_code';
                $filter_value = $registration_code;
            } else {
                $filter_type = 'department_id';
                $filter_value = $department_id;
            }
            $employees = $this->model['tax_report']->getEmployees($filter_type, $filter_value, $parent_company_id, $company_id);
            //d($employees, true);
            $arrEmployees = [];
            foreach($employees as $employee) {
                $arrEmployees[] = $employee['employee_id'];
            }
            $payrolls = $this->model['tax_report']->getTaxEmployee($parent_company_id, $company_id, $arrEmployees);
            //d([$parent_company_id, $company_id, $arrEmployees, $payrolls], true);
            $arrEmployees = [];
            foreach($payrolls as $payroll) {
                if(!isset($arrEmployees[$payroll['employee_id']])) {
                    $arrEmployees[$payroll['employee_id']] = [
                        'parent_company_id' => $payroll['parent_company_id'],
                        'company_id' => $payroll['company_id'],
                        'employee_id' => $payroll['employee_id'],
                        'cnic_name' => $payroll['cnic_name'],
                        'cnic_address' => $payroll['cnic_address'],
                        'cnic_no' => $payroll['cnic_no'],
                        'ntn_no' => $payroll['ntn_no'],
                        'taxable_salary' => 0,
                        'tax_deduction' => 0,
                        'payrolls' => []
                    ];
                }
                $arrEmployees[$payroll['employee_id']]['payrolls'][] = [
                    'payroll_id' => $payroll['payroll_id'],
                    'certificate_serial_id' => $payroll['certificate_serial_id'],
                    'taxable_salary' => $payroll['taxable_salary'],
                    'tax_deduction' => $payroll['tax_deduction'],
                ];
                $arrEmployees[$payroll['employee_id']]['taxable_salary'] += $payroll['taxable_salary'];
                $arrEmployees[$payroll['employee_id']]['tax_deduction'] += $payroll['tax_deduction'];
            }

            //d($arrEmployees, true);
            $sr_no = $max_no;
            $no_of_employee = $no_of_rows = 0;
            
           

            foreach ($arrEmployees as $employee) {

                $no_of_employee++;

                if($ReportType=='with_tax') {
                    if($employee['tax_deduction'] > 0) {
                        if($parent_company_id != 0) {
                            $insertData = [
                                'parent_company_id' => $employee['parent_company_id'],
                                'employee_id' => $employee['employee_id'],
                                'fiscal_year_id' => $this->session->data['fiscal_year_id'],
                                'serial_no' => $sr_no,
                                'cnic_no' => $employee['cnic_no'],
                                'cnic_name' => $employee['cnic_name'],
                                'cnic_address' => $employee['cnic_address'],
                                'ntn_no' => $employee['ntn_no'],
                                'tax_deduction' => $employee['tax_deduction'],
                                'taxable_salary' => $employee['taxable_salary'],
                                'hijri_period' => $hijri_period,
                                'issue_date' => MySqlDate($issue_date),
                                'issuer_name' => $issuer_name,
                                'issuer_designation' => $issuer_designation,
                            ];
                            $certificate_id = $this->model['certificate']->add($this->getAlias(), $insertData);
                            $this->model['payroll']->canAudit = false;
                            foreach($employee['payrolls'] as $payroll) {
                                $this->model['payroll']->edit($this->getAlias(), $payroll['payroll_id'],['certificate_serial_id' => $certificate_id]);
                            }
                        } else {
                            $insertData = [
                                'company_id' => $employee['company_id'],
                                'employee_id' => $employee['employee_id'],
                                'fiscal_year_id' => $this->session->data['fiscal_year_id'],
                                'serial_no' => $sr_no,
                                'cnic_no' => $employee['cnic_no'],
                                'cnic_name' => $employee['cnic_name'],
                                'cnic_address' => $employee['cnic_address'],
                                'ntn_no' => $employee['ntn_no'],
                                'tax_deduction' => $employee['tax_deduction'],
                                'taxable_salary' => $employee['taxable_salary'],
                                'hijri_period' => $hijri_period,
                                'issue_date' => MySqlDate($issue_date),
                                'issuer_name' => $issuer_name,
                                'issuer_designation' => $issuer_designation,
                            ];
                            $certificate_id = $this->model['certificate']->add($this->getAlias(), $insertData);
                            $this->model['payroll']->canAudit = false;
                            foreach($employee['payrolls'] as $payroll) {
                                $this->model['payroll']->edit($this->getAlias(), $payroll['payroll_id'],['certificate_serial_id' => $certificate_id]);
                            }
                        }
                        $sr_no++;
                        $no_of_rows++;
                    }
                } else {
                    //d($employee, true);
                    if($employee['tax_deduction'] == 0) {
                        if ($parent_company_id != 0) {
                            $insertData = [
                                'parent_company_id' => $employee['parent_company_id'],
                                'employee_id' => $employee['employee_id'],
                                'fiscal_year_id' => $this->session->data['fiscal_year_id'],
                                'serial_no' => $sr_no,
                                'cnic_no' => $employee['cnic_no'],
                                'cnic_name' => $employee['cnic_name'],
                                'cnic_address' => $employee['cnic_address'],
                                'ntn_no' => $employee['ntn_no'],
                                'tax_deduction' => $employee['tax_deduction'],
                                'taxable_salary' => $employee['taxable_salary'],
                                'hijri_period' => $hijri_period,
                                'issue_date' => MySqlDate($issue_date),
                                'issuer_name' => $issuer_name,
                                'issuer_designation' => $issuer_designation,
                            ];
                            $certificate_id = $this->model['certificate']->add($this->getAlias(), $insertData);
                            foreach ($employee['payrolls'] as $payroll) {
                                 $this->model['payroll']->edit($this->getAlias(), $payroll['payroll_id'], ['certificate_serial_id' => $certificate_id]);
                            }
                        } else {
                            $insertData = [
                                'company_id' => $employee['company_id'],
                                'employee_id' => $employee['employee_id'],
                                'fiscal_year_id' => $this->session->data['fiscal_year_id'],
                                'serial_no' => $sr_no,
                                'cnic_no' => $employee['cnic_no'],
                                'cnic_name' => $employee['cnic_name'],
                                'cnic_address' => $employee['cnic_address'],
                                'ntn_no' => $employee['ntn_no'],
                                'tax_deduction' => $employee['tax_deduction'],
                                'taxable_salary' => $employee['taxable_salary'],
                                'hijri_period' => $hijri_period,
                                'issue_date' => MySqlDate($issue_date),
                                'issuer_name' => $issuer_name,
                                'issuer_designation' => $issuer_designation,
                            ];
                             $certificate_id = $this->model['certificate']->add($this->getAlias(), $insertData);
                            foreach ($employee['payrolls'] as $payroll) {
                                 $this->model['payroll']->edit($this->getAlias(), $payroll['payroll_id'], ['certificate_serial_id' => $certificate_id]);
                            }
                        }
                        $sr_no++;
                        $no_of_rows++;
                    }
                }
            }

            if(!empty($arrEmployees)) {

               $text =  (($no_of_rows!=0) ? $no_of_rows : '').' Certificate Generated successfully, ';

               if($no_of_rows!=$no_of_employee){
                $record = ($no_of_employee-$no_of_rows ==1) ? $no_of_employee-$no_of_rows.' Record' : $no_of_employee-$no_of_rows.' Records';
                $text .=  ' But '.$record.' is already exist.';
                }

                $json = [
                    'success' => true,
                    'message' => $text
                ];
            } else {
                $json = [
                    'success' => true,
                    'message' => 'No records found.'
                ];
            }
        } catch (Exception $e) {
            $json = [
                'success' => false,
                'error' => $e->getMessage()
            ];
            //d($e, true);
        }

        echo json_encode($json);
        exit;
    }

    public function printReport() {
        $session = $this->session->data;
        $post = $this->request->post;
        if($post['select']=='department_id') {
            $post['employee_code'] = '';
            $post['registration_code'] = '';
        } elseif($post['select']=='registration_code') {
            $post['employee_code'] = '';
            $post['department_id'] = [];
        } else {
            $post['registration_code'] = '';
            $post['department_id'] = [];
        }
        //d($post,true);
        $ReportType = $post['report_type'];
        $employee_code = $post['employee_code'];
        $registration_code = $post['registration_code'];
        $department_id = $post['department_id'];
        $hijri_period = $post['hijri_period'];
        $issue_date = $post['issue_date'];
        $name = $post['name'];
        $designation = $post['designation'];

        $parent_company_id = $this->session->data['parent_company_id'];
        $company_id = $this->session->data['company_id'];

        $this->model['company'] = $this->load->model('setup/company');
        $parent_company = $this->model['company']->getRow(['company_id' => $parent_company_id]);
        $company = $this->model['company']->getRow(['company_id' => $company_id]);
        //d($session,true);

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $this->model['certificate'] = $this->load->model('report/certificate_serial_no');
        $this->model['tax_report'] = $this->load->model('report/income_tax_certificate');

        $filter = [
            'parent_company_id' => $parent_company_id,
            'company_id' => $company_id,
            'employee_code' => $employee_code,
            'registration_code' => $registration_code,
            'department_id' => $department_id,
        ];
        $employees = $this->model['certificate']->getCertificateEmployees($filter);
        $arrEmployees = [];
        foreach($employees as $employee) {
            $arrEmployees[] = $employee['employee_id'];
        }
        $filter['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $filter['employees'] = $arrEmployees;
        $employees = $this->model['certificate']->getCertificate($filter);
        //d([$filter, $employees], true);
        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => 'Income Tax Certificate',
        );
        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Income Tax Certificate');
        $pdf->SetSubject('Income Tax Certificate');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 70, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 5);

//        d(array($ReportType,$employees),true);
        foreach($employees as $employee) {
            $payrolls = $this->model['tax_report']->getTaxPayrolls($employee['certificate_serial_no_id']);
            //d(array($employee, $payrolls), true);
            // add a page
            $pdf->AddPage();

            $pdf->SetFont('freesans', 'B', 10);
            // Title
            $pdf->Cell(0, 10,"Certificate Of Collection or Deduction of Income Tax (Including Salary)", 0, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Ln(6);
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(0, 10, "Under Rule 42", 0, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Ln(8);
            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(15, 5,"S.No. ".$employee['serial_no'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 5,"", 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(77, 5,"Original/Duplicate", 0, false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(40, 5,"Date Of Issue:", 0, false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(30, 5,$issue_date, 'B', false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->ln(6);

            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(40, 5, 'Certified that a sum of', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(20, 5, 'Rupees', 0, false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(40, 5, number_format($employee['tax_deduction'],0), 'B', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(80, 5, '(Amount of Tax collected/deducted in figures)', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(6);
            $pdf->Cell(40, 5, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(20, 5, 'Rupees', 0, false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(80, 5, Number2Words(round($employee['tax_deduction'])), 'B', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(40, 5, ' (Amount in Words)', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(6);
            $txt = "on account of income tax has been deducted/collected from (Name and Address of the person from whom tax collected/deducted)";
            $pdf->MultiCell(70, 20,$txt, 0, 'L', 0, 0, '', '', true);
            $pdf->Cell(110, 10, strtoupper($employee['cnic_name']), 'B', false, 'L', 0, '', 0, false, 'M', 'B');
            $pdf->ln(10);
            $pdf->Cell(70, 5, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(110, 5, $employee['cnic_address'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(6);
            $pdf->Cell(70, 5, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(110, 5, '', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->SetFont('freesans', '', 8);
            $pdf->Cell(70, 5, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(110, 5, 'In case of an individual, his/her name in full and incase of an association of', '', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->ln(3);
            $pdf->Cell(70, 5, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(110, 5, 'persons/company, name and style of the association of persons/company', '', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->SetFont('freesans', '', 10);
            $pdf->Cell(70, 5, 'having National Tax Number', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, $employee['ntn_no'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, '(if any) and', '', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->Cell(70, 5, 'holder of CNIC No.', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, $employee['cnic_no'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, '(in case of an individual only) and', '', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->Cell(70, 5, 'on', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, '', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, '(Date of collection/deduction)', '', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->Cell(70, 5, 'Or during the period', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, 'From '.stdDate($session['fiscal_date_from']).' To '.stdDate($session['fiscal_date_to']), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, '(Period of collection/deduction)', '', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->Cell(70, 5, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            //$pdf->Cell(55, 5, 'From '.HDate($session['fiscal_date_from']).'H To '.HDate($session['fiscal_date_to']).'H', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            if($hijri_period != '') {
                $pdf->Cell(55, 5, $hijri_period, 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            }
            $pdf->Cell(55, 5, '', '', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->Cell(70, 5, 'Under section', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, '149', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, '(specify section of the income tax ordinance 2001)', '', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->Cell(70, 5, 'on account of', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, 'Salary', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, '(specify nature)', '', false, 'L', 0, '', 1, false, 'M', 'M');
            if($employee['medical_allowance'] != 0) {
                $gross_salary = $employee['taxable_salary'] + $employee['medical_allowance'];
                $pdf->ln(5);
                $pdf->Cell(70, 5, 'Gross Salary', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(40, 5, 'Rupee: '. number_format($gross_salary,0), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(70, 5, '', '', false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->ln(5);
                $pdf->Cell(70, 5, 'Medical Allowance (10% of Basic Salary)', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(40, 5, 'Rupee: '. number_format($employee['medical_allowance'],0), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(70, 5, '', '', false, 'L', 0, '', 1, false, 'M', 'M');
            }
            $pdf->ln(5);
            $pdf->Cell(70, 5, 'Vide', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, 'N.A', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, '(particulars of LC, Contract etc.)', '', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->Cell(70, 5, 'on the value/amount of', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(40, 5, 'Rupee: '. number_format($employee['taxable_salary'],0), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(70, 5, '(Gross amount on which tax deducted/collected in figures)', '', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->Cell(70, 5, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(80, 5, 'Rupee: '. Number2Words(round($employee['taxable_salary'])), 'B', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(30, 5, '(Amount in words)', '', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(7);
            $pdf->Cell(0, 5, 'This is to further certify that the tax collected/deducted has been deposited in Federal Government Accounts', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->Cell(0, 5, 'as per following details:', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(6);
            $pdf->SetFont('freesans', '', 9);
            $pdf->Cell(30, 4, 'Date of Deposit', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(30, 4, 'SBP/NBP/Treasury', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(30, 4, 'Branch/City', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(30, 4, 'Amount (Rupees)', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(60, 4, 'Challan No/CPR No/Traesury', 1, false, 'C', 0, '', 1, false, 'M', 'M');
            $pdf->ln(4);
            $pdf->SetFont('freesans', '', 8);
            foreach($payrolls as $payroll) {
                $pdf->Cell(30, 4, stdDate($payroll['tax_challan_date']), 1, false, 'C', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 4, $payroll['bank_name'], 1, false, 'C', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 4, $payroll['tax_challan_branch'], 1, false, 'C', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 4, number_format($payroll['tax_deduction'],0), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(60, 4, $payroll['tax_challan_no'], 1, false, 'C', 0, '', 1, false, 'M', 'M');
                $pdf->ln(4);
            }
            // Edit By fahad
            $pdf->SetFont('freesans', '', 8);
            $pdf->ln(2);
            $pdf->Cell(0, 5, 'Company / Office etc. collecting/deduction the tax:', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->Cell(30, 5, 'Name:', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            if($parent_company_id)
            {
                $pdf->Cell(55, 5, $parent_company['company_name'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            } else {
                $pdf->Cell(55, 5, $company['company_name'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
            }
            $pdf->Cell(10, 5, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(30, 5, 'Signature:', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, '', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(6);
            $pdf->Cell(30, 5, 'Address:', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, $company['address'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(10, 5, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(30, 5, 'Name:', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, $employee['issuer_name'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(6);
            $pdf->Cell(30, 5, 'NTN (if any)', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, $company['ntn_no'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(10, 5, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(30, 5, 'Designation:', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, $employee['issuer_designation'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(6);
            $pdf->Cell(30, 5, 'Date', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, stdDate($employee['issue_date']), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(10, 5, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(30, 5, 'Seal:', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(55, 5, '', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        }

        //Close and output PDF document
        $pdf->Output('Payroll Slip:'.date('YmdHis').'.pdf', 'I');
    }

    public function printDetailReport() {
        ini_set('max_execution_time',400);
        $lang = $this->load->language($this->getAlias());
        $session = $this->session->data;
        $post = $this->request->post;

        // edit by fahad
        $this->model['company'] = $this->load->model('setup/company');
        $company = $this->model['company']->getRow(array('company_id' => $session['company_id']));

        // edit by fahad
        $this->model['parent_company'] = $this->load->model('setup/parent_company');
        $ParentCompany = $this->model['parent_company']->getRow(array('parent_company_id' => $session['parent_company_id']));

        $this->model['tax_report'] = $this->load->model('report/income_tax_certificate');
        $Records = $this->model['tax_report']->getCertificateReport($post['department_id']);

        //d($Records,true);
        //d($employees, true);
        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => 'Income Tax Certificate Report',
            'type' => 'Report',
        );
        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Fahad');
        $pdf->SetTitle('Income Tax Certificate Report');
        $pdf->SetSubject('Income Tax Certificate Report');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 10, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 5);

        $pdf->AddPage();

        $pdf->SetFont('freesans', 'B', 16);
        $pdf->Cell(0, 10, $this->session->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Ln(10);
        $pdf->SetFont('freesans', 'B', 14);
        $pdf->Cell(0, 7, 'Income Tax Certificate Report', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Ln(15);

        $pdf->SetFont('freesans', 'B', 9);
        $pdf->Cell(15, 7, 'Serial #', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(15, 7, 'Emp No', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(105, 7, 'Emp Name', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(55, 7, 'Department', 1, false, 'C', 0, '', 0, false, 'M', 'M');

        $pdf->SetFont('freesans', '', 9);
        foreach($Records as $record) {

            $pdf->Ln(6);
            $pdf->Cell(15, 6, $record['serial_no'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 6, $record['registration_code'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(105, 6, $record['full_name'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(55, 6, $record['department_name'], 1, false, 'L', 0, '', 1, false, 'M', 'M');

        }
        //Close and output PDF document
        $pdf->Output('Income Tax Report:'.date('YmdHis').'.pdf', 'I');

    }

}

class PDF extends TCPDF {
    public $data;
    //Page header
    public function Header() {
        $this->SetFont('freesans', '', 9);
        // Logo
        //$image_file = DIR_IMAGE.'itax_image.png';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 75, 2, 60, 50, 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        $this->Ln(50);
        //$this->Cell(0, 5, 'Administration of 53rd al-Dai al-Mutlaq, His Holiness Syedna Mufaddal Saifuddin TUS', '', false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(0, 5, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Ln(10);
        $this->Cell(100, 5, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
        //$this->Cell(80, 5, 'ADMINISTRATIVE OFFICE', '', false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(80, 5, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Ln(4);
        $this->Cell(100, 5, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(80, 5, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
        //$this->Cell(80, 5, 'KARACHI', '', false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Ln(5);
        $this->Cell(0, 1, '', '', false, 'C', 0, '', 0, false, 'T', 'M');

    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-10);
        // Set font
        $this->SetFont('helvetica', '', 8);
        // Page number
        //$this->Cell(0, 5, 'Burhani Mahal, Mclever Road, Karachi-75530 (PAKISTAN)', 'T', false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(0, 5, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
        $this->ln(5);
        $this->Cell(10, 5, '', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        //$this->Cell(160, 5, 'TEL: +92 21 35685676, +92 21 35646666, EMAIL: dh@dawatkhi.com', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(160, 5, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(10, 5, '', 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>