<?php

class ControllerReportPayrollRegister extends HController {

    protected function getAlias() {
        return 'report/payroll_register';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['document_date'] = stdDate();
        $this->data['href_get_report'] = $this->url->link($this->getAlias() . '/getReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_report'] = $this->url->link($this->getAlias() . '/printReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_summary_report'] = $this->url->link($this->getAlias() . '/printSummaryReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_employee_register'] = $this->url->link($this->getAlias() . '/printEmployeeRegister', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_excel_report'] = $this->url->link($this->getAlias() . '/excelReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation']="{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function getReport() {
        $from_document_date = $this->request->post['from_document_date'];
        $to_document_date = $this->request->post['to_document_date'];
        $department_id = $this->request->post['department_id'];
        $employee_id = $this->request->post['employee_id'];

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`document_date` >= '".MySqlDate($from_document_date)."'";
        $arrWhere[] = "`document_date` <= '".MySqlDate($to_document_date)."'";
        if($department_id != '') {
            $arrWhere[] = "`department_id` IN (".implode(',',$department_id).")";
        }
        if($employee_id != '') {
            $arrWhere[] = "`employee_id` = '".$employee_id."'";
        }

        $where = implode(' AND ', $arrWhere);
        $payrolls = $this->model['payroll']->getRows($where);
        //d(array($where, $payrolls), true);
        $html = '';
        foreach($payrolls as $row_id => $payroll) {
            $html .= '<tr>';
            $html .= '<td class="text-left">'.($row_id+1).'</td>';
            $html .= '<td class="text-left">'.$payroll['registration_code'].'</td>';
            $html .= '<td class="text-left">'.$payroll['employee_name'].'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['basic_salary'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['arrears'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['other_allowance'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['gross_salary'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['other_deduction'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['tax_deduction'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['net_salary']-$payroll['payable_salary'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['payable_salary'],2).'</td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'filter' => $arrWhere,
            'payrolls' => $payrolls,
            'html' => $html
        );

        echo json_encode($json);
    }

    public function printReport() {
        ini_set('max_execution_time',400);
        $lang = $this->load->language($this->getAlias());
        $from_document_date = $this->request->post['from_document_date'];
        $to_document_date = $this->request->post['to_document_date'];
        $department_id = $this->request->post['department_id'];
        $employee_id = $this->request->post['employee_id'];

        $arrWhere = array();
        $arrWhere[] = "p.`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "p.`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        $arrWhere[] = "`document_date` >= '".MySqlDate($from_document_date)."'";
        $arrWhere[] = "`document_date` <= '".MySqlDate($to_document_date)."'";
        if($department_id != '') {
            $arrWhere[] = "p.`department_id` IN (".implode(',',$department_id).")";
        }
        if($employee_id != '') {
            $arrWhere[] = "p.`employee_id` = '".$employee_id."'";
        }

        $where = implode(' AND ', $arrWhere);

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $rows = $this->model['payroll']->getRegister($where);
        $columns = array_keys($rows[0]);
        //d($columns,true);
        //d([$columns,$rows],true);
        $columns[0] = 'Sr.';

        unset($columns[1]);
        unset($columns[2]);
        unset($columns[3]);
        unset($columns[4]);
        unset($columns[5]);
        unset($columns[6]);
        unset($columns[7]);
        unset($columns[8]);
        unset($columns[10]);
        unset($columns[11]);
        unset($columns[12]);
        unset($columns[13]);
        unset($columns[14]);

        //d($columns, true);
        $pdf = new PDF('L', PDF_UNIT, 'A3', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => 'Payroll Register',
            'subtitle' => $rows[0]['document_title']
        );
        $page_width = 415;

        $arrColumns = array();
        $total_ratio = count($columns) + 4;
        $width = round($page_width / $total_ratio);
        //d($rows, true);
        //d(array($columns, count($columns), $total_ratio, $width), true);
        $total_width = 0;
        foreach($columns as $column) {
            if($column != 'Name') {
                $arrColumns[$column] = $width;
            } else {
                $arrColumns[$column] = $page_width - ($width*($total_ratio-4));
            }
        }
        //d(array($columns, $arrColumns), true);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Payroll Register');
        $pdf->SetSubject('Payroll Register');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();
        //$pdf->Cell(390, 10, '', 1, false, 'L', 0, '', 0, false, 'M', 'M');
        $department_name = '';
        $pdf->SetFont('freesans', '', 9);
        $arrTotal = array();
        $arrGTotal = array();
        foreach($arrColumns as $column_name => $width) {
            if($column_name=='Sr.' || $column_name=='Doc. Date' || $column_name=='document_title' || $column_name=='Reg No.' || $column_name=='Name' || $column_name == 'CHQ') {
                $arrGTotal[$column_name] = '';
            } else {
                $arrGTotal[$column_name] = 0;
            }
        }
        foreach($rows as $row_id => $row) {
            $row['Sr.'] = ($row_id+1);
            if($department_name != $row['department_name']) {
                if($department_name != '') {
                    $pdf->SetFont('freesans', 'B', 9);
                    foreach($arrColumns as $column_name => $width) {
                        if($column_name=='Sr.' || $column_name=='Doc. Date' || $column_name=='document_title' || $column_name=='Reg No.' || $column_name=='Name' || $column_name == 'CHQ' || $column_name == 'chq_date') {
                            $pdf->Cell($width, 10, '', 'B', false, 'C', 0, '', 1, false, 'M', 'M');
                        } else {
                            $pdf->Cell($width, 10, number_format($arrTotal[$column_name],0), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
                        }
                    }
                    $pdf->ln(10);
                }
                $arrTotal = array();
                foreach($arrColumns as $column_name => $width) {
                    if($column_name=='Sr.' || $column_name=='Doc. Date' || $column_name=='document_title' || $column_name=='Reg No.' || $column_name=='Name' || $column_name == 'CHQ' || $column_name == 'chq_date') {
                        $arrTotal[$column_name] = '';
                    } else {
                        $arrTotal[$column_name] = 0;
                    }
                }
                $pdf->Cell(30, 10, $row['department_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->ln(10);
                foreach($arrColumns as $column_name => $width) {
                    $pdf->Cell($width, 10, $column_name, 1, false, 'C', 0, '', 1, false, 'M', 'M');
                }
                $pdf->ln(10);
                $department_name = $row['department_name'];
            }

            $pdf->SetFont('freesans', '', 9);
            foreach($arrColumns as $column_name => $width) {
                if($column_name=='Sr.' || $column_name=='Doc. Date' || $column_name=='Reg No.' || $column_name=='Name' || $column_name == 'CHQ' || $column_name == 'chq_date') {
                    $pdf->Cell($width, 10, $row[$column_name], '', false, 'L', 0, '', 1, false, 'M', 'M');
                } else {
                    $pdf->Cell($width, 10, number_format($row[$column_name],0), '', false, 'R', 0, '', 1, false, 'M', 'M');
                    $arrTotal[$column_name] += $row[$column_name];
                    $arrGTotal[$column_name] += $row[$column_name];
                }
            }
            $pdf->ln(5);
            $pdf->Cell(0, 10, ' Joining Date : '.stdDate($row['joining_date']).' | CNIC :  '.$row['cnic_no'].' |  Designation : '.$row['designation_name'].' |  Name : '.$row['Name'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(10);
            $y=$pdf->GetY();
            if($y > 250) {
                $pdf->AddPage();
                foreach($arrColumns as $column_name => $width) {
                    $pdf->Cell($width, 10, $column_name, 1, false, 'C', 0, '', 1, false, 'M', 'M');
                }
                $pdf->ln(10);
            }
        }


        $pdf->SetFont('freesans', 'B', 9);
        foreach($arrColumns as $column_name => $width) {
            if($column_name=='Reg No.' || $column_name=='Doc. Date' || $column_name=='document_title' || $column_name=='Name' || $column_name == 'CHQ' || $column_name == 'chq_date') {
                $pdf->Cell($width, 10, '', 'B', false, 'C', 0, '', 1, false, 'M', 'M');
            } else {
                $pdf->Cell($width, 10, number_format($arrTotal[$column_name],0), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
            }
        }
        $pdf->ln(20);
        foreach($arrColumns as $column_name => $width) {
            if($column_name=='Name') {
                $pdf->Cell($width, 10, 'Total', 'B', false, 'C', 0, '', 1, false, 'M', 'M');
            } elseif($column_name=='Sr.' || $column_name=='document_date' || $column_name=='document_title' || $column_name=='Emp No.' || $column_name == 'CHQ' || $column_name == 'chq_date') {
                $pdf->Cell($width, 10, '', 'B', false, 'C', 0, '', 1, false, 'M', 'M');
            } else {
                $pdf->Cell($width, 10, number_format($arrGTotal[$column_name],0), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
            }
        }

        //Close and output PDF document
        $pdf->Output('Payroll Register:'.date('YmdHis').'.pdf', 'I');
    }

    public function printSummaryReport() {
        ini_set('max_execution_time',0);
        $lang = $this->load->language($this->getAlias());
        $from_document_date = $this->request->post['from_document_date'];
        $to_document_date = $this->request->post['to_document_date'];
        $department_id = $this->request->post['department_id'];
        $employee_id = $this->request->post['employee_id'];

        $arrWhere = array();
        $arrWhere[] = "p.`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "p.`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        $arrWhere[] = "`document_date` >= '".MySqlDate($from_document_date)."'";
        $arrWhere[] = "`document_date` <= '".MySqlDate($to_document_date)."'";
        if($department_id != '') {
            $arrWhere[] = "p.`department_id` IN (".implode(',',$department_id).")";
        }
        if($employee_id != '') {
            $arrWhere[] = "p.`employee_id` = '".$employee_id."'";
        }

        $where = implode(' AND ', $arrWhere);

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        //$rows = $this->model['payroll']->getRegisterSummary($where);
        $rows = $this->model['payroll']->createTemporaryRegister($where);
        //d(array('where' => $where, 'rows' => $rows), true);
        $columns = array_keys($rows[0]);
        $columns[0] = 'Sr.';

        $arrColumns = array();
        $total_ratio = count($columns) + 3;
        $width = round(390 / $total_ratio);
        //d($rows, true);
        //d(array($columns, count($columns), $total_ratio, $width), true);
        $total_width = 0;
        foreach($columns as $column) {
            if($column != 'Name') {
                $arrColumns[$column] = $width;
            } else {
                $arrColumns[$column] = 390 - ($width*($total_ratio-3));
            }
        }
        //d(array($columns, $arrColumns), true);

        $pdf = new PDF('L', PDF_UNIT, 'A3', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => 'Payroll Register',
            // 'subtitle' => $rows[0]['document_title']
            // Edit by Fahad
            'subtitle' => 'Period from: '.$from_document_date . ' to ' . $to_document_date

        );
        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Payroll Summary Register');
        $pdf->SetSubject('Payroll Summary Register');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();
        //$pdf->Cell(390, 10, '', 1, false, 'L', 0, '', 0, false, 'M', 'M');
        //$department_name = '';
        $employee_name = '';
        $pdf->SetFont('freesans', '', 10);
        $arrTotal = array();
        $arrGTotal = array();
        foreach($arrColumns as $column_name => $width) {
            if($column_name=='Sr.' || $column_name=='Reg No.' || $column_name=='Name' || $column_name == 'CHQ') {
                $arrGTotal[$column_name] = '';
            } else {
                $arrGTotal[$column_name] = 0;
            }
        }


        //d($rows,true);
        foreach($rows as $row_id => $row) {
            $row['Sr.'] = ($row_id+1);
            //if($department_name != $row['department_name']) {
            if($employee_name != $row['Reg No.']) {
                //if($department_name != '') {
                if($employee_name != '') {
                    $pdf->SetFont('freesans', 'B', 10);
                    foreach($arrColumns as $column_name => $width) {
                        if($column_name=='Sr.' || $column_name=='Reg No.' || $column_name=='Name' || $column_name == 'CHQ' || $column_name == 'Doc. Date') {
                            $pdf->Cell($width, 10, '', 'B', false, 'C', 0, '', 1, false, 'M', 'M');
                        } else {
                            $pdf->Cell($width, 10, number_format($arrTotal[$column_name],0), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
                        }
                    }
                    $pdf->ln(10);
                }
                $arrTotal = array();
                foreach($arrColumns as $column_name => $width) {
                    if($column_name=='Sr.' || $column_name=='Reg No.' || $column_name=='Name' || $column_name == 'CHQ' || $column_name == 'Doc. Date') {
                        $arrTotal[$column_name] = '';
                    } else {
                        $arrTotal[$column_name] = 0;
                    }
                }
                $pdf->Cell(30, 10, $row['Reg No.'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                //$pdf->Cell(30, 10, $row['department_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->ln(10);
                foreach($arrColumns as $column_name => $width) {
                    $pdf->Cell($width, 10, $column_name, 1, false, 'C', 0, '', 1, false, 'M', 'M');
                }
                $pdf->ln(10);
                //$department_name = $row['department_name'];
                $employee_name = $row['Reg No.'];
            }
            $pdf->SetFont('freesans', '', 10);
            foreach($arrColumns as $column_name => $width) {
                if($column_name=='Sr.' || $column_name=='Reg No.' || $column_name=='Name' || $column_name == 'CHQ' || $column_name == 'Doc. Date') {
                    $pdf->Cell($width, 10, $row[$column_name], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
                } else {
                    $pdf->Cell($width, 10, number_format($row[$column_name],0), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
                    $arrTotal[$column_name] += $row[$column_name];
                    $arrGTotal[$column_name] += $row[$column_name];
                }
            }
            $pdf->ln(10);
        }
        $pdf->SetFont('freesans', 'B', 10);
        foreach($arrColumns as $column_name => $width) {
            if($column_name=='Reg No.' || $column_name=='Name' || $column_name == 'CHQ' || $column_name == 'Doc. Date') {
                $pdf->Cell($width, 10, '', 'B', false, 'C', 0, '', 1, false, 'M', 'M');
            } else {
                $pdf->Cell($width, 10, number_format($arrTotal[$column_name],0), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
            }
        }
        $pdf->ln(20);
        foreach($arrColumns as $column_name => $width) {
            if($column_name=='Reg No.') {
                $pdf->Cell($width, 10, 'Total', 'B', false, 'C', 0, '', 1, false, 'M', 'M');
            } elseif($column_name=='Sr.' || $column_name=='Emp No.' || $column_name == 'CHQ' || $column_name == 'Doc. Date') {
                $pdf->Cell($width, 10, '', 'B', false, 'C', 0, '', 1, false, 'M', 'M');
            } else {
                $pdf->Cell($width, 10, number_format($arrGTotal[$column_name],0), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
            }
        }

        //Close and output PDF document
        $pdf->Output('Payroll Register:'.date('YmdHis').'.pdf', 'I');
    }

    public function printEmployeeRegister() {
        ini_set('max_execution_time',0);
        $lang = $this->load->language($this->getAlias());
        $from_document_date = $this->request->post['from_document_date'];
        $to_document_date = $this->request->post['to_document_date'];
        $department_id = $this->request->post['department_id'];
        $employee_id = $this->request->post['employee_id'];

        $arrWhere = array();
        $arrWhere[] = "p.`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`document_date` >= '".MySqlDate($from_document_date)."'";
        $arrWhere[] = "`document_date` <= '".MySqlDate($to_document_date)."'";
        if($department_id != '') {
            $arrWhere[] = "p.`department_id` IN (".implode(',',$department_id).")";
        }
        if($employee_id != '') {
            $arrWhere[] = "p.`employee_id` = '".$employee_id."'";
        }

        $where = implode(' AND ', $arrWhere);

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $rows = $this->model['payroll']->getRegister($where);
        $arrPayrolls = array();
        foreach($rows as $row) {
            $employee_registration_id = $row['employee_registration_id'];
            if(!isset($arrPayrolls[$employee_registration_id])) {
                $arrPayrolls[$employee_registration_id] = array(
                    'department_name' => $row['department_name'],
                    'reg_no' => $row['Reg No.'],
                    'name' => $row['Name'],
                    'payrolls' => array()
                );
            }

            unset($row['payroll_id']);
            unset($row['company_id']);
            unset($row['company_name']);
            //unset($row['department_name']);
            unset($row['employee_registration_id']);
            unset($row['employee_id']);
            unset($row['Reg No.']);
            unset($row['Name']);
            unset($row['ntn_no']);
            unset($row['cnic_name']);
            $arrPayrolls[$employee_registration_id]['payrolls'][] = $row;
        }
        //d($arrPayrolls, true);
        $arrColumns = array_keys($arrPayrolls[$employee_registration_id]['payrolls'][0]);
        $total_ratio = 0;
        $columns[] = array(
            'column_name' => 'sr',
            'display_name' => 'Sr.',
            'data_type' => 'I',
            'column_ratio' => 1
        );
        $total_ratio += 1;
        //d($arrColumns, true);
        foreach($arrColumns as $column) {
            if($column=='Doc. Date') {
                $columns[] = array(
                    'column_name' => $column,
                    'display_name' => 'Doc. Date',
                    'data_type' => 'D',
                    'column_ratio' => 2
                );
                $total_ratio += 2;
//            } elseif($column=='designation_name') {
//                $columns[] = array(
//                    'column_name' => $column,
//                    'display_name' => 'Designation',
//                    'data_type' => 'S',
//                    'column_ratio' => 2
//                );
//                $total_ratio += 2;
//            } elseif($column=='joining_date') {
//                $columns[] = array(
//                    'column_name' => $column,
//                    'display_name' => 'Join. Date',
//                    'data_type' => 'D',
//                    'column_ratio' => 2
//                );
//                $total_ratio += 2;
//            } elseif($column=='cnic_no') {
//                $columns[] = array(
//                    'column_name' => $column,
//                    'display_name' => 'CNIC',
//                    'data_type' => 'S',
//                    'column_ratio' => 2
//                );
//                $total_ratio += 2;
            } elseif($column=='document_title') {
                $columns[] = array(
                    'column_name' => $column,
                    'display_name' => 'Title',
                    'data_type' => 'S',
                    'column_ratio' => 4
                );
                $total_ratio += 4;
            } elseif($column=='CHQ') {
                $columns[] = array(
                    'column_name' => $column,
                    'display_name' => 'CHQ',
                    'data_type' => 'S',
                    'column_ratio' => 1
                );
                $total_ratio += 1;
            } elseif($column=='chq_date') {
                $columns[] = array(
                    'column_name' => $column,
                    'display_name' => 'CHQ. Dt.',
                    'data_type' => 'D',
                    'column_ratio' => 1
                );
                $total_ratio += 1;
            } elseif($column!='joining_date' && $column != 'cnic_no' && $column != 'Acc. Title' && $column != 'Acc. No.' && $column != 'department_name' && $column != 'designation_name') {
                $columns[] = array(
                    'column_name' => $column,
                    'display_name' => $column,
                    'data_type' => 'N',
                    'column_ratio' => 1
                );
                $total_ratio += 1;
            }
        }
        $width = floor(400 / $total_ratio);

        //d($columns, true);
        $pdf = new PDF('L', PDF_UNIT, 'A3', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => 'Payroll Register',
            'subtitle' => 'Period from: '.$from_document_date . ' to ' . $to_document_date
        );
        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Payroll Register');
        $pdf->SetSubject('Payroll Register');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $arrGTotal = array();
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        foreach($arrPayrolls as $employee_registration_id => $employees) {
            $employee = $this->model['employee_registration']->getRow(array('employee_registration_id' => $employee_registration_id));
            if($employee['employee_image'] && file_exists(DIR_IMAGE.$employee['employee_image'])) {
                $employee_image = DIR_IMAGE . $employee['employee_image'];
            } else {
                $employee_image = DIR_IMAGE . 'no_user.jpg';
            }

            $pdf->AddPage();
            $pdf->SetFont('freesans', '', 14);
            $pdf->Image($employee_image, 15, 45, 25, 25);
            $pdf->Cell(30,10,'');
            $pdf->Cell(30,10,'Emp. Code:');
            $pdf->Cell(30,10,$employee['registration_code']);
            $pdf->Cell(30,10,'');
            //$pdf->Cell(30,10,'Department:');
            //$pdf->Cell(30,10,$employee['department_name']);
            $pdf->ln(10);
            $pdf->Cell(30,10,'');
            $pdf->Cell(30,10,'Emp. Name:');
            $pdf->Cell(30,10,$employee['employee_name']);
            $pdf->ln(10);
            $pdf->SetFont('freesans', 'B', 10);
            $arrTotal = array();
            //d($columns, true);
            foreach($columns as $column) {
                if($column['data_type']=='N') {
                    $arrTotal[$column['column_name']]=0;
                } else {
                    $arrTotal[$column['column_name']]='';
                }
                $pdf->Cell($width*$column['column_ratio'],10,$column['display_name'],1,0,'C',false,'',1);
            }
            $pdf->ln(10);
            $pdf->SetFont('freesans', '', 10);
            $sr=0;
            foreach($employees['payrolls'] as $payroll) {
                $txt = 'Department: '.$payroll['department_name'].', Designation: '.$payroll['designation_name'].', Joining Date: '.($payroll['joining_date'] != ''?stdDate($payroll['joining_date']):'').', CNIC: '.$payroll['cnic_no'].', Acc. Title: '.$payroll['Acc. Title'].', Acc. No.'.$payroll['Acc. No.'];
                $pdf->Cell(0,10,$txt,0,0,'L',false,'',1);
                $pdf->ln(6);
                foreach($columns as $column) {
                    if($column['column_name']=='sr') {
                        $sr++;
                        $pdf->Cell($width*$column['column_ratio'],10,$sr,'B',0,'C',false,'',1);
                    } elseif($column['data_type']=='S') {
                        $pdf->Cell($width*$column['column_ratio'],10,$payroll[$column['column_name']],'B',0,'L',false,'',1);
                    } elseif($column['data_type']=='D') {
                        $pdf->Cell($width*$column['column_ratio'],10,stdDate($payroll[$column['column_name']]),'B',0,'L',false,'',1);
                    } elseif($column['data_type']=='I') {
                        $pdf->Cell($width*$column['column_ratio'],10,$payroll[$column['column_name']],'B',0,'R',false,'',1);
                    } elseif($column['data_type']=='N') {
                        $pdf->Cell($width*$column['column_ratio'],10,number_format($payroll[$column['column_name']]),'B',0,'R',false,'',1);
                        if(isset($arrTotal[$column['column_name']])) {
                            $arrTotal[$column['column_name']] += $payroll[$column['column_name']];
                        } else {
                            $arrTotal[$column['column_name']] = $payroll[$column['column_name']];
                        }
                    }
                }
                $pdf->ln(10);
            }
            //d(array($columns, $arrTotal), true);
            $pdf->SetFont('freesans', 'B', 10);
            foreach($columns as $column) {
                if($column['data_type']=='N') {
                    $pdf->Cell($width*$column['column_ratio'],10,number_format($arrTotal[$column['column_name']]),'B',0,'R',false,'',1);
                } else {
                    $pdf->Cell($width*$column['column_ratio'],10,'',0,0,'R',false,'',1);
                }
            }
        }

        //Close and output PDF document
        $pdf->Output('Payroll Register:'.date('YmdHis').'.pdf', 'I');
    }

    public function excelReport() {
        ini_set('max_execution_time',400);
        $lang = $this->load->language($this->getAlias());
        $post = $this->request->post;
        $from_document_date = $post['from_document_date'];
        $to_document_date = $post['to_document_date'];
        $department_id = $post['department_id'];
        $employee_id = $post['employee_id'];
        $session = $this->session->data;

        $arrWhere = array();
        $arrWhere[] = "p.`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "p.`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        $arrWhere[] = "`document_date` >= '".MySqlDate($from_document_date)."'";
        $arrWhere[] = "`document_date` <= '".MySqlDate($to_document_date)."'";
        if($department_id != '') {
            $arrWhere[] = "p.`department_id` IN (".implode(',',$department_id).")";
        }
        if($employee_id != '') {
            $arrWhere[] = "p.`employee_id` = '".$employee_id."'";
        }

        $where = implode(' AND ', $arrWhere);

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $rows = $this->model['payroll']->getRegister($where);
        $columns = array_keys($rows[0]);
        //d([$columns,$rows],true);
        unset($columns[0]);
        unset($columns[1]);
        unset($columns[2]);
        //unset($columns[3]);
        //unset($columns[4]);
        //unset($columns[5]);
        //unset($columns[6]);
        //unset($columns[7]);
        //unset($columns[8]);
        //unset($columns[10]);
        unset($columns[11]);
        unset($columns[12]);

        $no_of_columns = count($columns);
        $start_column_idx = 0;
        $end_column_idx = $start_column_idx + $no_of_columns -1;

        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getProperties()
            ->setCreator("Hira")
            ->setLastModifiedBy("Hira")
            ->setTitle("Payroll Register");

        $objPHPExcel->data = array(
            'company_name' => $session['company_name'],
            'report_name' => 'Payroll Register'
        );

        $row_no = 1;
        $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
        //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
        $style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'font' => array(
                'size' => 25
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'ebebeb')
            )
        );
        $objPHPExcel->getActiveSheet()
            ->mergeCells($merge_cells)
            ->setCellValue('A'.$row_no,$session['company_name'])
            ->getStyle($merge_cells)
            ->applyFromArray($style);

        $row_no ++;
        $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
        //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
        $style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'font' => array(
                'size' => 25
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'ebebeb')
            )
        );
        $objPHPExcel->getActiveSheet()
            ->mergeCells($merge_cells)
            ->setCellValue('A'.$row_no,'Payroll Register')
            ->getStyle($merge_cells)
            ->applyFromArray($style);

        $row_no ++;
        $column_no = 0;
        $row_no++;
        foreach($columns as $column) {
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, $column)
                ->getStyleByColumnAndRow($column_no, $row_no)
                ->applyFromArray(
                    array(
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => '000000')
                        )
                    ,
                        'font'  => array(
                            'color' => array('rgb' => 'ffffff')
                        )
                    )
                )
            ;
            $column_no++;
        }
        $row_no++;


        foreach ($rows as $row)
        {
            $column_no=0;
            foreach($columns as $column) {
                $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($column_no, $row_no, $row[$column]);
                $column_no++;
            }

            $row_no++;
        }

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="Payroll Register.xlsx"');
        header('Cache-Control: max-age=0');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('php://output');
        exit;
    }

    private function cellsToMergeByColsRow($start = -1, $end = -1, $row = -1){
        $merge = 'A1:A1';
        if($start>=0 && $end>=0 && $row>=0){
            $start = PHPExcel_Cell::stringFromColumnIndex($start);
            $end = PHPExcel_Cell::stringFromColumnIndex($end);
            $merge = "$start{$row}:$end{$row}";
        }
        return $merge;
    }

}

class PDF extends TCPDF {
    public $data;
    //Page header
    public function Header() {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('freesans', 'B', 20);
        // Title
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->SetFont('freesans', 'B', 14);
        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->SetFont('freesans', '', 14);
        $this->Cell(0, 10, $this->data['subtitle'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(130, 10, $this->data['subtitle'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(130, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(130, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>