<?php

class ControllerReportPayrollSlip extends HController {

    protected function getAlias() {
        return 'report/payroll_slip';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['document_date'] = stdDate();
        $this->data['href_get_report'] = $this->url->link($this->getAlias() . '/getReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_report'] = $this->url->link($this->getAlias() . '/printReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation']="{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function getReport() {
        $from_document_date = $this->request->post['from_document_date'];
        $to_document_date = $this->request->post['to_document_date'];
        $department_id = $this->request->post['department_id'];
        $employee_id = $this->request->post['employee_id'];

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`document_date` >= '".MySqlDate($from_document_date)."'";
        $arrWhere[] = "`document_date` <= '".MySqlDate($to_document_date)."'";
        if($department_id != '') {
            $arrWhere[] = "`department_id` IN (".implode(',',$department_id).")";
        }
        if($employee_id != '') {
            $arrWhere[] = "`employee_id` = '".$employee_id."'";
        }

        $where = implode(' AND ', $arrWhere);
        $payrolls = $this->model['payroll']->getRows($where);
        //d(array($where, $payrolls), true);
        $html = '';
        foreach($payrolls as $row_id => $payroll) {
            $html .= '<tr>';
            $html .= '<td class="text-left">'.($row_id+1).'</td>';
            $html .= '<td class="text-left">'.$payroll['registration_code'].'</td>';
            $html .= '<td class="text-left">'.$payroll['employee_name'].'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['basic_salary'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['arrears'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['other_allowance'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['gross_salary'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['other_deduction'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['tax_deduction'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['attendance_deduction'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['payable_salary'],2).'</td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'filter' => $arrWhere,
            'payrolls' => $payrolls,
            'html' => $html
        );

        echo json_encode($json);
    }

    public function printReport() {
        ini_set('max_execution_time',400);
        $lang = $this->load->language($this->getAlias());
        $from_document_date = $this->request->post['from_document_date'];
        $to_document_date = $this->request->post['to_document_date'];
        $department_id = $this->request->post['department_id'];
        $employee_id = $this->request->post['employee_id'];

        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`document_date` >= '".MySqlDate($from_document_date)."'";
        $arrWhere[] = "`document_date` <= '".MySqlDate($to_document_date)."'";
        if($department_id != '') {
            $arrWhere[] = "`department_id` IN (".implode(',',$department_id).")";
        }
        if($employee_id != '') {
            $arrWhere[] = "`employee_id` = '".$employee_id."'";
        }

        $where = implode(' AND ', $arrWhere);

        $this->model['bank'] = $this->load->model('setup/bank');
        //$this->model['deposit_slip'] = $this->load->model('payroll/deposit_slip');
        $this->model['individual_cheque_detail'] = $this->load->model('payroll/individual_cheque_detail');
        $this->model['bank_letter_detail'] = $this->load->model('payroll/bank_letter_detail');
        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $this->model['payroll_allowance'] = $this->load->model('payroll/payroll_allowance');
        $this->model['payroll_deduction'] = $this->load->model('payroll/payroll_deduction');
        $rows = $this->model['payroll']->getRows($where,array('registration_code','document_date'));
        //d($rows, true);
        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => 'Payroll Register',
            'subtitle' => $rows[0]['document_title']
        );
        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Payroll Slip');
        $pdf->SetSubject('Payroll Slip');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 10, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 5);

        // add a page
        $pdf->AddPage();
        //$pdf->Cell(0, 10, '', 1, false, 'L', 0, '', 0, false, 'M', 'M');
        //$pdf->ln(10);
        //$pdf->Cell(180, 10, '', 1, false, 'L', 0, '', 0, false, 'M', 'M');
        $arrDepositSlip = array();
        foreach($rows as $row) {
            $arrAllowances = array();
            $arrDeductions = array();
            $bank_letter = $this->model['bank_letter_detail']->getRecord(array('source_table_id' => $row['payroll_id']));
            $individual_cheque = $this->model['individual_cheque_detail']->getRow(array('source_table_id' => $row['payroll_id']));
            if($bank_letter) {
                $row['cheque_no'] = $bank_letter['cheque_no'];
            } elseif ($individual_cheque) {
                $row['cheque_no'] = $individual_cheque['cheque_no'];
            } else {
                $row['cheque_no'] = '';
            }
            $allowances = $this->model['payroll_allowance']->getRows(array('payroll_id' => $row['payroll_id']), array('allowance_id'));
            $deductions = $this->model['payroll_deduction']->getRows(array('payroll_id' => $row['payroll_id']),array('deduction_id'));
            $arrAllowances[] = array(
                'allowance_name' => 'Basic',
                'allowance_amount' => $row['basic_salary'],
            );
            if($row['arrears'] != 0) {
                $arrAllowances[] = array(
                    'allowance_name' => 'Arrears',
                    'allowance_amount' => $row['arrears'],
                );
            }
            foreach($allowances as $allowance) {
                if($allowance['allowance_amount'] != 0 && $allowance['grossable']) {
                    $arrAllowances[] = array(
                        'allowance_name' => $allowance['allowance_name'],
                        'allowance_amount' => $allowance['allowance_amount'],
                    );
                }
            }
            foreach($deductions as $deduction) {
                $arrDeductions[] = array(
                    'deduction_name' => $deduction['deduction_name'],
                    'deduction_amount' => $deduction['deduction_amount'],
                );
            }
            $arrDeductions[] = array(
                'deduction_name' => 'Tax',
                'deduction_amount' => $row['tax_deduction'],
            );
            if($row['attendance_deduction']) {
                $arrDeductions[] = array(
                    'deduction_name' => 'Attendance',
                    'deduction_amount' => $row['attendance_deduction'],
                );
            }
            //d([$arrAllowances, $arrDeductions]);
            $count_loop = max(count($arrAllowances), count($arrDeductions));
//            if(!isset($arrDepositSlip[$row['deposit_slip_id']])) {
//                $deposit_slip = $this->model['deposit_slip']->getRow(array('deposit_slip_id' => $row['deposit_slip_id']));
//                $arrDepositSlip[$row['deposit_slip_id']] = $deposit_slip;
//            }
//            $deposit_slip = $arrDepositSlip[$row['deposit_slip_id']];

            if(!isset($arrBanks[$row['bank_id']])) {
                $bank = $this->model['bank']->getRow(array('bank_id' => $row['bank_id']));
                $arrBanks[$row['bank_id']] = $bank;
            }
            $bank = $arrBanks[$row['bank_id']];
            //d(array($row['deposit_slip_id'], $arrDepositSlip), true);

            $start_page = $pdf->getPage();
            $pdf->startTransaction();
            $pdf->SetLineStyle(array('width' => 0.1, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(150, 5, $this->session->data['company_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 8);
            $pdf->Cell(30, 5, '(PAY SLIP)', 0, false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(20, 5, 'Emp. No.', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 8);
            $pdf->Cell(70, 5, $row['employee_code']. ' - ' .$row['employee_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(20, 5, 'CNIC Name', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 8);
            $pdf->Cell(80, 5, $row['cnic_name']. ' ' .$row['employee_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(50, 5, 'CNIC', 0, false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 8);
            $pdf->Cell(30, 5, $row['cnic_no'], 0, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(20, 5, 'By Cheque', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 8);
            $pdf->Cell(70, 5, $row['cheque_no'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(90, 5, $row['document_title'], 0, false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->Cell(0, 1, '', 'T');
            $total_allowance = 0;
            $total_deduction = 0;
            for($i=0;$i<$count_loop;$i++) {
                $pdf->ln(4);
                if(isset($arrAllowances[$i])) {
                    $pdf->Cell(30, 4, $arrAllowances[$i]['allowance_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(20, 4, number_format($arrAllowances[$i]['allowance_amount'],2), 0, false, 'R', 0, '', 1, false, 'M', 'M');
                    $total_allowance += $arrAllowances[$i]['allowance_amount'];
                } else {
                    $pdf->Cell(30, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(20, 4, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
                }
                $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(1, 4, '', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                if(isset($arrDeductions[$i])) {
                    $pdf->Cell(30, 4, $arrDeductions[$i]['deduction_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(20, 4, number_format($arrDeductions[$i]['deduction_amount'],2), 0, false, 'R', 0, '', 1, false, 'M', 'M');
                    $total_deduction += $arrDeductions[$i]['deduction_amount'];
                } else {
                    $pdf->Cell(30, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(20, 4, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
                }
                $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(1, 4, '', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            }
            $pdf->ln(3);
            $pdf->Cell(0, 1, '', 'T');
            $pdf->ln(3);
            $pdf->Cell(30, 4, 'Gross', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(20, 4, number_format($row['gross_salary'],2), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(30, 4, 'Deductions', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(20, 4, number_format($total_deduction,2), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(30, 4, 'Net', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(20, 4, number_format($row['payable_salary'],2), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->ln(8);
            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(60, 5, 'Credited to A/C.: ' . $row['bank_account_no'].' in '.$bank['bank_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(7);
            $pdf->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 4, 'color' => array(211, 211, 211)));
            $pdf->Cell(0, 1, '', 'T', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $end_page = $pdf->getPage();
            if($start_page != $end_page) {
                $pdf->rollbackTransaction(true); //Do not forget to add True
                $pdf->AddPage();
                $pdf->SetLineStyle(array('width' => 0.1, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
                $pdf->SetFont('freesans', 'B', 8);
                $pdf->Cell(150, 5, $this->session->data['company_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->SetFont('freesans', '', 8);
                $pdf->Cell(30, 5, '(PAY SLIP)', 0, false, 'R', 0, '', 0, false, 'M', 'M');
                $pdf->ln(5);
                $pdf->SetFont('freesans', 'B', 8);
                $pdf->Cell(20, 5, 'Emp. No.', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->SetFont('freesans', '', 8);
                $pdf->Cell(70, 5, $row['employee_code']. ' - ' .$row['employee_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->ln(5);
                $pdf->SetFont('freesans', 'B', 8);
                $pdf->Cell(20, 5, 'CNIC Name', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->SetFont('freesans', '', 8);
                $pdf->Cell(80, 5, $row['cnic_name']. ' ' .$row['employee_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->SetFont('freesans', 'B', 8);
                $pdf->Cell(50, 5, 'CNIC', 0, false, 'R', 0, '', 0, false, 'M', 'M');
                $pdf->SetFont('freesans', '', 8);
                $pdf->Cell(30, 5, $row['cnic_no'], 0, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->ln(5);
                $pdf->SetFont('freesans', 'B', 8);
                $pdf->Cell(20, 5, 'By Cheque', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->SetFont('freesans', '', 8);
                $pdf->Cell(70, 5, $row['cheque_no'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(90, 5, $row['document_title'], 0, false, 'R', 0, '', 0, false, 'M', 'M');
                $pdf->ln(5);
                $pdf->Cell(0, 1, '', 'T');
                $total_allowance = 0;
                $total_deduction = 0;
                for($i=0;$i<$count_loop;$i++) {
                    $pdf->ln(4);
                    if(isset($arrAllowances[$i])) {
                        $pdf->Cell(30, 4, $arrAllowances[$i]['allowance_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                        $pdf->Cell(20, 4, number_format($arrAllowances[$i]['allowance_amount'],2), 0, false, 'R', 0, '', 1, false, 'M', 'M');
                        $total_allowance += $arrAllowances[$i]['allowance_amount'];
                    } else {
                        $pdf->Cell(30, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                        $pdf->Cell(20, 4, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
                    }
                    $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(1, 4, '', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    if(isset($arrDeductions[$i])) {
                        $pdf->Cell(30, 4, $arrDeductions[$i]['deduction_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                        $pdf->Cell(20, 4, number_format($arrDeductions[$i]['deduction_amount'],2), 0, false, 'R', 0, '', 1, false, 'M', 'M');
                        $total_deduction += $arrDeductions[$i]['deduction_amount'];
                    } else {
                        $pdf->Cell(30, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                        $pdf->Cell(20, 4, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
                    }
                    $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(1, 4, '', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                }
                $pdf->ln(3);
                $pdf->Cell(0, 1, '', 'T');
                $pdf->ln(3);
                $pdf->Cell(30, 4, 'Gross', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 4, number_format($row['gross_salary'],2), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(15, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(30, 4, 'Deductions', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 4, number_format($total_deduction,2), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(15, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(30, 4, 'Net', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 4, number_format($row['payable_salary'],2), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->ln(8);
                $pdf->SetFont('freesans', 'B', 8);
                $pdf->Cell(60, 5, 'Credited to A/C.: ' . $row['bank_account_no'].' in '.$bank['bank_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->ln(7);
                $pdf->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 4, 'color' => array(211, 211, 211)));
                $pdf->Cell(0, 1, '', 'T', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->ln(5);
            } else {
                $pdf->commitTransaction();
            }
        }
        //Close and output PDF document
        $pdf->Output('Payroll Slip:'.date('YmdHis').'.pdf', 'I');
    }

}

class PDF extends TCPDF {
    public $data;
    //Page header
    public function Header() {
//        // Logo
//        //$image_file = DIR_IMAGE.'logo.jpg';
//        //$image_file = DIR_IMAGE.'no_image.jpg';
//        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
//        // Set font
//        $this->SetFont('freesans', 'B', 20);
//        // Title
//        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('freesans', 'B', 14);
//        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('freesans', '', 14);
//        $this->Cell(0, 10, $this->data['subtitle'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-10);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(60, 10, 'Payroll Slip', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>