<?php

class ControllerReportSalaryComparison extends HController {

    protected function getAlias() {
        return 'report/salary_comparison';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['document_date'] = stdDate();
        $this->data['href_excel_report'] = $this->url->link($this->getAlias() . '/excelReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation']="{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function excelReport() {
        ini_set('max_execution_time',400);
        $lang = $this->load->language($this->getAlias());
        $session = $this->session->data;
        $post = $this->request->post;
        $company_id = $session['company_id'];
        $from_document_date = MySqlDate($post['from_document_date']);
        $to_document_date = MySqlDate($post['to_document_date']);
        $department_id = $post['department_id'];
        $report_type = $post['report_type'];

        $arrDates = [];

        $this->model['salary_comparison'] = $this->load->model('report/salary_comparison');
        if($report_type=='Range Report') {
            $rows = $this->model['salary_comparison']->getRangeRecords($company_id, $from_document_date, $to_document_date, $department_id);

            $from_document_date = date('Y-m-01', strtotime($from_document_date));
            $begin = new DateTime($from_document_date);
            $end = new DateTime($to_document_date);

            $interval = DateInterval::createFromDateString('1 month');
            $period = new DatePeriod($begin, $interval, $end);

            foreach ($period as $dt) {
                $arrDates[] = [
                    'value' => $dt->format("Y-m"),
                    'display' => $dt->format("M Y"),
                ];
            }
        } else {
            $rows = $this->model['salary_comparison']->getDateRecords($company_id, $from_document_date, $to_document_date, $department_id);
            $arrDates[] = [
                'value' => $from_document_date,
                'display' => stdDate($from_document_date),
            ];
            $arrDates[] = [
                'value' => $to_document_date,
                'display' => stdDate($to_document_date),
            ];
        }
        $arrReports = [];
        $arrTotals = [
            'salaries' => [],
            'differences' => []
        ];
        foreach($rows as $id => $row) {
            $salaries = [];
            $differences = [];
            $difference_exists = 0;

            $previous_month = $arrDates[0]['display'];
            $previous_salary = $row[$previous_month];
            foreach($arrDates as $dt) {
                $current_month = $dt['display'];
                $current_salary = $row[$current_month];
                $difference_salary = $current_salary - $previous_salary;
                if($difference_salary != 0) {
                    $difference_exists=1;
                }
                $salaries[$current_month] = $current_salary;
                $differences[$current_month] = $difference_salary;

                //$previous_month = $current_month;
                $previous_salary = $current_salary;

                if(isset($arrTotals['salaries'][$current_month])) {
                    $arrTotals['salaries'][$current_month] += $current_salary;
                    $arrTotals['differences'][$current_month] += $difference_salary;
                } else {
                    $arrTotals['salaries'][$current_month] = $current_salary;
                    $arrTotals['differences'][$current_month] = $difference_salary;
                }
            }

            $arrReports[$id] = array(
                'department_name' => $row['department_name'],
                'registration_code' => $row['registration_code'],
                'employee_name' => $row['employee_name'],
                'difference_exists' => $difference_exists,
                'salaries' => $salaries,
                'differences' => $differences
            );
        }
        //d($arrTotals, true);

        $no_of_columns = count($arrDates) + 3;
        $start_column_idx = 0;
        $end_column_idx = $start_column_idx + $no_of_columns -1;

        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getProperties()
            ->setCreator("Huzaifa Khambaty")
            ->setLastModifiedBy("Huzaifa Khambaty")
            ->setTitle("Salary Comparison");

        $objPHPExcel->data = array(
            'company_name' => $session['company_name'],
            'report_name' => 'Salary Comparison'
        );

        $row_no = 1;
        $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
        //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
        $style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'font' => array(
                'size' => 25
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'ebebeb')
            )
        );
        $objPHPExcel->getActiveSheet()
            ->mergeCells($merge_cells)
            ->setCellValue('A'.$row_no,$session['company_name'])
            ->getStyle($merge_cells)
            ->applyFromArray($style);

        $row_no ++;
        $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
        //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
        $style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'font' => array(
                'size' => 25
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'ebebeb')
            )
        );
        $objPHPExcel->getActiveSheet()
            ->mergeCells($merge_cells)
            ->setCellValue('A'.$row_no,'Salary Comparison')
            ->getStyle($merge_cells)
            ->applyFromArray($style);

        $row_no ++;
        $column_no = 0;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow($column_no, $row_no, 'Department')
            ->getStyleByColumnAndRow($column_no, $row_no)
            ->applyFromArray(
                array(
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => '000000')
                    )
                ,
                    'font'  => array(
                        'color' => array('rgb' => 'ffffff')
                    )
                )
            )
        ;
        $column_no++;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow($column_no, $row_no, 'Reg. Code')
            ->getStyleByColumnAndRow($column_no, $row_no)
            ->applyFromArray(
                array(
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => '000000')
                    )
                ,
                    'font'  => array(
                        'color' => array('rgb' => 'ffffff')
                    )
                )
            )
        ;
        $column_no++;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow($column_no, $row_no, 'Employee')
            ->getStyleByColumnAndRow($column_no, $row_no)
            ->applyFromArray(
                array(
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => '000000')
                    )
                ,
                    'font'  => array(
                        'color' => array('rgb' => 'ffffff')
                    )
                )
            )
        ;
        $column_no++;

        $columns = array_keys($arrTotals['salaries']);
        foreach($columns as $column) {
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, $column)
                ->getStyleByColumnAndRow($column_no, $row_no)
                ->applyFromArray(
                    array(
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => '000000')
                        )
                    ,
                        'font'  => array(
                            'color' => array('rgb' => 'ffffff')
                        )
                    )
                )
            ;
            $column_no++;
        }

        $row_no++;
        $column_no=2;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow($column_no, $row_no, 'Total Salary');
        $column_no++;
        foreach($columns as $column) {
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, $arrTotals['salaries'][$column]);
            $column_no++;
        }

        $row_no++;
        $column_no=2;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow($column_no, $row_no, 'Difference');
        $column_no++;
        foreach($columns as $column) {
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, $arrTotals['differences'][$column]);
            $column_no++;
        }

        $row_no ++;
        $row_no ++;
        foreach($arrReports as $report) {
            if($report['difference_exists']) {
                $row_no ++;
                $column_no = 0;
                $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($column_no, $row_no, $report['department_name']);
                $column_no++;
                $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($column_no, $row_no, $report['registration_code']);
                $column_no++;
                $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($column_no, $row_no, $report['employee_name']);

                foreach($report['differences'] as $column_name => $value) {
                    $column_no++;
                    $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($column_no, $row_no, $value);

                }
            }
        }
        $column_name = PHPExcel_Cell::stringFromColumnIndex($column_no);
        //d($column_name, true);
        $objPHPExcel->getActiveSheet()
            ->getStyle('D4:'.$column_name.$row_no)
            ->getNumberFormat()
            ->setFormatCode('#,##0.00;[Red]-#,##0.00');

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="Salary Comparison.xlsx"');
        header('Cache-Control: max-age=0');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('php://output');
        exit;
    }

    private function cellsToMergeByColsRow($start = -1, $end = -1, $row = -1){
        $merge = 'A1:A1';
        if($start>=0 && $end>=0 && $row>=0){
            $start = PHPExcel_Cell::stringFromColumnIndex($start);
            $end = PHPExcel_Cell::stringFromColumnIndex($end);
            $merge = "$start{$row}:$end{$row}";
        }
        return $merge;
    }

}

?>