<?php

class ControllerReportSalaryHistory extends HController {

    protected function getAlias() {
        return 'report/salary_history';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->model['company'] = $this->load->model('user/user_access');
        $this->data['companies'] = $this->model['company']->getRows(array('user_id' => $this->session->data['user_id'], 'status' => 'Active'));

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['href_get_department'] = $this->url->link($this->getAlias() . '/getDepartments', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_excel_report'] = $this->url->link($this->getAlias() . '/excelReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation']="{
            'rules':{
		        'no_of_increments': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function getDepartments() {
        $post = $this->request->post;

        $this->model['department'] = $this->load->model('setup/department');
        $arrWhere = [];
        $arrWhere[] = "d.`status` = 'Active'";
        $arrWhere[] = "d.`company_id` IN (".$post['company_id'].")";
        $where = implode(" AND ", $arrWhere);

        $departments = $this->model['department']->getRecords($where,['company_name','department_name'],['c.company_id','c.company_name','d.department_id','d.department_name']);

        $data = [];
        foreach($departments as $department) {
            $data[$department['company_name']][] = $department;
        }

        echo json_encode(['success' => true, 'data' => $data]);
    }

    public function excelReport() {
        ini_set('max_execution_time',400);
        $lang = $this->load->language($this->getAlias());
        $session = $this->session->data;
        $post = $this->request->post;
        $company_id = $post['company_id'];
        $department_id = $post['department_id'];
        $employee_status = $post['employee_status'];
        $employee_id = $post['employee_id'];
        $no_of_increments = $post['no_of_increments'];


        $arrWhere = [];
        if($company_id) {
            $arrWhere[] = "er.`company_id` IN (".implode(",",$company_id).")";
        } else {
            $this->model['company'] = $this->load->model('user/user_access');
            $companies = $this->model['company']->getRows(array('user_id' => $this->session->data['user_id'], 'status' => 'Active'));
            $arrCompanyId = [];
            foreach($companies as $company) {
                $arrCompanyId[] = $company['company_id'];
            }

            $company_id = implode(",",$arrCompanyId);
            $arrWhere[] = "er.`company_id` IN (".$company_id.")";
        }
        if($department_id) {
            $arrWhere[] = "er.`department_id` IN (".implode(",",$department_id).")";
        }
        if($employee_status) {
            $arrWhere[] = "er.`status` = '$employee_status'";
        }
        if($employee_id) {
            $arrWhere[] = "er.`employee_id` = '".$employee_id."'";
        }
        $where = implode(" AND ", $arrWhere);
        $this->model['salary_history'] = $this->load->model('report/salary_history');
        $employees = $this->model['salary_history']->getEmployees($where);

        $no_of_columns = 10;
        $start_column_idx = 0;
        $end_column_idx = $start_column_idx + $no_of_columns -1;

        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getProperties()
            ->setCreator("Huzaifa Khambaty")
            ->setLastModifiedBy("Huzaifa Khambaty")
            ->setTitle("Salary Comparison");

        $objPHPExcel->data = array(
            'company_name' => $session['company_name'],
            'report_name' => 'Salary Comparison'
        );

        $row_no = 1;
//        $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no, $row_no);
//        //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
//        $style = array(
//            'alignment' => array(
//                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
//            ),
//            'font' => array(
//                'size' => 25
//            ),
//            'fill' => array(
//                'type' => PHPExcel_Style_Fill::FILL_SOLID,
//                'color' => array('rgb' => 'ebebeb')
//            )
//        );
//        $objPHPExcel->getActiveSheet()
//            ->mergeCells($merge_cells)
//            ->setCellValue('A'.$row_no,$session['company_name'])
//            ->getStyle($merge_cells)
//            ->applyFromArray($style);
//
//        $row_no ++;
        $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no, $row_no);
        //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
        $style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'font' => array(
                'size' => 25
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'ebebeb')
            )
        );
        $objPHPExcel->getActiveSheet()
            ->mergeCells($merge_cells)
            ->setCellValue('A'.$row_no,'Salary History Report')
            ->getStyle($merge_cells)
            ->applyFromArray($style);

        foreach($employees as $employee) {
            $row_no ++;
            $row_no ++;
            $row1=$row_no;
            if($employee['employee_image'] && file_exists(DIR_IMAGE . $employee['employee_image'])) {
                $image_dir = HTTP_IMAGE . $employee['employee_image'];
            } else {
                $image_dir = HTTP_IMAGE . 'no_image.jpg';
            }

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(12);

            $image_data = file_get_contents($image_dir);
            $gdImage = imagecreatefromstring($image_data);

            $objDrawing = new PHPExcel_Worksheet_MemoryDrawing();
            $objDrawing->setName('Sample image');$objDrawing->setDescription('Sample image');
            $objDrawing->setImageResource($gdImage);
            $objDrawing->setRenderingFunction(PHPExcel_Worksheet_MemoryDrawing::RENDERING_DEFAULT);
            $objDrawing->setMimeType(PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_DEFAULT);
            $objDrawing->setHeight(75);
            $objDrawing->setCoordinates('A'.$row_no);
            $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

            $column_no = 1;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, 'Emp. Code:')
                ->getStyleByColumnAndRow($column_no, $row_no)
                ->applyFromArray(
                    array(
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => 'CDCDCD')
                        )
                    ,
                        'font'  => array(
                            'color' => array('rgb' => '000000')
                        )
                    )
                )
            ;
            $column_no = 2;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, $employee['employee_code'])
                ->getStyleByColumnAndRow($column_no, $row_no)
            ;
            $row_no++;
            $column_no = 1;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, 'Emp. Name:')
                ->getStyleByColumnAndRow($column_no, $row_no)
                ->applyFromArray(
                    array(
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => 'CDCDCD')
                        )
                    ,
                        'font'  => array(
                            'color' => array('rgb' => '000000')
                        )
                    )
                )
            ;
            $column_no = 2;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, $employee['employee_name'])
                ->getStyleByColumnAndRow($column_no, $row_no)
            ;
            $row_no++;
            $column_no = 1;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, 'DOJ:')
                ->getStyleByColumnAndRow($column_no, $row_no)
                ->applyFromArray(
                    array(
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => 'CDCDCD')
                        )
                    ,
                        'font'  => array(
                            'color' => array('rgb' => '000000')
                        )
                    )
                )
            ;
            $column_no = 2;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, $employee['joining_date'])
                ->getStyleByColumnAndRow($column_no, $row_no)
            ;
            $row_no++;
            $column_no = 1;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, 'ITS:')
                ->getStyleByColumnAndRow($column_no, $row_no)
                ->applyFromArray(
                    array(
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => 'CDCDCD')
                        )
                    ,
                        'font'  => array(
                            'color' => array('rgb' => '000000')
                        )
                    )
                )
            ;
            $column_no = 2;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, $employee['its_no'])
                ->getStyleByColumnAndRow($column_no, $row_no)
            ;
            $row_no++;
            $row2=$row_no;

            $arrColumns = [
                ['column_name' => 'registration_code', 'column_title' => 'Reg. Code'],
                ['column_name' => 'company_name', 'column_title' => 'Company'],
                ['column_name' => 'department_name', 'column_title' => 'Department'],
                ['column_name' => 'designation_name', 'column_title' => 'Designation'],
                ['column_name' => 'department_joining_date', 'column_title' => 'Joining Date'],
                ['column_name' => 'wef_date', 'column_title' => 'WEF Date'],
                ['column_name' => 'basic_salary', 'column_title' => 'Salary'],
                ['column_name' => 'allowance', 'column_title' => 'Allowance'],
                ['column_name' => 'gross_amount', 'column_title' => 'Gross'],
                ['column_name' => 'percent', 'column_title' => '% Increase'],
            ];

            foreach ($arrColumns as $column_no => $column) {
                $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($column_no, $row_no, $column['column_title'])
                    ->getStyleByColumnAndRow($column_no, $row_no)
                    ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => 'CDCDCD')
                            )
                        ,
                            'font'  => array(
                                'color' => array('rgb' => '000000')
                            )
                        )
                    )
                ;
            }

            $salaries = $this->model['salary_history']->getSalaryData($employee['employee_id'], $no_of_increments);
//            d([$employee['employee_id'], $no_of_increments, $salaries]);
//            $columns = array_column($salaries, 'created_at');
//            d($columns);
//            array_multisort($columns, SORT_ASC, $salaries);
//            d($salaries);

            //$arrSalaries = [];
            $previous_salary = null;
            foreach($salaries as $index => $salary) {
                if($previous_salary==null) {
                    $increment = 0;
                } else {
                    $increment = round(($salary['basic_salary']-$previous_salary)/$previous_salary*100,2);
                }
                $previous_salary = $salary['basic_salary'];
                $salary['percent'] = $increment;
                //$arrSalaries[] = $salary;

                $row_no++;
                foreach ($arrColumns as $column_no => $column) {
                    $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($column_no, $row_no, $salary[$column['column_name']])
                    ;
                }

            }
            $row3=$row_no;
            $objPHPExcel->getActiveSheet()->getStyle("B$row1:C$row2")->applyFromArray(array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN
                    )
                )
            ));

            $objPHPExcel->getActiveSheet()->getStyle("A$row2:J$row3")->applyFromArray(array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN
                    )
                )
            ));

            $row_no++;
            $row_no++;
        }

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="SalaryHistoryReport.xlsx"');
        header('Cache-Control: max-age=0');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('php://output');
        exit;
    }

    private function cellsToMergeByColsRow($startColumn = -1, $endColumn = -1, $startRow = -1, $endRow = -1){
        $merge = 'A1:A1';
        if($startColumn>=0 && $endColumn>=0 && $startRow>=0 && $endRow>=0){
            $start = PHPExcel_Cell::stringFromColumnIndex($startColumn);
            $end = PHPExcel_Cell::stringFromColumnIndex($endColumn);
            $merge = "$start{$startRow}:$end{$endRow}";
        }
        return $merge;
    }

    private function SortAssociativeASC($a,$b)
    {
        if ($a['created_at']==$b['created_at']) return 0;
        return ($a<$b)?-1:1;
    }

    private function SortAssociativeDESC($a,$b, $column)
    {
        if ($a[$column]==$b[$column]) return 0;
        return ($a>$b)?-1:1;
    }

}

?>