<?php

class ControllerReportSavingStatement extends HController {

    protected function getAlias() {
        return 'report/saving_statement';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['deduction'] = $this->load->model('setup/company_deduction');
        $this->data['deductions'] = $this->model['deduction']->getRows(array('company_id' => $this->session->data['company_id']));
        //d($this->data['deductions'], true);
        $this->data['document_date'] = stdDate();
        $this->data['href_get_report'] = $this->url->link($this->getAlias() . '/getReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_report'] = $this->url->link($this->getAlias() . '/printReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation']="{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function getReport() {
        $from_document_date = $this->request->post['from_document_date'];
        $to_document_date = $this->request->post['to_document_date'];
        $department_id = $this->request->post['department_id'];
        $employee_id = $this->request->post['employee_id'];

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`document_date` >= '".MySqlDate($from_document_date)."'";
        $arrWhere[] = "`document_date` <= '".MySqlDate($to_document_date)."'";
        if($department_id != '') {
            $arrWhere[] = "`department_id` IN (".implode(',',$department_id).")";
        }
        if($employee_id != '') {
            $arrWhere[] = "`employee_id` = '".$employee_id."'";
        }

        $where = implode(' AND ', $arrWhere);
        $payrolls = $this->model['payroll']->getRows($where);
        //d(array($where, $payrolls), true);
        $html = '';
        foreach($payrolls as $row_id => $payroll) {
            $html .= '<tr>';
            $html .= '<td class="text-left">'.($row_id+1).'</td>';
            $html .= '<td class="text-left">'.$payroll['registration_code'].'</td>';
            $html .= '<td class="text-left">'.$payroll['employee_name'].'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['basic_salary'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['arrears'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['other_allowance'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['gross_salary'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['other_deduction'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['tax_deduction'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['net_salary']-$payroll['payable_salary'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($payroll['payable_salary'],2).'</td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'filter' => $arrWhere,
            'payrolls' => $payrolls,
            'html' => $html
        );

        echo json_encode($json);
    }

    public function printReport() {
        ini_set('max_execution_time',400);
        $post = $this->request->post;
        $lang = $this->load->language($this->getAlias());
        $from_document_date = $post['from_document_date'];
        $to_document_date = $post['to_document_date'];
        $department_id = $post['department_id'];
        $deductions = $post['deductions'];

        $arrWhere = array();
        $arrWhere[] = "p.`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`document_date` >= '".MySqlDate($from_document_date)."'";
        $arrWhere[] = "`document_date` <= '".MySqlDate($to_document_date)."'";
        if($department_id != '') {
            $arrWhere[] = "p.`department_id` IN (".implode(',',$department_id).")";
        }

        $where = implode(' AND ', $arrWhere);

        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $rows = $this->model['payroll']->getRegister($where);
        $columns = array();
        $columns[] = 'Sr.';
        $columns[] = 'Reg No.';
        $columns[] = 'Name';
        foreach($deductions as $deduction) {
            $columns[] = $deduction;
        }
        $columns[] = 'Total';

        $arrColumns = array();
        $total_ratio = count($columns) + 3;
        $width = round(390 / $total_ratio);
        //d($rows, true);
        //d(array($columns, count($columns), $total_ratio, $width), true);
        $total_width = 0;
        foreach($columns as $column) {
            if($column != 'Name') {
                $arrColumns[$column] = $width;
            } else {
                $arrColumns[$column] = 390 - ($width*($total_ratio-3));
            }
        }
        //d(array($columns, $arrColumns), true);

        $pdf = new PDF('L', PDF_UNIT, 'A3', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => 'Saving Statement',
            'subtitle' => $post['subtitle'],
            'from_date' => $from_document_date,
            'to_date' => $to_document_date,
        );
        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Saving Statement');
        $pdf->SetSubject('Saving Statement');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();
        //$pdf->Cell(390, 10, '', 1, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->SetFont('freesans', '', 10);
        $arrTotal = array();
        $arrGTotal = array();
        foreach($arrColumns as $column_name => $width) {
            if($column_name=='Sr.' || $column_name=='Reg No.' || $column_name=='Name') {
                $arrGTotal[$column_name] = '';
            } else {
                $arrGTotal[$column_name] = 0;
            }
        }

        $arrRecords = array();
        $departmentTotal = array();
        foreach($rows as $row_id => $row) {
            foreach($arrColumns as $column_name => $width) {
                if($column_name=='Total') {
                    $row[$column_name] = 0;
                    foreach($deductions as $deduction) {
                        $row[$column_name] += isset($row[$deduction])?$row[$deduction]:0;
                    }
                    if(isset($departmentTotal[$row['department_name']])) {
                        $departmentTotal[$row['department_name']] += $row['Total'];
                    } else {
                        $departmentTotal[$row['department_name']] = $row['Total'];
                    }
                }
                $arrRecords[$row['department_name']][$row_id][$column_name] = $row[$column_name];
            }
        }

        // This will remove whole Department having Sum 0;
        foreach($departmentTotal as $department_name => $total) {
            if($total==0) {
                unset($arrRecords[$department_name]);
            }
        }

        //d($arrRecords, true);
        $row_id =1;
        foreach($arrColumns as $column_name => $width) {
            if($column_name=='Sr.' || $column_name=='Reg No.' || $column_name=='Name') {
                $arrGTotal[$column_name] = '';
            } else {
                $arrGTotal[$column_name] = 0;
            }
        }
        foreach($arrRecords as $department_name => $rows) {
            $pdf->Cell(30, 10, $department_name, 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(10);
            $pdf->SetFont('freesans', 'B', 10);
            foreach($arrColumns as $column_name => $width) {
                if($column_name=='Sr.' || $column_name=='Reg No.' || $column_name=='Name') {
                    $arrTotal[$column_name] = '';
                } else {
                    $arrTotal[$column_name] = 0;
                }
                $pdf->Cell($width, 10, $column_name, 1, false, 'C', 0, '', 1, false, 'M', 'M');
            }
            $pdf->ln(10);
            foreach($rows as $row) {
                if($row['Total'] != 0) {
                    $row['Sr.'] = $row_id;
                    $row_id++;
                    foreach($arrColumns as $column_name => $width) {
                        if($column_name=='Sr.' || $column_name=='Reg No.' || $column_name=='Name') {
                            $arrTotal[$column_name] = '';
                            $arrGTotal[$column_name] = '';
                            $pdf->Cell($width, 10, $row[$column_name], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                        } else {
                            $arrTotal[$column_name] += $row[$column_name];
                            $arrGTotal[$column_name] += $row[$column_name];
                            $pdf->Cell($width, 10, number_format($row[$column_name]), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                        }
                    }
                    $pdf->ln(10);
                }
            }
            foreach($arrColumns as $column_name => $width) {
                $column_total = floatval($arrTotal[$column_name]);
                $pdf->Cell($width, 10, number_format($column_total), 1, false, 'C', 0, '', 1, false, 'M', 'M');
            }
            $pdf->ln(10);
        }
        $pdf->ln(10);
        foreach($arrColumns as $column_name => $width) {
            $column_total = floatval($arrTotal[$column_name]);
            $pdf->Cell($width, 10, number_format($column_total), 1, false, 'C', 0, '', 1, false, 'M', 'M');
        }
        $pdf->ln(10);

        //Close and output PDF document
        $pdf->Output('Saving Statement:'.date('YmdHis').'.pdf', 'I');
    }

}

class PDF extends TCPDF {
    public $data;
    //Page header
    public function Header() {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('freesans', 'B', 20);
        // Title
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->SetFont('freesans', 'B', 14);
        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->SetFont('freesans', '', 14);
        $this->Cell(130, 10, 'Date: '.$this->data['from_date'].($this->data['from_date'] != $this->data['to_date']?' - '.$this->data['to_date']:''), 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $this->Cell(130, 10, $this->data['subtitle'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Cell(130, 10, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        //$this->Cell(0, 10, $this->data['subtitle'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('freesans', 'I', 8);
        // Page number
        $this->Cell(130, 10, $this->data['subtitle'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(130, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(130, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>