<?php

class ControllerReportSecurityDeposit extends HController {

    protected function getAlias() {
        return 'report/security_deposit';
    }

    protected function getList() {
        parent::getList();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['deduction'] = $this->load->model('setup/company_deduction');
        $this->data['deductions'] = $this->model['deduction']->getRows(array('company_id' => $this->session->data['company_id']));
        //d($this->data['deductions'], true);
        $this->data['document_date'] = stdDate();
        $this->data['href_excel_report'] = $this->url->link($this->getAlias() . '/excelReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation']="{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function excelReport() {
        ini_set('max_execution_time',400);
        $post = $this->request->post;
        $session = $this->session->data;

        $company_id = $session['company_id'];
        $from_document_date = MySqlDate($post['from_document_date']);
        $to_document_date = MySqlDate($post['to_document_date']);
        $department_id = isset($post['department_id'])?$post['department_id']:[];
        $deduction_id = $post['deduction_id'];
        $employee_status = $post['employee_status'];

        $this->model['security_deposit'] = $this->load->model('report/security_deposit');
        $rows = $this->model['security_deposit']->getReport($company_id, $from_document_date, $to_document_date, $deduction_id, $employee_status, $department_id);
        $arrRecords = [];
        foreach($rows as $row) {
            $department_name = $row['Department'];
            unset($row['Department']);
            $arrRecords[$department_name][] = $row;
        }
        include_once(DIR_SYSTEM.'library/PHPExcel.php');
        include_once(DIR_SYSTEM.'library/PHPExcel/Writer/Excel5.php');
        include_once(DIR_SYSTEM.'library/PHPExcel/Exception.php');

        try {
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getProperties()
                ->setCreator("Huzaifa Khambaty")
                ->setLastModifiedBy("Huzaifa Khambaty")
                ->setTitle("Security Deposit");

            $stringColumns=['Shift','Employee'];
            $row_no = 1;
            $columns = array_keys($row);
            $no_of_columns = count($columns);
            $start_column_idx = 0;
            $end_column_idx = $start_column_idx + $no_of_columns -1;
            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
            $style = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                ),
                'font' => array(
                    'size' => 25
                ),
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'ebebeb')
                )
            );
            $objPHPExcel->getActiveSheet()
                ->mergeCells($merge_cells)
                ->setCellValue('A'.$row_no,$session['company_name'])
                ->getStyle($merge_cells)
                ->applyFromArray($style);

            $row_no ++;
            $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
            //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
            $style = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                ),
                'font' => array(
                    'size' => 25
                ),
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'ebebeb')
                )
            );
            $objPHPExcel->getActiveSheet()
                ->mergeCells($merge_cells)
                ->setCellValue('A'.$row_no,'Security Deposit')
                ->getStyle($merge_cells)
                ->applyFromArray($style);

            if($post['subtitle'] != '') {
                $row_no++;
                $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
                $objPHPExcel->getActiveSheet()
                    ->mergeCells($merge_cells)
                    ->setCellValue('A'.$row_no,$post['subtitle'])
                    ->getStyle($merge_cells)
                    ->applyFromArray($style);
            }
            $row_no++;

            foreach ($arrRecords as $department_name=>$rows)
            {
                $row_no++;
                $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(0, $row_no, $department_name);
                $column_no = 0;
                $row_no++;
                $arrTotal = [];
                foreach($columns as $column) {
                    $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($column_no, $row_no, $column)
                        ->getStyleByColumnAndRow($column_no, $row_no)
                        ->applyFromArray(
                            array(
                                'fill' => array(
                                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                    'color' => array('rgb' => '000000')
                                )
                            ,
                                'font'  => array(
                                    'color' => array('rgb' => 'ffffff')
                                )
                            )
                        )
                    ;
                    $column_no++;

                    if(in_array($column, $stringColumns)) {
                        $arrTotal[$column] = "";
                    } else {
                        $arrTotal[$column] = 0;
                    }
                }
                $row_no++;
                foreach($rows as $row) {
                    $column_no=0;
                    foreach($columns as $column) {
                        $objPHPExcel->getActiveSheet()
                            ->setCellValueByColumnAndRow($column_no, $row_no, $row[$column]);
                        $column_no++;
                        if(in_array($column, $stringColumns)) {
                            $arrTotal[$column] = "";
                        } else {
                            $arrTotal[$column] += $row[$column];
                        }
                    }

                    $row_no++;
                }

                $border = [
                    'borders' => [
                        'top' => [
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('rgb' => '000000')
                        ],
                        'bottom' => [
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('rgb' => '000000')
                        ]
                    ]
                ];
                $column_no=0;
                foreach($arrTotal as $column_name => $total) {
                    if(in_array($column_name, $stringColumns)) {
                        $objPHPExcel->getActiveSheet()
                            ->setCellValueByColumnAndRow($column_no, $row_no, $total);
                    } else {
                        $objPHPExcel->getActiveSheet()
                            ->setCellValueByColumnAndRow($column_no, $row_no, $total)
                            ->getStyleByColumnAndRow($column_no, $row_no)
                            ->applyFromArray($border);
                    }
                    $column_no++;
                }

                $row_no++;
            }

            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Security Deposit - '.$session['company_name'].' - '.date('d-m-Y H i').'.xlsx"');
            header('Cache-Control: max-age=0');
            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
            $objWriter->save('php://output');
        }catch(PHPExcel_Exception $e) {
            d($e);
        }

        exit;
    }

    private function cellsToMergeByColsRow($start = -1, $end = -1, $row = -1){
        $merge = 'A1:A1';
        if($start>=0 && $end>=0 && $row>=0){
            $start = PHPExcel_Cell::stringFromColumnIndex($start);
            $end = PHPExcel_Cell::stringFromColumnIndex($end);
            $merge = "$start{$row}:$end{$row}";
        }
        return $merge;
    }
}
?>