<?php

class ControllerReportTaxDeduction extends HController {

    protected function getAlias() {
        return 'report/tax_deduction';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['company'] = $this->load->model('setup/company');
        $this->data['companys'] = $this->model['company']->getRows();

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['document_date'] = stdDate();
        $this->data['href_get_report'] = $this->url->link($this->getAlias() . '/getReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_excel_report'] = $this->url->link($this->getAlias() . '/downloadExcel', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_report'] = $this->url->link($this->getAlias() . '/printReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation']="{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function getReport() {
        $post = $this->request->post;

        //d($post,true);

        $from_date = MySqlDate($post['from_transaction_date']);
        $to_date = MySqlDate($post['to_transaction_date']);
        if(isset($post['company_id']) && is_array($post['company_id'])) {
            $company_id = $post['company_id'];
        } else {
            $company_id = array();
        }

        $this->model['tax'] = $this->load->model('report/tax_deduction');
        $rows = $this->model['tax']->getTaxDeduction($from_date, $to_date, $company_id);
        //d(array($where, $payrolls), true);
        $html = '';
        foreach($rows as $row_id => $row) {
            $html .= '<tr>';
            $html .= '<td class="text-left">'.($row_id+1).'</td>';
            $html .= '<td class="text-left">'.$row['company_name'].'</td>';
            $html .= '<td class="text-left">'.str_replace('-','',$row['TaxPayer_NTN']).'</td>';
            $html .= '<td class="text-left">'.str_replace('-','',$row['TaxPayer_CNIC']).'</td>';
            $html .= '<td class="text-left">'.$row['email'].'</td>';
            $html .= '<td class="text-left">'.$row['employee_code'].'</td>';
            $html .= '<td class="text-left">'.$row['registration_code'].'</td>';
            $html .= '<td class="text-left">'.$row['TaxPayer_Name'].'</td>';
            $html .= '<td class="text-left">'.$row['department_name'].'</td>';
            $html .= '<td class="text-right">'.number_format($row['Gross_Amount'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($row['Taxable_Amount'],2).'</td>';
            $html .= '<td class="text-right">'.number_format($row['Tax_Amount'],2).'</td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'rows' => $rows,
            'html' => $html
        );

        echo json_encode($json);
    }

    public function downloadExcel() {
        include_once(DIR_SYSTEM.'library/PHPExcel.php');
        include_once(DIR_SYSTEM.'library/PHPExcel/Classes/PHPExcel/Writer/Excel5.php');
        $post = $this->request->post;
        $from_date = MySqlDate($post['from_transaction_date']);
        $to_date = MySqlDate($post['to_transaction_date']);

        if(isset($post['company_id'])) {
            $company_id = $post['company_id'];
        } else {
            $company_id = array();
        }

        $this->model['tax'] = $this->load->model('report/tax_deduction');
        $rows = $this->model['tax']->getTaxDeduction($from_date, $to_date, $company_id);
        //d($rows, true);
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $rowCount = 1;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Company Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, 'NTN No.');
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, 'CNIC No.');
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, 'Email');
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, 'Employee Code');
        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, 'Reg No');
        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, 'Employee Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, 'Department Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, 'Gross_Amount');
        $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, 'Taxable_Amount');
        $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, 'Tax_Amount');
        $rowCount++;
        $total_gross_amount=0;
        $total_taxable_amount=0;
        $total_tax_amount=0;
        foreach($rows as $row){
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $row['company_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, str_replace('-','',$row['TaxPayer_NTN']));
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, str_replace('-','',$row['TaxPayer_CNIC']));
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $row['email']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $row['employee_code']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $row['registration_code']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $row['TaxPayer_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $row['department_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, $row['Gross_Amount']);
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, $row['Taxable_Amount']);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, $row['Tax_Amount']);
            $rowCount++;
            $total_gross_amount += $row['Gross_Amount'];
            $total_taxable_amount += $row['Taxable_Amount'];
            $total_tax_amount += $row['Tax_Amount'];
        }
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, 'Total');
        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, $total_gross_amount);
        $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, $total_taxable_amount);
        $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, $total_tax_amount);

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="Tax.xls"');
        header('Cache-Control: max-age=0');
        //$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        //$objWriter->save('some_excel_file.xlsx');
        $objWriter->save('php://output');
        exit;
    }

    public function printReport() {
        ini_set('max_execution_time',400);
        $lang = $this->load->language($this->getAlias());
        $post = $this->request->post;
        $from_date = MySqlDate($post['from_transaction_date']);
        $to_date = MySqlDate($post['to_transaction_date']);

        if(isset($post['company_id'])) {
            $company_id = $post['company_id'];
        } else {
            $company_id = array();
        }


        $this->model['tax'] = $this->load->model('report/tax_deduction');
        $rows = $this->model['tax']->getTaxDeduction($from_date, $to_date, $company_id);

        $columns = array_keys($rows[0]);

        $pdf = new PDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => 'Tax Report',
        );
        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Tax Report');
        $pdf->SetSubject('Tax Report');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 35, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();
        //$pdf->Cell(0, 10, '', 1, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->ln(10);
        //$pdf->Cell(267, 10, '', 1, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->SetFont('freesans', 'B', 9);
        $pdf->Cell(10,8,'Sr.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(50,8,'Company Name', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(20,8,'NTN No.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(20,8,'CNIC No.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(15,8,'Emp Code', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(15,8,'Reg No', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(50,8,'Employee Name', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(40,8,'Department', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(20,8,'Gross Amt', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(20,8,'Taxable Amt', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(20,8,'Tax Amt', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $pdf->ln(8);
        $pdf->SetFont('freesans', '', 9);
        $total_gross_amount=0;
        $total_taxable_amount=0;
        $total_tax_amount=0;
        foreach($rows as $row_no => $row) {
//            $pdf->Cell(10,8,($row_no+1), 'B', false, 'L', 0, '', 1, false, 'M', 'M');
//            $pdf->Cell(70,8,$row['company_name'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
//            $pdf->Cell(20,8,$row['TaxPayer_NTN'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
//            $pdf->Cell(20,8,$row['TaxPayer_CNIC'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
//            $pdf->Cell(20,8,$row['employee_code'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
//            $pdf->Cell(20,8,$row['registration_code'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
//            $pdf->Cell(70,8,$row['TaxPayer_Name'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
//            $pdf->Cell(25,8,$row['department_name'], 'B', false, 'L', 0, '', 1, false, 'M', 'M');
//            $pdf->Cell(30,8,number_format($row['Taxable_Amount'],0), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
//            $pdf->Cell(30,8,number_format($row['Tax_Amount'],0), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->MultiCell(10, 14, ($row_no+1), 'B', 'L',false,0);
            $pdf->MultiCell(50, 14, $row['company_name'], 'B', 'L',false,0);
            $pdf->MultiCell(20, 14, str_replace('-','',$row['TaxPayer_NTN']), 'B', 'L',false,0);
            $pdf->MultiCell(20, 14, str_replace('-','',$row['TaxPayer_CNIC']), 'B', 'L',false,0);
            $pdf->MultiCell(15, 14, $row['employee_code'], 'B', 'L',false,0);
            $pdf->MultiCell(15, 14, $row['registration_code'], 'B', 'L',false,0);
            $pdf->MultiCell(50, 14, $row['TaxPayer_Name'], 'B', 'L',false,0);
            $pdf->MultiCell(40, 14, $row['department_name'], 'B', 'L',false,0);
            $pdf->MultiCell(20, 14, number_format($row['Gross_Amount'],0), 'B', 'R',false,0);
            $pdf->MultiCell(20, 14, number_format($row['Taxable_Amount'],0), 'B', 'R',false,0);
            $pdf->MultiCell(20, 14, number_format($row['Tax_Amount'],0), 'B', 'R',false,0);
            $pdf->ln(16);

            $total_gross_amount += $row['Gross_Amount'];
            $total_taxable_amount += $row['Taxable_Amount'];
            $total_tax_amount += $row['Tax_Amount'];
        }
        $pdf->ln(4);
        $pdf->SetFont('freesans', 'B', 10);
        $pdf->MultiCell(210,8,'', '', 'R', 0, 0);
        $pdf->MultiCell(10,8,'Total:', 'TB', 'R', 0, 0);
        $pdf->MultiCell(20,8,number_format($total_gross_amount,0), 'TB', 'R', 0, 0);
        $pdf->MultiCell(20,8,number_format($total_taxable_amount,0), 'TB', 'R', 0, 0);
        $pdf->MultiCell(20,8,number_format($total_tax_amount,0), 'TB', 'R', 0, 0);

        //Close and output PDF document
        $pdf->Output('Tax Report:'.date('YmdHis').'.pdf', 'I');
    }
}

class PDF extends TCPDF {
    public $data;
    //Page header
    public function Header() {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('freesans', 'B', 20);
        // Title
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->SetFont('freesans', 'B', 14);
        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(90, 10, 'Tax Report', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(90, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(90, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>