<?php

class ControllerReportTaxSummary extends HController {

    protected function getAlias() {
        return 'report/tax_summary';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['document_date'] = stdDate();
        $this->data['href_get_report'] = $this->url->link($this->getAlias() . '/getReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_report'] = $this->url->link($this->getAlias() . '/printReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_summary_report'] = $this->url->link($this->getAlias() . '/printSummaryReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_employee_register'] = $this->url->link($this->getAlias() . '/printEmployeeRegister', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_excel_report'] = $this->url->link($this->getAlias() . '/excelReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation']="{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function getReport() {
        $post = $this->request->post;
        $session = $this->session->data;
        $parent_company_id = $session['parent_company_id'];
        $company_id = $session['company_id'];
        $fiscal_year_id = $session['fiscal_year_id'];
        $department_id = $post['department_id'];
        $employee_id = $post['employee_id'];
        $document_date = MySqlDate();

        $this->model['employee_register'] = $this->load->model('employee/employee_registration');
        $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
        $this->model['payroll'] = $this->load->model('payroll/payroll');

        $arrWhere = [];
        $arrWhere[] = "`company_id` = '$company_id'";
        $arrWhere[] = "`status` = 'Active'";
        if($department_id != '') {
            $arrWhere[] = "`department_id` IN (".implode(',',$department_id).")";
        }
        if($employee_id != '') {
            $arrWhere[] = "`employee_id` = '".$employee_id."'";
        }
        $where = implode(' AND ', $arrWhere);
        $employees = $this->model['employee_register']->getRows($where, ['department_name','employee_name']);
        $arrEmployees = [];
        foreach($employees as $employee) {
            $arrWhere = array();
            $arrWhere[] = "`employee_registration_id`='" . $employee['employee_registration_id'] . "'";
            $arrWhere[] = "`wef_date` <='$document_date'";
            $salary = $this->model['employee_salary']->getRow(implode(' AND ', $arrWhere), array('wef_date desc, created_at desc'));

            if($salary['taxable']=='Yes') { //Check if Salary is Taxable than calculateTaxAmount
                $objPayroll['taxable'] = 1;
                $filter = array(
                    'parent_company_id' => $parent_company_id,
                    'company_id' => $company_id,
                    'fiscal_year_id' => $fiscal_year_id,
                    'employee_registration_id' => $employee['employee_registration_id'],
                    'employee_id' => $employee['employee_id'],
                    'document_date' => $document_date,
                    'taxable_salary' => $salary['taxable_amount'],
                    'exclude_payroll' => 0,
                );
                $tax_info = $this->model['payroll']->getTaxDetail($filter);

                $arrEmployees[] = array(
                    'employee_code' => $employee['employee_code'],
                    'registration_code' => $employee['registration_code'],
                    'employee_name' => $employee['employee_name'],
                    'department_name' => $employee['department_name'],
                    'paid_salary' => $tax_info['annual_taxable_paid_salary'],
                    'paid_allowance' => $tax_info['annual_taxable_paid_allowance'],
                    'current_salary' => $tax_info['annual_taxable_current_salary'],
                    'remaining_salary' => $tax_info['annual_taxable_remainig_salary'],
                    'taxable_salary' => $tax_info['annual_taxable_salary'],
                    'tax_amount' => $tax_info['annual_tax_amount'],
                    'tax_paid' => $tax_info['annual_tax_paid'],
                    'remaining_tax' => $tax_info['remaining_tax'],
                    'total_departments' => $tax_info['salary_count'],
                );
            }
        }

        $html = '';
        $total_paid_salary = 0;
        $total_paid_allowance = 0;
        $total_current_salary = 0;
        $total_remaining_salary = 0;
        $total_taxable_salary = 0;
        $total_tax_amount = 0;
        $total_tax_paid = 0;
        $total_remaining_tax = 0;
        foreach($arrEmployees as $index=>$employee) {
            $html.='<tr>';
            $html.='<td>'.($index+1).'</td>';
            $html.='<td>'.$employee['registration_code'].'</td>';
            $html.='<td>'.$employee['employee_name'].'</td>';
            $html.='<td class="text-right">'.number_format($employee['paid_salary']).'</td>';
            $html.='<td class="text-right">'.number_format($employee['paid_allowance']).'</td>';
            //$html.='<td class="text-right">'.number_format($employee['current_salary']).'</td>';
            //$html.='<td class="text-right">'.number_format($employee['remaining_salary']).'</td>';
            $html.='<td class="text-right">'.number_format($employee['current_salary']+$employee['remaining_salary']).'</td>';
            $html.='<td class="text-right">'.number_format($employee['taxable_salary']).'</td>';
            $html.='<td class="text-right">'.number_format($employee['tax_amount']).'</td>';
            $html.='<td class="text-right">'.number_format($employee['tax_paid']).'</td>';
            $html.='<td class="text-right">'.number_format($employee['remaining_tax']).'</td>';
            $html.='<td class="text-right">'.number_format($employee['total_departments']).'</td>';
            $html.='</tr>';

            $total_paid_salary += $employee['paid_salary'];
            $total_paid_allowance += $employee['paid_allowance'];
            $total_current_salary += $employee['current_salary'];
            $total_remaining_salary += $employee['remaining_salary'];
            $total_taxable_salary += $employee['taxable_salary'];
            $total_tax_amount += $employee['tax_amount'];
            $total_tax_paid += $employee['tax_paid'];
            $total_remaining_tax += $employee['remaining_tax'];
        }

        $html.='<tr>';
        $html.='<td>&nbsp;</td>';
        $html.='<td>&nbsp;</td>';
        $html.='<td class="text-right">Total:</td>';
        $html.='<td class="text-right">'.number_format($total_paid_salary).'</td>';
        $html.='<td class="text-right">'.number_format($total_paid_allowance).'</td>';
        //$html.='<td class="text-right">'.number_format($total_current_salary).'</td>';
        $html.='<td class="text-right">'.number_format($total_current_salary+$total_remaining_salary).'</td>';
        $html.='<td class="text-right">'.number_format($total_taxable_salary).'</td>';
        $html.='<td class="text-right">'.number_format($total_tax_amount).'</td>';
        $html.='<td class="text-right">'.number_format($total_tax_paid).'</td>';
        $html.='<td class="text-right">'.number_format($total_remaining_tax).'</td>';
        $html.='<td class="text-right">&nbsp;</td>';
        $html.='</tr>';
        $json = array(
            'success' => true,
            'employees' => $arrEmployees,
            'html' => $html,
        );

        echo json_encode($json);
    }

    public function printReport() {
        ini_set('max_execution_time',400);

        $post = $this->request->post;
        $session = $this->session->data;
        $parent_company_id = $session['parent_company_id'];
        $company_id = $session['company_id'];
        $fiscal_year_id = $session['fiscal_year_id'];
        $department_id = $post['department_id'];
        $employee_id = $post['employee_id'];
        $document_date = MySqlDate();

        $this->model['employee_register'] = $this->load->model('employee/employee_registration');
        $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
        $this->model['payroll'] = $this->load->model('payroll/payroll');

        $arrWhere = [];
        $arrWhere[] = "`company_id` = '$company_id'";
        $arrWhere[] = "`status` = 'Active'";
        if($department_id != '') {
            $arrWhere[] = "`department_id` IN (".implode(',',$department_id).")";
        }
        if($employee_id != '') {
            $arrWhere[] = "`employee_id` = '".$employee_id."'";
        }
        $where = implode(' AND ', $arrWhere);
        $employees = $this->model['employee_register']->getRows($where, ['department_name','employee_name']);
        $arrEmployees = [];
        foreach($employees as $employee) {
            $arrWhere = array();
            $arrWhere[] = "`employee_registration_id`='" . $employee['employee_registration_id'] . "'";
            $arrWhere[] = "`wef_date` <='$document_date'";
            $salary = $this->model['employee_salary']->getRow(implode(' AND ', $arrWhere), array('wef_date desc, created_at desc'));

            if($salary['taxable']=='Yes') { //Check if Salary is Taxable than calculateTaxAmount
                $objPayroll['taxable'] = 1;
                $filter = array(
                    'parent_company_id' => $parent_company_id,
                    'company_id' => $company_id,
                    'fiscal_year_id' => $fiscal_year_id,
                    'employee_registration_id' => $employee['employee_registration_id'],
                    'employee_id' => $employee['employee_id'],
                    'document_date' => $document_date,
                    'taxable_salary' => $salary['taxable_amount'],
                    'exclude_payroll' => 0,
                );
                $tax_info = $this->model['payroll']->getTaxDetail($filter);

                $arrEmployees[] = array(
                    'employee_code' => $employee['employee_code'],
                    'registration_code' => $employee['registration_code'],
                    'employee_name' => $employee['employee_name'],
                    'department_name' => $employee['department_name'],
                    'paid_salary' => $tax_info['annual_taxable_paid_salary'],
                    'paid_allowance' => $tax_info['annual_taxable_paid_allowance'],
                    'current_salary' => $tax_info['annual_taxable_current_salary'],
                    'remaining_salary' => $tax_info['annual_taxable_remainig_salary'],
                    'taxable_salary' => $tax_info['annual_taxable_salary'],
                    'tax_amount' => $tax_info['annual_tax_amount'],
                    'tax_paid' => $tax_info['annual_tax_paid'],
                    'remaining_tax' => $tax_info['remaining_tax'],
                    'total_departments' => $tax_info['salary_count'],
                );
            }
        }

        $pdf = new PDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => 'Est. TAX Summary Report',
        );
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Est. Tax Summary');
        $pdf->SetSubject('Est. Tax Summary');
        $pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->AddPage();
        $sr=0;
        $tot_paid_salary = 0;
        $tot_paid_allowance = 0;
        $tot_remaining_salary = 0;
        $tot_taxable_salary = 0;
        $tot_tax_amount = 0;
        $tot_tax_paid = 0;
        $tot_tax_remaining = 0;
        foreach($arrEmployees as $department_name => $employees) {

            $start_page = $pdf->getPage();
            $pdf->startTransaction();

            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(0, 10, $department_name, 0, false, 'L');
            $pdf->ln(8);

            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(10, 10, 'Sr.', 1, false, 'C');
            $pdf->Cell(20, 10, 'Reg. Code', 1, false, 'C');
            $pdf->Cell(70, 10, 'Employee Name', 1, false, 'C');
            $pdf->Cell(23, 10, 'Paid Salary', 1, false, 'C');
            $pdf->Cell(23, 10, 'Paid Allow.', 1, false, 'C');
            $pdf->Cell(23, 10, 'Rem. Salary', 1, false, 'C');
            $pdf->Cell(23, 10, 'Taxable Salary', 1, false, 'C');
            $pdf->Cell(23, 10, 'Tax Amount', 1, false, 'C');
            $pdf->Cell(23, 10, 'Paid Tax', 1, false, 'C');
            $pdf->Cell(23, 10, 'Rem. Tax', 1, false, 'C');
            $pdf->Cell(19, 10, 'Tot. Depts.', 1, false, 'C');
            $pdf->ln(10);

            $dept_paid_salary = 0;
            $dept_paid_allowance = 0;
            $dept_remaining_salary = 0;
            $dept_taxable_salary = 0;
            $dept_tax_amount = 0;
            $dept_tax_paid = 0;
            $dept_tax_remaining = 0;
            $pdf->SetFont('freesans', '', 10);
            foreach($employees as $employee) {
                $sr++;
                $pdf->Cell(10, 8, $sr, 1, false, 'R');
                $pdf->Cell(20, 8, $employee['registration_code'], 1, false, 'L');
                $pdf->Cell(70, 8, $employee['employee_name'], 1, false, 'L');
                $pdf->Cell(23, 8, number_format($employee['paid_salary']), 1, false, 'R');
                $pdf->Cell(23, 8, number_format($employee['paid_allowance']), 1, false, 'R');
                $pdf->Cell(23, 8, number_format($employee['remaining_salary']), 1, false, 'R');
                $pdf->Cell(23, 8, number_format($employee['taxable_salary']), 1, false, 'R');
                $pdf->Cell(23, 8, number_format($employee['tax_amount']), 1, false, 'R');
                $pdf->Cell(23, 8, number_format($employee['tax_paid']), 1, false, 'R');
                $pdf->Cell(23, 8, number_format($employee['remaining_tax']), 1, false, 'R');
                $pdf->Cell(19, 8, number_format($employee['total_departments']), 1, false, 'R');
                $pdf->ln(8);

                $dept_paid_salary += $employee['paid_salary'];
                $dept_paid_allowance += $employee['paid_allowance'];
                $dept_remaining_salary += $employee['remaining_salary'];
                $dept_taxable_salary += $employee['taxable_salary'];
                $dept_tax_amount += $employee['tax_amount'];
                $dept_tax_paid += $employee['tax_paid'];
                $dept_tax_remaining += $employee['remaining_tax'];

                $tot_paid_salary += $employee['paid_salary'];
                $tot_paid_allowance += $employee['paid_allowance'];
                $tot_remaining_salary += $employee['remaining_salary'];
                $tot_taxable_salary += $employee['taxable_salary'];
                $tot_tax_amount += $employee['tax_amount'];
                $tot_tax_paid += $employee['tax_paid'];
                $tot_tax_remaining += $employee['remaining_tax'];
            }
            $pdf->SetFont('freesans', 'B', 10);
            $pdf->Cell(10, 8, '', 1, false, 'R');
            $pdf->Cell(20, 8, '', 1, false, 'L');
            $pdf->Cell(70, 8, 'Dept. Total', 1, false, 'L');
            $pdf->Cell(23, 8, number_format($dept_paid_salary), 1, false, 'R');
            $pdf->Cell(23, 8, number_format($dept_paid_allowance), 1, false, 'R');
            $pdf->Cell(23, 8, number_format($dept_remaining_salary), 1, false, 'R');
            $pdf->Cell(23, 8, number_format($dept_taxable_salary), 1, false, 'R');
            $pdf->Cell(23, 8, number_format($dept_tax_amount), 1, false, 'R');
            $pdf->Cell(23, 8, number_format($dept_tax_paid), 1, false, 'R');
            $pdf->Cell(23, 8, number_format($dept_tax_remaining), 1, false, 'R');
            $pdf->Cell(19, 8, '', 1, false, 'R');
            $pdf->ln(8);
            $pdf->ln(10);

            $end_page = $pdf->getPage();
            if($start_page != $end_page) {
                $pdf->rollbackTransaction(true); //Do not forget to add True
                $pdf->AddPage();

                $pdf->SetFont('freesans', 'B', 10);
                $pdf->Cell(0, 10, $department_name, 0, false, 'L');
                $pdf->ln(8);

                $pdf->SetFont('freesans', 'B', 8);
                $pdf->Cell(10, 10, 'Sr.', 1, false, 'C');
                $pdf->Cell(20, 10, 'Reg. Code', 1, false, 'C');
                $pdf->Cell(70, 10, 'Employee Name', 1, false, 'C');
                $pdf->Cell(23, 10, 'Paid Salary', 1, false, 'C');
                $pdf->Cell(23, 10, 'Paid Allow.', 1, false, 'C');
                $pdf->Cell(23, 10, 'Rem. Salary', 1, false, 'C');
                $pdf->Cell(23, 10, 'Taxable Salary', 1, false, 'C');
                $pdf->Cell(23, 10, 'Tax Amount', 1, false, 'C');
                $pdf->Cell(23, 10, 'Paid Tax', 1, false, 'C');
                $pdf->Cell(23, 10, 'Rem. Tax', 1, false, 'C');
                $pdf->Cell(19, 10, 'Tot. Depts.', 1, false, 'C');
                $pdf->ln(10);

                $dept_paid_salary = 0;
                $dept_paid_allowance = 0;
                $dept_remaining_salary = 0;
                $dept_taxable_salary = 0;
                $dept_tax_amount = 0;
                $dept_tax_paid = 0;
                $dept_tax_remaining = 0;
                $pdf->SetFont('freesans', '', 10);
                foreach($employees as $employee) {
                    $sr++;
                    $pdf->Cell(10, 8, $sr, 1, false, 'R');
                    $pdf->Cell(20, 8, $employee['registration_code'], 1, false, 'L');
                    $pdf->Cell(70, 8, $employee['employee_name'], 1, false, 'L');
                    $pdf->Cell(23, 8, number_format($employee['paid_salary']), 1, false, 'R');
                    $pdf->Cell(23, 8, number_format($employee['paid_allowance']), 1, false, 'R');
                    $pdf->Cell(23, 8, number_format($employee['remaining_salary']), 1, false, 'R');
                    $pdf->Cell(23, 8, number_format($employee['taxable_salary']), 1, false, 'R');
                    $pdf->Cell(23, 8, number_format($employee['tax_amount']), 1, false, 'R');
                    $pdf->Cell(23, 8, number_format($employee['tax_paid']), 1, false, 'R');
                    $pdf->Cell(23, 8, number_format($employee['remaining_tax']), 1, false, 'R');
                    $pdf->Cell(19, 8, number_format($employee['total_departments']), 1, false, 'R');
                    $pdf->ln(8);

                    $dept_paid_salary += $employee['paid_salary'];
                    $dept_paid_allowance += $employee['paid_allowance'];
                    $dept_remaining_salary += $employee['remaining_salary'];
                    $dept_taxable_salary += $employee['taxable_salary'];
                    $dept_tax_amount += $employee['tax_amount'];
                    $dept_tax_paid += $employee['tax_paid'];
                    $dept_tax_remaining += $employee['remaining_tax'];

                    $tot_paid_salary += $employee['paid_salary'];
                    $tot_paid_allowance += $employee['paid_allowance'];
                    $tot_remaining_salary += $employee['remaining_salary'];
                    $tot_taxable_salary += $employee['taxable_salary'];
                    $tot_tax_amount += $employee['tax_amount'];
                    $tot_tax_paid += $employee['tax_paid'];
                    $tot_tax_remaining += $employee['remaining_tax'];
                }
                $pdf->SetFont('freesans', 'B', 10);
                $pdf->Cell(10, 8, '', 1, false, 'R');
                $pdf->Cell(20, 8, '', 1, false, 'L');
                $pdf->Cell(70, 8, 'Dept. Total', 1, false, 'L');
                $pdf->Cell(23, 8, number_format($dept_paid_salary), 1, false, 'R');
                $pdf->Cell(23, 8, number_format($dept_paid_allowance), 1, false, 'R');
                $pdf->Cell(23, 8, number_format($dept_remaining_salary), 1, false, 'R');
                $pdf->Cell(23, 8, number_format($dept_taxable_salary), 1, false, 'R');
                $pdf->Cell(23, 8, number_format($dept_tax_amount), 1, false, 'R');
                $pdf->Cell(23, 8, number_format($dept_tax_paid), 1, false, 'R');
                $pdf->Cell(23, 8, number_format($dept_tax_remaining), 1, false, 'R');
                $pdf->Cell(19, 8, '', 1, false, 'R');
                $pdf->ln(8);
                $pdf->ln(10);
            } else {
                $pdf->commitTransaction();
            }
        }

        $pdf->SetFont('freesans', 'B', 10);
        $pdf->Cell(10, 8, '', 1, false, 'R');
        $pdf->Cell(20, 8, '', 1, false, 'L');
        $pdf->Cell(70, 8, 'Total', 1, false, 'L');
        $pdf->Cell(23, 8, number_format($tot_paid_salary), 1, false, 'R');
        $pdf->Cell(23, 8, number_format($tot_paid_allowance), 1, false, 'R');
        $pdf->Cell(23, 8, number_format($tot_remaining_salary), 1, false, 'R');
        $pdf->Cell(23, 8, number_format($tot_taxable_salary), 1, false, 'R');
        $pdf->Cell(23, 8, number_format($tot_tax_amount), 1, false, 'R');
        $pdf->Cell(23, 8, number_format($tot_tax_paid), 1, false, 'R');
        $pdf->Cell(23, 8, number_format($tot_tax_remaining), 1, false, 'R');
        $pdf->Cell(19, 8, '', 1, false, 'R');
        //Close and output PDF document
        $pdf->Output('Tax Summary:'.date('YmdHis').'.pdf', 'I');
    }

    public function excelReport() {
        ini_set('max_execution_time',400);
        $post = $this->request->post;
        $session = $this->session->data;
        $parent_company_id = $session['parent_company_id'];
        $company_id = $session['company_id'];
        $fiscal_year_id = $session['fiscal_year_id'];
        $department_id = $post['department_id'];
        $employee_id = $post['employee_id'];
        $document_date = MySqlDate();

        $this->model['employee_register'] = $this->load->model('employee/employee_registration');
        $this->model['employee_salary'] = $this->load->model('employee/employee_salary');
        $this->model['payroll'] = $this->load->model('payroll/payroll');

        $arrWhere = [];
        $arrWhere[] = "`company_id` = '$company_id'";
        $arrWhere[] = "`status` = 'Active'";
        if($department_id != '') {
            $arrWhere[] = "`department_id` IN (".implode(',',$department_id).")";
        }
        if($employee_id != '') {
            $arrWhere[] = "`employee_id` = '".$employee_id."'";
        }
        $where = implode(' AND ', $arrWhere);
        $employees = $this->model['employee_register']->getRows($where, ['department_name','employee_name']);
        $arrEmployees = [];
        foreach($employees as $employee) {
            $arrWhere = array();
            $arrWhere[] = "`employee_registration_id`='" . $employee['employee_registration_id'] . "'";
            $arrWhere[] = "`wef_date` <='$document_date'";
            $salary = $this->model['employee_salary']->getRow(implode(' AND ', $arrWhere), array('wef_date desc, created_at desc'));

            if($salary['taxable']=='Yes') { //Check if Salary is Taxable than calculateTaxAmount
                $objPayroll['taxable'] = 1;
                $filter = array(
                    'parent_company_id' => $parent_company_id,
                    'company_id' => $company_id,
                    'fiscal_year_id' => $fiscal_year_id,
                    'employee_registration_id' => $employee['employee_registration_id'],
                    'employee_id' => $employee['employee_id'],
                    'document_date' => $document_date,
                    'taxable_salary' => $salary['taxable_amount'],
                    'exclude_payroll' => 0,
                );
                $tax_info = $this->model['payroll']->getTaxDetail($filter);

                $arrEmployees[] = array(
                    'employee_code' => $employee['employee_code'],
                    'registration_code' => $employee['registration_code'],
                    'employee_name' => $employee['employee_name'],
                    'department_name' => $employee['department_name'],
                    'paid_salary' => $tax_info['annual_taxable_paid_salary'],
                    'paid_allowance' => $tax_info['annual_taxable_paid_allowance'],
                    'current_salary' => $tax_info['annual_taxable_current_salary'],
                    'remaining_salary' => $tax_info['annual_taxable_remainig_salary'],
                    'taxable_salary' => $tax_info['annual_taxable_salary'],
                    'tax_amount' => $tax_info['annual_tax_amount'],
                    'tax_paid' => $tax_info['annual_tax_paid'],
                    'remaining_tax' => $tax_info['remaining_tax'],
                    'total_departments' => $tax_info['salary_count'],
                );
            }
        }

        $columns = array_keys($arrEmployees[0]);
        $no_of_columns = count($columns);
        $start_column_idx = 0;
        $end_column_idx = $start_column_idx + $no_of_columns -1;

        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getProperties()
            ->setCreator("Hira")
            ->setLastModifiedBy("Hira")
            ->setTitle("Est. Tax Summary");

        $objPHPExcel->data = array(
            'company_name' => $session['company_name'],
            'report_name' => 'Est. Tax Summary'
        );

        $row_no = 1;
        $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
        //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
        $style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'font' => array(
                'size' => 25
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'ebebeb')
            )
        );
        $objPHPExcel->getActiveSheet()
            ->mergeCells($merge_cells)
            ->setCellValue('A'.$row_no,$session['company_name'])
            ->getStyle($merge_cells)
            ->applyFromArray($style);

        $row_no ++;
        $merge_cells = $this->cellsToMergeByColsRow($start_column_idx, $end_column_idx, $row_no);
        //d(array($start_column_idx, $no_of_columns, $end_column_idx, $merge_cells), true);
        $style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'font' => array(
                'size' => 25
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'ebebeb')
            )
        );
        $objPHPExcel->getActiveSheet()
            ->mergeCells($merge_cells)
            ->setCellValue('A'.$row_no,'Est. Tax Summary')
            ->getStyle($merge_cells)
            ->applyFromArray($style);

        $row_no ++;
        $column_no = 0;
        $row_no++;
        foreach($columns as $column) {
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($column_no, $row_no, $column)
                ->getStyleByColumnAndRow($column_no, $row_no)
                ->applyFromArray(
                    array(
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => '000000')
                        )
                    ,
                        'font'  => array(
                            'color' => array('rgb' => 'ffffff')
                        )
                    )
                )
            ;
            $column_no++;
        }
        $row_no++;


        foreach ($arrEmployees as $row)
        {
            $column_no=0;
            foreach($columns as $column) {
                $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($column_no, $row_no, $row[$column]);
                $column_no++;
            }

            $row_no++;
        }

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="Payroll Register.xlsx"');
        header('Cache-Control: max-age=0');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('php://output');
        exit;
    }

    private function cellsToMergeByColsRow($start = -1, $end = -1, $row = -1){
        $merge = 'A1:A1';
        if($start>=0 && $end>=0 && $row>=0){
            $start = PHPExcel_Cell::stringFromColumnIndex($start);
            $end = PHPExcel_Cell::stringFromColumnIndex($end);
            $merge = "$start{$row}:$end{$row}";
        }
        return $merge;
    }

}

class PDF extends TCPDF {
    public $data;
    //Page header
    public function Header() {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('freesans', 'B', 20);
        // Title
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->SetFont('freesans', 'B', 14);
        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->SetFont('freesans', '', 14);
        $this->Cell(0, 10, $this->data['subtitle'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(89, 10, $this->data['subtitle'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(89, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(89, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>