<?php

class ControllerReportWithholdingStatement extends HController {

    protected function getAlias() {
        return 'report/withholding_statement';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/payroll');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->model['company'] = $this->load->model('user/user_access');
        $this->data['companies'] = $this->model['company']->getRows(array('user_id' => $this->session->data['user_id']));

        $this->data['document_date'] = stdDate();
        $this->data['href_get_report'] = $this->url->link($this->getAlias() . '/getReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_download_excel'] = $this->url->link($this->getAlias() . '/downloadExcel', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['strValidation']="{
            'rules':{
		        'from_document_date': {'required':true},
		        'to_document_date': {'required':true},
		        'company_id[]': {'required':true},
            },
        }";

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function getReport() {
        $from_document_date = MySqlDate($this->request->post['from_document_date']);
        $to_document_date = MySqlDate($this->request->post['to_document_date']);
        $companies = $this->request->post['company_id'];

        //$this->model['withholding_statement'] = $this->load->model('report/withholding_statement');
        //$rows = $this->model['withholding_statement']->getReport($from_document_date, $to_document_date, $companies);

        $arrWhere = array();
        $arrWhere[] = "p.`company_id` IN (".implode(',',$companies).")";
        $arrWhere[] = "p.`document_date` >= '".$from_document_date."'";
        $arrWhere[] = "p.`document_date` <= '".$to_document_date."'";
        $where = implode(' AND ', $arrWhere);
        $this->model['report'] = $this->load->model($this->getAlias());
        //$rows = $this->model['payroll']->getRegister($where);
        $rows = $this->model['report']->getRecords($where);
        //d([$where,$rows], true);
        $html = '';
        $total_amount = 0;
        $total_tax = 0;
        foreach($rows as $row_id => $row) {
            $html .= '<tr>';
            $html .= '<td class="text-left">'.($row_id+1).'</td>';
            $html .= '<td class="text-left">'.$row['ntn_no'].'</td>';
            $html .= '<td class="text-left">'.$row['cnic_no'].'</td>';
            $html .= '<td class="text-left">'.$row['cnic_name'].'</td>';
            $html .= '<td class="text-right">'.$row['document_date'].'</td>';
            $html .= '<td class="text-right">64020004</td>';
            $html .= '<td class="text-right">'.number_format($row['gross_salary']-$row['manual_deduction']-$row['attendance_deduction'],2).'</td>';
            $html .= '<td class="text-right">&nbsp;</td>';
            $html .= '<td class="text-right">'.number_format($row['tax_deduction'],2).'</td>';
            $html .= '</tr>';

            $total_amount += $row['amount'];
            $total_tax += $row['tax_amount'];
        }

        $json = array(
            'success' => true,
            'filter' => $this->request->post,
            'payrolls' => $rows,
            'html' => $html
        );

        echo json_encode($json);
    }

    public function downloadExcel() {
        include_once(DIR_SYSTEM.'library/PHPExcel.php');
        include_once(DIR_SYSTEM.'library/PHPExcel/Classes/PHPExcel/Writer/Excel5.php');
        $from_document_date = MySqlDate($this->request->post['from_document_date']);
        $to_document_date = MySqlDate($this->request->post['to_document_date']);
        $companies = $this->request->post['company_id'];

        //$this->model['withholding_statement'] = $this->load->model('report/withholding_statement');
        //$rows = $this->model['withholding_statement']->getReport($from_document_date, $to_document_date, $companies);
        $arrWhere = array();
        $arrWhere[] = "p.`company_id` IN (".implode(',',$companies).")";
        $arrWhere[] = "p.`document_date` >= '".$from_document_date."'";
        $arrWhere[] = "p.`document_date` <= '".$to_document_date."'";
        $where = implode(' AND ', $arrWhere);
        $this->model['report'] = $this->load->model($this->getAlias());
        //$rows = $this->model['payroll']->getRegister($where);
        $rows = $this->model['report']->getRecords($where);

        //d([$arrWhere, $rows], true);
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $rowCount = 1;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'REGISTRATION NO');
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, 'IDENTIFICATION NO');
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, 'NAME');
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, 'TRANSACTION DATE');
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, 'CODE');
        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, 'AMOUNT');
        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, 'EXEMPTION CODE');
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, 'TAX COLLECTIBLE / DEDUCTIBLE');
        $rowCount++;
        //d($rows, true);
        foreach($rows as $row){
            $ntn_no = is_null($row['ntn_no'])?'':substr($row['ntn_no'],0,7);
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $ntn_no==false?'':$ntn_no);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, str_replace('-','',$row['cnic_no']));
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $row['cnic_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, date('d-M-y',strtotime($row['document_date'])));
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, '64020004');
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, ($row['gross_salary']-$row['manual_deduction']-$row['attendance_deduction']));
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $row['tax_deduction']);
            $rowCount++;
        }

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="Tax.xls"');
        header('Cache-Control: max-age=0');
        //$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        //$objWriter->save('some_excel_file.xlsx');
        $objWriter->save('php://output');
        exit;
    }

    public function printReport() {
        ini_set('max_execution_time',400);
        $lang = $this->load->language($this->getAlias());
        $from_document_date = MySqlDate($this->request->post['from_document_date']);
        $to_document_date = MySqlDate($this->request->post['to_document_date']);
        $companies = $this->request->post['company_id'];
        $include_gross = $this->request->post['include_gross'];
        $include_with_allowance = $this->request->post['include_with_allowance'];
        //d(array($from_document_date, $to_document_date, $companies, $include_gross, $include_with_allowance), true);

        $this->model['withholding_statement'] = $this->load->model('report/withholding_statement');
        $rows = $this->model['withholding_statement']->getReport($from_document_date, $to_document_date, $companies);
        //d($rows, true);
        $pdf = new PDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->data = array(
            'company_name' => $this->session->data['company_name'],
            'report_title' => 'EOBI Report',
            'subtitle' => '',
            'include_gross' => $include_gross,
            'include_with_allowance' => $include_with_allowance,
        );
        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('EOBI Report');
        $pdf->SetSubject('EOBI Report');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        //$pdf->SetMargins(PDF_MARGIN_LEFT, 20, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(5, 25, 5);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 5);

        // add a page
        $pdf->AddPage();
        //$pdf->Cell(0, 10, '', 1, false, 'L', 0, '', 0, false, 'M', 'M');
        //$pdf->ln(10);
        //$pdf->Cell(180, 10, '', 1, false, 'L', 0, '', 0, false, 'M', 'M');
        $arrDepositSlip = array();
        $pdf->SetFont('freesans', '', 9);
        $total_gross_with_allowance=0;
        $total_gross_salary=0;
        $total_withholding_statement_deduction=0;
        foreach($rows as $sr_no => $row) {
            $pdf->Cell(10, 7, ($sr_no+1), 'B', false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 7, $row['employee_code'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 7, $row['registration_code'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(70, 7, $row['employee_name'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            if($row['joining_date']=='') {
                $pdf->Cell(20, 7, '', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            } else {
                $pdf->Cell(20, 7, stdDate($row['joining_date']), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            }
            $pdf->Cell(30, 7, $row['withholding_statement_no'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            if($row['withholding_statement_date']=='') {
                $pdf->Cell(20, 7, '', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            } else {
                $pdf->Cell(20, 7, stdDate($row['withholding_statement_date']), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            }
            $pdf->Cell(30, 7, $row['cnic_no'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            if($row['dob']=='') {
                $pdf->Cell(20, 7, '', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            } else {
                $pdf->Cell(20, 7, stdDate($row['dob']), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            }
            if($pdf->data['include_with_allowance'])
                $pdf->Cell(20, 7, number_format($row['gross_with_allowance'],2), 'B', false, 'R', 0, '', 0, false, 'M', 'M');
            if($pdf->data['include_gross'])
                $pdf->Cell(20, 7, number_format($row['gross_salary'],2), 'B', false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 7, number_format($row['deduction_amount'],2), 'B', false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->ln(7);

            $total_gross_with_allowance += $row['gross_with_allowance'];
            $total_gross_salary += $row['gross_salary'];
            $total_withholding_statement_deduction += $row['deduction_amount'];
        }
        $pdf->SetFont('freesans', 'B', 8);
        $pdf->Cell(225, 7, 'Total:', 'B', false, 'R', 0, '', 0, false, 'M', 'M');
        if($pdf->data['include_with_allowance'])
            $pdf->Cell(20, 7, number_format($total_gross_with_allowance,2), 'B', false, 'R', 0, '', 0, false, 'M', 'M');
        if($pdf->data['include_gross'])
            $pdf->Cell(20, 7, number_format($total_gross_salary,2), 'B', false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(20, 7, number_format($total_withholding_statement_deduction,2), 'B', false, 'R', 0, '', 0, false, 'M', 'M');
        //Close and output PDF document
        $pdf->Output('Payroll Slip:'.date('YmdHis').'.pdf', 'I');
    }

}

class PDF extends TCPDF {
    public $data;
    //Page header
    public function Header() {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('freesans', 'B', 20);
        // Title
//        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
        $this->SetFont('freesans', 'B', 14);
        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('freesans', '', 14);
//        $this->Cell(0, 10, $this->data['subtitle'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('freesans', 'B', 9);
        $this->Ln(10);
        $this->Cell(10, 10, 'Sr.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $this->Cell(15, 10, 'Emp. No.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $this->Cell(15, 10, 'Reg. No.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $this->Cell(70, 10, 'Emp. Name', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $this->Cell(20, 10, 'Joining Dt.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $this->Cell(30, 10, 'EOBI No.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $this->Cell(20, 10, 'EOBI Dt.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $this->Cell(30, 10, 'CNIC No.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $this->Cell(20, 10, 'DOB', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        if($this->data['include_with_allowance'])
        $this->Cell(20, 10, 'S&A', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        if($this->data['include_gross'])
        $this->Cell(20, 10, 'Gross', 1, false, 'C', 0, '', 1, false, 'M', 'M');
        $this->Cell(15, 10, 'EOBI Amt.', 1, false, 'C', 0, '', 1, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-10);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(95, 10, 'Payroll Slip', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(95, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(95, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>