<?php

class ControllerSetupAttendanceShift extends HController {

    protected function getAlias() {
        return 'setup/attendance_shift';
    }

    protected function getPrimaryKey() {
        return 'attendance_shift_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $this->load->language('setup/attendance_shift');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'shift_title','late_deduction','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $this->data['lang']['delete'],
                'href' => 'javascript:void(0);',
                'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                'btn_class' => 'btn btn-danger btn-xs',
                'class' => 'fa fa-times'
            );


            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();
        $this->data['shift_details']['Mon'] = array(
            'day' => 'Mon',
            'day_status' => 'Working Day',
            'from_time' => '9:00',
            'to_time' => '17:00',
        );
        $this->data['shift_details']['Tue'] = array(
            'day' => 'Tue',
            'day_status' => 'Working Day',
            'from_time' => '9:00',
            'to_time' => '17:00',
        );
        $this->data['shift_details']['Wed'] = array(
            'day' => 'Wed',
            'day_status' => 'Working Day',
            'from_time' => '9:00',
            'to_time' => '17:00',
        );
        $this->data['shift_details']['Thu'] = array(
            'day' => 'Thu',
            'day_status' => 'Working Day',
            'from_time' => '9:00',
            'to_time' => '17:00',
        );
        $this->data['shift_details']['Fri'] = array(
            'day' => 'Fri',
            'day_status' => 'Working Day',
            'from_time' => '9:00',
            'to_time' => '17:00',
        );
        $this->data['shift_details']['Sat'] = array(
            'day' => 'Sat',
            'day_status' => 'Holiday',
            'from_time' => '0:00',
            'to_time' => '0:00',
        );
        $this->data['shift_details']['Sun'] = array(
            'day' => 'Sun',
            'day_status' => 'Holiday',
            'from_time' => '0:00',
            'to_time' => '0:00',
        );

        if (isset($this->request->get['attendance_shift_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('attendance_shift_id' => $this->request->get['attendance_shift_id']));
            foreach($result as $field => $value) {
                $this->data[$field] = $value;
            }

            $this->model['attendance_shift_detail'] = $this->load->model('setup/attendance_shift_detail');
            $details = $this->model['attendance_shift_detail']->getArrays('day', array('day','day_status','from_time', 'to_time'), array('attendance_shift_id' => $result['attendance_shift_id']));
            foreach($details as $day => $detail) {
                $this->data['shift_details'][$day] = $detail;
            }
        }

        $this->data['action_validate_name'] = $this->url->link($this->getAlias() . '/validateName', 'token=' . $this->session->data['token'] . '&attendance_shift_id=' . $this->request->get['attendance_shift_id']);
        $this->data['strValidation']="{
            'rules':{
		        'shift_title': {'required':true, 'minlength': 5, 'remote':  {url: '" . $this->data['action_validate_name'] . "', type: 'post'}},
		        'late_deduction': {'required':true},
            },
        }";

        $this->response->setOutput($this->render());
    }

    public function validateName()
    {
        $name = $this->request->post['shift_title'];
        //$company_id = $this->session->data['company_id'];
        //$company_branch_id = $this->session->data['company_branch_id'];
        $attendance_shift_id = $this->request->get['attendance_shift_id'];

        $this->load->language('setup/attendance_shift');
        if ($name) {
            $this->model['attendance_shift'] = $this->load->model('setup/attendance_shift');
            $where = " LOWER(shift_title) = '".strtolower($name)."' AND attendance_shift_id != '".$attendance_shift_id."'";
            //$where .= " AND company_id='" . $company_id . "' AND company_branch_id='" . $company_branch_id . "'";
            $row = $this->model['attendance_shift']->getRow($where);
            if ($row) {
                echo json_encode($this->language->get('error_duplicate_name'));
            } else {
                echo json_encode("true");
            }
        } else {
            echo json_encode($this->language->get('error_name'));
        }
        exit;
    }

    public function insertData($data) {
        $data['company_id'] = $this->session->data['company_id'];
        $attendance_shift_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);
        $this->model['attendance_shift_detail'] = $this->load->model('setup/attendance_shift_detail');
        foreach($data['shift_details'] as $detail) {
            $detail['attendance_shift_id'] = $attendance_shift_id;

            $this->model['attendance_shift_detail']->add($this->getAlias(), $detail);
        }
        return $attendance_shift_id;
    }

    public function updateData($primary_key, $data) {
        $attendance_shift_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);
        $this->model['attendance_shift_detail'] = $this->load->model('setup/attendance_shift_detail');
        $this->model['attendance_shift_detail']->deleteBulk($this->getAlias(), array('attendance_shift_id' => $attendance_shift_id));
        foreach($data['shift_details'] as $detail) {
            $detail['attendance_shift_id'] = $attendance_shift_id;

            $this->model['attendance_shift_detail']->add($this->getAlias(), $detail);
        }
        return $attendance_shift_id;

    }
}

?>