<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require DIR_SYSTEM . 'library/PHPMailer/Exception.php';
require DIR_SYSTEM . 'library/PHPMailer/PHPMailer.php';
require DIR_SYSTEM . 'library/PHPMailer/SMTP.php';

class ControllerSetupCoreSetting extends HController {

    protected function getAlias() {
        return 'setup/core_setting';
    }

    protected function getPrimaryKey() {
        return 'core_setting_id';
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('setup/core_setting');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    public function index() {
        $this->redirect($this->url->link($this->getAlias() . '/insert', 'token=' . $this->session->data['token'], 'SSL'));
    }

    protected function getForm() {
        parent::getForm();

        $results = $this->model[$this->getAlias()]->getRows(array('company_id' => $this->session->data['company_id'], 'module' => 'general'));
        foreach($results as $result) {
            $this->data[$result['field']] = $result['value'];
        }

        $this->model['allowance_type'] = $this->load->model('setup/special_allowance_type');
        $this->data['allowance_type'] = $this->model['allowance_type']->getRows();

        $this->model['policy'] = $this->load->model('setup/company_allowance_policy');
        $this->data['policies'] = $this->model['policy']->getRecords(['p.company_id' => $this->session->data['company_id']],['sort_order']);
        //d($this->data['policies'], true);

        $this->data['href_send_test_email'] = $this->url->link($this->getAlias() . '/sendTestEmail', 'token=' . $this->session->data['token'] . 'SSL');
        $this->data['href_send_test_sms'] = $this->url->link($this->getAlias() . '/sendTestSMS', 'token=' . $this->session->data['token'] . 'SSL');
        $this->data['href_allowance_category'] = $this->url->link($this->getAlias() . '/getAllowanceCategory', 'token=' . $this->session->data['token'] . 'SSL');
        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function getAllowanceCategory()
    {
        $post = $this->request->post;
        $type_id = $post['allowance_type_id'];
        $this->model['allowance_category'] = $this->load->model('setup/special_allowance_category');
        $result = $this->model['allowance_category']->getRows(array('special_allowance_type_id' => $type_id));

        $html = '<option value="0">ALL</option>';
        foreach ($result as $key => $value) {
            $html .= '<option value="'.$value['special_allowance_category_id'].'">'.$value['special_allowance_category'].'</option>';
        }
        $json = array(
            'success' => true,
            'html' => $html,
        );
        echo json_encode($json);
        exit;
    }

    public function sendTestEmail() {
        $post = $this->request->post;
        //d($post, true);
        try {
            $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
            $mail->SMTPOptions = array(
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                )
            );
            //Server settings
            $mail->SMTPDebug = 0;                                 // Enable verbose debug output
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = $post['smtp_host'];
            $mail->SMTPAuth = true;
            $mail->Username = $post['smtp_user_name']; //paste one generated by Mailtrap
            $mail->Password = $post['smtp_password']; //paste one generated by Mailtrap
            //$mail->SMTPSecure = 'tls';
            $mail->Port = $post['smtp_port'];
            for($i=1; $i<=10; $i++) {
                $mail->setFrom($post['smtp_user_name'], $post['smtp_display_name']);
                $mail->addAddress($post['test_email']);
                $mail->isHTML(true);                                  // Set email format to HTML
                $mail->Subject = "Test Mail $i.";
                $mail->Body    = "This is test email $i to confirm SMTP setting is working fine.";
                if(!$mail->Send()) {
                    $json = array(
                        'success' => false,
                        'error' => $mail->ErrorInfo
                    );
                } else {
                    $json = array(
                        'success' => true,
                    );
                }
            }
        } catch (Exception $e) {
            d($e);
        }


        echo json_encode($json);
        exit;
    }

    public function sendTestSMS() {
        $post = $this->request->post;
        $username = $post['sms_user_name'];
        $password = $post['sms_password'];
        $from_mask = $post['sms_from_mask'];
        $test_mobile_no = $post['test_mobile_no'];

        $mobile_no = str_replace("+92","0",str_replace(" ","",$test_mobile_no));
        $url = 'https://connect.jazzcmt.com/sendsms_url.html?Username='.$username.'&Password='.$password.'&From='.$from_mask.'&To='.$mobile_no.'&Message=' . urlencode("This test SMS verifies that service working fine.");
        $response = file_get_contents($url);
        $json = [
            'success' => true,
            'response' => $response
        ];
        echo json_encode($json);
        exit;
    }

    protected function insertData($data) {
        $this->model[$this->getAlias()]->deleteBulk($this->getAlias(), array('company_id' => $this->session->data['company_id'], 'module' => 'general'));
        $policies = $data['policies'];
        unset($data['policies']);
        foreach($data as $field => $value) {
            $insertData = array(
                'company_id' => $this->session->data['company_id'],
                'module' => 'general',
                'field' => $field,
                'value' => $value
            );

            $this->model[$this->getAlias()]->add($this->getAlias(), $insertData);
        }

        $this->model['policy'] = $this->load->model('setup/company_allowance_policy');
        $this->model['policy']->deleteBulk($this->getAlias(), ['company_id' => $this->session->data['company_id']]);
        $sort_order = 0;
        foreach ($policies as $policy) {
            $sort_order++;
            $policy['company_id'] = $this->session->data['company_id'];
            $policy['sort_order'] = $sort_order;
            $this->model['policy']->add($this->getAlias(), $policy);
        }
    }
}

?>