<?php

class ControllerSetupDepartment extends HController {

    protected function getAlias() {
        return 'setup/department';
    }

    protected function getPrimaryKey() {
        return 'department_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $this->load->language('setup/department');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action','company_name', 'department_name','phone_no','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            if($aRow['total_registration']==0) {
                $actions[] = array(
                    'text' => $this->data['lang']['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }


            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $this->model['company'] = $this->load->model('setup/company');
        $this->data['companies'] = $this->model['company']->getRows(array('status' => 'Active'));
        $this->data['company_id'] = $this->session->data['company_id'];
        if (isset($this->request->get['department_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('department_id' => $this->request->get['department_id']));
            //d($result,true);
            foreach($result as $field => $value) {
                $this->data[$field] = $value;
            }

            $this->model['policy'] = $this->load->model('setup/department_allowance_policy');
            $this->data['policies'] = $this->model['policy']->getRecords(['d.department_id' => $this->request->get['department_id']],['sort_order']);
        }

        $this->model['allowance_type'] = $this->load->model('setup/special_allowance_type');
        $this->data['allowance_type'] = $this->model['allowance_type']->getRows();

        $this->data['href_allowance_category'] = $this->url->link($this->getAlias() . '/getAllowanceCategory', 'token=' . $this->session->data['token'] . 'SSL');
        $this->data['action_validate_code'] = $this->url->link($this->getAlias() . '/validateCode', 'token=' . $this->session->data['token'] . '&department_id=' . $this->request->get['department_id']);
        $this->data['action_validate_name'] = $this->url->link($this->getAlias() . '/validateName', 'token=' . $this->session->data['token'] . '&department_id=' . $this->request->get['department_id']);
//        $this->data['strValidation']="{
//            'rules':{
//		        'department_code': {'required':true, 'minlength': 3, 'remote':  {url: '" . $this->data['action_validate_code'] . "', type: 'post', data: {company_id: function() { return $('#company_id').val();}}}},
//		        'department_name': {'required':true, 'minlength': 3, 'remote':  {url: '" . $this->data['action_validate_name'] . "', type: 'post', data: {company_id: function() { return $('#company_id').val();}}}},
//            },
//        }";
        $this->data['strValidation']="{
            'rules':{
		        'department_name': {'required':true, 'minlength': 3, 'remote':  {url: '" . $this->data['action_validate_name'] . "', type: 'post', data: {company_id: function() { return $('#company_id').val();}}}},
            },
        }";

        $this->response->setOutput($this->render());
    }

    public function validateCode()
    {
        $code = $this->request->post['department_code'];
        $company_id = $this->request->post['company_id'];
        //$company_id = $this->session->data['company_id'];
        //$company_branch_id = $this->session->data['company_branch_id'];
        $department_id = $this->request->get['department_id'];

        $this->load->language('setup/department');
        if ($code) {
            $this->model['department'] = $this->load->model('setup/department');
            $where = "LOWER(department_code) = '".strtolower($code)."' AND department_id != '".$department_id."'";
            $where .= " AND company_id='" . $company_id . "'";
            //$where .= " AND company_branch_id='" . $company_branch_id . "'";
            $row = $this->model['department']->getRow($where);
            if ($row) {
                echo json_encode($this->language->get('error_duplicate_code'));
            } else {
                echo json_encode("true");
            }
        } else {
            echo json_encode($this->language->get('error_code'));
        }
        exit;
    }

    public function validateName()
    {
        $name = $this->request->post['department_name'];
        $company_id = $this->request->post['company_id'];
        //$company_id = $this->session->data['company_id'];
        //$company_id = $this->session->data['company_id'];
        //$company_branch_id = $this->session->data['company_branch_id'];
        $department_id = $this->request->get['department_id'];

        $this->load->language('setup/department');
        if ($name) {
            $this->model['department'] = $this->load->model('setup/department');
            $where = " LOWER(department_name) = '".strtolower($name)."' AND department_id != '".$department_id."'";
            $where .= " AND company_id='" . $company_id . "'";
            //$where .= " AND company_branch_id='" . $company_branch_id . "'";
            $row = $this->model['department']->getRow($where);
            if ($row) {
                echo json_encode($this->language->get('error_duplicate_name'));
            } else {
                echo json_encode("true");
            }
        } else {
            echo json_encode($this->language->get('error_name'));
        }
        exit;
    }

    protected function insertData($data) {
        if(!isset($data['override_attendance_policy'])) {
            $data['override_attendance_policy']=0;
        }
        if(!isset($data['override_allowance_policy'])) {
            $data['override_allowance_policy']=0;
        }
        if(!isset($data['attendance_exempted'])) {
            $data['attendance_exempted']=0;
        }
        //d($data, true);
        $policies = $data['policies'];
        unset($data['policies']);

        if(!isset($data['attendance_exempted']))
        {
            $data['attendance_exempted'] = 0;
        }
        $department_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);

        $this->model['policy'] = $this->load->model('setup/department_allowance_policy');
        $sort_order=0;
        foreach ($policies as $policy) {
            $sort_order++;
            $policy['department_id'] = $department_id;
            $policy['sort_order'] = $sort_order;

            $this->model['policy']->add($this->getAlias(),$policy);
        }

        return $department_id;
    }

    protected function updateData($primary_key, $data) {
        if(!isset($data['override_attendance_policy'])) {
            $data['override_attendance_policy']=0;
        }
        if(!isset($data['override_allowance_policy'])) {
            $data['override_allowance_policy']=0;
        }
        if(!isset($data['attendance_exempted'])) {
            $data['attendance_exempted']=0;
        }
        //d($data, true);
        $policies = $data['policies'];
        unset($data['policies']);

        if(!isset($data['attendance_exempted']))
        {
            $data['attendance_exempted'] = 0;
        }
        $department_id =  $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);

        $this->model['policy'] = $this->load->model('setup/department_allowance_policy');
        $this->model['policy']->deleteBulk($this->getAlias(), ['department_id' => $primary_key]);
        $sort_order=0;
        foreach ($policies as $policy) {
            $sort_order++;
            $policy['department_id'] = $department_id;
            $policy['sort_order'] = $sort_order;

            $this->model['policy']->add($this->getAlias(),$policy);
        }

        return $department_id;
    }


    public function getAllowanceCategory()
    {
        $post = $this->request->post;
        $type_id = $post['allowance_type_id'];
        $this->model['allowance_category'] = $this->load->model('setup/special_allowance_category');
        $result = $this->model['allowance_category']->getRows(array('special_allowance_type_id' => $type_id));

        $html = '<option value="0">ALL</option>';
        foreach ($result as $key => $value) {
            $html .= '<option value="'.$value['special_allowance_category_id'].'">'.$value['special_allowance_category'].'</option>';
        }
        $json = array(
            'success' => true,
            'html' => $html,
        );
        echo json_encode($json);
        exit;
    }
}

?>