<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require DIR_SYSTEM . 'library/PHPMailer/Exception.php';
require DIR_SYSTEM . 'library/PHPMailer/PHPMailer.php';
require DIR_SYSTEM . 'library/PHPMailer/SMTP.php';

class ControllerToolEmail extends HController {

    protected function getAlias() {
        return 'tool/email';
    }

    public function index() {
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];

        $this->data['heading_title'] = $this->language->get('heading_title');

//        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
//            $this->model['core_setting'] = $this->load->model('setup/core_setting');
//            $config = $this->model['core_setting']->getArrays('field','value',array('module'=>'general'));
//            $post = $this->request->post;
//            //d($config, true);
//
//            foreach($post['employees'] as $employee) {
//                if($employee['email'] != '') {
//                    $message = html_entity_decode($post['message']);
//                    $message = str_replace('[RegCode]',$employee['registration_code'],$message);
//                    $message = str_replace('[EmployeeName]',$employee['employee_name'],$message);
//                    try {
//                        $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
//                        //Server settings
//                        $mail->SMTPDebug = 0;                                 // Enable verbose debug output
//                        if($config['config_mail_engine']=='smtp') {
//                            $mail->isSMTP();                                      // Set mailer to use SMTP
//                            $mail->SMTPOptions = array (
//                                'ssl' => array(
//                                    'verify_peer' => false,
//                                    'verify_peer_name' => false,
//                                    'allow_self_signed' => true
//                                )
//                            );
//                            $mail->Host = $config['config_mail_smtp_hostname'];  // Specify main and backup SMTP servers
//                            $mail->SMTPAuth = true;                               // Enable SMTP authentication
//                            $mail->Username = $config['config_mail_smtp_username'];                 // SMTP username
//                            $mail->Password = $config['config_mail_smtp_password'];                           // SMTP password
//                        }
//                        //$mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
//                        $mail->Port = $config['config_mail_smtp_port'];                                    // TCP port to connect to
//
//                        //Recipients
//                        $mail->setFrom($config['config_mail_smtp_username'], $config['config_mail_smtp_displayname']);
//                        //$mail->addAddress('huzaifa.khambaty@gmail.com', 'Huzaifa Khambaty');     // Add a recipient
//                        $mail->addAddress($employee['email'], $employee['employee_name']);     // Add a recipient
//
//                        //Content
//                        $mail->isHTML(true);                                  // Set email format to HTML
//                        $mail->Subject = $post['subject'];
//                        $mail->Body    = $message;
//                        $mail->send();
//
//                    } catch (Exception $e) {
//                        $this->session->data['error_warning'] =  'Message could not be sent. Mailer Error: '. $mail->ErrorInfo;
//                        $json = array(
//                            'success' => false,
//                            'error' => 'Message could not be sent. Mailer Error: '. $mail->ErrorInfo
//                        );
//                    }
//                }
//            }
//
//            $this->session->data['success'] = $this->language->get('success_insert');
//            $this->redirect($this->url->link($this->getAlias(), 'token=' . $this->session->data['token'], 'SSL'));
//        }


        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id' => $this->session->data['company_id']));


        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $this->data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $this->data['success'] = '';
        }

        $this->data['breadcrumbs'] = array();

        $this->data['breadcrumbs'][] = array(
            'text' => $this->language->get('home'),
            'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => false
        );

        $this->data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('tool/sms', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );


        $this->data['href_get_employees'] = $this->url->link($this->getAlias().'/getEmployees', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_send_email'] = $this->url->link($this->getAlias().'/sendEmail', 'token=' . $this->session->data['token'], 'SSL');
        $this->template = 'tool/email.tpl';
        $this->children = array(
            'common/header',
            'common/page_header',
            'common/footer',
            'common/page_footer',
            'common/column_left'
        );

        $this->response->setOutput($this->render());
    }

    public function getEmployees() {
        $post = $this->request->post;

        if($post['department_id'] != '') {
            $filter = array(
                'company_id' => $this->session->data['company_id'],
                'department_id' => $post['department_id'],
                'status' => 'Active'
            );
        } else {
            $filter = array(
                'company_id' => $this->session->data['company_id'],
                'status' => 'Active'
            );
        }

        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $employees = $this->model['employee_registration']->getRows($filter,array('registration_code'));
        $html = '';
        foreach($employees as $row_id => $employee) {
            $html .= '<tr id="row_'.$row_id.'" data-id="'.$row_id.'">';
            $html .= '<td>'.($row_id + 1).'</td>';
            $html .= '<td><input type="text" id="employee_'.$row_id.'_registration_code" name="employees['.$row_id.'][registration_code]" value="'.$employee['registration_code'].'" style="min-width:50px; width:55px;" class="form-control text-right" /></td>';
            $html .= '<td><input type="text" id="employee_'.$row_id.'_employee_name" name="employees['.$row_id.'][employee_name]" value="'.$employee['employee_name'].'" class="form-control" /></td>';
            $html .= '<td><input type="text" id="employee_'.$row_id.'_email" name="employees['.$row_id.'][email]" value="'.$employee['email'].'" class="form-control" /></td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'post' => $post,
            'html' => $html,
        );

        echo json_encode($json);
    }


    public function sendEmail() {
        $post = $this->request->post;

        $this->model['core_setting'] = $this->load->model('setup/core_setting');
        $config = $this->model['core_setting']->getArrays('field','value',array('company_id' => $this->session->data['company_id'], 'module'=>'general'));

        $subject = html_entity_decode($post['subject']);
        $message = html_entity_decode($post['message']);
        $message = str_replace('[RegCode]',$post['registration_code'],$message);
        $message = str_replace('[EmployeeName]',$post['employee_name'],$message);
        //d([$post, $config], true);
        try {
            $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
            $mail->SMTPOptions = array(
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                )
            );
            //Server settings
            $mail->SMTPDebug = 0;                                 // Enable verbose debug output
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = $config['config_mail_smtp_hostname'];
            $mail->SMTPAuth = true;
            $mail->Username = $config['config_mail_smtp_username']; //paste one generated by Mailtrap
            $mail->Password = $config['config_mail_smtp_password']; //paste one generated by Mailtrap
            //$mail->SMTPSecure = 'tls';
            $mail->Port = $config['config_mail_smtp_port'];
            $mail->setFrom($config['config_mail_smtp_username'], $post['config_mail_smtp_displayname']);
            $mail->addAddress($post['email']);
            $mail->isHTML(true);
            // Set email format to HTML
            $mail->Subject = $subject;
            $mail->Body    = $message;
            //d($mail, true);
            if(!$mail->Send()) {
                $json = [
                    'success' => false,
                    'error' => $mail->ErrorInfo,
                    'id' => $post['id'],
                    'next_id' => $post['id']+1,
                ];
            } else {
                $json = [
                    'success' => true,
                    'id' => $post['id'],
                    'next_id' => $post['id']+1,
                ];
            }
        } catch (Exception $e) {
            $json = [
                'success' => false,
                'error' => $e->getCode().'|'.$e->getMessage(),
                'id' => $post['id'],
                'next_id' => $post['id']+1,
            ];
        }

        echo json_encode($json);
        exit;
    }
}

?>